"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ZnifferParser_exports = {};
__export(ZnifferParser_exports, {
  ZnifferParser: () => ZnifferParser
});
module.exports = __toCommonJS(ZnifferParser_exports);
var import_shared = require("@zwave-js/shared");
var import_Constants = require("../message/Constants.js");
var import_MessageHeaders = require("../message/MessageHeaders.js");
var import_ZnifferSerialFrame = require("./ZnifferSerialFrame.js");
function getMessageLength(data) {
  if (!data || data.length === 0)
    return;
  if (data[0] === import_MessageHeaders.ZnifferMessageHeaders.SOCF) {
    if (data.length < 3)
      return;
    const length = data[2];
    return length + 3;
  } else if (data[0] === import_MessageHeaders.ZnifferMessageHeaders.SODF) {
    if (data.length < 2)
      return;
    if (data[1] === import_Constants.ZnifferFrameType.BeamStart) {
      return 11;
    } else if (data[1] === import_Constants.ZnifferFrameType.BeamStop) {
      return 7;
    }
    if (data.length < 10)
      return;
    const length = data[9];
    return length + 10;
  }
}
__name(getMessageLength, "getMessageLength");
class ZnifferParserTransformer {
  static {
    __name(this, "ZnifferParserTransformer");
  }
  logger;
  constructor(logger) {
    this.logger = logger;
  }
  receiveBuffer = new import_shared.Bytes();
  // Allow ignoring the high nibble of an ACK once to work around an issue in the 700 series firmware
  ignoreAckHighNibble = false;
  transform(chunk, controller) {
    this.receiveBuffer = import_shared.Bytes.concat([this.receiveBuffer, chunk]);
    while (this.receiveBuffer.length > 0) {
      let skip = 0;
      while (skip < this.receiveBuffer.length && this.receiveBuffer[skip] !== import_MessageHeaders.ZnifferMessageHeaders.SOCF && this.receiveBuffer[skip] !== import_MessageHeaders.ZnifferMessageHeaders.SODF) {
        skip++;
      }
      if (skip > 0) {
        const discarded = this.receiveBuffer.subarray(0, skip);
        this.logger?.discarded(discarded);
        controller.enqueue({
          type: import_ZnifferSerialFrame.ZnifferSerialFrameType.Discarded,
          data: discarded
        });
        this.receiveBuffer = this.receiveBuffer.subarray(skip);
        continue;
      }
      const msgLength = getMessageLength(this.receiveBuffer);
      if (msgLength == void 0 || this.receiveBuffer.length < msgLength) {
        break;
      } else {
        const msg = this.receiveBuffer.subarray(0, msgLength);
        this.receiveBuffer = this.receiveBuffer.subarray(msgLength);
        this.logger?.data("inbound", msg);
        controller.enqueue({
          type: import_ZnifferSerialFrame.ZnifferSerialFrameType.SerialAPI,
          data: msg
        });
      }
    }
  }
}
class ZnifferParser extends TransformStream {
  static {
    __name(this, "ZnifferParser");
  }
  constructor(logger) {
    super(new ZnifferParserTransformer(logger));
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ZnifferParser
});
//# sourceMappingURL=ZnifferParser.js.map
