import { type MessageOrCCLogEntry } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export interface GetRoutingInfoRequestOptions {
    nodeId: number;
    removeNonRepeaters?: boolean;
    removeBadLinks?: boolean;
}
export declare class GetRoutingInfoRequest extends Message {
    constructor(options: GetRoutingInfoRequestOptions & MessageBaseOptions);
    sourceNodeId: number;
    removeNonRepeaters: boolean;
    removeBadLinks: boolean;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface GetRoutingInfoResponseOptions {
    nodeIds: number[];
}
export declare class GetRoutingInfoResponse extends Message {
    constructor(options: GetRoutingInfoResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): GetRoutingInfoResponse;
    nodeIds: number[];
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=GetRoutingInfoMessages.d.ts.map