import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare enum ReplaceFailedNodeStartFlags {
    OK = 0,
    /** The replacing process was aborted because the controller  is not the primary one */
    NotPrimaryController = 2,
    /** The replacing process was aborted because no call back function is used */
    NoCallbackFunction = 4,
    /** The replacing process aborted because the node was node found */
    NodeNotFound = 8,
    /** The replacing process is busy */
    ReplaceProcessBusy = 16,
    /** The replacing process could not be started*/
    ReplaceFailed = 32
}
export declare enum ReplaceFailedNodeStatus {
    NodeOK = 0,/* The node cannot be replaced because it is working properly (removed from the failed nodes list ) */
    /** The failed node is ready to be replaced and controller is ready to add new node with the nodeID of the failed node. */
    FailedNodeReplace = 3,
    /** The failed node has been replaced. */
    FailedNodeReplaceDone = 4,
    /** The failed node has not been replaced */
    FailedNodeReplaceFailed = 5
}
export declare class ReplaceFailedNodeRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): ReplaceFailedNodeRequestBase;
}
export interface ReplaceFailedNodeRequestOptions {
    failedNodeId: number;
}
export declare class ReplaceFailedNodeRequest extends ReplaceFailedNodeRequestBase {
    constructor(options: ReplaceFailedNodeRequestOptions & MessageBaseOptions);
    /** The node that should be removed */
    failedNodeId: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
}
export interface ReplaceFailedNodeResponseOptions {
    replaceStatus: ReplaceFailedNodeStartFlags;
}
export declare class ReplaceFailedNodeResponse extends Message implements SuccessIndicator {
    constructor(options: ReplaceFailedNodeResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): ReplaceFailedNodeResponse;
    replaceStatus: ReplaceFailedNodeStartFlags;
    isOK(): boolean;
}
export interface ReplaceFailedNodeRequestStatusReportOptions {
    replaceStatus: ReplaceFailedNodeStatus;
}
export declare class ReplaceFailedNodeRequestStatusReport extends ReplaceFailedNodeRequestBase implements SuccessIndicator {
    constructor(options: ReplaceFailedNodeRequestStatusReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): ReplaceFailedNodeRequestStatusReport;
    replaceStatus: ReplaceFailedNodeStatus;
    isOK(): boolean;
}
//# sourceMappingURL=ReplaceFailedNodeRequest.d.ts.map