import type { LogContainer } from "@zwave-js/core";
import type { ReadableWritablePair, UnderlyingSink, UnderlyingSource } from "node:stream/web";
import { SerialLogger } from "../log/Logger.js";
import type { ZWaveSerialFrame } from "../parsers/ZWaveSerialFrame.js";
import { ZWaveSerialMode } from "./definitions.js";
/** The low level bindings used by ZWaveSerialStream.
 * The `sink` is guaranteed to be opened first, so possible setup should be done in
 * the `start` method there. */
export interface ZWaveSerialBinding {
    sink: UnderlyingSink<Uint8Array>;
    source: UnderlyingSource<Uint8Array>;
}
export type ZWaveSerialBindingFactory = () => Promise<ZWaveSerialBinding>;
/** Tests if `obj` is (probably) a ZWaveSerialBindingFactory */
export declare function isZWaveSerialBindingFactory(obj: unknown): obj is ZWaveSerialBindingFactory;
/** Re-usable stream factory to create new serial streams */
export declare class ZWaveSerialStreamFactory {
    constructor(binding: ZWaveSerialBindingFactory, loggers: LogContainer);
    private binding;
    protected logger: SerialLogger;
    createStream(): Promise<ZWaveSerialStream>;
}
/** Single-use serial stream. Has to be re-created after being closed. */
export declare class ZWaveSerialStream implements ReadableWritablePair<ZWaveSerialFrame, Uint8Array> {
    #private;
    constructor(source: UnderlyingSource<Uint8Array>, sink: UnderlyingSink<Uint8Array>, logger: SerialLogger);
    protected logger: SerialLogger;
    readonly readable: ReadableStream<ZWaveSerialFrame>;
    readonly writable: WritableStream<Uint8Array>;
    private parser;
    get mode(): ZWaveSerialMode | undefined;
    set mode(mode: ZWaveSerialMode | undefined);
    ignoreAckHighNibbleOnce(): void;
    close(): Promise<void>;
    private _isOpen;
    get isOpen(): boolean;
    private _writer;
    writeAsync(data: Uint8Array): Promise<void>;
}
//# sourceMappingURL=ZWaveSerialStream.d.ts.map