import type { CCEncodingContext, CommandClass } from "@zwave-js/cc";
import { type FrameType, type MessageOrCCLogEntry } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
import type { MessageWithCC } from "../utils.js";
export declare enum ApplicationCommandStatusFlags {
    RoutedBusy = 1,// A response route is locked by the application
    LowPower = 2,// Received at low output power level
    TypeSingle = 0,// Received a single cast frame
    TypeBroad = 4,// Received a broad cast frame
    TypeMulti = 8,// Received a multi cast frame
    TypeMask = 12,
    Explore = 16,// Received an explore frame
    ForeignFrame = 64,// Received a foreign frame (only promiscuous mode)
    ForeignHomeId = 128
}
export type ApplicationCommandRequestOptions = ({
    command: CommandClass;
} | {
    nodeId: number;
    serializedCC: Uint8Array;
}) & {
    frameType?: ApplicationCommandRequest["frameType"];
    routedBusy?: boolean;
    isExploreFrame?: boolean;
    isForeignFrame?: boolean;
    fromForeignHomeId?: boolean;
};
export declare class ApplicationCommandRequest extends Message implements MessageWithCC {
    constructor(options: ApplicationCommandRequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): ApplicationCommandRequest;
    readonly routedBusy: boolean;
    readonly frameType: FrameType;
    readonly isExploreFrame: boolean;
    readonly isForeignFrame: boolean;
    readonly fromForeignHomeId: boolean;
    command: CommandClass | undefined;
    private _nodeId;
    getNodeId(): number | undefined;
    serializedCC: Uint8Array | undefined;
    serializeCC(ctx: CCEncodingContext): Promise<Uint8Array>;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=ApplicationCommandRequest.d.ts.map