var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, ZWaveError, ZWaveErrorCodes, encodeNodeID, parseNodeID, } from "@zwave-js/core";
import { FunctionType, Message, MessageType, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export var ApplicationCommandStatusFlags;
(function (ApplicationCommandStatusFlags) {
    ApplicationCommandStatusFlags[ApplicationCommandStatusFlags["RoutedBusy"] = 1] = "RoutedBusy";
    ApplicationCommandStatusFlags[ApplicationCommandStatusFlags["LowPower"] = 2] = "LowPower";
    ApplicationCommandStatusFlags[ApplicationCommandStatusFlags["TypeSingle"] = 0] = "TypeSingle";
    ApplicationCommandStatusFlags[ApplicationCommandStatusFlags["TypeBroad"] = 4] = "TypeBroad";
    ApplicationCommandStatusFlags[ApplicationCommandStatusFlags["TypeMulti"] = 8] = "TypeMulti";
    ApplicationCommandStatusFlags[ApplicationCommandStatusFlags["TypeMask"] = 12] = "TypeMask";
    ApplicationCommandStatusFlags[ApplicationCommandStatusFlags["Explore"] = 16] = "Explore";
    ApplicationCommandStatusFlags[ApplicationCommandStatusFlags["ForeignFrame"] = 64] = "ForeignFrame";
    ApplicationCommandStatusFlags[ApplicationCommandStatusFlags["ForeignHomeId"] = 128] = "ForeignHomeId";
})(ApplicationCommandStatusFlags || (ApplicationCommandStatusFlags = {}));
let ApplicationCommandRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.ApplicationCommand), priority(MessagePriority.Normal)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var ApplicationCommandRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ApplicationCommandRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if ("command" in options) {
                this.command = options.command;
            }
            else {
                this._nodeId = options.nodeId;
                this.serializedCC = options.serializedCC;
            }
            this.frameType = options.frameType ?? "singlecast";
            this.routedBusy = options.routedBusy ?? false;
            this.isExploreFrame = options.isExploreFrame ?? false;
            this.isForeignFrame = options.isForeignFrame ?? false;
            this.fromForeignHomeId = options.fromForeignHomeId ?? false;
        }
        static from(raw, ctx) {
            // first byte is a status flag
            const status = raw.payload[0];
            const routedBusy = !!(status & ApplicationCommandStatusFlags.RoutedBusy);
            let frameType;
            switch (status & ApplicationCommandStatusFlags.TypeMask) {
                case ApplicationCommandStatusFlags.TypeMulti:
                    frameType = "multicast";
                    break;
                case ApplicationCommandStatusFlags.TypeBroad:
                    frameType = "broadcast";
                    break;
                default:
                    frameType = "singlecast";
            }
            const isExploreFrame = frameType === "broadcast"
                && !!(status & ApplicationCommandStatusFlags.Explore);
            const isForeignFrame = !!(status & ApplicationCommandStatusFlags.ForeignFrame);
            const fromForeignHomeId = !!(status & ApplicationCommandStatusFlags.ForeignHomeId);
            // followed by a node ID
            let offset = 1;
            const { nodeId, bytesRead: nodeIdBytes } = parseNodeID(raw.payload, ctx.nodeIdType, offset);
            offset += nodeIdBytes;
            // and a command class
            const commandLength = raw.payload[offset++];
            const serializedCC = raw.payload.subarray(offset, offset + commandLength);
            return new this({
                routedBusy,
                frameType,
                isExploreFrame,
                isForeignFrame,
                fromForeignHomeId,
                serializedCC,
                nodeId,
            });
        }
        routedBusy;
        frameType;
        isExploreFrame;
        isForeignFrame;
        fromForeignHomeId;
        // This needs to be writable or unwrapping MultiChannelCCs crashes
        command;
        _nodeId;
        getNodeId() {
            if (this.command?.isSinglecast()) {
                return this.command.nodeId;
            }
            return this._nodeId ?? super.getNodeId();
        }
        serializedCC;
        async serializeCC(ctx) {
            if (!this.serializedCC) {
                if (!this.command) {
                    throw new ZWaveError(`Cannot serialize a ${this.constructor.name} without a command`, ZWaveErrorCodes.Argument_Invalid);
                }
                this.serializedCC = await this.command.serialize(ctx);
            }
            return this.serializedCC;
        }
        async serialize(ctx) {
            const statusByte = (this.frameType === "broadcast"
                ? ApplicationCommandStatusFlags.TypeBroad
                : this.frameType === "multicast"
                    ? ApplicationCommandStatusFlags.TypeMulti
                    : 0)
                | (this.routedBusy ? ApplicationCommandStatusFlags.RoutedBusy : 0);
            const serializedCC = await this.serializeCC(ctx);
            const nodeId = encodeNodeID(this.getNodeId() ?? ctx.ownNodeId, ctx.nodeIdType);
            this.payload = Bytes.concat([
                [statusByte],
                nodeId,
                [serializedCC.length],
                serializedCC,
            ]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const message = {};
            if (this.frameType !== "singlecast") {
                message.type = this.frameType;
            }
            return {
                ...super.toLogEntry(),
                message,
            };
        }
    };
    return ApplicationCommandRequest = _classThis;
})();
export { ApplicationCommandRequest };
//# sourceMappingURL=ApplicationCommandRequest.js.map