import { LongRangeChannel, type MessageOrCCLogEntry } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare class GetLongRangeChannelRequest extends Message {
}
export interface GetLongRangeChannelResponseOptions {
    channel: LongRangeChannel.Unsupported | LongRangeChannel.A | LongRangeChannel.B;
    supportsAutoChannelSelection: boolean;
    autoChannelSelectionActive: boolean;
}
export declare class GetLongRangeChannelResponse extends Message {
    constructor(options: GetLongRangeChannelResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): GetLongRangeChannelResponse;
    readonly channel: LongRangeChannel.A | LongRangeChannel.B | LongRangeChannel.Unsupported;
    readonly supportsAutoChannelSelection: boolean;
    readonly autoChannelSelectionActive: boolean;
}
export interface SetLongRangeChannelRequestOptions {
    channel: LongRangeChannel;
}
export declare class SetLongRangeChannelRequest extends Message {
    constructor(options: SetLongRangeChannelRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): SetLongRangeChannelRequest;
    channel: LongRangeChannel;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SetLongRangeChannelResponseOptions {
    success: boolean;
}
export declare class SetLongRangeChannelResponse extends Message implements SuccessIndicator {
    constructor(options: SetLongRangeChannelResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SetLongRangeChannelResponse;
    isOK(): boolean;
    readonly success: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=LongRangeChannelMessages.d.ts.map