import { type MessageOrCCLogEntry, NodeIDType, RFRegion } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare enum SerialAPISetupCommand {
    Unsupported = 0,
    GetSupportedCommands = 1,
    SetTxStatusReport = 2,
    SetLongRangeMaximumTxPower = 3,
    SetPowerlevel = 4,
    GetLongRangeMaximumTxPower = 5,
    GetPowerlevel = 8,
    GetMaximumPayloadSize = 16,
    GetRFRegion = 32,
    SetRFRegion = 64,
    SetNodeIDType = 128,
    GetLongRangeMaximumPayloadSize = 17,
    SetPowerlevel16Bit = 18,
    GetPowerlevel16Bit = 19,
    GetSupportedRegions = 21,
    GetRegionInfo = 22
}
export interface SerialAPISetupRequestOptions {
    command?: SerialAPISetupCommand;
}
export declare class SerialAPISetupRequest extends Message {
    constructor(options?: SerialAPISetupRequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): SerialAPISetupRequest;
    command: SerialAPISetupCommand;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SerialAPISetupResponseOptions {
    command?: SerialAPISetupCommand;
}
export declare class SerialAPISetupResponse extends Message {
    constructor(options: SerialAPISetupResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): SerialAPISetupResponse;
    command: SerialAPISetupCommand;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SerialAPISetup_CommandUnsupportedResponseOptions {
    command: SerialAPISetupCommand;
}
export declare class SerialAPISetup_CommandUnsupportedResponse extends SerialAPISetupResponse {
    constructor(options: SerialAPISetup_CommandUnsupportedResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_CommandUnsupportedResponse;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SerialAPISetup_GetSupportedCommandsRequest extends SerialAPISetupRequest {
}
export interface SerialAPISetup_GetSupportedCommandsResponseOptions {
    supportedCommands: SerialAPISetupCommand[];
}
export declare class SerialAPISetup_GetSupportedCommandsResponse extends SerialAPISetupResponse {
    constructor(options: SerialAPISetup_GetSupportedCommandsResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): SerialAPISetup_GetSupportedCommandsResponse;
    readonly supportedCommands: SerialAPISetupCommand[];
}
export interface SerialAPISetup_SetTXStatusReportOptions {
    enabled: boolean;
}
export declare class SerialAPISetup_SetTXStatusReportRequest extends SerialAPISetupRequest {
    constructor(options: SerialAPISetup_SetTXStatusReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_SetTXStatusReportRequest;
    enabled: boolean;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SerialAPISetup_SetTXStatusReportResponseOptions {
    success: boolean;
}
export declare class SerialAPISetup_SetTXStatusReportResponse extends SerialAPISetupResponse implements SuccessIndicator {
    constructor(options: SerialAPISetup_SetTXStatusReportResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_SetTXStatusReportResponse;
    isOK(): boolean;
    readonly success: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SerialAPISetup_SetNodeIDTypeOptions {
    nodeIdType: NodeIDType;
}
export declare class SerialAPISetup_SetNodeIDTypeRequest extends SerialAPISetupRequest {
    constructor(options: SerialAPISetup_SetNodeIDTypeOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_SetNodeIDTypeRequest;
    nodeIdType: NodeIDType;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SerialAPISetup_SetNodeIDTypeResponseOptions {
    success: boolean;
}
export declare class SerialAPISetup_SetNodeIDTypeResponse extends SerialAPISetupResponse implements SuccessIndicator {
    constructor(options: SerialAPISetup_SetNodeIDTypeResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_SetNodeIDTypeResponse;
    isOK(): boolean;
    readonly success: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SerialAPISetup_GetRFRegionRequest extends SerialAPISetupRequest {
}
export interface SerialAPISetup_GetRFRegionResponseOptions {
    region: RFRegion;
}
export declare class SerialAPISetup_GetRFRegionResponse extends SerialAPISetupResponse {
    constructor(options: SerialAPISetup_GetRFRegionResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_GetRFRegionResponse;
    readonly region: RFRegion;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SerialAPISetup_SetRFRegionOptions {
    region: RFRegion;
}
export declare class SerialAPISetup_SetRFRegionRequest extends SerialAPISetupRequest {
    constructor(options: SerialAPISetup_SetRFRegionOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_SetRFRegionRequest;
    region: RFRegion;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SerialAPISetup_SetRFRegionResponseOptions {
    success: boolean;
}
export declare class SerialAPISetup_SetRFRegionResponse extends SerialAPISetupResponse implements SuccessIndicator {
    constructor(options: SerialAPISetup_SetRFRegionResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_SetRFRegionResponse;
    isOK(): boolean;
    readonly success: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SerialAPISetup_GetPowerlevelRequest extends SerialAPISetupRequest {
}
export interface SerialAPISetup_GetPowerlevelResponseOptions {
    powerlevel: number;
    measured0dBm: number;
}
export declare class SerialAPISetup_GetPowerlevelResponse extends SerialAPISetupResponse {
    constructor(options: SerialAPISetup_GetPowerlevelResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_GetPowerlevelResponse;
    /** The configured normal powerlevel in dBm */
    readonly powerlevel: number;
    /** The measured output power in dBm for a normal output powerlevel of 0 */
    readonly measured0dBm: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SerialAPISetup_SetPowerlevelOptions {
    powerlevel: number;
    measured0dBm: number;
}
export declare class SerialAPISetup_SetPowerlevelRequest extends SerialAPISetupRequest {
    constructor(options: SerialAPISetup_SetPowerlevelOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_SetPowerlevelRequest;
    powerlevel: number;
    measured0dBm: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SerialAPISetup_SetPowerlevelResponseOptions {
    success: boolean;
}
export declare class SerialAPISetup_SetPowerlevelResponse extends SerialAPISetupResponse implements SuccessIndicator {
    constructor(options: SerialAPISetup_SetPowerlevelResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_SetPowerlevelResponse;
    isOK(): boolean;
    readonly success: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SerialAPISetup_GetPowerlevel16BitRequest extends SerialAPISetupRequest {
}
export interface SerialAPISetup_GetPowerlevel16BitResponseOptions {
    powerlevel: number;
    measured0dBm: number;
}
export declare class SerialAPISetup_GetPowerlevel16BitResponse extends SerialAPISetupResponse {
    constructor(options: SerialAPISetup_GetPowerlevel16BitResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_GetPowerlevel16BitResponse;
    /** The configured normal powerlevel in dBm */
    readonly powerlevel: number;
    /** The measured output power in dBm for a normal output powerlevel of 0 */
    readonly measured0dBm: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SerialAPISetup_SetPowerlevel16BitOptions {
    powerlevel: number;
    measured0dBm: number;
}
export declare class SerialAPISetup_SetPowerlevel16BitRequest extends SerialAPISetupRequest {
    constructor(options: SerialAPISetup_SetPowerlevel16BitOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_SetPowerlevel16BitRequest;
    powerlevel: number;
    measured0dBm: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SerialAPISetup_SetPowerlevel16BitResponseOptions {
    success: boolean;
}
export declare class SerialAPISetup_SetPowerlevel16BitResponse extends SerialAPISetupResponse implements SuccessIndicator {
    constructor(options: SerialAPISetup_SetPowerlevel16BitResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_SetPowerlevel16BitResponse;
    isOK(): boolean;
    readonly success: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SerialAPISetup_GetLongRangeMaximumTxPowerRequest extends SerialAPISetupRequest {
}
export interface SerialAPISetup_GetLongRangeMaximumTxPowerResponseOptions {
    limit: number;
}
export declare class SerialAPISetup_GetLongRangeMaximumTxPowerResponse extends SerialAPISetupResponse {
    constructor(options: SerialAPISetup_GetLongRangeMaximumTxPowerResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_GetLongRangeMaximumTxPowerResponse;
    /** The maximum LR TX power in dBm */
    readonly limit: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SerialAPISetup_SetLongRangeMaximumTxPowerOptions {
    limit: number;
}
export declare class SerialAPISetup_SetLongRangeMaximumTxPowerRequest extends SerialAPISetupRequest {
    constructor(options: SerialAPISetup_SetLongRangeMaximumTxPowerOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_SetLongRangeMaximumTxPowerRequest;
    /** The maximum LR TX power in dBm */
    limit: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SerialAPISetup_SetLongRangeMaximumTxPowerResponseOptions {
    success: boolean;
}
export declare class SerialAPISetup_SetLongRangeMaximumTxPowerResponse extends SerialAPISetupResponse implements SuccessIndicator {
    constructor(options: SerialAPISetup_SetLongRangeMaximumTxPowerResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_SetLongRangeMaximumTxPowerResponse;
    isOK(): boolean;
    readonly success: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SerialAPISetup_GetMaximumPayloadSizeRequest extends SerialAPISetupRequest {
}
export interface SerialAPISetup_GetMaximumPayloadSizeResponseOptions {
    maxPayloadSize: number;
}
export declare class SerialAPISetup_GetMaximumPayloadSizeResponse extends SerialAPISetupResponse {
    constructor(options: SerialAPISetup_GetMaximumPayloadSizeResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_GetMaximumPayloadSizeResponse;
    readonly maxPayloadSize: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest extends SerialAPISetupRequest {
}
export interface SerialAPISetup_GetLongRangeMaximumPayloadSizeResponseOptions {
    maxPayloadSize: number;
}
export declare class SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse extends SerialAPISetupResponse {
    constructor(options: SerialAPISetup_GetLongRangeMaximumPayloadSizeResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse;
    readonly maxPayloadSize: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SerialAPISetup_GetSupportedRegionsRequest extends SerialAPISetupRequest {
}
export interface SerialAPISetup_GetSupportedRegionsResponseOptions {
    supportedRegions: RFRegion[];
}
export declare class SerialAPISetup_GetSupportedRegionsResponse extends SerialAPISetupResponse {
    constructor(options: SerialAPISetup_GetSupportedRegionsResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_GetSupportedRegionsResponse;
    readonly supportedRegions: RFRegion[];
}
export interface SerialAPISetup_GetRegionInfoOptions {
    region: RFRegion;
}
export declare class SerialAPISetup_GetRegionInfoRequest extends SerialAPISetupRequest {
    constructor(options: SerialAPISetup_GetRegionInfoOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_GetRegionInfoRequest;
    region: RFRegion;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SerialAPISetup_GetRegionInfoResponseOptions {
    region: RFRegion;
    supportsZWave: boolean;
    supportsLongRange: boolean;
    includesRegion?: RFRegion;
}
export declare class SerialAPISetup_GetRegionInfoResponse extends SerialAPISetupResponse {
    constructor(options: SerialAPISetup_GetRegionInfoResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SerialAPISetup_GetRegionInfoResponse;
    readonly region: RFRegion;
    readonly supportsZWave: boolean;
    readonly supportsLongRange: boolean;
    readonly includesRegion?: RFRegion;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=SerialAPISetupMessages.d.ts.map