var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, encodeNodeID, parseNodeID, } from "@zwave-js/core";
import { FunctionType, Message, MessageType, expectedCallback, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
import { ApplicationUpdateRequestNodeInfoReceived, ApplicationUpdateRequestNodeInfoRequestFailed, } from "../application/ApplicationUpdateRequest.js";
let RequestNodeInfoResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.RequestNodeInfo)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var RequestNodeInfoResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            RequestNodeInfoResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.wasSent = options.wasSent;
        }
        static from(raw, _ctx) {
            const wasSent = raw.payload[0] !== 0;
            return new this({
                wasSent,
            });
        }
        wasSent;
        isOK() {
            return this.wasSent;
        }
        serialize(ctx) {
            this.payload = Bytes.from([this.wasSent ? 0x01 : 0]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: { "was sent": this.wasSent },
            };
        }
    };
    return RequestNodeInfoResponse = _classThis;
})();
export { RequestNodeInfoResponse };
function testCallbackForRequestNodeInfoRequest(sent, received) {
    return ((received instanceof ApplicationUpdateRequestNodeInfoReceived
        && received.nodeId === sent.nodeId)
        || received instanceof ApplicationUpdateRequestNodeInfoRequestFailed);
}
let RequestNodeInfoRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.RequestNodeInfo), expectedResponse(RequestNodeInfoResponse), expectedCallback(testCallbackForRequestNodeInfoRequest), priority(MessagePriority.NodeQuery)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var RequestNodeInfoRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            RequestNodeInfoRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.nodeId = options.nodeId;
        }
        static from(raw, ctx) {
            const nodeId = parseNodeID(raw.payload, ctx.nodeIdType, 0).nodeId;
            return new this({
                nodeId,
            });
        }
        nodeId;
        needsCallbackId() {
            // Not sure why it is this way, but this message contains no callback id
            return false;
        }
        serialize(ctx) {
            this.payload = encodeNodeID(this.nodeId, ctx.nodeIdType);
            return super.serialize(ctx);
        }
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: { "node id": this.nodeId },
            };
        }
    };
    return RequestNodeInfoRequest = _classThis;
})();
export { RequestNodeInfoRequest };
//# sourceMappingURL=RequestNodeInfoMessages.js.map