var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, ZWaveError, ZWaveErrorCodes, validatePayload, } from "@zwave-js/core";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes, getEnumMemberName, num2hex } from "@zwave-js/shared";
export var ExtendedNVMOperationsCommand;
(function (ExtendedNVMOperationsCommand) {
    ExtendedNVMOperationsCommand[ExtendedNVMOperationsCommand["Open"] = 0] = "Open";
    ExtendedNVMOperationsCommand[ExtendedNVMOperationsCommand["Read"] = 1] = "Read";
    ExtendedNVMOperationsCommand[ExtendedNVMOperationsCommand["Write"] = 2] = "Write";
    ExtendedNVMOperationsCommand[ExtendedNVMOperationsCommand["Close"] = 3] = "Close";
})(ExtendedNVMOperationsCommand || (ExtendedNVMOperationsCommand = {}));
export var ExtendedNVMOperationStatus;
(function (ExtendedNVMOperationStatus) {
    ExtendedNVMOperationStatus[ExtendedNVMOperationStatus["OK"] = 0] = "OK";
    ExtendedNVMOperationStatus[ExtendedNVMOperationStatus["Error"] = 1] = "Error";
    ExtendedNVMOperationStatus[ExtendedNVMOperationStatus["Error_OperationMismatch"] = 2] = "Error_OperationMismatch";
    ExtendedNVMOperationStatus[ExtendedNVMOperationStatus["Error_OperationInterference"] = 3] = "Error_OperationInterference";
    ExtendedNVMOperationStatus[ExtendedNVMOperationStatus["Error_SubCommandNotSupported"] = 4] = "Error_SubCommandNotSupported";
    ExtendedNVMOperationStatus[ExtendedNVMOperationStatus["EndOfFile"] = 255] = "EndOfFile";
})(ExtendedNVMOperationStatus || (ExtendedNVMOperationStatus = {}));
let ExtendedNVMOperationsRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.ExtendedNVMOperations), priority(MessagePriority.Controller), expectedResponse(FunctionType.ExtendedNVMOperations)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var ExtendedNVMOperationsRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ExtendedNVMOperationsRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        // This must be set in subclasses
        command;
        serialize(ctx) {
            this.payload = Bytes.concat([
                Bytes.from([this.command]),
                this.payload,
            ]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const message = {
                command: getEnumMemberName(ExtendedNVMOperationsCommand, this.command),
            };
            return {
                ...super.toLogEntry(),
                message,
            };
        }
    };
    return ExtendedNVMOperationsRequest = _classThis;
})();
export { ExtendedNVMOperationsRequest };
// =============================================================================
export class ExtendedNVMOperationsOpenRequest extends ExtendedNVMOperationsRequest {
    constructor(options = {}) {
        super(options);
        this.command = ExtendedNVMOperationsCommand.Open;
    }
}
// =============================================================================
export class ExtendedNVMOperationsCloseRequest extends ExtendedNVMOperationsRequest {
    constructor(options = {}) {
        super(options);
        this.command = ExtendedNVMOperationsCommand.Close;
    }
}
export class ExtendedNVMOperationsReadRequest extends ExtendedNVMOperationsRequest {
    constructor(options) {
        super(options);
        this.command = ExtendedNVMOperationsCommand.Read;
        if (options.length < 0 || options.length > 0xff) {
            throw new ZWaveError("The length must be between 0 and 255!", ZWaveErrorCodes.Argument_Invalid);
        }
        if (options.offset < 0 || options.offset > 0xffffffff) {
            throw new ZWaveError("The offset must be a 32-bit number!", ZWaveErrorCodes.Argument_Invalid);
        }
        this.length = options.length;
        this.offset = options.offset;
    }
    static from(_raw, _ctx) {
        throw new ZWaveError(`${this.name}: deserialization not implemented`, ZWaveErrorCodes.Deserialization_NotImplemented);
        // return new ExtendedNVMOperationsReadRequest({});
    }
    length;
    offset;
    serialize(ctx) {
        this.payload = new Bytes(5);
        this.payload[0] = this.length;
        this.payload.writeUInt32BE(this.offset, 1);
        return super.serialize(ctx);
    }
    toLogEntry() {
        const ret = super.toLogEntry();
        return {
            ...ret,
            message: {
                ...ret.message,
                "data length": this.length,
                "address offset": num2hex(this.offset),
            },
        };
    }
}
export class ExtendedNVMOperationsWriteRequest extends ExtendedNVMOperationsRequest {
    constructor(options) {
        super(options);
        this.command = ExtendedNVMOperationsCommand.Write;
        if (options.offset < 0 || options.offset > 0xffffffff) {
            throw new ZWaveError("The offset must be a 32-bit number!", ZWaveErrorCodes.Argument_Invalid);
        }
        if (options.buffer.length < 1 || options.buffer.length > 0xff) {
            throw new ZWaveError("The buffer must be between 1 and 255 bytes long", ZWaveErrorCodes.Argument_Invalid);
        }
        this.offset = options.offset;
        this.buffer = options.buffer;
    }
    static from(_raw, _ctx) {
        throw new ZWaveError(`${this.name}: deserialization not implemented`, ZWaveErrorCodes.Deserialization_NotImplemented);
        // return new ExtendedNVMOperationsWriteRequest({});
    }
    offset;
    buffer;
    serialize(ctx) {
        this.payload = new Bytes(1 + 4 + this.buffer.length);
        this.payload[0] = this.buffer.length;
        this.payload.writeUInt32BE(this.offset, 1);
        this.payload.set(this.buffer, 5);
        return super.serialize(ctx);
    }
    toLogEntry() {
        const ret = super.toLogEntry();
        return {
            ...ret,
            message: {
                ...ret.message,
                offset: num2hex(this.offset),
                buffer: `(${this.buffer.length} byte${this.buffer.length === 1 ? "" : "s"})`,
            },
        };
    }
}
let ExtendedNVMOperationsResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.ExtendedNVMOperations)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var ExtendedNVMOperationsResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ExtendedNVMOperationsResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            // TODO: Check implementation:
            this.status = options.status;
            this.offsetOrSize = options.offsetOrSize;
            this.bufferOrBitmask = options.bufferOrBitmask;
        }
        static from(raw, _ctx) {
            validatePayload(raw.payload.length >= 2);
            const status = raw.payload[0];
            const dataLength = raw.payload[1];
            let offset = 2;
            let offsetOrSize = 0;
            if (raw.payload.length >= offset + 4) {
                offsetOrSize = raw.payload.readUInt32BE(offset);
            }
            offset += 4;
            // The buffer will contain:
            // - Read command: the read NVM data
            // - Write/Close command: nothing
            // - Open command: bit mask of supported sub-commands
            let bufferOrBitmask;
            if (dataLength > 0 && raw.payload.length >= offset + dataLength) {
                bufferOrBitmask = raw.payload.subarray(offset, offset + dataLength);
            }
            else {
                bufferOrBitmask = new Uint8Array();
            }
            return new this({
                status,
                offsetOrSize,
                bufferOrBitmask,
            });
        }
        isOK() {
            return (this.status === ExtendedNVMOperationStatus.OK
                || this.status === ExtendedNVMOperationStatus.EndOfFile);
        }
        status;
        offsetOrSize;
        bufferOrBitmask;
        toLogEntry() {
            const message = {
                status: getEnumMemberName(ExtendedNVMOperationStatus, this.status),
                "address offset / NVM size": num2hex(this.offsetOrSize),
            };
            if (this.bufferOrBitmask.length > 0) {
                message.buffer = `(${this.bufferOrBitmask.length} byte${this.bufferOrBitmask.length === 1 ? "" : "s"})`;
            }
            return {
                ...super.toLogEntry(),
                message,
            };
        }
    };
    return ExtendedNVMOperationsResponse = _classThis;
})();
export { ExtendedNVMOperationsResponse };
//# sourceMappingURL=ExtendedNVMOperationsMessages.js.map