import { type MessageOrCCLogEntry } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare enum FirmwareUpdateNVMCommand {
    Init = 0,
    SetNewImage = 1,
    GetNewImage = 2,
    UpdateCRC16 = 3,
    IsValidCRC16 = 4,
    Write = 5
}
export interface FirmwareUpdateNVMRequestOptions {
    command?: FirmwareUpdateNVMCommand;
}
export declare class FirmwareUpdateNVMRequest extends Message {
    constructor(options?: FirmwareUpdateNVMRequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): FirmwareUpdateNVMRequest;
    command: FirmwareUpdateNVMCommand;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface FirmwareUpdateNVMResponseOptions {
    command?: FirmwareUpdateNVMCommand;
}
export declare class FirmwareUpdateNVMResponse extends Message {
    constructor(options: FirmwareUpdateNVMResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): FirmwareUpdateNVMResponse;
    command: FirmwareUpdateNVMCommand;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class FirmwareUpdateNVM_InitRequest extends FirmwareUpdateNVMRequest {
}
export interface FirmwareUpdateNVM_InitResponseOptions {
    supported: boolean;
}
export declare class FirmwareUpdateNVM_InitResponse extends FirmwareUpdateNVMResponse {
    constructor(options: FirmwareUpdateNVM_InitResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): FirmwareUpdateNVM_InitResponse;
    readonly supported: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface FirmwareUpdateNVM_SetNewImageRequestOptions {
    newImage: boolean;
}
export declare class FirmwareUpdateNVM_SetNewImageRequest extends FirmwareUpdateNVMRequest {
    constructor(options: FirmwareUpdateNVM_SetNewImageRequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): FirmwareUpdateNVM_SetNewImageRequest;
    newImage: boolean;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface FirmwareUpdateNVM_SetNewImageResponseOptions {
    changed: boolean;
}
export declare class FirmwareUpdateNVM_SetNewImageResponse extends FirmwareUpdateNVMResponse {
    constructor(options: FirmwareUpdateNVM_SetNewImageResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): FirmwareUpdateNVM_SetNewImageResponse;
    readonly changed: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class FirmwareUpdateNVM_GetNewImageRequest extends FirmwareUpdateNVMRequest {
}
export interface FirmwareUpdateNVM_GetNewImageResponseOptions {
    newImage: boolean;
}
export declare class FirmwareUpdateNVM_GetNewImageResponse extends FirmwareUpdateNVMResponse {
    constructor(options: FirmwareUpdateNVM_GetNewImageResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): FirmwareUpdateNVM_GetNewImageResponse;
    readonly newImage: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface FirmwareUpdateNVM_UpdateCRC16RequestOptions {
    crcSeed: number;
    offset: number;
    blockLength: number;
}
export declare class FirmwareUpdateNVM_UpdateCRC16Request extends FirmwareUpdateNVMRequest {
    constructor(options: FirmwareUpdateNVM_UpdateCRC16RequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): FirmwareUpdateNVM_UpdateCRC16Request;
    crcSeed: number;
    offset: number;
    blockLength: number;
    getResponseTimeout(): number | undefined;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface FirmwareUpdateNVM_UpdateCRC16ResponseOptions {
    crc16: number;
}
export declare class FirmwareUpdateNVM_UpdateCRC16Response extends FirmwareUpdateNVMResponse {
    constructor(options: FirmwareUpdateNVM_UpdateCRC16ResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): FirmwareUpdateNVM_UpdateCRC16Response;
    readonly crc16: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class FirmwareUpdateNVM_IsValidCRC16Request extends FirmwareUpdateNVMRequest {
    getResponseTimeout(): number | undefined;
}
export interface FirmwareUpdateNVM_IsValidCRC16ResponseOptions {
    isValid: boolean;
}
export declare class FirmwareUpdateNVM_IsValidCRC16Response extends FirmwareUpdateNVMResponse {
    constructor(options: FirmwareUpdateNVM_IsValidCRC16ResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): FirmwareUpdateNVM_IsValidCRC16Response;
    readonly isValid: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface FirmwareUpdateNVM_WriteRequestOptions {
    offset: number;
    buffer: Uint8Array;
}
export declare class FirmwareUpdateNVM_WriteRequest extends FirmwareUpdateNVMRequest {
    constructor(options: FirmwareUpdateNVM_WriteRequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): FirmwareUpdateNVM_WriteRequest;
    offset: number;
    buffer: Uint8Array;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface FirmwareUpdateNVM_WriteResponseOptions {
    overwritten: boolean;
}
export declare class FirmwareUpdateNVM_WriteResponse extends FirmwareUpdateNVMResponse {
    constructor(options: FirmwareUpdateNVM_WriteResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): FirmwareUpdateNVM_WriteResponse;
    readonly overwritten: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=FirmwareUpdateNVMMessages.d.ts.map