var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, validatePayload, } from "@zwave-js/core";
import { createSimpleReflectionDecorator } from "@zwave-js/core/reflection";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes, getEnumMemberName, num2hex } from "@zwave-js/shared";
export var FirmwareUpdateNVMCommand;
(function (FirmwareUpdateNVMCommand) {
    FirmwareUpdateNVMCommand[FirmwareUpdateNVMCommand["Init"] = 0] = "Init";
    FirmwareUpdateNVMCommand[FirmwareUpdateNVMCommand["SetNewImage"] = 1] = "SetNewImage";
    FirmwareUpdateNVMCommand[FirmwareUpdateNVMCommand["GetNewImage"] = 2] = "GetNewImage";
    FirmwareUpdateNVMCommand[FirmwareUpdateNVMCommand["UpdateCRC16"] = 3] = "UpdateCRC16";
    FirmwareUpdateNVMCommand[FirmwareUpdateNVMCommand["IsValidCRC16"] = 4] = "IsValidCRC16";
    FirmwareUpdateNVMCommand[FirmwareUpdateNVMCommand["Write"] = 5] = "Write";
})(FirmwareUpdateNVMCommand || (FirmwareUpdateNVMCommand = {}));
// We need to define the decorators for Requests and Responses separately
const { decorator: subCommandRequest, lookupConstructor: getSubCommandRequestConstructor, lookupValue: getSubCommandForRequest, } = createSimpleReflectionDecorator({
    name: "subCommandRequest",
});
const { decorator: subCommandResponse, lookupConstructor: getSubCommandResponseConstructor, lookupValue: getSubCommandForResponse, } = createSimpleReflectionDecorator({
    name: "subCommandResponse",
});
function testResponseForFirmwareUpdateNVMRequest(sent, received) {
    if (!(received instanceof FirmwareUpdateNVMResponse))
        return false;
    return sent.command === received.command;
}
let FirmwareUpdateNVMRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.FirmwareUpdateNVM), priority(MessagePriority.Controller), expectedResponse(testResponseForFirmwareUpdateNVMRequest)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var FirmwareUpdateNVMRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            FirmwareUpdateNVMRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options = {}) {
            super(options);
            this.command = options.command ?? getSubCommandForRequest(this);
        }
        static from(raw, ctx) {
            const command = raw.payload[0];
            const payload = raw.payload.subarray(1);
            const CommandConstructor = getSubCommandRequestConstructor(command);
            if (CommandConstructor) {
                return CommandConstructor.from(raw.withPayload(payload), ctx);
            }
            const ret = new FirmwareUpdateNVMRequest({
                command,
            });
            ret.payload = payload;
            return ret;
        }
        command;
        serialize(ctx) {
            this.payload = Bytes.concat([
                Bytes.from([this.command]),
                this.payload,
            ]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const message = {
                command: getEnumMemberName(FirmwareUpdateNVMCommand, this.command),
            };
            if (this.payload.length > 0) {
                message.payload = `0x${this.payload.toString("hex")}`;
            }
            return {
                ...super.toLogEntry(),
                message,
            };
        }
    };
    return FirmwareUpdateNVMRequest = _classThis;
})();
export { FirmwareUpdateNVMRequest };
let FirmwareUpdateNVMResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.FirmwareUpdateNVM)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var FirmwareUpdateNVMResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            FirmwareUpdateNVMResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.command = options.command ?? getSubCommandForResponse(this);
        }
        static from(raw, ctx) {
            const command = raw.payload[0];
            const payload = raw.payload.subarray(1);
            const CommandConstructor = getSubCommandResponseConstructor(command);
            if (CommandConstructor) {
                return CommandConstructor.from(raw.withPayload(payload), ctx);
            }
            const ret = new FirmwareUpdateNVMResponse({
                command,
            });
            ret.payload = payload;
            return ret;
        }
        command;
        toLogEntry() {
            const message = {
                command: getEnumMemberName(FirmwareUpdateNVMCommand, this.command),
            };
            if (this.payload.length > 0) {
                message.payload = `0x${this.payload.toString("hex")}`;
            }
            return {
                ...super.toLogEntry(),
                message,
            };
        }
    };
    return FirmwareUpdateNVMResponse = _classThis;
})();
export { FirmwareUpdateNVMResponse };
// =============================================================================
let FirmwareUpdateNVM_InitRequest = (() => {
    let _classDecorators = [subCommandRequest(FirmwareUpdateNVMCommand.Init)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = FirmwareUpdateNVMRequest;
    var FirmwareUpdateNVM_InitRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            FirmwareUpdateNVM_InitRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return FirmwareUpdateNVM_InitRequest = _classThis;
})();
export { FirmwareUpdateNVM_InitRequest };
let FirmwareUpdateNVM_InitResponse = (() => {
    let _classDecorators = [subCommandResponse(FirmwareUpdateNVMCommand.Init)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = FirmwareUpdateNVMResponse;
    var FirmwareUpdateNVM_InitResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            FirmwareUpdateNVM_InitResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.supported = options.supported;
        }
        static from(raw, _ctx) {
            const supported = raw.payload[0] !== 0;
            return new this({
                supported,
            });
        }
        supported;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message["FW update supported"] = this.supported;
            delete message.payload;
            return ret;
        }
    };
    return FirmwareUpdateNVM_InitResponse = _classThis;
})();
export { FirmwareUpdateNVM_InitResponse };
let FirmwareUpdateNVM_SetNewImageRequest = (() => {
    let _classDecorators = [subCommandRequest(FirmwareUpdateNVMCommand.SetNewImage)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = FirmwareUpdateNVMRequest;
    var FirmwareUpdateNVM_SetNewImageRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            FirmwareUpdateNVM_SetNewImageRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.newImage = options.newImage;
        }
        static from(raw, _ctx) {
            const newImage = raw.payload[0] !== 0;
            return new this({
                newImage,
            });
        }
        newImage;
        serialize(ctx) {
            this.payload = Bytes.from([this.newImage ? 1 : 0]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message["new image"] = this.newImage;
            delete message.payload;
            return ret;
        }
    };
    return FirmwareUpdateNVM_SetNewImageRequest = _classThis;
})();
export { FirmwareUpdateNVM_SetNewImageRequest };
let FirmwareUpdateNVM_SetNewImageResponse = (() => {
    let _classDecorators = [subCommandResponse(FirmwareUpdateNVMCommand.SetNewImage)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = FirmwareUpdateNVMResponse;
    var FirmwareUpdateNVM_SetNewImageResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            FirmwareUpdateNVM_SetNewImageResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.changed = options.changed;
        }
        static from(raw, _ctx) {
            const changed = raw.payload[0] !== 0;
            return new this({
                changed,
            });
        }
        changed;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message.changed = this.changed;
            delete message.payload;
            return ret;
        }
    };
    return FirmwareUpdateNVM_SetNewImageResponse = _classThis;
})();
export { FirmwareUpdateNVM_SetNewImageResponse };
// =============================================================================
let FirmwareUpdateNVM_GetNewImageRequest = (() => {
    let _classDecorators = [subCommandRequest(FirmwareUpdateNVMCommand.GetNewImage)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = FirmwareUpdateNVMRequest;
    var FirmwareUpdateNVM_GetNewImageRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            FirmwareUpdateNVM_GetNewImageRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return FirmwareUpdateNVM_GetNewImageRequest = _classThis;
})();
export { FirmwareUpdateNVM_GetNewImageRequest };
let FirmwareUpdateNVM_GetNewImageResponse = (() => {
    let _classDecorators = [subCommandResponse(FirmwareUpdateNVMCommand.GetNewImage)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = FirmwareUpdateNVMResponse;
    var FirmwareUpdateNVM_GetNewImageResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            FirmwareUpdateNVM_GetNewImageResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.newImage = options.newImage;
        }
        static from(raw, _ctx) {
            const newImage = raw.payload[0] !== 0;
            return new this({
                newImage,
            });
        }
        newImage;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message["new image"] = this.newImage;
            delete message.payload;
            return ret;
        }
    };
    return FirmwareUpdateNVM_GetNewImageResponse = _classThis;
})();
export { FirmwareUpdateNVM_GetNewImageResponse };
let FirmwareUpdateNVM_UpdateCRC16Request = (() => {
    let _classDecorators = [subCommandRequest(FirmwareUpdateNVMCommand.UpdateCRC16)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = FirmwareUpdateNVMRequest;
    var FirmwareUpdateNVM_UpdateCRC16Request = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            FirmwareUpdateNVM_UpdateCRC16Request = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.command = FirmwareUpdateNVMCommand.UpdateCRC16;
            this.crcSeed = options.crcSeed;
            this.offset = options.offset;
            this.blockLength = options.blockLength;
        }
        static from(raw, _ctx) {
            const offset = raw.payload.readUIntBE(0, 3);
            const blockLength = raw.payload.readUInt16BE(3);
            const crcSeed = raw.payload.readUInt16BE(5);
            return new this({
                crcSeed,
                offset,
                blockLength,
            });
        }
        crcSeed;
        offset;
        blockLength;
        getResponseTimeout() {
            // Computing the CRC-16 of a couple hundred KB can take a while on slow sticks
            return 30000;
        }
        serialize(ctx) {
            this.payload = new Bytes(7);
            this.payload.writeUIntBE(this.offset, 0, 3);
            this.payload.writeUInt16BE(this.blockLength, 3);
            this.payload.writeUInt16BE(this.crcSeed, 5);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message.offset = num2hex(this.offset);
            message["block length"] = this.blockLength;
            message["CRC seed"] = num2hex(this.crcSeed);
            delete message.payload;
            return ret;
        }
    };
    return FirmwareUpdateNVM_UpdateCRC16Request = _classThis;
})();
export { FirmwareUpdateNVM_UpdateCRC16Request };
let FirmwareUpdateNVM_UpdateCRC16Response = (() => {
    let _classDecorators = [subCommandResponse(FirmwareUpdateNVMCommand.UpdateCRC16)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = FirmwareUpdateNVMResponse;
    var FirmwareUpdateNVM_UpdateCRC16Response = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            FirmwareUpdateNVM_UpdateCRC16Response = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.crc16 = options.crc16;
        }
        static from(raw, _ctx) {
            validatePayload(raw.payload.length >= 2);
            const crc16 = raw.payload.readUInt16BE(0);
            return new this({
                crc16,
            });
        }
        crc16;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message["CRC-16"] = num2hex(this.crc16);
            delete message.payload;
            return ret;
        }
    };
    return FirmwareUpdateNVM_UpdateCRC16Response = _classThis;
})();
export { FirmwareUpdateNVM_UpdateCRC16Response };
// =============================================================================
let FirmwareUpdateNVM_IsValidCRC16Request = (() => {
    let _classDecorators = [subCommandRequest(FirmwareUpdateNVMCommand.IsValidCRC16)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = FirmwareUpdateNVMRequest;
    var FirmwareUpdateNVM_IsValidCRC16Request = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            FirmwareUpdateNVM_IsValidCRC16Request = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        getResponseTimeout() {
            // Computing the CRC-16 of a couple hundred KB can take a while on slow sticks
            return 30000;
        }
    };
    return FirmwareUpdateNVM_IsValidCRC16Request = _classThis;
})();
export { FirmwareUpdateNVM_IsValidCRC16Request };
let FirmwareUpdateNVM_IsValidCRC16Response = (() => {
    let _classDecorators = [subCommandResponse(FirmwareUpdateNVMCommand.IsValidCRC16)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = FirmwareUpdateNVMResponse;
    var FirmwareUpdateNVM_IsValidCRC16Response = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            FirmwareUpdateNVM_IsValidCRC16Response = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.isValid = options.isValid;
        }
        static from(raw, _ctx) {
            const isValid = raw.payload[0] !== 0;
            // There are two more bytes containing the CRC result, but we don't care about that
            return new this({
                isValid,
            });
        }
        isValid;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message["CRC-16 valid"] = this.isValid;
            delete message.payload;
            return ret;
        }
    };
    return FirmwareUpdateNVM_IsValidCRC16Response = _classThis;
})();
export { FirmwareUpdateNVM_IsValidCRC16Response };
let FirmwareUpdateNVM_WriteRequest = (() => {
    let _classDecorators = [subCommandRequest(FirmwareUpdateNVMCommand.Write)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = FirmwareUpdateNVMRequest;
    var FirmwareUpdateNVM_WriteRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            FirmwareUpdateNVM_WriteRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.offset = options.offset;
            this.buffer = options.buffer;
        }
        static from(raw, _ctx) {
            const offset = raw.payload.readUIntBE(0, 3);
            const bufferLength = raw.payload.readUInt16BE(3);
            const buffer = raw.payload.subarray(5, 5 + bufferLength);
            return new this({
                offset,
                buffer,
            });
        }
        offset;
        buffer;
        serialize(ctx) {
            this.payload = new Bytes(5 + this.buffer.length);
            this.payload.writeUIntBE(this.offset, 0, 3);
            this.payload.writeUInt16BE(this.buffer.length, 3);
            this.payload.set(this.buffer, 5);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message.offset = num2hex(this.offset);
            if (this.buffer.length > 0) {
                message.buffer = `(${this.buffer.length} byte${this.buffer.length === 1 ? "" : "s"})`;
            }
            delete message.payload;
            return ret;
        }
    };
    return FirmwareUpdateNVM_WriteRequest = _classThis;
})();
export { FirmwareUpdateNVM_WriteRequest };
let FirmwareUpdateNVM_WriteResponse = (() => {
    let _classDecorators = [subCommandResponse(FirmwareUpdateNVMCommand.Write)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = FirmwareUpdateNVMResponse;
    var FirmwareUpdateNVM_WriteResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            FirmwareUpdateNVM_WriteResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.overwritten = options.overwritten;
        }
        static from(raw, _ctx) {
            const overwritten = raw.payload[0] !== 0;
            return new this({
                overwritten,
            });
        }
        overwritten;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message.overwritten = this.overwritten;
            delete message.payload;
            return ret;
        }
    };
    return FirmwareUpdateNVM_WriteResponse = _classThis;
})();
export { FirmwareUpdateNVM_WriteResponse };
//# sourceMappingURL=FirmwareUpdateNVMMessages.js.map