"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var forward_exports = {};
__export(forward_exports, {
  EventForwarder: () => EventForwarder
});
module.exports = __toCommonJS(forward_exports);
var import_zwave_js = require("zwave-js");
var import_core = require("@zwave-js/core");
var import_state = require("./state.js");
var import_error = require("./error.js");
class EventForwarder {
  clientsController;
  /**
   * Only load this once the driver is ready.
   *
   * @param clientsController
   */
  constructor(clientsController) {
    this.clientsController = clientsController;
  }
  start() {
    this.setupControllerAndNodes();
    this.clientsController.driver.on("driver ready", () => {
      this.setupControllerAndNodes();
      this.clientsController.clients.forEach((client) => {
        if (client.schemaVersion >= 40) {
          this.sendEvent(client, {
            source: "driver",
            event: "driver ready"
          });
        }
      });
    });
    this.clientsController.driver.on("firmware update progress", (progress) => {
      this.clientsController.clients.forEach((client) => {
        this.sendEvent(client, {
          source: client.schemaVersion >= 41 ? "driver" : "controller",
          event: "firmware update progress",
          progress
        });
      });
    });
    this.clientsController.driver.on("firmware update finished", (result) => {
      this.clientsController.clients.forEach((client) => {
        this.sendEvent(client, {
          source: client.schemaVersion >= 41 ? "driver" : "controller",
          event: "firmware update finished",
          result
        });
      });
    });
  }
  forwardEvent(data, minSchemaVersion) {
    this.clientsController.clients.forEach((client) => this.sendEvent(client, data, minSchemaVersion));
  }
  sendEvent(client, data, minSchemaVersion) {
    if (client.receiveEvents && client.isConnected && client.schemaVersion >= (minSchemaVersion ?? 0)) {
      client.sendEvent(data);
    }
  }
  setupControllerAndNodes() {
    this.clientsController.driver.controller.nodes.forEach((node) => this.setupNode(node));
    this.clientsController.driver.controller.on("node added", (node, result) => {
      this.clientsController.clients.forEach((client) => this.sendEvent(client, {
        source: "controller",
        event: "node added",
        node: (0, import_state.dumpNode)(node, client.schemaVersion),
        result
      }));
      this.setupNode(node);
    });
    this.clientsController.driver.controller.on("node found", (node) => {
      this.clientsController.clients.filter((client) => client.schemaVersion > 18).forEach((client) => this.sendEvent(client, {
        source: "controller",
        event: "node found",
        node: (0, import_state.dumpFoundNode)(node, client.schemaVersion)
      }));
    });
    this.clientsController.driver.controller.on("inclusion state changed", (state) => {
      this.clientsController.clients.filter((client) => client.schemaVersion > 37).forEach((client) => this.sendEvent(client, {
        source: "controller",
        event: "inclusion state changed",
        state
      }));
    });
    {
      const events = [
        "inclusion failed",
        "exclusion failed",
        "exclusion started",
        "inclusion stopped",
        "exclusion stopped"
      ];
      for (const event of events) {
        this.clientsController.driver.controller.on(event, () => this.forwardEvent({
          source: "controller",
          event
        }));
      }
    }
    this.clientsController.driver.controller.on("inclusion started", (strategy) => {
      this.clientsController.clients.forEach((client) => {
        if (client.schemaVersion >= 37) {
          this.sendEvent(client, {
            source: "controller",
            event: "inclusion started",
            strategy
          });
        } else {
          this.sendEvent(client, {
            source: "controller",
            event: "inclusion started",
            secure: strategy !== import_zwave_js.InclusionStrategy.Insecure
          });
        }
      });
    });
    this.clientsController.driver.controller.on("node removed", (node, reason) => (
      // forward event to all connected clients, respecting schemaVersion it supports
      this.clientsController.clients.forEach((client) => {
        if (client.schemaVersion < 29) {
          this.sendEvent(client, {
            source: "controller",
            event: "node removed",
            node: (0, import_state.dumpNode)(node, client.schemaVersion),
            replaced: [
              import_zwave_js.RemoveNodeReason.Replaced,
              import_zwave_js.RemoveNodeReason.ProxyReplaced
            ].includes(reason)
          });
        } else {
          this.sendEvent(client, {
            source: "controller",
            event: "node removed",
            node: (0, import_state.dumpNode)(node, client.schemaVersion),
            reason
          });
        }
      })
    ));
    this.clientsController.driver.controller.on("rebuild routes progress", (progress) => {
      this.clientsController.clients.forEach((client) => {
        if (client.schemaVersion <= 31) {
          client.sendEvent({
            source: "controller",
            event: "heal network progress",
            progress: Object.fromEntries(progress)
          });
        } else {
          client.sendEvent({
            source: "controller",
            event: "rebuild routes progress",
            progress: Object.fromEntries(progress)
          });
        }
      });
    });
    this.clientsController.driver.controller.on("status changed", (status) => this.forwardEvent({
      source: "controller",
      event: "status changed",
      status
    }, 31));
    this.clientsController.driver.controller.on("rebuild routes done", (result) => {
      this.clientsController.clients.forEach((client) => {
        if (client.schemaVersion <= 31) {
          client.sendEvent({
            source: "controller",
            event: "heal network done",
            result: Object.fromEntries(result)
          });
        } else {
          client.sendEvent({
            source: "controller",
            event: "rebuild routes done",
            result: Object.fromEntries(result)
          });
        }
      });
    });
    this.clientsController.driver.controller.on("statistics updated", (statistics) => this.forwardEvent({
      source: "controller",
      event: "statistics updated",
      statistics
    }));
    this.clientsController.driver.controller.on("identify", (triggeringNode) => this.forwardEvent({
      source: "controller",
      event: "identify",
      nodeId: triggeringNode.nodeId
    }, 31));
  }
  setupNode(node) {
    const notifyNode = (node2, event, extra = {}) => this.forwardEvent({
      source: "node",
      event,
      nodeId: node2.nodeId,
      ...extra
    });
    node.on("ready", (changedNode) => {
      this.clientsController.clients.forEach((client) => this.sendEvent(client, {
        source: "node",
        event: "ready",
        nodeId: changedNode.nodeId,
        nodeState: (0, import_state.dumpNode)(changedNode, client.schemaVersion)
      }));
    });
    {
      const events = ["wake up", "sleep", "dead", "alive"];
      for (const event of events) {
        node.on(event, (changedNode, oldStatus) => notifyNode(changedNode, event, { oldStatus }));
      }
    }
    {
      const events = [
        "interview completed",
        "interview started",
        "interview failed"
      ];
      for (const event of events) {
        node.on(event, (changedNode, args) => {
          notifyNode(changedNode, event, { args });
        });
      }
    }
    node.on("interview stage completed", (changedNode, stageName) => {
      notifyNode(changedNode, "interview stage completed", { stageName });
    });
    {
      const events = [
        "value updated",
        "value removed",
        "value added",
        "value notification"
      ];
      for (const event of events) {
        node.on(event, (changedNode, args) => {
          if (!changedNode.ready)
            return;
          notifyNode(changedNode, event, { args });
        });
      }
    }
    node.on("metadata updated", (changedNode, oldArgs) => {
      if (!changedNode.ready)
        return;
      this.clientsController.clients.forEach((client) => {
        const args = { ...oldArgs };
        if (args.metadata != void 0) {
          if (args.commandClass === import_core.CommandClasses.Configuration) {
            args.metadata = (0, import_state.dumpConfigurationMetadata)(args.metadata, client.schemaVersion);
          } else {
            args.metadata = (0, import_state.dumpMetadata)(args.metadata, client.schemaVersion);
          }
        }
        this.sendEvent(client, {
          source: "node",
          event: "metadata updated",
          nodeId: changedNode.nodeId,
          args
        });
      });
    });
    node.on("notification", (endpoint, ccId, args) => {
      const changedNode = endpoint.tryGetNode();
      if (!changedNode) {
        throw new import_error.NodeNotFoundError(endpoint.nodeId);
      }
      if (!changedNode.ready)
        return;
      this.clientsController.clients.forEach((client) => {
        if (client.schemaVersion < 3 && ccId == import_core.CommandClasses.Notification) {
          let eventData = {
            source: "node",
            event: "notification",
            nodeId: changedNode.nodeId,
            notificationLabel: args.eventLabel
          };
          if ("parameters" in args) {
            eventData["parameters"] = args.parameters;
          }
          this.sendEvent(client, eventData);
        } else if (client.schemaVersion >= 3) {
          if (client.schemaVersion < 21) {
            if ([
              import_core.CommandClasses["Multilevel Switch"],
              import_core.CommandClasses["Entry Control"]
            ].includes(ccId)) {
              delete args.eventTypeLabel;
            }
            if (ccId == import_core.CommandClasses["Entry Control"]) {
              delete args.dataTypeLabel;
            }
          }
          if (client.schemaVersion <= 31) {
            this.sendEvent(client, {
              source: "node",
              event: "notification",
              nodeId: changedNode.nodeId,
              ccId,
              args
            });
          } else {
            this.sendEvent(client, {
              source: "node",
              event: "notification",
              nodeId: endpoint.nodeId,
              endpointIndex: endpoint.index,
              ccId,
              args
            });
          }
        }
      });
    });
    node.on("firmware update progress", (changedNode, progress) => {
      if (!changedNode.ready)
        return;
      this.clientsController.clients.forEach((client) => {
        if (client.schemaVersion <= 23) {
          this.sendEvent(client, {
            source: "node",
            event: "firmware update progress",
            nodeId: changedNode.nodeId,
            sentFragments: progress.sentFragments,
            totalFragments: progress.totalFragments
          });
        } else {
          this.sendEvent(client, {
            source: "node",
            event: "firmware update progress",
            nodeId: changedNode.nodeId,
            progress
          });
        }
      });
    });
    node.on("firmware update finished", (changedNode, result) => {
      if (!changedNode.ready)
        return;
      this.clientsController.clients.forEach((client) => {
        if (client.schemaVersion <= 23) {
          this.sendEvent(client, {
            source: "node",
            event: "firmware update finished",
            nodeId: changedNode.nodeId,
            status: result.status,
            waitTime: result.waitTime
          });
        } else {
          this.sendEvent(client, {
            source: "node",
            event: "firmware update finished",
            nodeId: changedNode.nodeId,
            result
          });
        }
      });
    });
    node.on("statistics updated", (changedNode, statistics) => {
      notifyNode(changedNode, "statistics updated", { statistics });
    });
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  EventForwarder
});
//# sourceMappingURL=forward.js.map
