"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var inclusion_user_callbacks_exports = {};
__export(inclusion_user_callbacks_exports, {
  inclusionUserCallbacks: () => inclusionUserCallbacks
});
module.exports = __toCommonJS(inclusion_user_callbacks_exports);
var import_deferred_promise = require("alcalzone-shared/deferred-promise");
const inclusionUserCallbacks = (clientsController, client) => {
  return {
    grantSecurityClasses: (requested) => {
      clientsController.grantSecurityClassesPromise = (0, import_deferred_promise.createDeferredPromise)();
      clientsController.grantSecurityClassesPromise.catch(() => {
      });
      clientsController.grantSecurityClassesPromise.finally(() => {
        if (clientsController.grantSecurityClassesPromise !== void 0) {
          delete clientsController.grantSecurityClassesPromise;
        }
      });
      if (client !== void 0) {
        client.sendEvent({
          source: "controller",
          event: "grant security classes",
          requested
        });
      } else {
        clientsController.clients.forEach((client2) => {
          if (client2.isConnected && client2.receiveEvents) {
            client2.sendEvent({
              source: "controller",
              event: "grant security classes",
              requested
            });
          }
        });
      }
      return clientsController.grantSecurityClassesPromise;
    },
    validateDSKAndEnterPIN: (dsk) => {
      clientsController.validateDSKAndEnterPinPromise = (0, import_deferred_promise.createDeferredPromise)();
      clientsController.validateDSKAndEnterPinPromise.catch(() => {
      });
      clientsController.validateDSKAndEnterPinPromise.finally(() => {
        if (clientsController.validateDSKAndEnterPinPromise != void 0) {
          delete clientsController.validateDSKAndEnterPinPromise;
        }
      });
      if (client !== void 0) {
        client.sendEvent({
          source: "controller",
          event: "validate dsk and enter pin",
          dsk
        });
      } else {
        clientsController.clients.forEach((client2) => {
          if (client2.isConnected && client2.receiveEvents) {
            client2.sendEvent({
              source: "controller",
              event: "validate dsk and enter pin",
              dsk
            });
          }
        });
      }
      return clientsController.validateDSKAndEnterPinPromise;
    },
    abort: () => {
      delete clientsController.grantSecurityClassesPromise;
      delete clientsController.validateDSKAndEnterPinPromise;
      if (client !== void 0) {
        client.sendEvent({
          source: "controller",
          event: "inclusion aborted"
        });
      } else {
        clientsController.clients.forEach((client2) => {
          if (client2.isConnected && client2.receiveEvents) {
            client2.sendEvent({
              source: "controller",
              event: "inclusion aborted"
            });
          }
        });
      }
    }
  };
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  inclusionUserCallbacks
});
//# sourceMappingURL=inclusion_user_callbacks.js.map
