"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MockZWaveFrame_exports = {};
__export(MockZWaveFrame_exports, {
  MOCK_FRAME_ACK_TIMEOUT: () => MOCK_FRAME_ACK_TIMEOUT,
  MockZWaveFrameType: () => MockZWaveFrameType,
  createMockZWaveAckFrame: () => createMockZWaveAckFrame,
  createMockZWaveRequestFrame: () => createMockZWaveRequestFrame,
  unlazyMockZWaveFrame: () => unlazyMockZWaveFrame
});
module.exports = __toCommonJS(MockZWaveFrame_exports);
var MockZWaveFrameType;
(function(MockZWaveFrameType2) {
  MockZWaveFrameType2[MockZWaveFrameType2["Request"] = 0] = "Request";
  MockZWaveFrameType2[MockZWaveFrameType2["ACK"] = 1] = "ACK";
})(MockZWaveFrameType || (MockZWaveFrameType = {}));
function createMockZWaveRequestFrame(payload, options = {}) {
  const { repeaters = [], ackRequested = true } = options;
  return {
    type: MockZWaveFrameType.Request,
    repeaters,
    ackRequested,
    payload
  };
}
__name(createMockZWaveRequestFrame, "createMockZWaveRequestFrame");
function createMockZWaveAckFrame(options = {}) {
  const { repeaters = [], ack = true, failedHop } = options;
  return {
    type: MockZWaveFrameType.ACK,
    repeaters,
    ack,
    failedHop
  };
}
__name(createMockZWaveAckFrame, "createMockZWaveAckFrame");
async function unlazyMockZWaveFrame(frame) {
  if (frame.type === MockZWaveFrameType.ACK)
    return frame;
  let payload = frame.payload;
  if (typeof payload === "function") {
    payload = await payload();
  }
  return {
    ...frame,
    payload
  };
}
__name(unlazyMockZWaveFrame, "unlazyMockZWaveFrame");
const MOCK_FRAME_ACK_TIMEOUT = 1e3;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MOCK_FRAME_ACK_TIMEOUT,
  MockZWaveFrameType,
  createMockZWaveAckFrame,
  createMockZWaveRequestFrame,
  unlazyMockZWaveFrame
});
//# sourceMappingURL=MockZWaveFrame.js.map
