"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var NVMIO_exports = {};
__export(NVMIO_exports, {
  SerialNVMIO500: () => SerialNVMIO500,
  SerialNVMIO700: () => SerialNVMIO700
});
module.exports = __toCommonJS(NVMIO_exports);
var import_core = require("@zwave-js/core");
var import_nvmedit = require("@zwave-js/nvmedit");
var import_serial = require("@zwave-js/serial");
var import_serialapi = require("@zwave-js/serial/serialapi");
class SerialNVMIO500 {
  static {
    __name(this, "SerialNVMIO500");
  }
  constructor(controller) {
    this._controller = controller;
  }
  _controller;
  _size;
  _chunkSize;
  async open(_access) {
    this._size = (0, import_serialapi.nvmSizeToBufferSize)((await this._controller.getNVMId()).memorySize);
    if (!this._size) {
      throw new import_core.ZWaveError("Unknown NVM size - cannot backup!", import_core.ZWaveErrorCodes.Controller_NotSupported);
    }
    return import_nvmedit.NVMAccess.ReadWrite;
  }
  get size() {
    if (this._size == void 0) {
      throw new import_core.ZWaveError("The NVM is not open", import_core.ZWaveErrorCodes.NVM_NotOpen);
    }
    return this._size;
  }
  get accessMode() {
    if (this._size == void 0) {
      return import_nvmedit.NVMAccess.None;
    } else {
      return import_nvmedit.NVMAccess.ReadWrite;
    }
  }
  async determineChunkSize() {
    if (this._size == void 0) {
      throw new import_core.ZWaveError("The NVM is not open", import_core.ZWaveErrorCodes.NVM_NotOpen);
    }
    if (!this._chunkSize) {
      const chunk = await this._controller.externalNVMReadBuffer(0, 65535);
      this._chunkSize = chunk.length || 48;
    }
    return this._chunkSize;
  }
  async read(offset, length) {
    const size = this.size;
    if (offset < 0 || offset >= size) {
      throw new import_core.ZWaveError("Cannot read outside of the NVM", import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    const chunkSize = await this.determineChunkSize();
    const readSize = Math.min(length, chunkSize, size - offset);
    const buffer = await this._controller.externalNVMReadBuffer(offset, readSize);
    const endOfFile = offset + readSize >= size;
    return {
      buffer,
      endOfFile
    };
  }
  async write(offset, data) {
    const size = this.size;
    if (offset < 0 || offset >= size) {
      throw new import_core.ZWaveError("Cannot read outside of the NVM", import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    const chunkSize = await this.determineChunkSize() - 5;
    const writeSize = Math.min(data.length, chunkSize, size - offset);
    await this._controller.externalNVMWriteBuffer(offset, data.subarray(0, writeSize));
    const endOfFile = offset + writeSize >= size;
    return {
      bytesWritten: writeSize,
      endOfFile
    };
  }
  close() {
    return Promise.resolve();
  }
}
class SerialNVMIO700 {
  static {
    __name(this, "SerialNVMIO700");
  }
  constructor(controller) {
    this._controller = controller;
    if (controller.isFunctionSupported(import_serial.FunctionType.ExtendedNVMOperations)) {
      this._open = async () => {
        const { size } = await controller.externalNVMOpenExt();
        return size;
      };
      this._read = (offset, length) => controller.externalNVMReadBufferExt(offset, length);
      this._write = (offset, buffer) => controller.externalNVMWriteBufferExt(offset, buffer);
      this._close = () => controller.externalNVMCloseExt();
    } else {
      this._open = () => controller.externalNVMOpen();
      this._read = (offset, length) => controller.externalNVMReadBuffer700(offset, length);
      this._write = (offset, buffer) => controller.externalNVMWriteBuffer700(offset, buffer);
      this._close = () => controller.externalNVMClose();
    }
  }
  _controller;
  _open;
  _read;
  _write;
  _close;
  _size;
  _chunkSize;
  _accessMode = import_nvmedit.NVMAccess.None;
  async open(access) {
    this._size = await this._open();
    this._accessMode = access;
    return access;
  }
  get size() {
    if (this._size == void 0) {
      throw new import_core.ZWaveError("The NVM is not open", import_core.ZWaveErrorCodes.NVM_NotOpen);
    }
    return this._size;
  }
  get accessMode() {
    return this._accessMode;
  }
  async determineChunkSize() {
    if (!this._chunkSize) {
      this._chunkSize = (await this._read(0, 255)).buffer.length || 48;
    }
    return this._chunkSize;
  }
  async read(offset, length) {
    const size = this.size;
    if (offset < 0 || offset >= size) {
      throw new import_core.ZWaveError("Cannot read outside of the NVM", import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    const chunkSize = await this.determineChunkSize();
    return this._read(offset, Math.min(length, chunkSize, size - offset));
  }
  async write(offset, data) {
    const size = this.size;
    if (offset < 0 || offset >= size) {
      throw new import_core.ZWaveError("Cannot read outside of the NVM", import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    const chunkSize = await this.determineChunkSize();
    const writeSize = Math.min(data.length, chunkSize, size - offset);
    const { endOfFile } = await this._write(offset, data.subarray(0, writeSize));
    return {
      bytesWritten: writeSize,
      endOfFile
    };
  }
  close() {
    this._accessMode = import_nvmedit.NVMAccess.None;
    return this._close();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SerialNVMIO500,
  SerialNVMIO700
});
//# sourceMappingURL=NVMIO.js.map
