"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ThrottlePresets_exports = {};
__export(ThrottlePresets_exports, {
  throttlePresets: () => throttlePresets
});
module.exports = __toCommonJS(ThrottlePresets_exports);
const throttlePresets = {
  slow: {
    autoCompress: {
      intervalMs: 60 * 6e4,
      // compress every 60 minutes
      intervalMinChanges: 100,
      // if there were at least 100 changes
      sizeFactor: 3,
      // only compress large DBs after they have grown 3x
      sizeFactorMinimumSize: 100
    },
    throttleFS: {
      intervalMs: 5 * 6e4,
      // write at most every 5 minutes
      maxBufferedCommands: 500
      // or after 500 changes
    }
  },
  normal: {
    autoCompress: {
      intervalMs: 6e4,
      intervalMinChanges: 5,
      sizeFactor: 2,
      sizeFactorMinimumSize: 20
    },
    throttleFS: {
      intervalMs: 1e3,
      maxBufferedCommands: 50
    }
  },
  fast: {
    autoCompress: {
      intervalMs: 6e4,
      intervalMinChanges: 5,
      sizeFactor: 2,
      sizeFactorMinimumSize: 20
    }
    // no throttle :)
  }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  throttlePresets
});
//# sourceMappingURL=ThrottlePresets.js.map
