"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var UserAgent_exports = {};
__export(UserAgent_exports, {
  mergeUserAgent: () => mergeUserAgent,
  userAgentComponentsToString: () => userAgentComponentsToString
});
module.exports = __toCommonJS(UserAgent_exports);
function mergeUserAgent(existingComponents, additionalComponents, allowOverwrite = false) {
  const ret = new Map(existingComponents);
  function normalize(str) {
    return str.replaceAll(/[^a-zA-Z0-9\.\-]/g, "");
  }
  __name(normalize, "normalize");
  for (let [name, version] of Object.entries(additionalComponents)) {
    name = normalize(name);
    if (name === "node-zwave-js" || name === "zwave-js")
      continue;
    if (!allowOverwrite && ret.has(name))
      continue;
    if (version == void 0) {
      ret.delete(name);
    } else {
      version = normalize(version);
      ret.set(name, version);
    }
  }
  return ret;
}
__name(mergeUserAgent, "mergeUserAgent");
function userAgentComponentsToString(components) {
  return [...components].map(([name, version]) => `${name}/${version}`).join(" ");
}
__name(userAgentComponentsToString, "userAgentComponentsToString");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  mergeUserAgent,
  userAgentComponentsToString
});
//# sourceMappingURL=UserAgent.js.map
