"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var BatteryCC_exports = {};
__export(BatteryCC_exports, {
  handleBatteryReport: () => handleBatteryReport
});
module.exports = __toCommonJS(BatteryCC_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
function handleBatteryReport(ctx, node, command) {
  const endpoint = node.getEndpoint(command.endpointIndex ?? 0) ?? node;
  if (command.level === 255) {
    node.emit("notification", endpoint, import_core.CommandClasses.Battery, {
      eventType: "battery low",
      urgency: command.rechargeOrReplace || import_cc.BatteryReplacementStatus.Soon
    });
  }
}
__name(handleBatteryReport, "handleBatteryReport");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handleBatteryReport
});
//# sourceMappingURL=BatteryCC.js.map
