"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ClockCC_exports = {};
__export(ClockCC_exports, {
  getDefaultClockHandlerStore: () => getDefaultClockHandlerStore,
  handleClockReport: () => handleClockReport
});
module.exports = __toCommonJS(ClockCC_exports);
function getDefaultClockHandlerStore() {
  return {
    busySettingClock: false
  };
}
__name(getDefaultClockHandlerStore, "getDefaultClockHandlerStore");
async function handleClockReport(ctx, node, command, store) {
  if (store.busySettingClock)
    return;
  const endpoint = node.getEndpoint(command.endpointIndex);
  if (!endpoint)
    return;
  let now = /* @__PURE__ */ new Date();
  const seconds = now.getSeconds();
  if (seconds >= 30) {
    now = new Date(now.getTime() + (60 - seconds) * 1e3);
  }
  const hours = now.getHours();
  const minutes = now.getMinutes();
  let weekday = now.getDay();
  if (weekday === 0)
    weekday = 7;
  if (command.weekday !== weekday || command.hour !== hours || command.minute !== minutes) {
    ctx.logNode(node.id, `detected a deviation of the node's clock, updating it...`);
    try {
      store.busySettingClock = true;
      await endpoint.commandClasses.Clock.set(hours, minutes, weekday);
    } catch {
    } finally {
      store.busySettingClock = false;
    }
  }
}
__name(handleClockReport, "handleClockReport");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getDefaultClockHandlerStore,
  handleClockReport
});
//# sourceMappingURL=ClockCC.js.map
