"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DeviceResetLocallyCC_exports = {};
__export(DeviceResetLocallyCC_exports, {
  handleDeviceResetLocallyNotification: () => handleDeviceResetLocallyNotification
});
module.exports = __toCommonJS(DeviceResetLocallyCC_exports);
var import_shared = require("@zwave-js/shared");
var import_Inclusion = require("../../controller/Inclusion.js");
function handleDeviceResetLocallyNotification(ctx, controller, node, cmd) {
  if (cmd.endpointIndex !== 0) {
    ctx.logNode(node.id, {
      message: `Received reset locally notification from non-root endpoint - ignoring it...`,
      direction: "inbound"
    });
    return;
  }
  setTimeout(async () => {
    ctx.logNode(node.id, {
      message: `The node was reset locally, removing it`,
      direction: "inbound"
    });
    try {
      await controller.removeFailedNodeInternal(node.id, import_Inclusion.RemoveNodeReason.Reset);
    } catch (e) {
      ctx.logNode(node.id, {
        message: `removing the node failed: ${(0, import_shared.getErrorMessage)(e)}`,
        level: "error"
      });
    }
  }, 500);
}
__name(handleDeviceResetLocallyNotification, "handleDeviceResetLocallyNotification");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handleDeviceResetLocallyNotification
});
//# sourceMappingURL=DeviceResetLocallyCC.js.map
