"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MockNodeBehaviors_exports = {};
__export(MockNodeBehaviors_exports, {
  createDefaultBehaviors: () => createDefaultBehaviors
});
module.exports = __toCommonJS(MockNodeBehaviors_exports);
var import_cc = require("@zwave-js/cc");
var import_ZWavePlusCC = require("@zwave-js/cc/ZWavePlusCC");
var import_ZWaveProtocolCC = require("@zwave-js/cc/ZWaveProtocolCC");
var import_core = require("@zwave-js/core");
var import_Basic = require("./mockCCBehaviors/Basic.js");
var import_BinarySensor = require("./mockCCBehaviors/BinarySensor.js");
var import_BinarySwitch = require("./mockCCBehaviors/BinarySwitch.js");
var import_ColorSwitch = require("./mockCCBehaviors/ColorSwitch.js");
var import_Configuration = require("./mockCCBehaviors/Configuration.js");
var import_EnergyProduction = require("./mockCCBehaviors/EnergyProduction.js");
var import_Indicator = require("./mockCCBehaviors/Indicator.js");
var import_ManufacturerSpecific = require("./mockCCBehaviors/ManufacturerSpecific.js");
var import_Meter = require("./mockCCBehaviors/Meter.js");
var import_MultiChannel = require("./mockCCBehaviors/MultiChannel.js");
var import_MultilevelSensor = require("./mockCCBehaviors/MultilevelSensor.js");
var import_MultilevelSwitch = require("./mockCCBehaviors/MultilevelSwitch.js");
var import_Notification = require("./mockCCBehaviors/Notification.js");
var import_ScheduleEntryLock = require("./mockCCBehaviors/ScheduleEntryLock.js");
var import_SoundSwitch = require("./mockCCBehaviors/SoundSwitch.js");
var import_ThermostatMode = require("./mockCCBehaviors/ThermostatMode.js");
var import_ThermostatSetback = require("./mockCCBehaviors/ThermostatSetback.js");
var import_ThermostatSetpoint = require("./mockCCBehaviors/ThermostatSetpoint.js");
var import_UserCode = require("./mockCCBehaviors/UserCode.js");
var import_WindowCovering = require("./mockCCBehaviors/WindowCovering.js");
const respondToRequestNodeInfo = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ZWaveProtocolCC.ZWaveProtocolCCRequestNodeInformationFrame) {
      const cc = new import_ZWaveProtocolCC.ZWaveProtocolCCNodeInformationFrame({
        nodeId: self.id,
        ...self.capabilities,
        supportedCCs: [...self.implementedCCs].filter(([ccId]) => ccId !== import_core.CommandClasses.Basic).filter(([, info]) => info.isSupported).map(([ccId]) => ccId)
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToVersionCCCommandClassGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.VersionCCCommandClassGet) {
      const endpoint = receivedCC.endpointIndex === 0 ? self : self.endpoints.get(receivedCC.endpointIndex);
      if (!endpoint)
        return;
      let version = 0;
      for (const ep of [self, ...self.endpoints.values()]) {
        const info = ep.implementedCCs.get(receivedCC.requestedCC);
        if (info?.version) {
          version = info.version;
          break;
        }
      }
      if (version === 0 && receivedCC.requestedCC === import_core.CommandClasses.Basic) {
        version = 1;
      }
      const cc = new import_cc.VersionCCCommandClassReport({
        nodeId: self.id,
        endpointIndex: "index" in endpoint ? endpoint.index : void 0,
        requestedCC: receivedCC.requestedCC,
        ccVersion: version
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToZWavePlusCCGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ZWavePlusCC.ZWavePlusCCGet) {
      const cc = new import_ZWavePlusCC.ZWavePlusCCReport({
        nodeId: controller.ownNodeId,
        zwavePlusVersion: 2,
        nodeType: import_cc.ZWavePlusNodeType.Node,
        roleType: self.capabilities.isListening ? import_cc.ZWavePlusRoleType.AlwaysOnSlave : self.capabilities.isFrequentListening ? import_cc.ZWavePlusRoleType.SleepingListeningSlave : import_cc.ZWavePlusRoleType.SleepingReportingSlave,
        installerIcon: 0,
        userIcon: 0
      });
      return { action: "sendCC", cc, ackRequested: true };
    }
  }
};
const respondToS0ZWavePlusCCGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.SecurityCCCommandEncapsulation && receivedCC.encapsulated instanceof import_ZWavePlusCC.ZWavePlusCCGet) {
      let cc = new import_ZWavePlusCC.ZWavePlusCCReport({
        nodeId: controller.ownNodeId,
        zwavePlusVersion: 2,
        nodeType: import_cc.ZWavePlusNodeType.Node,
        roleType: self.capabilities.isListening ? import_cc.ZWavePlusRoleType.AlwaysOnSlave : self.capabilities.isFrequentListening ? import_cc.ZWavePlusRoleType.SleepingListeningSlave : import_cc.ZWavePlusRoleType.SleepingReportingSlave,
        installerIcon: 0,
        userIcon: 0
      });
      cc = import_cc.SecurityCC.encapsulate(self.id, self.securityManagers.securityManager, cc);
      return { action: "sendCC", cc, ackRequested: true };
    }
  }
};
const respondToS2ZWavePlusCCGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.Security2CCMessageEncapsulation && receivedCC.encapsulated instanceof import_ZWavePlusCC.ZWavePlusCCGet) {
      let cc = new import_ZWavePlusCC.ZWavePlusCCReport({
        nodeId: controller.ownNodeId,
        zwavePlusVersion: 2,
        nodeType: import_cc.ZWavePlusNodeType.Node,
        roleType: self.capabilities.isListening ? import_cc.ZWavePlusRoleType.AlwaysOnSlave : self.capabilities.isFrequentListening ? import_cc.ZWavePlusRoleType.SleepingListeningSlave : import_cc.ZWavePlusRoleType.SleepingReportingSlave,
        installerIcon: 0,
        userIcon: 0
      });
      cc = import_cc.Security2CC.encapsulate(cc, self.id, self.securityManagers);
      return { action: "sendCC", cc };
    }
  }
};
function createDefaultBehaviors() {
  return [
    respondToRequestNodeInfo,
    ...import_MultiChannel.MultiChannelCCHooks,
    ...import_MultiChannel.MultiChannelCCBehaviors,
    respondToVersionCCCommandClassGet,
    respondToZWavePlusCCGet,
    respondToS0ZWavePlusCCGet,
    respondToS2ZWavePlusCCGet,
    ...import_Basic.BasicCCBehaviors,
    ...import_BinarySensor.BinarySensorCCBehaviors,
    ...import_BinarySwitch.BinarySwitchCCBehaviors,
    ...import_ColorSwitch.ColorSwitchCCBehaviors,
    ...import_Configuration.ConfigurationCCBehaviors,
    ...import_EnergyProduction.EnergyProductionCCBehaviors,
    ...import_Indicator.IndicatorCCBehaviors,
    ...import_ManufacturerSpecific.ManufacturerSpecificCCBehaviors,
    ...import_Meter.MeterCCBehaviors,
    ...import_MultilevelSensor.MultilevelSensorCCBehaviors,
    ...import_MultilevelSwitch.MultilevelSwitchCCBehaviors,
    ...import_Notification.NotificationCCBehaviors,
    ...import_ScheduleEntryLock.ScheduleEntryLockCCBehaviors,
    ...import_SoundSwitch.SoundSwitchCCBehaviors,
    ...import_ThermostatMode.ThermostatModeCCBehaviors,
    ...import_ThermostatSetpoint.ThermostatSetpointCCBehaviors,
    ...import_ThermostatSetback.ThermostatSetbackCCBehaviors,
    ...import_UserCode.UserCodeCCBehaviors,
    ...import_WindowCovering.WindowCoveringCCBehaviors
  ];
}
__name(createDefaultBehaviors, "createDefaultBehaviors");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createDefaultBehaviors
});
//# sourceMappingURL=MockNodeBehaviors.js.map
