import { type CommandClasses, type MaybeNotKnown, type QuerySecurityClasses, SecurityClass, type SetSecurityClass } from "@zwave-js/core";
import type { Driver } from "../../driver/Driver.js";
import type { DeviceClass } from "../DeviceClass.js";
import { NetworkRoleMixin } from "./01_NetworkRole.js";
export declare abstract class NodeSecurityMixin extends NetworkRoleMixin implements QuerySecurityClasses, SetSecurityClass {
    constructor(nodeId: number, driver: Driver, index: number, deviceClass?: DeviceClass, supportedCCs?: CommandClasses[]);
    get isSecure(): MaybeNotKnown<boolean>;
    hasSecurityClass(securityClass: SecurityClass): MaybeNotKnown<boolean>;
    setSecurityClass(securityClass: SecurityClass, granted: boolean): void;
    getHighestSecurityClass(): MaybeNotKnown<SecurityClass>;
}
//# sourceMappingURL=05_Security.d.ts.map