import { type FirmwareUpdateCapabilities, FirmwareUpdateMetaDataCCGet, type FirmwareUpdateMetaDataCCMetaDataGet, type FirmwareUpdateMetaDataCCPrepareGet, type FirmwareUpdateMetaDataCCRequestGet, type FirmwareUpdateOptions, type FirmwareUpdateResult } from "@zwave-js/cc";
import { type Firmware } from "@zwave-js/core";
import { type Task } from "../../driver/Task.js";
import { SchedulePollMixin } from "./60_ScheduledPoll.js";
/** Checks if a task belongs to a route rebuilding process */
export declare function isFirmwareUpdateOTATask(t: Task<unknown>): boolean;
export interface NodeFirmwareUpdate {
    /**
     * Aborts an active firmware update process
     */
    abortFirmwareUpdate(): Promise<void>;
    /**
     * Performs an OTA firmware upgrade of one or more chips on this node.
     *
     * This method will resolve after the process has **COMPLETED**. Failure to start any one of the provided updates will throw an error.
     *
     * **WARNING: Use at your own risk! We don't take any responsibility if your devices don't work after an update.**
     *
     * @param updates An array of firmware updates that will be done in sequence
     *
     * @returns Whether all of the given updates were successful.
     */
    updateFirmware(updates: Firmware[], options?: FirmwareUpdateOptions): Promise<FirmwareUpdateResult>;
    /**
     * Returns whether a firmware update is in progress for this node.
     */
    isFirmwareUpdateInProgress(): boolean;
    /**
     * Retrieves the firmware update capabilities of a node to decide which options to offer a user prior to the update.
     * This communicates with the node to retrieve fresh information.
     */
    getFirmwareUpdateCapabilities(): Promise<FirmwareUpdateCapabilities>;
    /**
     * Retrieves the firmware update capabilities of a node to decide which options to offer a user prior to the update.
     * This method uses cached information from the most recent interview.
     */
    getFirmwareUpdateCapabilitiesCached(): FirmwareUpdateCapabilities;
}
export declare abstract class FirmwareUpdateMixin extends SchedulePollMixin implements NodeFirmwareUpdate {
    getFirmwareUpdateCapabilities(): Promise<FirmwareUpdateCapabilities>;
    getFirmwareUpdateCapabilitiesCached(): FirmwareUpdateCapabilities;
    private _abortFirmwareUpdate;
    abortFirmwareUpdate(): Promise<void>;
    private _previousFirmwareCRC;
    /** Is used to remember fragment requests that came in before they were able to be handled */
    private _firmwareUpdatePrematureRequest;
    updateFirmware(updates: Firmware[], options?: FirmwareUpdateOptions): Promise<FirmwareUpdateResult>;
    isFirmwareUpdateInProgress(): boolean;
    private getUpdateFirmwareTask;
    /** Prepares the firmware update of a single target by collecting the necessary information */
    private prepareFirmwareUpdateInternal;
    protected handleUnexpectedFirmwareUpdateGet(command: FirmwareUpdateMetaDataCCGet): Promise<void>;
    /** Kicks off a firmware update of a single target. Returns whether the node accepted resuming and non-secure transfer */
    private beginFirmwareUpdateInternal;
    protected handleFirmwareUpdateMetaDataGet(command: FirmwareUpdateMetaDataCCMetaDataGet): Promise<void>;
    protected handleFirmwareUpdateRequestGet(command: FirmwareUpdateMetaDataCCRequestGet): Promise<void>;
    protected handleFirmwareUpdatePrepareGet(command: FirmwareUpdateMetaDataCCPrepareGet): Promise<void>;
    private sendCorruptedFirmwareUpdateReport;
    private hasPendingFirmwareUpdateFragment;
    private doFirmwareUpdateInternal;
}
//# sourceMappingURL=70_FirmwareUpdate.d.ts.map