import { DeviceConfig } from "@zwave-js/config";
import { type MaybeNotKnown } from "@zwave-js/core";
import { FirmwareUpdateMixin } from "./70_FirmwareUpdate.js";
export interface NodeDeviceConfig {
    /**
     * Contains additional information about this node, loaded from a config file
     */
    get deviceConfig(): MaybeNotKnown<DeviceConfig>;
    /**
     * Returns the manufacturer/brand name defined in the device configuration,
     * or looks it up from the manufacturer database if no config is available
     */
    get manufacturer(): MaybeNotKnown<string>;
    /**
     * Returns the device label defined in the device configuration.
     */
    get label(): MaybeNotKnown<string>;
    get deviceDatabaseUrl(): MaybeNotKnown<string>;
    /**
     * Returns whether the device config for this node has changed since the last interview.
     * If it has, the node likely needs to be re-interviewed for the changes to be picked up.
     */
    hasDeviceConfigChanged(): MaybeNotKnown<boolean>;
}
export declare abstract class DeviceConfigMixin extends FirmwareUpdateMixin implements NodeDeviceConfig {
    private _deviceConfig;
    /**
     * Contains additional information about this node, loaded from a config file
     */
    get deviceConfig(): MaybeNotKnown<DeviceConfig>;
    protected set deviceConfig(value: MaybeNotKnown<DeviceConfig>);
    /**
     * Returns the manufacturer/brand name defined in the device configuration,
     * or looks it up from the manufacturer database if no config is available
     */
    get manufacturer(): MaybeNotKnown<string>;
    /**
     * Returns the device label defined in the device configuration.
     */
    get label(): MaybeNotKnown<string>;
    get deviceDatabaseUrl(): MaybeNotKnown<string>;
    /**
     * Returns whether the device config for this node has changed since the last interview.
     * If it has, the node likely needs to be re-interviewed for the changes to be picked up.
     */
    hasDeviceConfigChanged(): MaybeNotKnown<boolean>;
    protected set cachedDeviceConfigHash(value: Uint8Array | undefined);
    private _currentDeviceConfigHash;
    protected set currentDeviceConfigHash(value: Uint8Array | undefined);
    /**
     * Loads the device configuration for this node from a config file
     */
    protected loadDeviceConfig(): Promise<void>;
}
//# sourceMappingURL=80_DeviceConfig.d.ts.map