"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MultilevelSwitch_exports = {};
__export(MultilevelSwitch_exports, {
  MultilevelSwitchCCBehaviors: () => MultilevelSwitchCCBehaviors
});
module.exports = __toCommonJS(MultilevelSwitch_exports);
var import_cc = require("@zwave-js/cc");
var import_MultilevelSwitchCC = require("@zwave-js/cc/MultilevelSwitchCC");
var import_core = require("@zwave-js/core");
const defaultCapabilities = {
  defaultValue: 0,
  primarySwitchType: import_cc.SwitchType["Down/Up"]
};
const STATE_KEY_PREFIX = "MultilevelSwitch_";
const StateKeys = {
  currentValue: `${STATE_KEY_PREFIX}currentValue`
};
const respondToMultilevelSwitchGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_MultilevelSwitchCC.MultilevelSwitchCCGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Multilevel Switch"], receivedCC.endpointIndex)
      };
      const currentValue = self.state.get(StateKeys.currentValue) ?? capabilities.defaultValue ?? import_core.UNKNOWN_STATE;
      const cc = new import_MultilevelSwitchCC.MultilevelSwitchCCReport({
        nodeId: controller.ownNodeId,
        currentValue,
        // We don't support transitioning yet
        targetValue: currentValue
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToMultilevelSwitchSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_MultilevelSwitchCC.MultilevelSwitchCCSet) {
      self.state.set(StateKeys.currentValue, receivedCC.targetValue);
      return { action: "ok" };
    }
  }
};
const respondToMultilevelSwitchSupportedGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_MultilevelSwitchCC.MultilevelSwitchCCSupportedGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Multilevel Switch"], receivedCC.endpointIndex)
      };
      const cc = new import_MultilevelSwitchCC.MultilevelSwitchCCSupportedReport({
        nodeId: controller.ownNodeId,
        switchType: capabilities.primarySwitchType
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToMultilevelSwitchStartLevelChange = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_MultilevelSwitchCC.MultilevelSwitchCCStartLevelChange) {
      self.state.set(StateKeys.currentValue, receivedCC.direction === "up" ? 99 : 0);
      return { action: "ok" };
    }
  }
};
const respondToMultilevelSwitchStopLevelChange = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_MultilevelSwitchCC.MultilevelSwitchCCStopLevelChange) {
      return { action: "ok" };
    }
  }
};
const MultilevelSwitchCCBehaviors = [
  respondToMultilevelSwitchGet,
  respondToMultilevelSwitchSet,
  respondToMultilevelSwitchSupportedGet,
  respondToMultilevelSwitchStartLevelChange,
  respondToMultilevelSwitchStopLevelChange
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MultilevelSwitchCCBehaviors
});
//# sourceMappingURL=MultilevelSwitch.js.map
