"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ThermostatSetback_exports = {};
__export(ThermostatSetback_exports, {
  ThermostatSetbackCCBehaviors: () => ThermostatSetbackCCBehaviors
});
module.exports = __toCommonJS(ThermostatSetback_exports);
var import_cc = require("@zwave-js/cc");
var import_ThermostatSetbackCC = require("@zwave-js/cc/ThermostatSetbackCC");
const STATE_KEY_PREFIX = "ThermostatSetback_";
const StateKeys = {
  setbackType: `${STATE_KEY_PREFIX}setbackType`,
  setbackState: `${STATE_KEY_PREFIX}setbackState`
};
const respondToThermostatSetbackSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ThermostatSetbackCC.ThermostatSetbackCCSet) {
      self.state.set(StateKeys.setbackType, receivedCC.setbackType);
      self.state.set(StateKeys.setbackState, receivedCC.setbackState);
      return { action: "ok" };
    }
  }
};
const respondToThermostatSetbackGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ThermostatSetbackCC.ThermostatSetbackCCGet) {
      const setbackType = self.state.get(StateKeys.setbackType) ?? import_cc.SetbackType.None;
      const setbackState = self.state.get(StateKeys.setbackState) ?? "Unused";
      const cc = new import_ThermostatSetbackCC.ThermostatSetbackCCReport({
        nodeId: controller.ownNodeId,
        setbackType,
        setbackState
      });
      return { action: "sendCC", cc };
    }
  }
};
const ThermostatSetbackCCBehaviors = [
  respondToThermostatSetbackGet,
  respondToThermostatSetbackSet
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ThermostatSetbackCCBehaviors
});
//# sourceMappingURL=ThermostatSetback.js.map
