import { Bytes } from "@zwave-js/shared";
export declare enum AttachmentTypes {
    NetworkKeys = 3,
    FrameComment = 4,
    Session = 5
}
export type ZLFAttachmentConstructor<T extends ZLFAttachment> = typeof ZLFAttachment & {
    new (options: ZLFAttachmentOptions): T;
};
export interface ZLFAttachmentBaseOptions {
}
export interface ZLFAttachmentOptions extends ZLFAttachmentBaseOptions {
    type: AttachmentTypes;
    version: number;
    data?: Bytes;
}
export declare class ZLFAttachmentRaw {
    readonly type: AttachmentTypes;
    readonly version: number;
    readonly data: Bytes;
    constructor(type: AttachmentTypes, version: number, data: Bytes);
    static parse(buffer: Uint8Array): {
        raw: ZLFAttachmentRaw;
        bytesRead: number;
    };
    withData(data: Bytes): ZLFAttachmentRaw;
}
/**
 * Represents a ZLF attachment for parsing data from a Zniffer trace
 */
export declare class ZLFAttachment {
    constructor(options: ZLFAttachmentOptions);
    static parse(buffer: Uint8Array): {
        attachment: ZLFAttachment;
        bytesRead: number;
    };
    /** Creates an instance of the attachment that is serialized in the given buffer */
    static from(raw: ZLFAttachmentRaw): ZLFAttachment;
    type: AttachmentTypes;
    version: number;
    data: Bytes;
    /** Serializes this attachment into a Buffer */
    serialize(): Bytes;
}
export interface ZLFNetworkKeysAttachmentOptions extends ZLFAttachmentBaseOptions {
    homeId: number;
    keys: Uint8Array[];
    tempKeys: Uint8Array[];
}
export declare class ZLFNetworkKeysAttachment extends ZLFAttachment {
    constructor(options: ZLFNetworkKeysAttachmentOptions);
    static from(raw: ZLFAttachmentRaw): ZLFNetworkKeysAttachment;
    readonly homeId: number;
    readonly keys: Bytes[];
    readonly tempKeys: Bytes[];
}
export interface ZLFFrameCommentAttachmentOptions extends ZLFAttachmentBaseOptions {
    comment: string;
    version?: number;
    data?: Bytes;
}
export declare class ZLFFrameCommentAttachment extends ZLFAttachment {
    constructor(options: ZLFFrameCommentAttachmentOptions);
    static from(_raw: ZLFAttachmentRaw): ZLFFrameCommentAttachment;
    readonly comment: string;
}
export interface ZLFSessionAttachmentOptions extends ZLFAttachmentBaseOptions {
    sessionId: number;
    version?: number;
    data?: Bytes;
}
export declare class ZLFSessionAttachment extends ZLFAttachment {
    constructor(options: ZLFSessionAttachmentOptions);
    static from(_raw: ZLFAttachmentRaw): ZLFSessionAttachment;
    readonly sessionId: number;
}
//# sourceMappingURL=ZLFAttachment.d.ts.map