"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ZLFAttachment_exports = {};
__export(ZLFAttachment_exports, {
  AttachmentTypes: () => AttachmentTypes,
  ZLFAttachment: () => ZLFAttachment,
  ZLFAttachmentRaw: () => ZLFAttachmentRaw,
  ZLFFrameCommentAttachment: () => ZLFFrameCommentAttachment,
  ZLFNetworkKeysAttachment: () => ZLFNetworkKeysAttachment,
  ZLFSessionAttachment: () => ZLFSessionAttachment
});
module.exports = __toCommonJS(ZLFAttachment_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var AttachmentTypes;
(function(AttachmentTypes2) {
  AttachmentTypes2[AttachmentTypes2["NetworkKeys"] = 3] = "NetworkKeys";
  AttachmentTypes2[AttachmentTypes2["FrameComment"] = 4] = "FrameComment";
  AttachmentTypes2[AttachmentTypes2["Session"] = 5] = "Session";
})(AttachmentTypes || (AttachmentTypes = {}));
class ZLFAttachmentRaw {
  static {
    __name(this, "ZLFAttachmentRaw");
  }
  type;
  version;
  data;
  constructor(type, version, data) {
    this.type = type;
    this.version = version;
    this.data = data;
  }
  static parse(buffer) {
    if (buffer.length < 2) {
      throw new import_core.ZWaveError("Incomplete ZLF attachment", import_core.ZWaveErrorCodes.PacketFormat_Truncated);
    }
    const type = buffer[0];
    const version = buffer[1];
    const data = import_shared.Bytes.view(buffer.subarray(2));
    return {
      raw: new ZLFAttachmentRaw(type, version, data),
      bytesRead: buffer.length
    };
  }
  withData(data) {
    return new ZLFAttachmentRaw(this.type, this.version, data);
  }
}
function getZLFAttachmentConstructor(raw) {
  switch (raw.type) {
    case AttachmentTypes.NetworkKeys:
      return ZLFNetworkKeysAttachment;
    case AttachmentTypes.FrameComment:
      return ZLFFrameCommentAttachment;
    case AttachmentTypes.Session:
      return ZLFSessionAttachment;
    default:
      return ZLFAttachment;
  }
}
__name(getZLFAttachmentConstructor, "getZLFAttachmentConstructor");
class ZLFAttachment {
  static {
    __name(this, "ZLFAttachment");
  }
  constructor(options) {
    this.type = options.type;
    this.version = options.version;
    this.data = options.data || new import_shared.Bytes();
  }
  static parse(buffer) {
    const { raw, bytesRead } = ZLFAttachmentRaw.parse(buffer);
    const Constructor = getZLFAttachmentConstructor(raw);
    return {
      attachment: Constructor.from(raw),
      bytesRead
    };
  }
  /** Creates an instance of the attachment that is serialized in the given buffer */
  static from(raw) {
    return new this({
      type: raw.type,
      version: raw.version,
      data: raw.data
    });
  }
  type;
  version;
  data;
  /** Serializes this attachment into a Buffer */
  serialize() {
    return import_shared.Bytes.concat([
      import_shared.Bytes.from([this.type, this.version]),
      this.data
    ]);
  }
}
class ZLFNetworkKeysAttachment extends ZLFAttachment {
  static {
    __name(this, "ZLFNetworkKeysAttachment");
  }
  constructor(options) {
    super({
      type: AttachmentTypes.NetworkKeys,
      version: 1
    });
    this.homeId = options.homeId;
    this.keys = options.keys.map((key) => import_shared.Bytes.from(key));
    this.tempKeys = options.tempKeys.map((key) => import_shared.Bytes.from(key));
  }
  static from(raw) {
    if (raw.data.length < 12) {
      throw new import_core.ZWaveError("Incomplete NetworkKeysAttachment", import_core.ZWaveErrorCodes.PacketFormat_Truncated);
    }
    let offset = 0;
    const homeId = raw.data.readUInt32BE(offset);
    offset += 4;
    const tempKeys = [];
    const keys = [];
    let count = raw.data[offset++];
    let isTemporary = !!(raw.data[offset++] & 1);
    if (offset + count * 16 + 6 >= raw.data.length) {
      throw new import_core.ZWaveError("Incomplete NetworkKeysAttachment", import_core.ZWaveErrorCodes.PacketFormat_Truncated);
    }
    for (let i = 0; i < count; i++) {
      const key = raw.data.subarray(offset, offset + 16);
      offset += 16;
      if (isTemporary) {
        tempKeys.push(key);
      } else {
        keys.push(key);
      }
    }
    offset += 4;
    count = raw.data[offset++];
    isTemporary = !!(raw.data[offset++] & 1);
    if (offset + count * 16 > raw.data.length) {
      throw new import_core.ZWaveError("Incomplete NetworkKeysAttachment", import_core.ZWaveErrorCodes.PacketFormat_Truncated);
    }
    for (let i = 0; i < count; i++) {
      const key = raw.data.subarray(offset, offset + 16);
      offset += 16;
      if (isTemporary) {
        tempKeys.push(key);
      } else {
        keys.push(key);
      }
    }
    return new ZLFNetworkKeysAttachment({
      homeId,
      keys,
      tempKeys
    });
  }
  homeId;
  keys;
  tempKeys;
}
class ZLFFrameCommentAttachment extends ZLFAttachment {
  static {
    __name(this, "ZLFFrameCommentAttachment");
  }
  constructor(options) {
    super({
      type: AttachmentTypes.FrameComment,
      version: options.version || 1,
      data: options.data
    });
    this.comment = options.comment;
  }
  static from(_raw) {
    throw new import_core.ZWaveError("ZLFFrameCommentAttachment parsing not yet implemented", import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
  }
  comment;
}
class ZLFSessionAttachment extends ZLFAttachment {
  static {
    __name(this, "ZLFSessionAttachment");
  }
  constructor(options) {
    super({
      type: AttachmentTypes.Session,
      version: options.version || 1,
      data: options.data
    });
    this.sessionId = options.sessionId;
  }
  static from(_raw) {
    throw new import_core.ZWaveError("ZLFSessionAttachment parsing not yet implemented", import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
  }
  sessionId;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AttachmentTypes,
  ZLFAttachment,
  ZLFAttachmentRaw,
  ZLFFrameCommentAttachment,
  ZLFNetworkKeysAttachment,
  ZLFSessionAttachment
});
//# sourceMappingURL=ZLFAttachment.js.map
