"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ZLFEntry_exports = {};
__export(ZLFEntry_exports, {
  ZLFEntryKind: () => ZLFEntryKind,
  captureToZLFEntry: () => captureToZLFEntry,
  parseZLFEntry: () => parseZLFEntry,
  parseZLFHeader: () => parseZLFHeader
});
module.exports = __toCommonJS(ZLFEntry_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var import_ZLFAttachment = require("./ZLFAttachment.js");
function captureToZLFEntry(capture) {
  const buffer = new import_shared.Bytes(14 + capture.rawData.length).fill(0);
  let ticks = BigInt(capture.timestamp.getTime()) * 10000n + 621355968000000000n;
  ticks = ticks | 2n << 62n;
  buffer.writeBigUInt64LE(ticks, 0);
  const direction = 0;
  buffer[8] = direction | 1;
  buffer.writeUInt32LE(capture.rawData.length, 9);
  buffer.set(capture.rawData, 13);
  buffer[buffer.length - 1] = 254;
  return buffer;
}
__name(captureToZLFEntry, "captureToZLFEntry");
function parseZLFHeader(buffer) {
  if (buffer.length < 2048) {
    throw new import_core.ZWaveError("Invalid ZLF file: header too small", import_core.ZWaveErrorCodes.Argument_Invalid);
  }
  const bytes = import_shared.Bytes.view(buffer);
  const znifferVersion = bytes[0];
  const checksum = bytes.readUInt16BE(2046);
  return {
    znifferVersion,
    checksum,
    bytesRead: 2048
  };
}
__name(parseZLFHeader, "parseZLFHeader");
var ZLFEntryKind;
(function(ZLFEntryKind2) {
  ZLFEntryKind2[ZLFEntryKind2["Zniffer"] = 0] = "Zniffer";
  ZLFEntryKind2[ZLFEntryKind2["Attachment"] = 6] = "Attachment";
})(ZLFEntryKind || (ZLFEntryKind = {}));
function parseZLFEntry(buffer, offset, accumulator) {
  const bytes = import_shared.Bytes.view(buffer.subarray(offset));
  if (bytes.length < 14) {
    throw new import_core.ZWaveError("Invalid ZLF file: entry truncated", import_core.ZWaveErrorCodes.PacketFormat_Truncated);
  }
  const ticks = bytes.readBigUInt64LE(0);
  const timeStampMask = (1n << 62n) - 1n;
  const jsTimestamp = Number(((ticks & timeStampMask) - 621355968000000000n) / 10000n);
  const timestamp = new Date(jsTimestamp);
  const rawDataLength = bytes.readUInt32LE(9);
  const totalLength = 14 + rawDataLength;
  if (bytes.length < totalLength) {
    throw new import_core.ZWaveError("Invalid ZLF file: entry truncated", import_core.ZWaveErrorCodes.PacketFormat_Truncated);
  }
  const kind = 254 - bytes[totalLength - 1];
  if (kind !== ZLFEntryKind.Zniffer && kind !== ZLFEntryKind.Attachment) {
    return {
      complete: true,
      bytesRead: totalLength,
      entries: []
    };
  }
  let rawData = bytes.subarray(13, totalLength - 1);
  if (accumulator) {
    rawData = import_shared.Bytes.concat([
      accumulator.rawData,
      rawData
    ]);
  }
  const parsed = [];
  try {
    if (kind === ZLFEntryKind.Zniffer) {
      while (rawData.length > 0) {
        const { msg, bytesRead } = import_serial.ZnifferMessage.parse(rawData);
        if (bytesRead === 0)
          break;
        const capture = {
          timestamp,
          rawData: rawData.subarray(0, bytesRead),
          frameData: msg.payload
        };
        if (msg instanceof import_serial.ZnifferDataMessage) {
          parsed.push({
            kind: ZLFEntryKind.Zniffer,
            type: import_serial.ZnifferMessageType.Data,
            msg,
            capture
          });
        } else {
          parsed.push({
            kind: ZLFEntryKind.Zniffer,
            type: import_serial.ZnifferMessageType.Command,
            msg,
            capture
          });
        }
        rawData = rawData.subarray(bytesRead);
      }
    } else if (kind === ZLFEntryKind.Attachment) {
      try {
        const { attachment } = import_ZLFAttachment.ZLFAttachment.parse(rawData);
        parsed.push({
          kind: ZLFEntryKind.Attachment,
          attachment
        });
      } catch (e) {
        if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Deserialization_NotImplemented) {
          console.warn("Ignoring unsupported ZLF attachment");
        }
      }
    }
    return {
      complete: true,
      bytesRead: totalLength,
      entries: parsed
    };
  } catch (e) {
    if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.PacketFormat_Truncated) {
      accumulator ??= {
        timestamp,
        rawData: new import_shared.Bytes(),
        frameData: new import_shared.Bytes()
        // Cannot be determined yet
      };
      accumulator.rawData = rawData;
      return {
        complete: false,
        bytesRead: totalLength,
        accumulator,
        // Include what was parsed already
        entries: parsed
      };
    }
    debugger;
    throw e;
  }
}
__name(parseZLFEntry, "parseZLFEntry");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ZLFEntryKind,
  captureToZLFEntry,
  parseZLFEntry,
  parseZLFHeader
});
//# sourceMappingURL=ZLFEntry.js.map
