export declare enum BootloaderState {
    Menu = 0,
    UploadingFirmware = 1
}
/** Encapsulates information about the currently active bootloader */
export declare class Bootloader {
    constructor(writeSerial: (data: Uint8Array) => Promise<void>, version: string, options: {
        num: number;
        option: string;
    }[]);
    readonly writeSerial: (data: Uint8Array) => Promise<void>;
    state: BootloaderState;
    readonly version: string;
    readonly options: ReadonlyMap<number, string>;
    readonly uploadOption: number;
    readonly runOption: number;
    selectOption(option: number): Promise<boolean>;
    findOption(predicate: (option: string) => boolean): number | undefined;
    beginUpload(): Promise<void>;
    runApplication(): Promise<void>;
    uploadFragment(fragmentNumber: number, data: Uint8Array): Promise<void>;
    finishUpload(): Promise<void>;
}
//# sourceMappingURL=Bootloader.d.ts.map