import { StateMachine } from "@zwave-js/core";
import { type Message } from "@zwave-js/serial";
export type SerialAPICommandState = {
    value: "initial";
} | {
    value: "sending";
} | {
    value: "waitingForACK";
} | {
    value: "waitingForResponse";
} | {
    value: "waitingForCallback";
    responseTimedOut?: boolean;
} | {
    value: "success";
    result?: Message;
    done: true;
} | ({
    value: "failure";
} & SerialAPICommandMachineFailure);
export type SerialAPICommandMachineFailure = {
    reason: "ACK timeout";
    result?: undefined;
} | {
    reason: "CAN";
    result?: undefined;
} | {
    reason: "NAK";
    result?: undefined;
} | {
    reason: "response timeout";
    result?: undefined;
} | {
    reason: "callback timeout";
    result?: undefined;
} | {
    reason: "response NOK";
    result: Message;
} | {
    reason: "callback NOK";
    result: Message;
};
export type SerialAPICommandMachineInput = {
    value: "start";
} | {
    value: "message sent";
} | {
    value: "ACK";
} | {
    value: "CAN";
} | {
    value: "NAK";
} | {
    value: "timeout";
} | {
    value: "response" | "response NOK";
    response: Message;
} | {
    value: "callback" | "callback NOK";
    callback: Message;
};
export type SerialAPICommandMachine = StateMachine<SerialAPICommandState, SerialAPICommandMachineInput>;
export declare function createSerialAPICommandMachine(message: Message): SerialAPICommandMachine;
//# sourceMappingURL=SerialAPICommandMachine.d.ts.map