export const driverPresets = Object.freeze({
    /**
     * Increases several timeouts to be able to deal with controllers
     * and/or nodes that have severe trouble communicating.
     */
    SAFE_MODE: {
        timeouts: {
            // 500 series controllers that take long to respond instead of delaying the callback
            response: 60000,
            // Any controller having trouble reaching a node
            sendDataAbort: 60000,
            sendDataCallback: 65000,
            // Slow nodes taking long to respond
            report: 10000,
            nonce: 20000,
        },
        attempts: {
            // Increase communication attempts with nodes to their maximum
            sendData: 5,
            sendDataJammed: 10,
            nodeInterview: 10,
        },
    },
    /**
     * Disables the unresponsive controller recovery to be able to deal with controllers
     * that frequently become unresponsive for seemingly no reason.
     */
    NO_CONTROLLER_RECOVERY: {
        features: {
            unresponsiveControllerRecovery: false,
        },
    },
    /**
     * @deprecated
     * This used to prevent the driver from enabling the watchdog on 700 series controllers.
     * This is now the default behavior, so this option is no longer necessary.
     */
    NO_WATCHDOG: {
        features: {
            watchdog: false,
        },
    },
    /**
     * Sends battery powered nodes to sleep more quickly in order to save battery.
     */
    BATTERY_SAVE: {
        timeouts: {
            sendToSleep: 100,
        },
    },
    /**
     * Sends battery powered nodes to sleep less quickly to give applications
     * more time between interactions.
     */
    AWAKE_LONGER: {
        timeouts: {
            sendToSleep: 1000,
        },
    },
});
//# sourceMappingURL=ZWaveOptions.js.map