import { BatteryReplacementStatus, } from "@zwave-js/cc";
import { CommandClasses } from "@zwave-js/core";
/** Handles the receipt of a BatteryCCReport */
export function handleBatteryReport(ctx, node, command) {
    const endpoint = node.getEndpoint(command.endpointIndex ?? 0) ?? node;
    if (command.level === 0xff) {
        // Low battery, treat it as a notification
        node.emit("notification", endpoint, CommandClasses.Battery, {
            eventType: "battery low",
            urgency: command.rechargeOrReplace
                || BatteryReplacementStatus.Soon,
        });
    }
}
//# sourceMappingURL=BatteryCC.js.map