import { EntryControlDataTypes, entryControlEventTypeLabels, } from "@zwave-js/cc";
import { CommandClasses } from "@zwave-js/core";
import { getEnumMemberName, pick } from "@zwave-js/shared";
export function getDefaultEntryControlHandlerStore() {
    return {
        recentSequenceNumbers: [],
    };
}
export function handleEntryControlNotification(ctx, node, command, store) {
    if (!node.deviceConfig?.compat?.disableStrictEntryControlDataValidation) {
        if (store.recentSequenceNumbers.includes(command.sequenceNumber)) {
            ctx.logNode(node.id, `Received duplicate Entry Control Notification (sequence number ${command.sequenceNumber}), ignoring...`, "warn");
            return;
        }
        // Keep track of the last 5 sequence numbers
        store.recentSequenceNumbers.unshift(command.sequenceNumber);
        if (store.recentSequenceNumbers.length > 5) {
            store.recentSequenceNumbers.pop();
        }
    }
    // Notify listeners
    const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
    node.emit("notification", endpoint, CommandClasses["Entry Control"], {
        ...pick(command, ["eventType", "dataType", "eventData"]),
        eventTypeLabel: entryControlEventTypeLabels[command.eventType],
        dataTypeLabel: getEnumMemberName(EntryControlDataTypes, command.dataType),
    });
}
//# sourceMappingURL=EntryControlCC.js.map