import { ThermostatMode } from "@zwave-js/cc";
import { ThermostatModeCCGet, ThermostatModeCCReport, ThermostatModeCCSet, ThermostatModeCCSupportedGet, ThermostatModeCCSupportedReport, } from "@zwave-js/cc/ThermostatModeCC";
import { CommandClasses } from "@zwave-js/core";
const defaultCapabilities = {
    supportedModes: [ThermostatMode.Off],
};
const STATE_KEY_PREFIX = "ThermostatMode_";
const StateKeys = {
    mode: `${STATE_KEY_PREFIX}mode`,
    manufacturerData: `${STATE_KEY_PREFIX}manufacturerData`,
};
const respondToThermostatModeSet = {
    handleCC(controller, self, receivedCC) {
        if (receivedCC instanceof ThermostatModeCCSet) {
            self.state.set(StateKeys.mode, receivedCC.mode);
            self.state.set(StateKeys.manufacturerData, receivedCC.manufacturerData);
            return { action: "ok" };
        }
    },
};
const respondToThermostatModeGet = {
    handleCC(controller, self, receivedCC) {
        if (receivedCC instanceof ThermostatModeCCGet) {
            const mode = (self.state.get(StateKeys.mode)
                ?? ThermostatMode.Off);
            const manufacturerData = mode === ThermostatMode["Manufacturer specific"]
                ? self.state.get(StateKeys.manufacturerData)
                : undefined;
            const cc = new ThermostatModeCCReport({
                nodeId: controller.ownNodeId,
                mode,
                // @ts-expect-error I know...
                manufacturerData,
            });
            return { action: "sendCC", cc };
        }
    },
};
const respondToThermostatModeSupportedGet = {
    handleCC(controller, self, receivedCC) {
        if (receivedCC instanceof ThermostatModeCCSupportedGet) {
            const capabilities = {
                ...defaultCapabilities,
                ...self.getCCCapabilities(CommandClasses["Thermostat Mode"], receivedCC.endpointIndex),
            };
            const cc = new ThermostatModeCCSupportedReport({
                nodeId: controller.ownNodeId,
                supportedModes: capabilities.supportedModes,
            });
            return { action: "sendCC", cc };
        }
    },
};
export const ThermostatModeCCBehaviors = [
    respondToThermostatModeGet,
    respondToThermostatModeSet,
    respondToThermostatModeSupportedGet,
];
//# sourceMappingURL=ThermostatMode.js.map