"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var AlarmSensorCC_exports = {};
__export(AlarmSensorCC_exports, {
  AlarmSensorCC: () => AlarmSensorCC,
  AlarmSensorCCAPI: () => AlarmSensorCCAPI,
  AlarmSensorCCGet: () => AlarmSensorCCGet,
  AlarmSensorCCReport: () => AlarmSensorCCReport,
  AlarmSensorCCSupportedGet: () => AlarmSensorCCSupportedGet,
  AlarmSensorCCSupportedReport: () => AlarmSensorCCSupportedReport,
  AlarmSensorCCValues: () => import_CCValues_generated.AlarmSensorCCValues
});
module.exports = __toCommonJS(AlarmSensorCC_exports);
var __validateArgs = __toESM(require("./AlarmSensorCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_AlarmSensorCCAPI_get } = __validateArgs;
let AlarmSensorCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Alarm Sensor"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  let _instanceExtraInitializers = [];
  let _get_decorators;
  var AlarmSensorCCAPI2 = class extends _classSuper {
    static {
      __name(this, "AlarmSensorCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _get_decorators = [validateArgs_AlarmSensorCCAPI_get({ strictEnums: true })];
      __esDecorate(this, null, _get_decorators, { kind: "method", name: "get", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "get" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.get, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AlarmSensorCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.AlarmSensorCommand.Get:
        case import_Types.AlarmSensorCommand.SupportedGet:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    /**
     * Retrieves the current value from this sensor
     * @param sensorType The (optional) sensor type to retrieve the value for
     */
    async get(sensorType) {
      this.assertSupportsCommand(import_Types.AlarmSensorCommand, import_Types.AlarmSensorCommand.Get);
      const cc = new AlarmSensorCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        sensorType
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response)
        return (0, import_shared.pick)(response, ["state", "severity", "duration"]);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getSupportedSensorTypes() {
      this.assertSupportsCommand(import_Types.AlarmSensorCommand, import_Types.AlarmSensorCommand.SupportedGet);
      const cc = new AlarmSensorCCSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response)
        return response.supportedSensorTypes;
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return AlarmSensorCCAPI2 = _classThis;
})();
let AlarmSensorCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Alarm Sensor"]), (0, import_CommandClassDecorators.implementedVersion)(1), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.AlarmSensorCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var AlarmSensorCC2 = class extends _classSuper {
    static {
      __name(this, "AlarmSensorCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AlarmSensorCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      if (endpoint.supportsCC(import_core.CommandClasses.Notification)) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `${this.constructor.name}: skipping interview because Notification CC is supported...`,
          direction: "none"
        });
        this.setInterviewComplete(ctx, true);
        return;
      }
      const api = import_API.CCAPI.create(import_core.CommandClasses["Alarm Sensor"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying supported sensor types...",
        direction: "outbound"
      });
      const supportedSensorTypes = await api.getSupportedSensorTypes();
      if (supportedSensorTypes) {
        const logMessage = `received supported sensor types: ${supportedSensorTypes.map((type) => (0, import_shared.getEnumMemberName)(import_Types.AlarmSensorType, type)).map((name) => `
\xB7 ${name}`).join("")}`;
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      } else {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Querying supported sensor types timed out, skipping interview...",
          level: "warn"
        });
        return;
      }
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Alarm Sensor"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      const supportedSensorTypes = this.getValue(ctx, import_CCValues_generated.AlarmSensorCCValues.supportedSensorTypes) ?? [];
      for (const type of supportedSensorTypes) {
        if (!(0, import_shared.isEnumMember)(import_Types.AlarmSensorType, type))
          continue;
        const sensorName = (0, import_shared.getEnumMemberName)(import_Types.AlarmSensorType, type);
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `querying current value for ${sensorName}...`,
          direction: "outbound"
        });
        const currentValue = await api.get(type);
        if (currentValue) {
          let message = `received current value for ${sensorName}: 
state:    ${currentValue.state}`;
          if (currentValue.severity != void 0) {
            message += `
severity: ${currentValue.severity}`;
          }
          if (currentValue.duration != void 0) {
            message += `
duration: ${currentValue.duration}`;
          }
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message,
            direction: "inbound"
          });
        }
      }
    }
    /**
     * Returns which sensor types are supported.
     * This only works AFTER the interview process
     */
    static getSupportedSensorTypesCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.AlarmSensorCCValues.supportedSensorTypes.endpoint(endpoint.index));
    }
    createMetadataForSensorType(ctx, sensorType) {
      const stateValue = import_CCValues_generated.AlarmSensorCCValues.state(sensorType);
      const severityValue = import_CCValues_generated.AlarmSensorCCValues.severity(sensorType);
      const durationValue = import_CCValues_generated.AlarmSensorCCValues.duration(sensorType);
      this.ensureMetadata(ctx, stateValue);
      this.ensureMetadata(ctx, severityValue);
      this.ensureMetadata(ctx, durationValue);
    }
  };
  return AlarmSensorCC2 = _classThis;
})();
let AlarmSensorCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AlarmSensorCommand.Report)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AlarmSensorCC;
  var AlarmSensorCCReport2 = class extends _classSuper {
    static {
      __name(this, "AlarmSensorCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AlarmSensorCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sensorType = options.sensorType;
      this.state = options.state;
      this.severity = options.severity;
      this.duration = options.duration;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 5, raw.payload[1] !== 255);
      const sourceNodeId = raw.payload[0];
      const sensorType = raw.payload[1];
      const state = raw.payload[2] > 0;
      let severity;
      if (raw.payload[2] > 0 && raw.payload[2] <= 100) {
        severity = raw.payload[2];
      }
      const duration = raw.payload.readUInt16BE(3) || void 0;
      return new this({
        // Alarm Sensor reports may be forwarded by a different node, in this case
        // (and only then!) the payload contains the original node ID
        nodeId: sourceNodeId || ctx.sourceNodeId,
        sensorType,
        state,
        severity,
        duration
      });
    }
    sensorType;
    state;
    severity;
    duration;
    toLogEntry(ctx) {
      const message = {
        "sensor type": (0, import_shared.getEnumMemberName)(import_Types.AlarmSensorType, this.sensorType),
        "alarm state": this.state
      };
      if (this.severity != void 0) {
        message.severity = this.severity;
      }
      if (this.duration != void 0) {
        message.duration = `${this.duration} seconds`;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      this.createMetadataForSensorType(ctx, this.sensorType);
      const stateValue = import_CCValues_generated.AlarmSensorCCValues.state(this.sensorType);
      const severityValue = import_CCValues_generated.AlarmSensorCCValues.severity(this.sensorType);
      const durationValue = import_CCValues_generated.AlarmSensorCCValues.duration(this.sensorType);
      this.setValue(ctx, stateValue, this.state);
      this.setValue(ctx, severityValue, this.severity);
      this.setValue(ctx, durationValue, this.duration);
      return true;
    }
  };
  return AlarmSensorCCReport2 = _classThis;
})();
function testResponseForAlarmSensorGet(sent, received) {
  return sent.sensorType === import_Types.AlarmSensorType.Any || received.sensorType === sent.sensorType;
}
__name(testResponseForAlarmSensorGet, "testResponseForAlarmSensorGet");
let AlarmSensorCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AlarmSensorCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(AlarmSensorCCReport, testResponseForAlarmSensorGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AlarmSensorCC;
  var AlarmSensorCCGet2 = class extends _classSuper {
    static {
      __name(this, "AlarmSensorCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AlarmSensorCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sensorType = options.sensorType ?? import_Types.AlarmSensorType.Any;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    sensorType;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.sensorType]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "sensor type": (0, import_shared.getEnumMemberName)(import_Types.AlarmSensorType, this.sensorType)
        }
      };
    }
  };
  return AlarmSensorCCGet2 = _classThis;
})();
let AlarmSensorCCSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AlarmSensorCommand.SupportedReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedSensorTypes", import_CCValues_generated.AlarmSensorCCValues.supportedSensorTypes)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AlarmSensorCC;
  var AlarmSensorCCSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "AlarmSensorCCSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AlarmSensorCCSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedSensorTypes = options.supportedSensorTypes;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const bitMaskLength = raw.payload[0];
      (0, import_core.validatePayload)(raw.payload.length >= 1 + bitMaskLength);
      const supportedSensorTypes = (0, import_core.parseBitMask)(raw.payload.subarray(1, 1 + bitMaskLength), import_Types.AlarmSensorType["General Purpose"]);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedSensorTypes
      });
    }
    supportedSensorTypes;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      for (const type of this.supportedSensorTypes) {
        this.createMetadataForSensorType(ctx, type);
      }
      return true;
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supported sensor types": this.supportedSensorTypes.map((t) => (0, import_shared.getEnumMemberName)(import_Types.AlarmSensorType, t)).join(", ")
        }
      };
    }
  };
  return AlarmSensorCCSupportedReport2 = _classThis;
})();
let AlarmSensorCCSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.AlarmSensorCommand.SupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(AlarmSensorCCSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AlarmSensorCC;
  var AlarmSensorCCSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "AlarmSensorCCSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AlarmSensorCCSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return AlarmSensorCCSupportedGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AlarmSensorCC,
  AlarmSensorCCAPI,
  AlarmSensorCCGet,
  AlarmSensorCCReport,
  AlarmSensorCCSupportedGet,
  AlarmSensorCCSupportedReport,
  AlarmSensorCCValues
});
//# sourceMappingURL=AlarmSensorCC.js.map
