"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var CRC16CC_exports = {};
__export(CRC16CC_exports, {
  CRC16CC: () => CRC16CC,
  CRC16CCAPI: () => CRC16CCAPI,
  CRC16CCCommandEncapsulation: () => CRC16CCCommandEncapsulation
});
module.exports = __toCommonJS(CRC16CC_exports);
var import_core = require("@zwave-js/core");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_shared = require("@zwave-js/shared");
var import_Types = require("../lib/_Types.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
const headerBuffer = import_shared.Bytes.from([
  import_core.CommandClasses["CRC-16 Encapsulation"],
  import_Types.CRC16Command.CommandEncapsulation
]);
let CRC16CCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["CRC-16 Encapsulation"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  var CRC16CCAPI2 = class extends _classSuper {
    static {
      __name(this, "CRC16CCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      CRC16CCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(_cmd) {
      return true;
    }
    async sendEncapsulated(encapsulatedCC) {
      this.assertSupportsCommand(import_Types.CRC16Command, import_Types.CRC16Command.CommandEncapsulation);
      const cc = new CRC16CCCommandEncapsulation({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        encapsulated: encapsulatedCC
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
  };
  return CRC16CCAPI2 = _classThis;
})();
let CRC16CC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["CRC-16 Encapsulation"]), (0, import_CommandClassDecorators.implementedVersion)(1)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var CRC16CC2 = class extends _classSuper {
    static {
      __name(this, "CRC16CC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      CRC16CC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    /** Tests if a command should be supervised and thus requires encapsulation */
    static requiresEncapsulation(cc) {
      return !!(cc.encapsulationFlags & import_core.EncapsulationFlags.CRC16) && !(cc instanceof CRC16CCCommandEncapsulation);
    }
    /** Encapsulates a command in a CRC-16 CC */
    static encapsulate(cc) {
      const ret = new CRC16CCCommandEncapsulation({
        nodeId: cc.nodeId,
        encapsulated: cc
      });
      ret.encapsulationFlags = cc.encapsulationFlags & ~import_core.EncapsulationFlags.CRC16;
      return ret;
    }
  };
  return CRC16CC2 = _classThis;
})();
function getCCResponseForCommandEncapsulation(ctx, sent) {
  if (sent.encapsulated?.expectsCCResponse(ctx)) {
    return CRC16CCCommandEncapsulation;
  }
}
__name(getCCResponseForCommandEncapsulation, "getCCResponseForCommandEncapsulation");
let CRC16CCCommandEncapsulation = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.CRC16Command.CommandEncapsulation), (0, import_CommandClassDecorators.expectedCCResponse)(getCCResponseForCommandEncapsulation, () => "checkEncapsulated")];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = CRC16CC;
  var CRC16CCCommandEncapsulation2 = class extends _classSuper {
    static {
      __name(this, "CRC16CCCommandEncapsulation");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      CRC16CCCommandEncapsulation2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.encapsulated = options.encapsulated;
      this.encapsulated.encapsulatingCC = this;
    }
    static async from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const ccBuffer = raw.payload.subarray(0, -2);
      let expectedCRC = (0, import_core.CRC16_CCITT)(headerBuffer);
      expectedCRC = (0, import_core.CRC16_CCITT)(ccBuffer, expectedCRC);
      const actualCRC = raw.payload.readUInt16BE(raw.payload.length - 2);
      (0, import_core.validatePayload)(expectedCRC === actualCRC);
      const encapsulated = await import_CommandClass.CommandClass.parse(ccBuffer, ctx);
      return new this({
        nodeId: ctx.sourceNodeId,
        encapsulated
      });
    }
    encapsulated;
    async serialize(ctx) {
      const commandBuffer = await this.encapsulated.serialize(ctx);
      this.payload = import_shared.Bytes.concat([commandBuffer, new import_shared.Bytes(2)]);
      let crc = (0, import_core.CRC16_CCITT)(headerBuffer);
      crc = (0, import_core.CRC16_CCITT)(commandBuffer, crc);
      this.payload.writeUInt16BE(crc, this.payload.length - 2);
      return super.serialize(ctx);
    }
    computeEncapsulationOverhead() {
      return super.computeEncapsulationOverhead() + 2;
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        // Hide the default payload line
        message: void 0
      };
    }
  };
  return CRC16CCCommandEncapsulation2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CRC16CC,
  CRC16CCAPI,
  CRC16CCCommandEncapsulation
});
//# sourceMappingURL=CRC16CC.js.map
