"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ClimateControlScheduleCC_exports = {};
__export(ClimateControlScheduleCC_exports, {
  ClimateControlScheduleCC: () => ClimateControlScheduleCC,
  ClimateControlScheduleCCAPI: () => ClimateControlScheduleCCAPI,
  ClimateControlScheduleCCChangedGet: () => ClimateControlScheduleCCChangedGet,
  ClimateControlScheduleCCChangedReport: () => ClimateControlScheduleCCChangedReport,
  ClimateControlScheduleCCGet: () => ClimateControlScheduleCCGet,
  ClimateControlScheduleCCOverrideGet: () => ClimateControlScheduleCCOverrideGet,
  ClimateControlScheduleCCOverrideReport: () => ClimateControlScheduleCCOverrideReport,
  ClimateControlScheduleCCOverrideSet: () => ClimateControlScheduleCCOverrideSet,
  ClimateControlScheduleCCReport: () => ClimateControlScheduleCCReport,
  ClimateControlScheduleCCSet: () => ClimateControlScheduleCCSet,
  ClimateControlScheduleCCValues: () => import_CCValues_generated.ClimateControlScheduleCCValues
});
module.exports = __toCommonJS(ClimateControlScheduleCC_exports);
var __validateArgs = __toESM(require("./ClimateControlScheduleCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_serializers = require("../lib/serializers.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_ClimateControlScheduleCCAPI_set, validateArgs_ClimateControlScheduleCCAPI_get, validateArgs_ClimateControlScheduleCCAPI_setOverride } = __validateArgs;
let ClimateControlScheduleCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Climate Control Schedule"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _set_decorators;
  let _get_decorators;
  let _setOverride_decorators;
  var ClimateControlScheduleCCAPI2 = class extends _classSuper {
    static {
      __name(this, "ClimateControlScheduleCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _set_decorators = [validateArgs_ClimateControlScheduleCCAPI_set({ strictEnums: true })];
      _get_decorators = [validateArgs_ClimateControlScheduleCCAPI_get({ strictEnums: true })];
      _setOverride_decorators = [validateArgs_ClimateControlScheduleCCAPI_setOverride({ strictEnums: true })];
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _get_decorators, { kind: "method", name: "get", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "get" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.get, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setOverride_decorators, { kind: "method", name: "setOverride", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setOverride" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setOverride, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClimateControlScheduleCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.ClimateControlScheduleCommand.Set:
        case import_Types.ClimateControlScheduleCommand.OverrideSet:
          return true;
        // mandatory
        case import_Types.ClimateControlScheduleCommand.Get:
        case import_Types.ClimateControlScheduleCommand.ChangedGet:
        case import_Types.ClimateControlScheduleCommand.OverrideGet:
          return this.isSinglecast();
      }
      return super.supportsCommand(cmd);
    }
    async set(weekday, switchPoints) {
      this.assertSupportsCommand(import_Types.ClimateControlScheduleCommand, import_Types.ClimateControlScheduleCommand.Set);
      const cc = new ClimateControlScheduleCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        weekday,
        switchPoints
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async get(weekday) {
      this.assertSupportsCommand(import_Types.ClimateControlScheduleCommand, import_Types.ClimateControlScheduleCommand.Get);
      const cc = new ClimateControlScheduleCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        weekday
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.schedule;
    }
    async getChangeCounter() {
      this.assertSupportsCommand(import_Types.ClimateControlScheduleCommand, import_Types.ClimateControlScheduleCommand.ChangedGet);
      const cc = new ClimateControlScheduleCCChangedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.changeCounter;
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getOverride() {
      this.assertSupportsCommand(import_Types.ClimateControlScheduleCommand, import_Types.ClimateControlScheduleCommand.OverrideGet);
      const cc = new ClimateControlScheduleCCOverrideGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return {
          type: response.overrideType,
          state: response.overrideState
        };
      }
    }
    async setOverride(type, state) {
      this.assertSupportsCommand(import_Types.ClimateControlScheduleCommand, import_Types.ClimateControlScheduleCommand.OverrideSet);
      const cc = new ClimateControlScheduleCCOverrideSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        overrideType: type,
        overrideState: state
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return ClimateControlScheduleCCAPI2 = _classThis;
})();
let ClimateControlScheduleCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Climate Control Schedule"]), (0, import_CommandClassDecorators.implementedVersion)(1), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.ClimateControlScheduleCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ClimateControlScheduleCC2 = class extends _classSuper {
    static {
      __name(this, "ClimateControlScheduleCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClimateControlScheduleCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ClimateControlScheduleCC2 = _classThis;
})();
let ClimateControlScheduleCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ClimateControlScheduleCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ClimateControlScheduleCC;
  var ClimateControlScheduleCCSet2 = class extends _classSuper {
    static {
      __name(this, "ClimateControlScheduleCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClimateControlScheduleCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.switchPoints = options.switchPoints;
      this.weekday = options.weekday;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    switchPoints;
    weekday;
    serialize(ctx) {
      const allSwitchPoints = this.switchPoints.slice(0, 9);
      while (allSwitchPoints.length < 9) {
        allSwitchPoints.push({
          hour: 0,
          minute: 0,
          state: "Unused"
        });
      }
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.weekday & 7]),
        ...allSwitchPoints.map((sp) => (0, import_serializers.encodeSwitchpoint)(sp))
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          weekday: (0, import_shared.getEnumMemberName)(import_Types.Weekday, this.weekday),
          switchpoints: this.switchPoints.map((sp) => `
\xB7 ${sp.hour.toString().padStart(2, "0")}:${sp.minute.toString().padStart(2, "0")} --> ${sp.state}`).join("")
        }
      };
    }
  };
  return ClimateControlScheduleCCSet2 = _classThis;
})();
let ClimateControlScheduleCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ClimateControlScheduleCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("schedule", import_CCValues_generated.ClimateControlScheduleCCValues.schedule, (self) => [self.weekday])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ClimateControlScheduleCC;
  var ClimateControlScheduleCCReport2 = class extends _classSuper {
    static {
      __name(this, "ClimateControlScheduleCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClimateControlScheduleCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.weekday = options.weekday;
      this.schedule = options.schedule;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 28);
      const weekday = raw.payload[0] & 7;
      const allSwitchpoints = [];
      for (let i = 0; i <= 8; i++) {
        allSwitchpoints.push((0, import_serializers.decodeSwitchpoint)(raw.payload.subarray(1 + 3 * i)));
      }
      const schedule = allSwitchpoints.filter((sp) => sp.state !== "Unused");
      return new this({
        nodeId: ctx.sourceNodeId,
        weekday,
        schedule
      });
    }
    weekday;
    schedule;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          weekday: (0, import_shared.getEnumMemberName)(import_Types.Weekday, this.weekday),
          schedule: this.schedule.map((sp) => `
\xB7 ${sp.hour.toString().padStart(2, "0")}:${sp.minute.toString().padStart(2, "0")} --> ${sp.state}`).join("")
        }
      };
    }
  };
  return ClimateControlScheduleCCReport2 = _classThis;
})();
let ClimateControlScheduleCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ClimateControlScheduleCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(ClimateControlScheduleCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ClimateControlScheduleCC;
  var ClimateControlScheduleCCGet2 = class extends _classSuper {
    static {
      __name(this, "ClimateControlScheduleCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClimateControlScheduleCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.weekday = options.weekday;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    weekday;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.weekday & 7]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { weekday: (0, import_shared.getEnumMemberName)(import_Types.Weekday, this.weekday) }
      };
    }
  };
  return ClimateControlScheduleCCGet2 = _classThis;
})();
let ClimateControlScheduleCCChangedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ClimateControlScheduleCommand.ChangedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ClimateControlScheduleCC;
  var ClimateControlScheduleCCChangedReport2 = class extends _classSuper {
    static {
      __name(this, "ClimateControlScheduleCCChangedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClimateControlScheduleCCChangedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.changeCounter = options.changeCounter;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const changeCounter = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        changeCounter
      });
    }
    changeCounter;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "change counter": this.changeCounter }
      };
    }
  };
  return ClimateControlScheduleCCChangedReport2 = _classThis;
})();
let ClimateControlScheduleCCChangedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ClimateControlScheduleCommand.ChangedGet), (0, import_CommandClassDecorators.expectedCCResponse)(ClimateControlScheduleCCChangedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ClimateControlScheduleCC;
  var ClimateControlScheduleCCChangedGet2 = class extends _classSuper {
    static {
      __name(this, "ClimateControlScheduleCCChangedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClimateControlScheduleCCChangedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ClimateControlScheduleCCChangedGet2 = _classThis;
})();
let ClimateControlScheduleCCOverrideReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ClimateControlScheduleCommand.OverrideReport), (0, import_CommandClassDecorators.ccValueProperty)("overrideType", import_CCValues_generated.ClimateControlScheduleCCValues.overrideType), (0, import_CommandClassDecorators.ccValueProperty)("overrideState", import_CCValues_generated.ClimateControlScheduleCCValues.overrideState)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ClimateControlScheduleCC;
  var ClimateControlScheduleCCOverrideReport2 = class extends _classSuper {
    static {
      __name(this, "ClimateControlScheduleCCOverrideReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClimateControlScheduleCCOverrideReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.overrideType = options.overrideType;
      this.overrideState = options.overrideState;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const overrideType = raw.payload[0] & 3;
      const overrideState = (0, import_serializers.decodeSetbackState)(raw.payload, 1) || raw.payload.readInt8(1);
      return new this({
        nodeId: ctx.sourceNodeId,
        overrideType,
        overrideState
      });
    }
    overrideType;
    overrideState;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "override type": (0, import_shared.getEnumMemberName)(import_Types.ScheduleOverrideType, this.overrideType),
          "override state": this.overrideState
        }
      };
    }
  };
  return ClimateControlScheduleCCOverrideReport2 = _classThis;
})();
let ClimateControlScheduleCCOverrideGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ClimateControlScheduleCommand.OverrideGet), (0, import_CommandClassDecorators.expectedCCResponse)(ClimateControlScheduleCCOverrideReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ClimateControlScheduleCC;
  var ClimateControlScheduleCCOverrideGet2 = class extends _classSuper {
    static {
      __name(this, "ClimateControlScheduleCCOverrideGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClimateControlScheduleCCOverrideGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ClimateControlScheduleCCOverrideGet2 = _classThis;
})();
let ClimateControlScheduleCCOverrideSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ClimateControlScheduleCommand.OverrideSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ClimateControlScheduleCC;
  var ClimateControlScheduleCCOverrideSet2 = class extends _classSuper {
    static {
      __name(this, "ClimateControlScheduleCCOverrideSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClimateControlScheduleCCOverrideSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.overrideType = options.overrideType;
      this.overrideState = options.overrideState;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    overrideType;
    overrideState;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        [this.overrideType & 3],
        (0, import_serializers.encodeSetbackState)(this.overrideState)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "override type": (0, import_shared.getEnumMemberName)(import_Types.ScheduleOverrideType, this.overrideType),
          "override state": this.overrideState
        }
      };
    }
  };
  return ClimateControlScheduleCCOverrideSet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ClimateControlScheduleCC,
  ClimateControlScheduleCCAPI,
  ClimateControlScheduleCCChangedGet,
  ClimateControlScheduleCCChangedReport,
  ClimateControlScheduleCCGet,
  ClimateControlScheduleCCOverrideGet,
  ClimateControlScheduleCCOverrideReport,
  ClimateControlScheduleCCOverrideSet,
  ClimateControlScheduleCCReport,
  ClimateControlScheduleCCSet,
  ClimateControlScheduleCCValues
});
//# sourceMappingURL=ClimateControlScheduleCC.js.map
