"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ClockCC_exports = {};
__export(ClockCC_exports, {
  ClockCC: () => ClockCC,
  ClockCCAPI: () => ClockCCAPI,
  ClockCCGet: () => ClockCCGet,
  ClockCCReport: () => ClockCCReport,
  ClockCCSet: () => ClockCCSet
});
module.exports = __toCommonJS(ClockCC_exports);
var __validateArgs = __toESM(require("./ClockCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Types = require("../lib/_Types.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_ClockCCAPI_set } = __validateArgs;
let ClockCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses.Clock)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _set_decorators;
  var ClockCCAPI2 = class extends _classSuper {
    static {
      __name(this, "ClockCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _set_decorators = [validateArgs_ClockCCAPI_set({ strictEnums: true })];
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClockCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.ClockCommand.Get:
          return this.isSinglecast();
        case import_Types.ClockCommand.Set:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async get() {
      this.assertSupportsCommand(import_Types.ClockCommand, import_Types.ClockCommand.Get);
      const cc = new ClockCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["weekday", "hour", "minute"]);
      }
    }
    async set(hour, minute, weekday) {
      this.assertSupportsCommand(import_Types.ClockCommand, import_Types.ClockCommand.Set);
      const cc = new ClockCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        hour,
        minute,
        weekday: weekday ?? import_Types.Weekday.Unknown
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return ClockCCAPI2 = _classThis;
})();
let ClockCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses.Clock), (0, import_CommandClassDecorators.implementedVersion)(1)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ClockCC2 = class extends _classSuper {
    static {
      __name(this, "ClockCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClockCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Clock, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        message: "requesting current clock setting...",
        direction: "outbound"
      });
      const response = await api.get();
      if (response) {
        const logMessage = `received current clock setting: ${response.weekday !== import_Types.Weekday.Unknown ? import_Types.Weekday[response.weekday] + ", " : ""}${response.hour < 10 ? "0" : ""}${response.hour}:${response.minute < 10 ? "0" : ""}${response.minute}`;
        ctx.logNode(node.id, {
          message: logMessage,
          direction: "inbound"
        });
      }
    }
  };
  return ClockCC2 = _classThis;
})();
let ClockCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ClockCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ClockCC;
  var ClockCCSet2 = class extends _classSuper {
    static {
      __name(this, "ClockCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClockCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.weekday = options.weekday;
      this.hour = options.hour;
      this.minute = options.minute;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    weekday;
    hour;
    minute;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        (this.weekday & 7) << 5 | this.hour & 31,
        this.minute
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "clock setting": `${(0, import_shared.getEnumMemberName)(import_Types.Weekday, this.weekday)}, ${this.hour.toString().padStart(2, "0")}:${this.minute.toString().padStart(2, "0")}`
        }
      };
    }
  };
  return ClockCCSet2 = _classThis;
})();
let ClockCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ClockCommand.Report)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ClockCC;
  var ClockCCReport2 = class extends _classSuper {
    static {
      __name(this, "ClockCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClockCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.weekday = options.weekday;
      this.hour = options.hour;
      this.minute = options.minute;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const weekday = raw.payload[0] >>> 5;
      const hour = raw.payload[0] & 31;
      const minute = raw.payload[1];
      (0, import_core.validatePayload)(weekday <= import_Types.Weekday.Sunday, hour <= 23, minute <= 59);
      return new this({
        nodeId: ctx.sourceNodeId,
        weekday,
        hour,
        minute
      });
    }
    weekday;
    hour;
    minute;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "clock setting": `${(0, import_shared.getEnumMemberName)(import_Types.Weekday, this.weekday)}, ${this.hour.toString().padStart(2, "0")}:${this.minute.toString().padStart(2, "0")}`
        }
      };
    }
  };
  return ClockCCReport2 = _classThis;
})();
let ClockCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ClockCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(ClockCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ClockCC;
  var ClockCCGet2 = class extends _classSuper {
    static {
      __name(this, "ClockCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ClockCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ClockCCGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ClockCC,
  ClockCCAPI,
  ClockCCGet,
  ClockCCReport,
  ClockCCSet
});
//# sourceMappingURL=ClockCC.js.map
