"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ColorSwitchCC_exports = {};
__export(ColorSwitchCC_exports, {
  ColorSwitchCC: () => ColorSwitchCC,
  ColorSwitchCCAPI: () => ColorSwitchCCAPI,
  ColorSwitchCCGet: () => ColorSwitchCCGet,
  ColorSwitchCCReport: () => ColorSwitchCCReport,
  ColorSwitchCCSet: () => ColorSwitchCCSet,
  ColorSwitchCCStartLevelChange: () => ColorSwitchCCStartLevelChange,
  ColorSwitchCCStopLevelChange: () => ColorSwitchCCStopLevelChange,
  ColorSwitchCCSupportedGet: () => ColorSwitchCCSupportedGet,
  ColorSwitchCCSupportedReport: () => ColorSwitchCCSupportedReport,
  ColorSwitchCCValues: () => import_CCValues_generated.ColorSwitchCCValues
});
module.exports = __toCommonJS(ColorSwitchCC_exports);
var __validateArgs = __toESM(require("./ColorSwitchCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_math = require("alcalzone-shared/math");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_ColorSwitchCCAPI_get, validateArgs_ColorSwitchCCAPI_set, validateArgs_ColorSwitchCCAPI_startLevelChange, validateArgs_ColorSwitchCCAPI_stopLevelChange } = __validateArgs;
const hexColorRegex = /^#?(?<red>[0-9a-f]{2})(?<green>[0-9a-f]{2})(?<blue>[0-9a-f]{2})$/i;
const colorTableKeys = [
  ...(0, import_shared.keysOf)(import_Types.ColorComponent),
  ...(0, import_shared.keysOf)(import_Types.ColorComponentMap)
];
function colorTableKeyToComponent(key) {
  if (/^\d+$/.test(key)) {
    return parseInt(key, 10);
  } else if (key in import_Types.ColorComponentMap) {
    return import_Types.ColorComponentMap[key];
  } else if (key in import_Types.ColorComponent) {
    return import_Types.ColorComponent[key];
  }
  throw new import_core.ZWaveError(`Invalid color key ${key}!`, import_core.ZWaveErrorCodes.Argument_Invalid);
}
__name(colorTableKeyToComponent, "colorTableKeyToComponent");
function colorComponentToTableKey(component) {
  for (const [key, comp] of Object.entries(import_Types.ColorComponentMap)) {
    if (comp === component)
      return key;
  }
}
__name(colorComponentToTableKey, "colorComponentToTableKey");
let ColorSwitchCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Color Switch"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _get_decorators;
  let _set_decorators;
  let _startLevelChange_decorators;
  let _stopLevelChange_decorators;
  var ColorSwitchCCAPI2 = class extends _classSuper {
    static {
      __name(this, "ColorSwitchCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(this, null, _get_decorators, { kind: "method", name: "get", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "get" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.get, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _startLevelChange_decorators, { kind: "method", name: "startLevelChange", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "startLevelChange" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.startLevelChange, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _stopLevelChange_decorators, { kind: "method", name: "stopLevelChange", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "stopLevelChange" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.stopLevelChange, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ColorSwitchCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.ColorSwitchCommand.SupportedGet:
        case import_Types.ColorSwitchCommand.Get:
          return this.isSinglecast();
        case import_Types.ColorSwitchCommand.Set:
        case import_Types.ColorSwitchCommand.StartLevelChange:
        case import_Types.ColorSwitchCommand.StopLevelChange:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    async getSupported() {
      this.assertSupportsCommand(import_Types.ColorSwitchCommand, import_Types.ColorSwitchCommand.SupportedGet);
      const cc = new ColorSwitchCCSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.supportedColorComponents;
    }
    async get(component) {
      this.assertSupportsCommand(import_Types.ColorSwitchCommand, import_Types.ColorSwitchCommand.Get);
      const cc = new ColorSwitchCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        colorComponent: component
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["currentValue", "targetValue", "duration"]);
      }
    }
    async set(options) {
      this.assertSupportsCommand(import_Types.ColorSwitchCommand, import_Types.ColorSwitchCommand.Set);
      const cc = new ColorSwitchCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      const result = await this.host.sendCommand(cc, this.commandOptions);
      if ((0, import_core.isUnsupervisedOrSucceeded)(result)) {
        if (this.isSinglecast()) {
          this.updateCurrentColor(this.getValueDB(), cc.colorTable);
        } else if (this.isMulticast()) {
          const affectedNodes = this.endpoint.node.physicalNodes.filter((node) => node.getEndpoint(this.endpoint.index)?.supportsCC(this.ccId));
          for (const node of affectedNodes) {
            const valueDB = this.host.tryGetValueDB(node.id);
            if (valueDB) {
              this.updateCurrentColor(valueDB, cc.colorTable);
            }
          }
        }
      }
      return result;
    }
    /** Updates the current color for a given node by merging in the given changes */
    updateCurrentColor(valueDB, colorTable) {
      let updatedRGB = false;
      const currentColorValueId = import_CCValues_generated.ColorSwitchCCValues.currentColor.endpoint(this.endpoint.index);
      const targetColorValueId = import_CCValues_generated.ColorSwitchCCValues.targetColor.endpoint(this.endpoint.index);
      const currentCompoundColor = valueDB.getValue(currentColorValueId) ?? {};
      const targetCompoundColor = valueDB.getValue(targetColorValueId) ?? {};
      for (const [key, value] of Object.entries(colorTable)) {
        const component = colorTableKeyToComponent(key);
        if (component === import_Types.ColorComponent.Red || component === import_Types.ColorComponent.Green || component === import_Types.ColorComponent.Blue) {
          updatedRGB = true;
        }
        valueDB.setValue(import_CCValues_generated.ColorSwitchCCValues.currentColorChannel(component).endpoint(this.endpoint.index), value);
        if (key in import_Types.ColorComponentMap) {
          currentCompoundColor[key] = value;
          targetCompoundColor[key] = value;
        }
      }
      valueDB.setValue(currentColorValueId, currentCompoundColor);
      valueDB.setValue(targetColorValueId, targetCompoundColor);
      const supportsHex = valueDB.getValue(import_CCValues_generated.ColorSwitchCCValues.supportsHexColor.endpoint(this.endpoint.index));
      if (supportsHex && updatedRGB) {
        const hexValueId = import_CCValues_generated.ColorSwitchCCValues.hexColor.endpoint(this.endpoint.index);
        const [r, g, b] = [
          import_Types.ColorComponent.Red,
          import_Types.ColorComponent.Green,
          import_Types.ColorComponent.Blue
        ].map((c) => valueDB.getValue(import_CCValues_generated.ColorSwitchCCValues.currentColorChannel(c).endpoint(this.endpoint.index)) ?? 0);
        const hexValue = r << 16 | g << 8 | b;
        valueDB.setValue(hexValueId, hexValue.toString(16).padStart(6, "0"));
      }
    }
    async startLevelChange(options) {
      this.assertSupportsCommand(import_Types.ColorSwitchCommand, import_Types.ColorSwitchCommand.StartLevelChange);
      const cc = new ColorSwitchCCStartLevelChange({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async stopLevelChange(colorComponent) {
      this.assertSupportsCommand(import_Types.ColorSwitchCommand, import_Types.ColorSwitchCommand.StopLevelChange);
      const cc = new ColorSwitchCCStopLevelChange({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        colorComponent
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    get [(_get_decorators = [validateArgs_ColorSwitchCCAPI_get({ strictEnums: true })], _set_decorators = [validateArgs_ColorSwitchCCAPI_set()], _startLevelChange_decorators = [validateArgs_ColorSwitchCCAPI_startLevelChange({ strictEnums: true })], _stopLevelChange_decorators = [validateArgs_ColorSwitchCCAPI_stopLevelChange({ strictEnums: true })], import_API.SET_VALUE)]() {
      return async function({ property, propertyKey }, value, options) {
        if (property === "targetColor") {
          const duration = import_core.Duration.from(options?.transitionDuration);
          if (propertyKey != void 0) {
            if (typeof propertyKey !== "number") {
              (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
            } else if (typeof value !== "number") {
              (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
            }
            const result = await this.set({
              [propertyKey]: value,
              duration
            });
            if (this.isSinglecast() && !(0, import_core.supervisedCommandSucceeded)(result)) {
              this.schedulePoll({ property, propertyKey }, value, {
                duration,
                transition: "fast"
              });
            }
            return result;
          } else {
            if (!(0, import_typeguards.isObject)(value) || !Object.keys(value).every((key) => key in import_Types.ColorComponentMap)) {
              throw new import_core.ZWaveError(`${import_core.CommandClasses[this.ccId]}: "${property}" must be set to an object which specifies each color channel`, import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            for (const [key, val] of Object.entries(value)) {
              if (typeof val !== "number") {
                (0, import_API.throwWrongValueType)(this.ccId, `${property}.${key}`, "number", typeof val);
              }
            }
            if (this.isSinglecast()) {
              const supportedColors = this.tryGetValueDB()?.getValue(import_CCValues_generated.ColorSwitchCCValues.supportedColorComponents.endpoint(this.endpoint.index));
              if (supportedColors) {
                value = (0, import_shared.pick)(value, supportedColors.map((c) => colorComponentToTableKey(c)).filter((c) => !!c));
              }
            }
            if (Object.keys(value).length === 0)
              return;
            return this.set({ ...value, duration });
          }
        } else if (property === "hexColor") {
          if (typeof value !== "string") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "string", typeof value);
          }
          const duration = import_core.Duration.from(options?.transitionDuration);
          return this.set({ hexColor: value, duration });
        } else {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    isSetValueOptimistic(_valueId) {
      return false;
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property, propertyKey }) {
        if (propertyKey == void 0) {
          (0, import_API.throwMissingPropertyKey)(this.ccId, property);
        } else if (typeof propertyKey !== "number") {
          (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
        }
        switch (property) {
          case "currentColor":
            return (await this.get(propertyKey))?.currentValue;
          case "targetColor":
            return (await this.get(propertyKey))?.targetValue;
          case "duration":
            return (await this.get(propertyKey))?.duration;
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return ColorSwitchCCAPI2 = _classThis;
})();
let ColorSwitchCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Color Switch"]), (0, import_CommandClassDecorators.implementedVersion)(3), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.ColorSwitchCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ColorSwitchCC2 = class extends _classSuper {
    static {
      __name(this, "ColorSwitchCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ColorSwitchCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Color Switch"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying supported colors...",
        direction: "outbound"
      });
      const supportedColors = await api.getSupported();
      if (!supportedColors) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Querying supported colors timed out, skipping interview...",
          level: "warn"
        });
        return;
      }
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `received supported colors:${supportedColors.map((c) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.ColorComponent, c)}`).join("")}`,
        direction: "outbound"
      });
      for (const color of supportedColors) {
        const currentColorChannelValue = import_CCValues_generated.ColorSwitchCCValues.currentColorChannel(color);
        this.setMetadata(ctx, currentColorChannelValue);
        const targetColorChannelValue = import_CCValues_generated.ColorSwitchCCValues.targetColorChannel(color);
        this.setMetadata(ctx, targetColorChannelValue);
      }
      const currentColorValue = import_CCValues_generated.ColorSwitchCCValues.currentColor;
      this.setMetadata(ctx, currentColorValue);
      const targetColorValue = import_CCValues_generated.ColorSwitchCCValues.targetColor;
      this.setMetadata(ctx, targetColorValue);
      const supportsHex = [
        import_Types.ColorComponent.Red,
        import_Types.ColorComponent.Green,
        import_Types.ColorComponent.Blue
      ].every((c) => supportedColors.includes(c));
      this.setValue(ctx, import_CCValues_generated.ColorSwitchCCValues.supportsHexColor, supportsHex);
      if (supportsHex) {
        const hexColorValue = import_CCValues_generated.ColorSwitchCCValues.hexColor;
        this.setMetadata(ctx, hexColorValue);
      }
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Color Switch"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      const supportedColors = this.getValue(ctx, import_CCValues_generated.ColorSwitchCCValues.supportedColorComponents) ?? [];
      for (const color of supportedColors) {
        if (!(0, import_shared.isEnumMember)(import_Types.ColorComponent, color))
          continue;
        const colorName = (0, import_shared.getEnumMemberName)(import_Types.ColorComponent, color);
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `querying current color state (${colorName})`,
          direction: "outbound"
        });
        await api.get(color);
      }
    }
    translatePropertyKey(ctx, property, propertyKey) {
      if ((property === "currentColor" || property === "targetColor") && typeof propertyKey === "number") {
        const translated = import_Types.ColorComponent[propertyKey];
        if (translated)
          return translated;
      }
      return super.translatePropertyKey(ctx, property, propertyKey);
    }
  };
  return ColorSwitchCC2 = _classThis;
})();
let ColorSwitchCCSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ColorSwitchCommand.SupportedReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedColorComponents", import_CCValues_generated.ColorSwitchCCValues.supportedColorComponents)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ColorSwitchCC;
  var ColorSwitchCCSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "ColorSwitchCCSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ColorSwitchCCSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedColorComponents = options.supportedColorComponents;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const supportedColorComponents = (0, import_core.parseBitMask)(raw.payload.subarray(0, 2), import_Types.ColorComponent["Warm White"]);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedColorComponents
      });
    }
    supportedColorComponents;
    serialize(ctx) {
      this.payload = (0, import_core.encodeBitMask)(
        this.supportedColorComponents,
        15,
        // fixed 2 bytes
        import_Types.ColorComponent["Warm White"]
      );
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supported color components": this.supportedColorComponents.map((c) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.ColorComponent, c)}`).join("")
        }
      };
    }
  };
  return ColorSwitchCCSupportedReport2 = _classThis;
})();
let ColorSwitchCCSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ColorSwitchCommand.SupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(ColorSwitchCCSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ColorSwitchCC;
  var ColorSwitchCCSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "ColorSwitchCCSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ColorSwitchCCSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ColorSwitchCCSupportedGet2 = _classThis;
})();
let ColorSwitchCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ColorSwitchCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("currentValue", import_CCValues_generated.ColorSwitchCCValues.currentColorChannel, (self) => [self.colorComponent]), (0, import_CommandClassDecorators.ccValueProperty)("targetValue", import_CCValues_generated.ColorSwitchCCValues.targetColorChannel, (self) => [self.colorComponent]), (0, import_CommandClassDecorators.ccValueProperty)("duration", import_CCValues_generated.ColorSwitchCCValues.duration)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ColorSwitchCC;
  var ColorSwitchCCReport2 = class extends _classSuper {
    static {
      __name(this, "ColorSwitchCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ColorSwitchCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.colorComponent = options.colorComponent;
      this.currentValue = options.currentValue;
      this.targetValue = options.targetValue;
      this.duration = import_core.Duration.from(options.duration);
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const colorComponent = raw.payload[0];
      const currentValue = raw.payload[1];
      let targetValue;
      let duration;
      if (raw.payload.length >= 4) {
        targetValue = raw.payload[2];
        duration = import_core.Duration.parseReport(raw.payload[3]);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        colorComponent,
        currentValue,
        targetValue,
        duration
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const colorTableKey = colorComponentToTableKey(this.colorComponent);
      if (colorTableKey) {
        const compoundCurrentColorValue = import_CCValues_generated.ColorSwitchCCValues.currentColor;
        const compoundCurrentColor = this.getValue(ctx, compoundCurrentColorValue) ?? {};
        compoundCurrentColor[colorTableKey] = this.currentValue;
        this.setValue(ctx, compoundCurrentColorValue, compoundCurrentColor);
        if (this.targetValue != void 0) {
          const compoundTargetColorValue = import_CCValues_generated.ColorSwitchCCValues.targetColor;
          const compoundTargetColor = this.getValue(ctx, compoundTargetColorValue) ?? {};
          compoundTargetColor[colorTableKey] = this.targetValue;
          this.setValue(ctx, compoundTargetColorValue, compoundTargetColor);
        }
      }
      const supportsHex = !!this.getValue(ctx, import_CCValues_generated.ColorSwitchCCValues.supportsHexColor);
      if (supportsHex && (this.colorComponent === import_Types.ColorComponent.Red || this.colorComponent === import_Types.ColorComponent.Green || this.colorComponent === import_Types.ColorComponent.Blue)) {
        const hexColorValue = import_CCValues_generated.ColorSwitchCCValues.hexColor;
        const hexValue = this.getValue(ctx, hexColorValue) ?? "000000";
        const byteOffset = import_Types.ColorComponent.Blue - this.colorComponent;
        const byteMask = 255 << byteOffset * 8;
        let hexValueNumeric = parseInt(hexValue, 16);
        hexValueNumeric = hexValueNumeric & ~byteMask | this.currentValue << byteOffset * 8;
        this.setValue(ctx, hexColorValue, hexValueNumeric.toString(16).padStart(6, "0"));
      }
      return true;
    }
    colorComponent;
    currentValue;
    targetValue;
    duration;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.colorComponent,
        this.currentValue
      ]);
      if (this.targetValue != void 0 && this.duration != void 0) {
        this.payload = import_shared.Bytes.concat([
          this.payload,
          import_shared.Bytes.from([
            this.targetValue ?? 254,
            (this.duration ?? import_core.Duration.default()).serializeReport()
          ])
        ]);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "color component": (0, import_shared.getEnumMemberName)(import_Types.ColorComponent, this.colorComponent),
        "current value": this.currentValue
      };
      if (this.targetValue != void 0) {
        message["target value"] = this.targetValue;
      }
      if (this.duration != void 0) {
        message.duration = this.duration.toString();
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ColorSwitchCCReport2 = _classThis;
})();
function testResponseForColorSwitchGet(sent, received) {
  return sent.colorComponent === received.colorComponent;
}
__name(testResponseForColorSwitchGet, "testResponseForColorSwitchGet");
let ColorSwitchCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ColorSwitchCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(ColorSwitchCCReport, testResponseForColorSwitchGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ColorSwitchCC;
  var ColorSwitchCCGet2 = class extends _classSuper {
    static {
      __name(this, "ColorSwitchCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ColorSwitchCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this._colorComponent = options.colorComponent;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const colorComponent = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        colorComponent
      });
    }
    _colorComponent;
    get colorComponent() {
      return this._colorComponent;
    }
    set colorComponent(value) {
      if (!import_Types.ColorComponent[value]) {
        throw new import_core.ZWaveError("colorComponent must be a valid color component index.", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this._colorComponent = value;
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this._colorComponent]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "color component": (0, import_shared.getEnumMemberName)(import_Types.ColorComponent, this.colorComponent)
        }
      };
    }
  };
  return ColorSwitchCCGet2 = _classThis;
})();
let ColorSwitchCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ColorSwitchCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ColorSwitchCC;
  var ColorSwitchCCSet2 = class extends _classSuper {
    static {
      __name(this, "ColorSwitchCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ColorSwitchCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ("hexColor" in options) {
        const match = hexColorRegex.exec(options.hexColor);
        if (!match) {
          throw new import_core.ZWaveError(`${options.hexColor} is not a valid HEX color string`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
        this.colorTable = {
          red: parseInt(match.groups.red, 16),
          green: parseInt(match.groups.green, 16),
          blue: parseInt(match.groups.blue, 16)
        };
      } else {
        this.colorTable = (0, import_shared.pick)(options, colorTableKeys);
      }
      this.duration = import_core.Duration.from(options.duration);
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const populatedColorCount = raw.payload[0] & 31;
      (0, import_core.validatePayload)(raw.payload.length >= 1 + populatedColorCount * 2);
      const colorTable = {};
      let offset = 1;
      for (let color = 0; color < populatedColorCount; color++) {
        const component = raw.payload[offset];
        const value = raw.payload[offset + 1];
        const key = colorComponentToTableKey(component);
        if (key)
          this.colorTable[key] = value;
        offset += 2;
      }
      let duration;
      if (raw.payload.length > offset) {
        duration = import_core.Duration.parseSet(raw.payload[offset]);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        ...colorTable,
        duration
      });
    }
    colorTable;
    duration;
    serialize(ctx) {
      const populatedColorCount = Object.keys(this.colorTable).length;
      this.payload = new import_shared.Bytes(1 + populatedColorCount * 2 + 1);
      this.payload[0] = populatedColorCount & 31;
      let i = 1;
      for (const [key, value] of Object.entries(this.colorTable)) {
        const component = colorTableKeyToComponent(key);
        this.payload[i] = component;
        this.payload[i + 1] = (0, import_math.clamp)(value, 0, 255);
        i += 2;
      }
      this.payload[i] = (this.duration ?? import_core.Duration.default()).serializeSet();
      const ccVersion = (0, import_CommandClass.getEffectiveCCVersion)(ctx, this);
      if (ccVersion < 2 && ctx.getDeviceConfig?.(this.nodeId)?.compat?.encodeCCsUsingTargetVersion) {
        this.payload = this.payload.subarray(0, -1);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {};
      for (const [key, value] of Object.entries(this.colorTable)) {
        const realKey = key in import_Types.ColorComponentMap ? import_Types.ColorComponent[import_Types.ColorComponentMap[key]] : import_Types.ColorComponent[key];
        message[realKey] = value;
      }
      if (this.duration != void 0) {
        message.duration = this.duration.toString();
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ColorSwitchCCSet2 = _classThis;
})();
let ColorSwitchCCStartLevelChange = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ColorSwitchCommand.StartLevelChange), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ColorSwitchCC;
  var ColorSwitchCCStartLevelChange2 = class extends _classSuper {
    static {
      __name(this, "ColorSwitchCCStartLevelChange");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ColorSwitchCCStartLevelChange2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.duration = import_core.Duration.from(options.duration);
      this.ignoreStartLevel = options.ignoreStartLevel;
      this.startLevel = options.startLevel ?? 0;
      this.direction = options.direction;
      this.colorComponent = options.colorComponent;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const ignoreStartLevel = !!((raw.payload[0] & 32) >>> 5);
      const direction = (raw.payload[0] & 64) >>> 6 ? "down" : "up";
      const colorComponent = raw.payload[1];
      const startLevel = raw.payload[2];
      let duration;
      if (raw.payload.length >= 4) {
        duration = import_core.Duration.parseSet(raw.payload[3]);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        ignoreStartLevel,
        direction,
        colorComponent,
        startLevel,
        duration
      });
    }
    duration;
    startLevel;
    ignoreStartLevel;
    direction;
    colorComponent;
    serialize(ctx) {
      const controlByte = import_Types.LevelChangeDirection[this.direction] << 6 | (this.ignoreStartLevel ? 32 : 0);
      this.payload = import_shared.Bytes.from([
        controlByte,
        this.colorComponent,
        this.startLevel,
        (this.duration ?? import_core.Duration.default()).serializeSet()
      ]);
      const ccVersion = (0, import_CommandClass.getEffectiveCCVersion)(ctx, this);
      if (ccVersion < 3 && ctx.getDeviceConfig?.(this.nodeId)?.compat?.encodeCCsUsingTargetVersion) {
        this.payload = this.payload.subarray(0, -1);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "color component": (0, import_shared.getEnumMemberName)(import_Types.ColorComponent, this.colorComponent),
        "start level": `${this.startLevel}${this.ignoreStartLevel ? " (ignored)" : ""}`,
        direction: this.direction
      };
      if (this.duration != void 0) {
        message.duration = this.duration.toString();
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ColorSwitchCCStartLevelChange2 = _classThis;
})();
let ColorSwitchCCStopLevelChange = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ColorSwitchCommand.StopLevelChange), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ColorSwitchCC;
  var ColorSwitchCCStopLevelChange2 = class extends _classSuper {
    static {
      __name(this, "ColorSwitchCCStopLevelChange");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ColorSwitchCCStopLevelChange2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.colorComponent = options.colorComponent;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const colorComponent = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        colorComponent
      });
    }
    colorComponent;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.colorComponent]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "color component": (0, import_shared.getEnumMemberName)(import_Types.ColorComponent, this.colorComponent)
        }
      };
    }
  };
  return ColorSwitchCCStopLevelChange2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ColorSwitchCC,
  ColorSwitchCCAPI,
  ColorSwitchCCGet,
  ColorSwitchCCReport,
  ColorSwitchCCSet,
  ColorSwitchCCStartLevelChange,
  ColorSwitchCCStopLevelChange,
  ColorSwitchCCSupportedGet,
  ColorSwitchCCSupportedReport,
  ColorSwitchCCValues
});
//# sourceMappingURL=ColorSwitchCC.js.map
