"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var EntryControlCC_exports = {};
__export(EntryControlCC_exports, {
  EntryControlCC: () => EntryControlCC,
  EntryControlCCAPI: () => EntryControlCCAPI,
  EntryControlCCConfigurationGet: () => EntryControlCCConfigurationGet,
  EntryControlCCConfigurationReport: () => EntryControlCCConfigurationReport,
  EntryControlCCConfigurationSet: () => EntryControlCCConfigurationSet,
  EntryControlCCEventSupportedGet: () => EntryControlCCEventSupportedGet,
  EntryControlCCEventSupportedReport: () => EntryControlCCEventSupportedReport,
  EntryControlCCKeySupportedGet: () => EntryControlCCKeySupportedGet,
  EntryControlCCKeySupportedReport: () => EntryControlCCKeySupportedReport,
  EntryControlCCNotification: () => EntryControlCCNotification,
  EntryControlCCValues: () => import_CCValues_generated.EntryControlCCValues
});
module.exports = __toCommonJS(EntryControlCC_exports);
var __validateArgs = __toESM(require("./EntryControlCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var ccUtils = __toESM(require("../lib/utils.js"), 1);
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_EntryControlCCAPI_setConfiguration } = __validateArgs;
let EntryControlCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Entry Control"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _setConfiguration_decorators;
  var EntryControlCCAPI2 = class extends _classSuper {
    static {
      __name(this, "EntryControlCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(this, null, _setConfiguration_decorators, { kind: "method", name: "setConfiguration", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setConfiguration" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setConfiguration, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      EntryControlCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.EntryControlCommand.KeySupportedGet:
        case import_Types.EntryControlCommand.EventSupportedGet:
        case import_Types.EntryControlCommand.ConfigurationGet:
          return this.isSinglecast();
        case import_Types.EntryControlCommand.ConfigurationSet:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getSupportedKeys() {
      this.assertSupportsCommand(import_Types.EntryControlCommand, import_Types.EntryControlCommand.KeySupportedGet);
      const cc = new EntryControlCCKeySupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.supportedKeys;
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getEventCapabilities() {
      this.assertSupportsCommand(import_Types.EntryControlCommand, import_Types.EntryControlCommand.EventSupportedGet);
      const cc = new EntryControlCCEventSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "supportedDataTypes",
          "supportedEventTypes",
          "minKeyCacheSize",
          "maxKeyCacheSize",
          "minKeyCacheTimeout",
          "maxKeyCacheTimeout"
        ]);
      }
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getConfiguration() {
      this.assertSupportsCommand(import_Types.EntryControlCommand, import_Types.EntryControlCommand.ConfigurationGet);
      const cc = new EntryControlCCConfigurationGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["keyCacheSize", "keyCacheTimeout"]);
      }
    }
    async setConfiguration(keyCacheSize, keyCacheTimeout) {
      this.assertSupportsCommand(import_Types.EntryControlCommand, import_Types.EntryControlCommand.ConfigurationGet);
      const cc = new EntryControlCCConfigurationSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        keyCacheSize,
        keyCacheTimeout
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    get [(_setConfiguration_decorators = [validateArgs_EntryControlCCAPI_setConfiguration()], import_API.SET_VALUE)]() {
      return async function({ property }, value) {
        if (property !== "keyCacheSize" && property !== "keyCacheTimeout") {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        if (typeof value !== "number") {
          (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
        }
        let keyCacheSize = value;
        let keyCacheTimeout = 2;
        if (property === "keyCacheTimeout") {
          keyCacheTimeout = value;
          const oldKeyCacheSize = this.tryGetValueDB()?.getValue(import_CCValues_generated.EntryControlCCValues.keyCacheSize.endpoint(this.endpoint.index));
          if (oldKeyCacheSize == void 0) {
            throw new import_core.ZWaveError(`The "keyCacheTimeout" property cannot be changed before the key cache size is known!`, import_core.ZWaveErrorCodes.Argument_Invalid);
          }
          keyCacheSize = oldKeyCacheSize;
        }
        const result = await this.setConfiguration(keyCacheSize, keyCacheTimeout);
        if (this.isSinglecast() && !(0, import_core.supervisedCommandSucceeded)(result)) {
          this.schedulePoll({ property }, value, { transition: "fast" });
        }
        return result;
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        switch (property) {
          case "keyCacheSize":
          case "keyCacheTimeout":
            return (await this.getConfiguration())?.[property];
        }
        (0, import_API.throwUnsupportedProperty)(this.ccId, property);
      };
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return EntryControlCCAPI2 = _classThis;
})();
let EntryControlCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Entry Control"]), (0, import_CommandClassDecorators.implementedVersion)(1), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.EntryControlCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var EntryControlCC2 = class extends _classSuper {
    static {
      __name(this, "EntryControlCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      EntryControlCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    determineRequiredCCInterviews() {
      return [
        ...super.determineRequiredCCInterviews(),
        import_core.CommandClasses.Association,
        import_core.CommandClasses["Multi Channel Association"],
        import_core.CommandClasses["Association Group Information"]
      ];
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Entry Control"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      try {
        await ccUtils.assignLifelineIssueingCommand(ctx, endpoint, this.ccId, import_Types.EntryControlCommand.Notification);
      } catch {
        ctx.logNode(node.id, {
          endpoint: endpoint.index,
          message: `Configuring associations to receive ${(0, import_core.getCCName)(this.ccId)} commands failed!`,
          level: "warn"
        });
      }
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "requesting entry control supported keys...",
        direction: "outbound"
      });
      const supportedKeys = await api.getSupportedKeys();
      if (supportedKeys) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `received entry control supported keys: ${supportedKeys.toString()}`,
          direction: "inbound"
        });
      }
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "requesting entry control supported events...",
        direction: "outbound"
      });
      const eventCapabilities = await api.getEventCapabilities();
      if (eventCapabilities) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `received entry control supported keys:
data types:            ${eventCapabilities.supportedDataTypes.map((e) => import_Types.EntryControlDataTypes[e]).toString()}
event types:           ${eventCapabilities.supportedEventTypes.map((e) => import_Types.EntryControlEventTypes[e]).toString()}
min key cache size:    ${eventCapabilities.minKeyCacheSize}
max key cache size:    ${eventCapabilities.maxKeyCacheSize}
min key cache timeout: ${eventCapabilities.minKeyCacheTimeout} seconds
max key cache timeout: ${eventCapabilities.maxKeyCacheTimeout} seconds`,
          direction: "inbound"
        });
      }
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Entry Control"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "requesting entry control configuration...",
        direction: "outbound"
      });
      const conf = await api.getConfiguration();
      if (conf) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `received entry control configuration:
key cache size:    ${conf.keyCacheSize}
key cache timeout: ${conf.keyCacheTimeout} seconds`,
          direction: "inbound"
        });
      }
    }
  };
  return EntryControlCC2 = _classThis;
})();
let EntryControlCCNotification = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.EntryControlCommand.Notification)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = EntryControlCC;
  var EntryControlCCNotification2 = class extends _classSuper {
    static {
      __name(this, "EntryControlCCNotification");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      EntryControlCCNotification2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sequenceNumber = options.sequenceNumber;
      this.dataType = options.dataType;
      this.eventType = options.eventType;
      this.eventData = options.eventData;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 4);
      const sequenceNumber = raw.payload[0];
      let dataType = raw.payload[1] & 3;
      const eventType = raw.payload[2];
      const eventDataLength = raw.payload[3];
      (0, import_core.validatePayload)(eventDataLength >= 0 && eventDataLength <= 32);
      const offset = 4;
      (0, import_core.validatePayload)(raw.payload.length >= offset + eventDataLength);
      let eventData;
      if (eventDataLength > 0) {
        const noStrictValidation = !!ctx.getDeviceConfig?.(ctx.sourceNodeId)?.compat?.disableStrictEntryControlDataValidation;
        eventData = import_shared.Bytes.from(raw.payload.subarray(offset, offset + eventDataLength));
        switch (dataType) {
          case import_Types.EntryControlDataTypes.Raw:
            if (!noStrictValidation) {
              (0, import_core.validatePayload)(eventDataLength >= 1 && eventDataLength <= 32);
            }
            break;
          case import_Types.EntryControlDataTypes.ASCII:
            if (!noStrictValidation) {
              (0, import_core.validatePayload)(eventDataLength === 16 || eventDataLength === 32);
            }
            let paddingStart = eventDataLength;
            while (paddingStart > 0 && eventData[paddingStart - 1] === 255) {
              paddingStart--;
            }
            eventData = eventData.subarray(0, paddingStart).toString("ascii");
            if (!noStrictValidation) {
              (0, import_core.validatePayload)(/^[\u0000-\u007f]+$/.test(eventData));
            }
            break;
          case import_Types.EntryControlDataTypes.MD5:
            if (!noStrictValidation) {
              (0, import_core.validatePayload)(eventDataLength === 16);
            }
            break;
        }
      } else {
        dataType = import_Types.EntryControlDataTypes.None;
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        sequenceNumber,
        dataType,
        eventType,
        eventData
      });
    }
    sequenceNumber;
    dataType;
    eventType;
    eventData;
    toLogEntry(ctx) {
      const message = {
        "sequence number": this.sequenceNumber,
        "data type": this.dataType,
        "event type": this.eventType
      };
      if (this.eventData) {
        switch (this.eventType) {
          case import_Types.EntryControlEventTypes.CachedKeys:
          case import_Types.EntryControlEventTypes.Enter:
            message["event data"] = "*".repeat(this.eventData.length);
            break;
          default:
            message["event data"] = typeof this.eventData === "string" ? this.eventData : (0, import_shared.buffer2hex)(this.eventData);
        }
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return EntryControlCCNotification2 = _classThis;
})();
let EntryControlCCKeySupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.EntryControlCommand.KeySupportedReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedKeys", import_CCValues_generated.EntryControlCCValues.supportedKeys)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = EntryControlCC;
  var EntryControlCCKeySupportedReport2 = class extends _classSuper {
    static {
      __name(this, "EntryControlCCKeySupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      EntryControlCCKeySupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedKeys = options.supportedKeys;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const length = raw.payload[0];
      (0, import_core.validatePayload)(raw.payload.length >= 1 + length);
      const supportedKeys = (0, import_core.parseBitMask)(raw.payload.subarray(1, 1 + length), 0);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedKeys
      });
    }
    supportedKeys;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "supported keys": this.supportedKeys.toString() }
      };
    }
  };
  return EntryControlCCKeySupportedReport2 = _classThis;
})();
let EntryControlCCKeySupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.EntryControlCommand.KeySupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(EntryControlCCKeySupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = EntryControlCC;
  var EntryControlCCKeySupportedGet2 = class extends _classSuper {
    static {
      __name(this, "EntryControlCCKeySupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      EntryControlCCKeySupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return EntryControlCCKeySupportedGet2 = _classThis;
})();
let EntryControlCCEventSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.EntryControlCommand.EventSupportedReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedDataTypes", import_CCValues_generated.EntryControlCCValues.supportedDataTypes), (0, import_CommandClassDecorators.ccValueProperty)("supportedEventTypes", import_CCValues_generated.EntryControlCCValues.supportedEventTypes)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = EntryControlCC;
  var EntryControlCCEventSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "EntryControlCCEventSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      EntryControlCCEventSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedDataTypes = options.supportedDataTypes;
      this.supportedEventTypes = options.supportedEventTypes;
      this.minKeyCacheSize = options.minKeyCacheSize;
      this.maxKeyCacheSize = options.maxKeyCacheSize;
      this.minKeyCacheTimeout = options.minKeyCacheTimeout;
      this.maxKeyCacheTimeout = options.maxKeyCacheTimeout;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const dataTypeLength = raw.payload[0] & 3;
      let offset = 1;
      (0, import_core.validatePayload)(raw.payload.length >= offset + dataTypeLength);
      const supportedDataTypes = (0, import_core.parseBitMask)(raw.payload.subarray(offset, offset + dataTypeLength), import_Types.EntryControlDataTypes.None);
      offset += dataTypeLength;
      (0, import_core.validatePayload)(raw.payload.length >= offset + 1);
      const eventTypeLength = raw.payload[offset] & 31;
      offset += 1;
      (0, import_core.validatePayload)(raw.payload.length >= offset + eventTypeLength);
      const supportedEventTypes = (0, import_core.parseBitMask)(raw.payload.subarray(offset, offset + eventTypeLength), import_Types.EntryControlEventTypes.Caching);
      offset += eventTypeLength;
      (0, import_core.validatePayload)(raw.payload.length >= offset + 4);
      const minKeyCacheSize = raw.payload[offset];
      (0, import_core.validatePayload)(minKeyCacheSize >= 1 && minKeyCacheSize <= 32);
      const maxKeyCacheSize = raw.payload[offset + 1];
      (0, import_core.validatePayload)(maxKeyCacheSize >= minKeyCacheSize && maxKeyCacheSize <= 32);
      const minKeyCacheTimeout = raw.payload[offset + 2];
      const maxKeyCacheTimeout = raw.payload[offset + 3];
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedDataTypes,
        supportedEventTypes,
        minKeyCacheSize,
        maxKeyCacheSize,
        minKeyCacheTimeout,
        maxKeyCacheTimeout
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const keyCacheSizeValue = import_CCValues_generated.EntryControlCCValues.keyCacheSize;
      this.setMetadata(ctx, keyCacheSizeValue, {
        ...keyCacheSizeValue.meta,
        min: this.minKeyCacheSize,
        max: this.maxKeyCacheSize
      });
      const keyCacheTimeoutValue = import_CCValues_generated.EntryControlCCValues.keyCacheTimeout;
      this.setMetadata(ctx, keyCacheTimeoutValue, {
        ...keyCacheTimeoutValue.meta,
        min: this.minKeyCacheTimeout,
        max: this.maxKeyCacheTimeout
      });
      return true;
    }
    supportedDataTypes;
    supportedEventTypes;
    minKeyCacheSize;
    maxKeyCacheSize;
    minKeyCacheTimeout;
    maxKeyCacheTimeout;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supported data types": this.supportedDataTypes.map((dt) => import_Types.EntryControlDataTypes[dt]).toString(),
          "supported event types": this.supportedEventTypes.map((et) => import_Types.EntryControlEventTypes[et]).toString(),
          "min key cache size": this.minKeyCacheSize,
          "max key cache size": this.maxKeyCacheSize,
          "min key cache timeout": this.minKeyCacheTimeout,
          "max key cache timeout": this.maxKeyCacheTimeout
        }
      };
    }
  };
  return EntryControlCCEventSupportedReport2 = _classThis;
})();
let EntryControlCCEventSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.EntryControlCommand.EventSupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(EntryControlCCEventSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = EntryControlCC;
  var EntryControlCCEventSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "EntryControlCCEventSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      EntryControlCCEventSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return EntryControlCCEventSupportedGet2 = _classThis;
})();
let EntryControlCCConfigurationReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.EntryControlCommand.ConfigurationReport), (0, import_CommandClassDecorators.ccValueProperty)("keyCacheSize", import_CCValues_generated.EntryControlCCValues.keyCacheSize), (0, import_CommandClassDecorators.ccValueProperty)("keyCacheTimeout", import_CCValues_generated.EntryControlCCValues.keyCacheTimeout)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = EntryControlCC;
  var EntryControlCCConfigurationReport2 = class extends _classSuper {
    static {
      __name(this, "EntryControlCCConfigurationReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      EntryControlCCConfigurationReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.keyCacheSize = options.keyCacheSize;
      this.keyCacheTimeout = options.keyCacheTimeout;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const keyCacheSize = raw.payload[0];
      (0, import_core.validatePayload)(keyCacheSize >= 1 && keyCacheSize <= 32);
      const keyCacheTimeout = raw.payload[1];
      return new this({
        nodeId: ctx.sourceNodeId,
        keyCacheSize,
        keyCacheTimeout
      });
    }
    keyCacheSize;
    keyCacheTimeout;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "key cache size": this.keyCacheSize,
          "key cache timeout": this.keyCacheTimeout
        }
      };
    }
  };
  return EntryControlCCConfigurationReport2 = _classThis;
})();
let EntryControlCCConfigurationGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.EntryControlCommand.ConfigurationGet), (0, import_CommandClassDecorators.expectedCCResponse)(EntryControlCCConfigurationReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = EntryControlCC;
  var EntryControlCCConfigurationGet2 = class extends _classSuper {
    static {
      __name(this, "EntryControlCCConfigurationGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      EntryControlCCConfigurationGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return EntryControlCCConfigurationGet2 = _classThis;
})();
let EntryControlCCConfigurationSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.EntryControlCommand.ConfigurationSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = EntryControlCC;
  var EntryControlCCConfigurationSet2 = class extends _classSuper {
    static {
      __name(this, "EntryControlCCConfigurationSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      EntryControlCCConfigurationSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.keyCacheSize = options.keyCacheSize;
      this.keyCacheTimeout = options.keyCacheTimeout;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    keyCacheSize;
    keyCacheTimeout;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.keyCacheSize, this.keyCacheTimeout]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "key cache size": this.keyCacheSize,
          "key cache timeout": this.keyCacheTimeout
        }
      };
    }
  };
  return EntryControlCCConfigurationSet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  EntryControlCC,
  EntryControlCCAPI,
  EntryControlCCConfigurationGet,
  EntryControlCCConfigurationReport,
  EntryControlCCConfigurationSet,
  EntryControlCCEventSupportedGet,
  EntryControlCCEventSupportedReport,
  EntryControlCCKeySupportedGet,
  EntryControlCCKeySupportedReport,
  EntryControlCCNotification,
  EntryControlCCValues
});
//# sourceMappingURL=EntryControlCC.js.map
