"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var IndicatorCC_exports = {};
__export(IndicatorCC_exports, {
  IndicatorCC: () => IndicatorCC,
  IndicatorCCAPI: () => IndicatorCCAPI,
  IndicatorCCDescriptionGet: () => IndicatorCCDescriptionGet,
  IndicatorCCDescriptionReport: () => IndicatorCCDescriptionReport,
  IndicatorCCGet: () => IndicatorCCGet,
  IndicatorCCReport: () => IndicatorCCReport,
  IndicatorCCSet: () => IndicatorCCSet,
  IndicatorCCSupportedGet: () => IndicatorCCSupportedGet,
  IndicatorCCSupportedReport: () => IndicatorCCSupportedReport,
  IndicatorCCValues: () => import_CCValues_generated.IndicatorCCValues,
  shouldExposeIndicatorValue: () => shouldExposeIndicatorValue
});
module.exports = __toCommonJS(IndicatorCC_exports);
var __validateArgs = __toESM(require("./IndicatorCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_math = require("alcalzone-shared/math");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_IndicatorCCAPI_get, validateArgs_IndicatorCCAPI_set, validateArgs_IndicatorCCAPI_sendReport, validateArgs_IndicatorCCAPI_getSupported, validateArgs_IndicatorCCAPI_reportSupported, validateArgs_IndicatorCCAPI_reportDescription, validateArgs_IndicatorCCAPI_setTimeout, validateArgs_IndicatorCCAPI_getTimeout, validateArgs_IndicatorCCAPI_getDescription } = __validateArgs;
function isManufacturerDefinedIndicator(indicatorId) {
  return indicatorId >= 128 && indicatorId <= 159;
}
__name(isManufacturerDefinedIndicator, "isManufacturerDefinedIndicator");
const timeoutStringRegex = /^(?:(?<hoursStr>\d+)h)?(?:(?<minutesStr>\d+)m)?(?:(?<secondsStr>\d+(?:\.\d+)?)s)?$/i;
const MAX_INDICATOR_OBJECTS = 31;
function parseIndicatorTimeoutString(text) {
  if (!text.length)
    return void 0;
  const match = timeoutStringRegex.exec(text);
  if (!match)
    return void 0;
  const { hoursStr, minutesStr, secondsStr } = match.groups;
  if (!hoursStr && !minutesStr && !secondsStr)
    return void 0;
  const ret = {};
  if (hoursStr) {
    ret.hours = (0, import_math.clamp)(parseInt(hoursStr, 10), 0, 255);
  }
  if (minutesStr) {
    ret.minutes = (0, import_math.clamp)(parseInt(minutesStr, 10), 0, 255);
  }
  if (secondsStr) {
    ret.seconds = (0, import_math.clamp)((0, import_math.roundTo)(parseFloat(secondsStr), 2), 0, 59.99);
  }
  return ret;
}
__name(parseIndicatorTimeoutString, "parseIndicatorTimeoutString");
function groupByIndicatorId(values) {
  const ret = /* @__PURE__ */ new Map();
  for (const value of values) {
    if (!ret.has(value.indicatorId)) {
      ret.set(value.indicatorId, []);
    }
    ret.get(value.indicatorId).push(value);
  }
  return ret;
}
__name(groupByIndicatorId, "groupByIndicatorId");
function indicatorObjectsToTimeout(values) {
  const timeoutValues = values.filter((v) => [10, 6, 7, 8].includes(v.propertyId));
  if (!timeoutValues.length)
    return void 0;
  const hours = timeoutValues.find((v) => v.propertyId === 10)?.value ?? 0;
  const minutes = timeoutValues.find((v) => v.propertyId === 6)?.value ?? 0;
  const seconds = (0, import_math.clamp)(timeoutValues.find((v) => v.propertyId === 7)?.value ?? 0, 0, 59) + (0, import_math.clamp)(timeoutValues.find((v) => v.propertyId === 8)?.value ?? 0, 0, 99) / 100;
  return {
    hours,
    minutes,
    seconds
  };
}
__name(indicatorObjectsToTimeout, "indicatorObjectsToTimeout");
function getIndicatorMetadata(indicatorId, propertyId, overrideIndicatorLabel) {
  const label = getIndicatorLabel(indicatorId, propertyId, overrideIndicatorLabel);
  const prop = (0, import_core.getIndicatorProperty)(propertyId);
  const baseMetadata = import_CCValues_generated.IndicatorCCValues.valueV2(indicatorId, propertyId).meta;
  if (!prop) {
    return {
      ...baseMetadata,
      ...import_core.ValueMetadata.UInt8,
      label
    };
  } else {
    if (prop.type === "boolean") {
      return {
        ...baseMetadata,
        ...import_core.ValueMetadata.Boolean,
        label,
        description: prop.description,
        readable: !prop.readonly
      };
    } else {
      return {
        ...baseMetadata,
        ...import_core.ValueMetadata.UInt8,
        label,
        description: prop.description,
        min: prop.min,
        max: prop.max,
        readable: !prop.readonly
      };
    }
  }
}
__name(getIndicatorMetadata, "getIndicatorMetadata");
function getIndicatorName(indicatorId) {
  if (indicatorId) {
    return (0, import_shared.getEnumMemberName)(import_core.Indicator, indicatorId);
  } else {
    return "Default";
  }
}
__name(getIndicatorName, "getIndicatorName");
function getIndicatorLabel(indicatorId, propertyId, overrideIndicatorLabel, overridePropertyLabel) {
  const defaultName = overrideIndicatorLabel || getIndicatorName(indicatorId);
  const prop = (0, import_core.getIndicatorProperty)(propertyId);
  if (!prop)
    return defaultName;
  if (indicatorId >= import_core.Indicator["LCD backlight"] && indicatorId <= import_core.Indicator["Button 12 indication"] && (propertyId === 1 || propertyId === 2 || overridePropertyLabel)) {
    let ret = import_core.Indicator[indicatorId];
    if (overridePropertyLabel) {
      ret += ` - ${overridePropertyLabel}`;
    }
    return ret;
  }
  return `${defaultName} - ${overridePropertyLabel || prop.label}`;
}
__name(getIndicatorLabel, "getIndicatorLabel");
function shouldExposeIndicatorValue(indicatorId, propertyId) {
  const prop = (0, import_core.getIndicatorProperty)(propertyId);
  if (prop && !prop.exposeAsValue) {
    return false;
  }
  return true;
}
__name(shouldExposeIndicatorValue, "shouldExposeIndicatorValue");
let IndicatorCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses.Indicator)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _get_decorators;
  let _set_decorators;
  let _sendReport_decorators;
  let _getSupported_decorators;
  let _reportSupported_decorators;
  let _reportDescription_decorators;
  let _setTimeout_decorators;
  let _getTimeout_decorators;
  let _getDescription_decorators;
  var IndicatorCCAPI2 = class extends _classSuper {
    static {
      __name(this, "IndicatorCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _get_decorators = [validateArgs_IndicatorCCAPI_get()];
      _set_decorators = [validateArgs_IndicatorCCAPI_set()];
      _sendReport_decorators = [validateArgs_IndicatorCCAPI_sendReport()];
      _getSupported_decorators = [validateArgs_IndicatorCCAPI_getSupported()];
      _reportSupported_decorators = [validateArgs_IndicatorCCAPI_reportSupported()];
      _reportDescription_decorators = [validateArgs_IndicatorCCAPI_reportDescription()];
      _setTimeout_decorators = [validateArgs_IndicatorCCAPI_setTimeout()];
      _getTimeout_decorators = [validateArgs_IndicatorCCAPI_getTimeout()];
      _getDescription_decorators = [validateArgs_IndicatorCCAPI_getDescription()];
      __esDecorate(this, null, _get_decorators, { kind: "method", name: "get", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "get" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.get, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _sendReport_decorators, { kind: "method", name: "sendReport", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "sendReport" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.sendReport, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getSupported_decorators, { kind: "method", name: "getSupported", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getSupported" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getSupported, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _reportSupported_decorators, { kind: "method", name: "reportSupported", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reportSupported" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reportSupported, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _reportDescription_decorators, { kind: "method", name: "reportDescription", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reportDescription" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reportDescription, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setTimeout_decorators, { kind: "method", name: "setTimeout", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setTimeout" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setTimeout, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getTimeout_decorators, { kind: "method", name: "getTimeout", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getTimeout" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getTimeout, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getDescription_decorators, { kind: "method", name: "getDescription", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getDescription" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getDescription, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IndicatorCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.IndicatorCommand.Get:
        case import_Types.IndicatorCommand.Report:
          return this.isSinglecast();
        case import_Types.IndicatorCommand.Set:
          return true;
        // This is mandatory
        case import_Types.IndicatorCommand.SupportedGet:
        case import_Types.IndicatorCommand.SupportedReport:
          return this.version >= 2 && this.isSinglecast();
        case import_Types.IndicatorCommand.DescriptionGet:
        case import_Types.IndicatorCommand.DescriptionReport:
          return this.version >= 4 && this.isSinglecast();
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property, propertyKey }, value) {
        const valueId = {
          commandClass: this.ccId,
          endpoint: this.endpoint.index,
          property,
          propertyKey
        };
        if (property === "value") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          return this.set(value);
        } else if (import_CCValues_generated.IndicatorCCValues.valueV2.is(valueId)) {
          const indicatorId = property;
          const propertyId = propertyKey;
          const expectedType = getIndicatorMetadata(indicatorId, propertyId).type;
          if (typeof value !== expectedType) {
            (0, import_API.throwWrongValueType)(this.ccId, property, expectedType, typeof value);
          }
          return this.set([
            {
              indicatorId,
              propertyId,
              value
            }
          ]);
        } else if (import_CCValues_generated.IndicatorCCValues.timeout.is(valueId)) {
          const indicatorId = property;
          if (typeof value !== "string") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "string", typeof value);
          }
          return this.setTimeout(indicatorId, value);
        } else if (import_CCValues_generated.IndicatorCCValues.identify.is(valueId)) {
          if (typeof value !== "boolean") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "boolean", typeof value);
          }
          return this.identify();
        } else {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        if (property === "value")
          return this.get();
        if (typeof property === "number") {
          return this.get(property);
        }
        (0, import_API.throwUnsupportedProperty)(this.ccId, property);
      };
    }
    async get(indicatorId) {
      this.assertSupportsCommand(import_Types.IndicatorCommand, import_Types.IndicatorCommand.Get);
      const cc = new IndicatorCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        indicatorId
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (!response)
        return;
      if (response.values)
        return response.values;
      return response.indicator0Value;
    }
    async set(value) {
      this.assertSupportsCommand(import_Types.IndicatorCommand, import_Types.IndicatorCommand.Set);
      if (this.version === 1 && typeof value !== "number") {
        throw new import_core.ZWaveError(`Node ${this.endpoint.nodeId} only supports IndicatorCC V1 which requires a single value to be set`, import_core.ZWaveErrorCodes.Argument_Invalid);
      } else if (this.version >= 2 && (0, import_typeguards.isArray)(value) && value.length > MAX_INDICATOR_OBJECTS) {
        throw new import_core.ZWaveError(`Only ${MAX_INDICATOR_OBJECTS} indicator values can be set at a time!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const cc = new IndicatorCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...typeof value === "number" ? { value } : { values: value }
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async sendReport(options) {
      this.assertSupportsCommand(import_Types.IndicatorCommand, import_Types.IndicatorCommand.Report);
      const cc = new IndicatorCCReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    async getSupported(indicatorId) {
      this.assertSupportsCommand(import_Types.IndicatorCommand, import_Types.IndicatorCommand.SupportedGet);
      const cc = new IndicatorCCSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        indicatorId
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return {
          // Include the actual indicator ID if 0x00 was requested
          ...indicatorId === 0 ? { indicatorId: response.indicatorId } : void 0,
          supportedProperties: response.supportedProperties,
          nextIndicatorId: response.nextIndicatorId
        };
      }
    }
    async reportSupported(indicatorId, supportedProperties, nextIndicatorId) {
      this.assertSupportsCommand(import_Types.IndicatorCommand, import_Types.IndicatorCommand.SupportedReport);
      const cc = new IndicatorCCSupportedReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        indicatorId,
        supportedProperties,
        nextIndicatorId
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    async reportDescription(indicatorId, description) {
      this.assertSupportsCommand(import_Types.IndicatorCommand, import_Types.IndicatorCommand.DescriptionReport);
      const cc = new IndicatorCCDescriptionReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        indicatorId,
        description
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Instructs the node to identify itself. Available starting with V3 of this CC.
     */
    async identify() {
      if (this.version < 3) {
        throw new import_core.ZWaveError(`The identify command is only supported in Indicator CC version 3 and above`, import_core.ZWaveErrorCodes.CC_NotSupported);
      }
      return this.set([
        {
          indicatorId: 80,
          propertyId: 3,
          value: 8
        },
        {
          indicatorId: 80,
          propertyId: 4,
          value: 3
        },
        {
          indicatorId: 80,
          propertyId: 5,
          value: 6
        }
      ]);
    }
    /**
     * Set a timeout for a given indicator ID after which the indicator will be turned off.
     * @param timeout The timeout in one of the supported forms:
     * 	- a timeout string in the form `12h18m17.59s`. All parts (hours, minutes, seconds, hundredths) are optional, but must be specified in this order. An empty string will be treated like `undefined`.
     * 	- an object specifying the timeout parts. An empty object will be treated like `undefined`.
     * 	- `undefined` to disable the timeout.
     */
    async setTimeout(indicatorId, timeout) {
      this.assertPhysicalEndpoint(this.endpoint);
      if (this.version < 3) {
        throw new import_core.ZWaveError(`The setTimeout command is only supported in Indicator CC version 3 and above`, import_core.ZWaveErrorCodes.CC_NotSupported);
      }
      if (typeof timeout === "string") {
        if (timeout === "") {
          timeout = void 0;
        } else {
          const parsed = parseIndicatorTimeoutString(timeout);
          if (!parsed) {
            throw new import_core.ZWaveError(`The timeout string "${timeout}" is not valid`, import_core.ZWaveErrorCodes.Argument_Invalid);
          }
          timeout = parsed;
        }
      }
      const supportedPropertyIDs = IndicatorCC.getSupportedPropertyIDsCached(this.host, this.endpoint, indicatorId);
      const objects = [];
      if (timeout) {
        const hours = timeout.hours ?? 0;
        const minutes = timeout.minutes ?? 0;
        const seconds = Math.floor(timeout.seconds ?? 0);
        const hundredths = Math.round((timeout.seconds ?? 0) % 1 * 100);
        if (hours) {
          if (!supportedPropertyIDs?.includes(10)) {
            throw new import_core.ZWaveError(`The indicator ${indicatorId} does not support setting the timeout in hours`, import_core.ZWaveErrorCodes.Argument_Invalid);
          }
          objects.push({
            indicatorId,
            propertyId: 10,
            value: hours
          });
        }
        if (minutes) {
          if (!supportedPropertyIDs?.includes(6)) {
            throw new import_core.ZWaveError(`The indicator ${indicatorId} does not support setting the timeout in minutes`, import_core.ZWaveErrorCodes.Argument_Invalid);
          }
          objects.push({
            indicatorId,
            propertyId: 6,
            value: minutes
          });
        }
        if (seconds) {
          if (!supportedPropertyIDs?.includes(7)) {
            throw new import_core.ZWaveError(`The indicator ${indicatorId} does not support setting the timeout in seconds`, import_core.ZWaveErrorCodes.Argument_Invalid);
          }
          objects.push({
            indicatorId,
            propertyId: 7,
            value: seconds
          });
        }
        if (hundredths) {
          if (!supportedPropertyIDs?.includes(8)) {
            throw new import_core.ZWaveError(`The indicator ${indicatorId} does not support setting the timeout in 1/100 seconds`, import_core.ZWaveErrorCodes.Argument_Invalid);
          }
          objects.push({
            indicatorId,
            propertyId: 8,
            value: hundredths
          });
        }
      }
      if (!objects.length) {
        objects.push(...(supportedPropertyIDs ?? []).map((p) => ({
          indicatorId,
          propertyId: p,
          value: 0
        })));
      }
      return this.set(objects);
    }
    /**
     * Returns the timeout after which the given indicator will be turned off.
     */
    async getTimeout(indicatorId) {
      const values = await this.get(indicatorId);
      if (!(0, import_typeguards.isArray)(values))
        return;
      return indicatorObjectsToTimeout(values);
    }
    async getDescription(indicatorId) {
      this.assertSupportsCommand(import_Types.IndicatorCommand, import_Types.IndicatorCommand.DescriptionGet);
      const cc = new IndicatorCCDescriptionGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        indicatorId
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.description;
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return IndicatorCCAPI2 = _classThis;
})();
let IndicatorCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses.Indicator), (0, import_CommandClassDecorators.implementedVersion)(4), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.IndicatorCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var IndicatorCC2 = class extends _classSuper {
    static {
      __name(this, "IndicatorCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IndicatorCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Indicator, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      if (api.version > 1) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "scanning supported indicator IDs...",
          direction: "outbound"
        });
        let curId = 0;
        const supportedIndicatorIds = [];
        do {
          const supportedResponse = await api.getSupported(curId);
          if (!supportedResponse) {
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: "Time out while scanning supported indicator IDs, skipping interview...",
              level: "warn"
            });
            return;
          }
          if (supportedResponse.supportedProperties.length > 0) {
            supportedIndicatorIds.push(supportedResponse.indicatorId ?? curId);
          }
          curId = supportedResponse.nextIndicatorId;
        } while (curId !== 0);
        this.setValue(ctx, import_CCValues_generated.IndicatorCCValues.supportedIndicatorIds, supportedIndicatorIds);
        const logMessage = `supported indicator IDs: ${supportedIndicatorIds.join(", ")}`;
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
        if (api.version >= 4) {
          const manufacturerDefinedIndicatorIds = supportedIndicatorIds.filter((id) => isManufacturerDefinedIndicator(id));
          if (manufacturerDefinedIndicatorIds.length > 0) {
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: "retrieving description for manufacturer-defined indicator IDs...",
              direction: "outbound"
            });
            for (const id of manufacturerDefinedIndicatorIds) {
              await api.getDescription(id);
            }
          }
        }
      }
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Indicator, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      if (api.version === 1) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "requesting current indicator value...",
          direction: "outbound"
        });
        await api.get();
      } else {
        const supportedIndicatorIds = this.getValue(ctx, import_CCValues_generated.IndicatorCCValues.supportedIndicatorIds) ?? [];
        for (const indicatorId of supportedIndicatorIds) {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `requesting current indicator value (id = ${(0, import_shared.num2hex)(indicatorId)})...`,
            direction: "outbound"
          });
          await api.get(indicatorId);
        }
      }
    }
    translatePropertyKey(ctx, property, propertyKey) {
      if (property === "value") {
        return void 0;
      } else if (typeof property === "number" && typeof propertyKey === "number") {
        const prop = (0, import_core.getIndicatorProperty)(propertyKey);
        if (prop)
          return prop.label;
      } else if (typeof property === "number" && propertyKey === "timeout") {
        return "Timeout";
      }
      return super.translatePropertyKey(ctx, property, propertyKey);
    }
    translateProperty(ctx, property, propertyKey) {
      if (typeof property === "number") {
        if (typeof propertyKey === "number" || propertyKey === "timeout") {
          if (property in import_core.Indicator)
            return import_core.Indicator[property];
        }
      }
      return super.translateProperty(ctx, property, propertyKey);
    }
    supportsV2Indicators(ctx) {
      const supportedIndicatorIds = this.getValue(ctx, import_CCValues_generated.IndicatorCCValues.supportedIndicatorIds);
      if (!supportedIndicatorIds?.length)
        return false;
      return supportedIndicatorIds.some((indicatorId) => !!this.getValue(ctx, import_CCValues_generated.IndicatorCCValues.supportedPropertyIDs(indicatorId))?.length);
    }
    getManufacturerDefinedIndicatorLabel(ctx, indicatorId) {
      if (isManufacturerDefinedIndicator(indicatorId)) {
        return this.getValue(ctx, import_CCValues_generated.IndicatorCCValues.indicatorDescription(indicatorId));
      }
    }
    static getSupportedPropertyIDsCached(ctx, endpoint, indicatorId) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.IndicatorCCValues.supportedPropertyIDs(indicatorId).endpoint(endpoint.index));
    }
  };
  return IndicatorCC2 = _classThis;
})();
let IndicatorCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IndicatorCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IndicatorCC;
  var IndicatorCCSet2 = class extends _classSuper {
    static {
      __name(this, "IndicatorCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IndicatorCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ("value" in options) {
        this.indicator0Value = options.value;
      } else {
        this.values = options.values;
      }
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const objCount = raw.payload.length >= 2 ? raw.payload[1] & 31 : 0;
      if (objCount === 0) {
        const indicator0Value = raw.payload[0];
        return new this({
          nodeId: ctx.sourceNodeId,
          value: indicator0Value
        });
      }
      (0, import_core.validatePayload)(raw.payload.length >= 2 + 3 * objCount);
      const values = [];
      for (let i = 0; i < objCount; i++) {
        const offset = 2 + 3 * i;
        const value = {
          indicatorId: raw.payload[offset],
          propertyId: raw.payload[offset + 1],
          value: raw.payload[offset + 2]
        };
        values.push(value);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        values
      });
    }
    indicator0Value;
    values;
    serialize(ctx) {
      if (this.values != void 0) {
        this.payload = import_shared.Bytes.alloc(2 + 3 * this.values.length, 0);
        const objCount = this.values.length & MAX_INDICATOR_OBJECTS;
        this.payload[1] = objCount;
        for (let i = 0; i < objCount; i++) {
          const offset = 2 + 3 * i;
          this.payload[offset] = this.values[i].indicatorId;
          this.payload[offset + 1] = this.values[i].propertyId;
          const value = this.values[i].value;
          this.payload[offset + 2] = value === true ? 255 : value === false ? 0 : value;
        }
      } else {
        this.payload = import_shared.Bytes.from([this.indicator0Value ?? 0]);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {};
      if (this.indicator0Value != void 0) {
        message["indicator 0 value"] = this.indicator0Value;
      }
      if (this.values != void 0) {
        message.values = this.values.map((v) => `
\xB7 indicatorId: ${v.indicatorId}
  propertyId:  ${v.propertyId}
  value:       ${v.value}`).join("");
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return IndicatorCCSet2 = _classThis;
})();
let IndicatorCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IndicatorCommand.Report)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IndicatorCC;
  var IndicatorCCReport2 = class extends _classSuper {
    static {
      __name(this, "IndicatorCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IndicatorCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ("value" in options) {
        this.indicator0Value = options.value;
      } else if ("values" in options) {
        if (options.values.length > MAX_INDICATOR_OBJECTS) {
          throw new import_core.ZWaveError(`Only ${MAX_INDICATOR_OBJECTS} indicator values can be set at a time!`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
        this.values = options.values;
      }
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const objCount = raw.payload.length >= 2 ? raw.payload[1] & 31 : 0;
      if (objCount === 0) {
        const indicator0Value = raw.payload[0];
        return new this({
          nodeId: ctx.sourceNodeId,
          value: indicator0Value
        });
      }
      (0, import_core.validatePayload)(raw.payload.length >= 2 + 3 * objCount);
      const values = [];
      for (let i = 0; i < objCount; i++) {
        const offset = 2 + 3 * i;
        const value = {
          indicatorId: raw.payload[offset],
          propertyId: raw.payload[offset + 1],
          value: raw.payload[offset + 2]
        };
        values.push(value);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        values
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      if (this.indicator0Value != void 0) {
        if (!this.supportsV2Indicators(ctx)) {
          const valueV1 = import_CCValues_generated.IndicatorCCValues.valueV1;
          this.setMetadata(ctx, valueV1);
          this.setValue(ctx, valueV1, this.indicator0Value);
        } else {
          if (this.isSinglecast()) {
            ctx.logNode(this.nodeId, {
              message: `ignoring V1 indicator report because the node supports V2 indicators`,
              direction: "none",
              endpoint: this.endpointIndex
            });
          }
        }
      } else if (this.values) {
        for (const value of this.values) {
          this.setIndicatorValue(ctx, value);
        }
        const groupedValues = groupByIndicatorId(this.values);
        for (const [indicatorId, values] of groupedValues) {
          const supportedPropertyIDs = this.getValue(ctx, import_CCValues_generated.IndicatorCCValues.supportedPropertyIDs(indicatorId)) ?? [];
          const filteredValues = values.filter((v) => supportedPropertyIDs.includes(v.propertyId));
          const overrideIndicatorLabel = this.getManufacturerDefinedIndicatorLabel(ctx, indicatorId);
          const timeout = indicatorObjectsToTimeout(filteredValues);
          if (timeout) {
            let timeoutString = "";
            if (timeout?.hours)
              timeoutString += `${timeout.hours}h`;
            if (timeout?.minutes) {
              timeoutString += `${timeout.minutes}m`;
            }
            if (timeout?.seconds) {
              timeoutString += `${timeout.seconds}s`;
            }
            const timeoutValue = import_CCValues_generated.IndicatorCCValues.timeout(indicatorId);
            const metadata = {
              ...timeoutValue.meta,
              label: getIndicatorLabel(
                indicatorId,
                6,
                // This is actually ignored, but pass a valid ID for clarity
                overrideIndicatorLabel,
                "Timeout"
              )
            };
            this.setMetadata(ctx, timeoutValue, metadata);
            this.setValue(ctx, timeoutValue, timeoutString);
          }
        }
      }
      return true;
    }
    indicator0Value;
    values;
    setIndicatorValue(ctx, value) {
      const overrideIndicatorLabel = this.getManufacturerDefinedIndicatorLabel(ctx, value.indicatorId);
      const metadata = getIndicatorMetadata(value.indicatorId, value.propertyId, overrideIndicatorLabel);
      if (metadata.type === "boolean") {
        value.value = !!value.value;
      }
      if (value.indicatorId === import_core.Indicator["Node Identify"]) {
        return;
      }
      const prop = (0, import_core.getIndicatorProperty)(value.propertyId);
      if (!prop?.exposeAsValue)
        return;
      const supportedPropertyIDs = this.getValue(ctx, import_CCValues_generated.IndicatorCCValues.supportedPropertyIDs(value.indicatorId)) ?? [];
      if (!supportedPropertyIDs.includes(value.propertyId))
        return;
      const valueV2 = import_CCValues_generated.IndicatorCCValues.valueV2(value.indicatorId, value.propertyId);
      this.setMetadata(ctx, valueV2, metadata);
      this.setValue(ctx, valueV2, value.value);
    }
    serialize(ctx) {
      if (this.values != void 0) {
        this.payload = import_shared.Bytes.alloc(2 + 3 * this.values.length, 0);
        const objCount = this.values.length & MAX_INDICATOR_OBJECTS;
        this.payload[1] = objCount;
        for (let i = 0; i < objCount; i++) {
          const offset = 2 + 3 * i;
          this.payload[offset] = this.values[i].indicatorId;
          this.payload[offset + 1] = this.values[i].propertyId;
          const value = this.values[i].value;
          this.payload[offset + 2] = value === true ? 255 : value === false ? 0 : value;
        }
      } else {
        this.payload = import_shared.Bytes.from([this.indicator0Value ?? 0]);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {};
      if (this.indicator0Value != void 0) {
        message["indicator 0 value"] = this.indicator0Value;
      }
      if (this.values != void 0) {
        message.values = this.values.map((v) => `
\xB7 indicatorId: ${v.indicatorId}
  propertyId:  ${v.propertyId}
  value:       ${v.value}`).join("");
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return IndicatorCCReport2 = _classThis;
})();
let IndicatorCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IndicatorCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(IndicatorCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IndicatorCC;
  var IndicatorCCGet2 = class extends _classSuper {
    static {
      __name(this, "IndicatorCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IndicatorCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.indicatorId = options.indicatorId;
    }
    static from(raw, ctx) {
      let indicatorId;
      if (raw.payload.length > 0) {
        indicatorId = raw.payload[0];
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        indicatorId
      });
    }
    indicatorId;
    serialize(ctx) {
      if (this.indicatorId != void 0) {
        this.payload = import_shared.Bytes.from([this.indicatorId]);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          indicator: getIndicatorName(this.indicatorId)
        }
      };
    }
  };
  return IndicatorCCGet2 = _classThis;
})();
let IndicatorCCSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IndicatorCommand.SupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IndicatorCC;
  var IndicatorCCSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "IndicatorCCSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IndicatorCCSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.indicatorId = options.indicatorId;
      this.nextIndicatorId = options.nextIndicatorId;
      this.supportedProperties = options.supportedProperties;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const indicatorId = raw.payload[0];
      const nextIndicatorId = raw.payload[1];
      const bitMaskLength = raw.payload[2] & 31;
      let supportedProperties;
      if (bitMaskLength === 0) {
        supportedProperties = [];
      } else {
        (0, import_core.validatePayload)(raw.payload.length >= 3 + bitMaskLength);
        supportedProperties = (0, import_core.parseBitMask)(raw.payload.subarray(3, 3 + bitMaskLength), 0).filter((v) => v !== 0);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        indicatorId,
        nextIndicatorId,
        supportedProperties
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      if (this.indicatorId !== 0) {
        this.setValue(ctx, import_CCValues_generated.IndicatorCCValues.supportedPropertyIDs(this.indicatorId), this.supportedProperties);
      }
      return true;
    }
    indicatorId;
    nextIndicatorId;
    supportedProperties;
    serialize(ctx) {
      const bitmask = this.supportedProperties.length > 0 ? (0, import_core.encodeBitMask)(this.supportedProperties, void 0, 0) : new import_shared.Bytes();
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([
          this.indicatorId,
          this.nextIndicatorId,
          bitmask.length
        ]),
        bitmask
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          indicator: getIndicatorName(this.indicatorId),
          "supported properties": this.supportedProperties.map((id) => (0, import_core.getIndicatorProperty)(id)?.label ?? `Unknown (${(0, import_shared.num2hex)(id)})`).join(", "),
          "next indicator": getIndicatorName(this.nextIndicatorId)
        }
      };
    }
  };
  return IndicatorCCSupportedReport2 = _classThis;
})();
function testResponseForIndicatorSupportedGet(sent, received) {
  return sent.indicatorId === 0 || received.indicatorId === sent.indicatorId;
}
__name(testResponseForIndicatorSupportedGet, "testResponseForIndicatorSupportedGet");
let IndicatorCCSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IndicatorCommand.SupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(IndicatorCCSupportedReport, testResponseForIndicatorSupportedGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IndicatorCC;
  var IndicatorCCSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "IndicatorCCSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IndicatorCCSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.indicatorId = options.indicatorId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const indicatorId = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        indicatorId
      });
    }
    indicatorId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.indicatorId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          indicator: getIndicatorName(this.indicatorId)
        }
      };
    }
  };
  return IndicatorCCSupportedGet2 = _classThis;
})();
let IndicatorCCDescriptionReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IndicatorCommand.DescriptionReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IndicatorCC;
  var IndicatorCCDescriptionReport2 = class extends _classSuper {
    static {
      __name(this, "IndicatorCCDescriptionReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IndicatorCCDescriptionReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.indicatorId = options.indicatorId;
      this.description = options.description;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const indicatorId = raw.payload[0];
      const descrptionLength = raw.payload[1];
      (0, import_core.validatePayload)(raw.payload.length >= 2 + descrptionLength);
      const description = raw.payload.subarray(2, 2 + descrptionLength).toString("utf8");
      return new this({
        nodeId: ctx.sourceNodeId,
        indicatorId,
        description
      });
    }
    indicatorId;
    description;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      if (this.description) {
        this.setValue(ctx, import_CCValues_generated.IndicatorCCValues.indicatorDescription(this.indicatorId), this.description);
      }
      return true;
    }
    serialize(ctx) {
      const description = import_shared.Bytes.from(this.description, "utf8");
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.indicatorId, description.length]),
        description
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "indicator ID": this.indicatorId,
          description: this.description || "(none)"
        }
      };
    }
  };
  return IndicatorCCDescriptionReport2 = _classThis;
})();
function testResponseForIndicatorDescriptionGet(sent, received) {
  return received.indicatorId === sent.indicatorId;
}
__name(testResponseForIndicatorDescriptionGet, "testResponseForIndicatorDescriptionGet");
let IndicatorCCDescriptionGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IndicatorCommand.DescriptionGet), (0, import_CommandClassDecorators.expectedCCResponse)(IndicatorCCDescriptionReport, testResponseForIndicatorDescriptionGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IndicatorCC;
  var IndicatorCCDescriptionGet2 = class extends _classSuper {
    static {
      __name(this, "IndicatorCCDescriptionGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IndicatorCCDescriptionGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.indicatorId = options.indicatorId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const indicatorId = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        indicatorId
      });
    }
    indicatorId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.indicatorId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "indicator ID": this.indicatorId
        }
      };
    }
  };
  return IndicatorCCDescriptionGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  IndicatorCC,
  IndicatorCCAPI,
  IndicatorCCDescriptionGet,
  IndicatorCCDescriptionReport,
  IndicatorCCGet,
  IndicatorCCReport,
  IndicatorCCSet,
  IndicatorCCSupportedGet,
  IndicatorCCSupportedReport,
  IndicatorCCValues,
  shouldExposeIndicatorValue
});
//# sourceMappingURL=IndicatorCC.js.map
