"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var IrrigationCC_exports = {};
__export(IrrigationCC_exports, {
  IrrigationCC: () => IrrigationCC,
  IrrigationCCAPI: () => IrrigationCCAPI,
  IrrigationCCSystemConfigGet: () => IrrigationCCSystemConfigGet,
  IrrigationCCSystemConfigReport: () => IrrigationCCSystemConfigReport,
  IrrigationCCSystemConfigSet: () => IrrigationCCSystemConfigSet,
  IrrigationCCSystemInfoGet: () => IrrigationCCSystemInfoGet,
  IrrigationCCSystemInfoReport: () => IrrigationCCSystemInfoReport,
  IrrigationCCSystemShutoff: () => IrrigationCCSystemShutoff,
  IrrigationCCSystemStatusGet: () => IrrigationCCSystemStatusGet,
  IrrigationCCSystemStatusReport: () => IrrigationCCSystemStatusReport,
  IrrigationCCValues: () => import_CCValues_generated.IrrigationCCValues,
  IrrigationCCValveConfigGet: () => IrrigationCCValveConfigGet,
  IrrigationCCValveConfigReport: () => IrrigationCCValveConfigReport,
  IrrigationCCValveConfigSet: () => IrrigationCCValveConfigSet,
  IrrigationCCValveInfoGet: () => IrrigationCCValveInfoGet,
  IrrigationCCValveInfoReport: () => IrrigationCCValveInfoReport,
  IrrigationCCValveRun: () => IrrigationCCValveRun,
  IrrigationCCValveTableGet: () => IrrigationCCValveTableGet,
  IrrigationCCValveTableReport: () => IrrigationCCValveTableReport,
  IrrigationCCValveTableRun: () => IrrigationCCValveTableRun,
  IrrigationCCValveTableSet: () => IrrigationCCValveTableSet
});
module.exports = __toCommonJS(IrrigationCC_exports);
var __validateArgs = __toESM(require("./IrrigationCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CCValueUtils = require("../lib/CCValueUtils.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_IrrigationCCAPI_setSystemConfig, validateArgs_IrrigationCCAPI_getValveInfo, validateArgs_IrrigationCCAPI_setValveConfig, validateArgs_IrrigationCCAPI_getValveConfig, validateArgs_IrrigationCCAPI_runValve, validateArgs_IrrigationCCAPI_shutoffValve, validateArgs_IrrigationCCAPI_setValveTable, validateArgs_IrrigationCCAPI_getValveTable, validateArgs_IrrigationCCAPI_runTables, validateArgs_IrrigationCCAPI_shutoffSystem } = __validateArgs;
const systemConfigProperties = [
  "masterValveDelay",
  "highPressureThreshold",
  "lowPressureThreshold",
  "rainSensorPolarity",
  "moistureSensorPolarity"
];
const valveConfigPropertyKeys = [
  "nominalCurrentHighThreshold",
  "nominalCurrentLowThreshold",
  "maximumFlow",
  "highFlowThreshold",
  "lowFlowThreshold",
  "useRainSensor",
  "useMoistureSensor"
];
let IrrigationCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses.Irrigation)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _setSystemConfig_decorators;
  let _getValveInfo_decorators;
  let _setValveConfig_decorators;
  let _getValveConfig_decorators;
  let _runValve_decorators;
  let _shutoffValve_decorators;
  let _setValveTable_decorators;
  let _getValveTable_decorators;
  let _runTables_decorators;
  let _shutoffSystem_decorators;
  var IrrigationCCAPI2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(this, null, _setSystemConfig_decorators, { kind: "method", name: "setSystemConfig", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setSystemConfig" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setSystemConfig, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getValveInfo_decorators, { kind: "method", name: "getValveInfo", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getValveInfo" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getValveInfo, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setValveConfig_decorators, { kind: "method", name: "setValveConfig", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setValveConfig" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setValveConfig, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getValveConfig_decorators, { kind: "method", name: "getValveConfig", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getValveConfig" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getValveConfig, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _runValve_decorators, { kind: "method", name: "runValve", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "runValve" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.runValve, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _shutoffValve_decorators, { kind: "method", name: "shutoffValve", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "shutoffValve" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.shutoffValve, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setValveTable_decorators, { kind: "method", name: "setValveTable", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setValveTable" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setValveTable, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getValveTable_decorators, { kind: "method", name: "getValveTable", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getValveTable" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getValveTable, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _runTables_decorators, { kind: "method", name: "runTables", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "runTables" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.runTables, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _shutoffSystem_decorators, { kind: "method", name: "shutoffSystem", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "shutoffSystem" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.shutoffSystem, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.IrrigationCommand.SystemInfoGet:
        case import_Types.IrrigationCommand.SystemStatusGet:
        case import_Types.IrrigationCommand.SystemConfigSet:
        case import_Types.IrrigationCommand.SystemConfigGet:
        case import_Types.IrrigationCommand.ValveInfoGet:
        case import_Types.IrrigationCommand.ValveConfigSet:
        case import_Types.IrrigationCommand.ValveConfigGet:
        case import_Types.IrrigationCommand.ValveRun:
        case import_Types.IrrigationCommand.ValveTableSet:
        case import_Types.IrrigationCommand.ValveTableGet:
        case import_Types.IrrigationCommand.ValveTableRun:
        case import_Types.IrrigationCommand.SystemShutoff:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getSystemInfo() {
      this.assertSupportsCommand(import_Types.IrrigationCommand, import_Types.IrrigationCommand.SystemInfoGet);
      const cc = new IrrigationCCSystemInfoGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "numValves",
          "numValveTables",
          "supportsMasterValve",
          "maxValveTableSize"
        ]);
      }
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getSystemStatus() {
      this.assertSupportsCommand(import_Types.IrrigationCommand, import_Types.IrrigationCommand.SystemStatusGet);
      const cc = new IrrigationCCSystemStatusGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "systemVoltage",
          "flowSensorActive",
          "pressureSensorActive",
          "rainSensorActive",
          "moistureSensorActive",
          "flow",
          "pressure",
          "shutoffDuration",
          "errorNotProgrammed",
          "errorEmergencyShutdown",
          "errorHighPressure",
          "errorLowPressure",
          "errorValve",
          "masterValveOpen",
          "firstOpenZoneId"
        ]);
      }
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getSystemConfig() {
      this.assertSupportsCommand(import_Types.IrrigationCommand, import_Types.IrrigationCommand.SystemConfigGet);
      const cc = new IrrigationCCSystemConfigGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "masterValveDelay",
          "highPressureThreshold",
          "lowPressureThreshold",
          "rainSensorPolarity",
          "moistureSensorPolarity"
        ]);
      }
    }
    async setSystemConfig(config) {
      this.assertSupportsCommand(import_Types.IrrigationCommand, import_Types.IrrigationCommand.SystemConfigSet);
      const cc = new IrrigationCCSystemConfigSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...config
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getValveInfo(valveId) {
      this.assertSupportsCommand(import_Types.IrrigationCommand, import_Types.IrrigationCommand.ValveInfoGet);
      const cc = new IrrigationCCValveInfoGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        valveId
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "connected",
          "nominalCurrent",
          "errorShortCircuit",
          "errorHighCurrent",
          "errorLowCurrent",
          "errorMaximumFlow",
          "errorHighFlow",
          "errorLowFlow"
        ]);
      }
    }
    async setValveConfig(options) {
      this.assertSupportsCommand(import_Types.IrrigationCommand, import_Types.IrrigationCommand.ValveConfigSet);
      const cc = new IrrigationCCValveConfigSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getValveConfig(valveId) {
      this.assertSupportsCommand(import_Types.IrrigationCommand, import_Types.IrrigationCommand.ValveConfigGet);
      const cc = new IrrigationCCValveConfigGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        valveId
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "nominalCurrentHighThreshold",
          "nominalCurrentLowThreshold",
          "maximumFlow",
          "highFlowThreshold",
          "lowFlowThreshold",
          "useRainSensor",
          "useMoistureSensor"
        ]);
      }
    }
    async runValve(valveId, duration) {
      this.assertSupportsCommand(import_Types.IrrigationCommand, import_Types.IrrigationCommand.ValveRun);
      const cc = new IrrigationCCValveRun({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        valveId,
        duration
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    shutoffValve(valveId) {
      return this.runValve(valveId, 0);
    }
    async setValveTable(tableId, entries) {
      this.assertSupportsCommand(import_Types.IrrigationCommand, import_Types.IrrigationCommand.ValveTableSet);
      if (!this.endpoint.virtual) {
        const maxValveTableSize = IrrigationCC.getMaxValveTableSizeCached(this.host, this.endpoint);
        if (maxValveTableSize != void 0 && entries.length > maxValveTableSize) {
          throw new import_core.ZWaveError(`The number of valve table entries must not exceed ${maxValveTableSize}.`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
      }
      const cc = new IrrigationCCValveTableSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        tableId,
        entries
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getValveTable(tableId) {
      this.assertSupportsCommand(import_Types.IrrigationCommand, import_Types.IrrigationCommand.ValveTableGet);
      const cc = new IrrigationCCValveTableGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        tableId
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return response?.entries;
      }
    }
    async runTables(tableIDs) {
      this.assertSupportsCommand(import_Types.IrrigationCommand, import_Types.IrrigationCommand.ValveTableRun);
      const cc = new IrrigationCCValveTableRun({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        tableIDs
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Shuts off the entire system for the given duration.
     * @param duration Shutoff duration in hours. A value of 255 will shut off the entire system permanently and prevents schedules from running.
     */
    async shutoffSystem(duration) {
      this.assertSupportsCommand(import_Types.IrrigationCommand, import_Types.IrrigationCommand.SystemShutoff);
      const cc = new IrrigationCCSystemShutoff({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        duration
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    /** Shuts off the entire system permanently and prevents schedules from running */
    shutoffSystemPermanently() {
      return this.shutoffSystem(255);
    }
    get [(_setSystemConfig_decorators = [validateArgs_IrrigationCCAPI_setSystemConfig({ strictEnums: true })], _getValveInfo_decorators = [validateArgs_IrrigationCCAPI_getValveInfo()], _setValveConfig_decorators = [validateArgs_IrrigationCCAPI_setValveConfig()], _getValveConfig_decorators = [validateArgs_IrrigationCCAPI_getValveConfig()], _runValve_decorators = [validateArgs_IrrigationCCAPI_runValve()], _shutoffValve_decorators = [validateArgs_IrrigationCCAPI_shutoffValve()], _setValveTable_decorators = [validateArgs_IrrigationCCAPI_setValveTable()], _getValveTable_decorators = [validateArgs_IrrigationCCAPI_getValveTable()], _runTables_decorators = [validateArgs_IrrigationCCAPI_runTables()], _shutoffSystem_decorators = [validateArgs_IrrigationCCAPI_shutoffSystem()], import_API.SET_VALUE)]() {
      return async function({ property, propertyKey }, value) {
        const valueDB = this.getValueDB();
        if (systemConfigProperties.includes(property)) {
          const options = {};
          for (const prop of systemConfigProperties) {
            if (prop === property)
              continue;
            const valueId = {
              commandClass: this.ccId,
              endpoint: this.endpoint.index,
              property: prop
            };
            const cachedVal = valueDB.getValue(valueId);
            if (cachedVal == void 0) {
              throw new import_core.ZWaveError(`The "${property}" property cannot be changed before ${prop} is known!`, import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            options[prop] = cachedVal;
          }
          options[property] = value;
          return this.setSystemConfig(options);
        } else if (property === "shutoff") {
          return this.shutoffSystem(0);
        } else if (property === "master" || typeof property === "number" && property >= 1) {
          if (propertyKey == void 0) {
            (0, import_API.throwMissingPropertyKey)(this.ccId, property);
          }
          if (valveConfigPropertyKeys.includes(propertyKey)) {
            const options = {
              valveId: property
            };
            for (const prop of valveConfigPropertyKeys) {
              if (prop === propertyKey)
                continue;
              const valueId = {
                commandClass: this.ccId,
                endpoint: this.endpoint.index,
                property,
                propertyKey: prop
              };
              const cachedVal = valueDB.getValue(valueId);
              if (cachedVal == void 0) {
                throw new import_core.ZWaveError(`The "${property}_${propertyKey}" property cannot be changed before ${property}_${prop} is known!`, import_core.ZWaveErrorCodes.Argument_Invalid);
              }
              options[prop] = cachedVal;
            }
            options[propertyKey] = value;
            return this.setValveConfig(options);
          } else if (propertyKey === "duration") {
            return;
          } else if (propertyKey === "startStop") {
            if (typeof value !== "boolean") {
              (0, import_API.throwWrongValueType)(this.ccId, property, "boolean", typeof value);
            }
            if (value) {
              const duration = valueDB.getValue(import_CCValues_generated.IrrigationCCValues.valveRunDuration(property).endpoint(this.endpoint.index));
              if (duration == void 0) {
                throw new import_core.ZWaveError(`Cannot start a valve run without specifying a duration first!`, import_core.ZWaveErrorCodes.Argument_Invalid);
              }
              return this.runValve(property, duration);
            } else {
              return this.shutoffValve(property);
            }
          } else {
            (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
          }
        }
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property, propertyKey }) {
        switch (property) {
          case "systemVoltage":
          case "flowSensorActive":
          case "pressureSensorActive":
          case "rainSensorActive":
          case "moistureSensorActive":
          case "flow":
          case "pressure":
          case "shutoffDuration":
          case "errorNotProgrammed":
          case "errorEmergencyShutdown":
          case "errorHighPressure":
          case "errorLowPressure":
          case "errorValve":
          case "masterValveOpen":
          case "firstOpenZoneId":
            return (await this.getSystemStatus())?.[property];
          case "masterValveDelay":
          case "highPressureThreshold":
          case "lowPressureThreshold":
          case "rainSensorPolarity":
          case "moistureSensorPolarity":
            return (await this.getSystemConfig())?.[property];
        }
        if (property === "master" || typeof property === "number" && property >= 1) {
          switch (propertyKey) {
            case "connected":
            case "nominalCurrent":
            case "errorShortCircuit":
            case "errorHighCurrent":
            case "errorLowCurrent":
            case "errorMaximumFlow":
            case "errorHighFlow":
            case "errorLowFlow":
              return (await this.getValveInfo(property))?.[propertyKey];
            case "nominalCurrentHighThreshold":
            case "nominalCurrentLowThreshold":
            case "maximumFlow":
            case "highFlowThreshold":
            case "lowFlowThreshold":
            case "useRainSensor":
            case "useMoistureSensor":
              return (await this.getValveConfig(property))?.[propertyKey];
            case void 0:
              (0, import_API.throwMissingPropertyKey)(this.ccId, property);
            default:
              (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
          }
        }
        (0, import_API.throwUnsupportedProperty)(this.ccId, property);
      };
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return IrrigationCCAPI2 = _classThis;
})();
let IrrigationCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses.Irrigation), (0, import_CommandClassDecorators.implementedVersion)(1), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.IrrigationCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var IrrigationCC2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    /**
     * Returns the maximum number of valve table entries reported by the node.
     * This only works AFTER the node has been interviewed.
     */
    static getMaxValveTableSizeCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.IrrigationCCValues.maxValveTableSize.endpoint(endpoint.index));
    }
    /**
     * Returns the number of zone valves reported by the node.
     * This only works AFTER the node has been interviewed.
     */
    static getNumValvesCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.IrrigationCCValues.numValves.endpoint(endpoint.index));
    }
    /**
     * Returns whether the node supports a master valve
     * This only works AFTER the node has been interviewed.
     */
    static supportsMasterValveCached(ctx, endpoint) {
      return !!ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.IrrigationCCValues.supportsMasterValve.endpoint(endpoint.index));
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Irrigation, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "Querying irrigation system info...",
        direction: "outbound"
      });
      const systemInfo = await api.getSystemInfo();
      if (!systemInfo) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Time out while querying irrigation system info, skipping interview...",
          level: "warn"
        });
        return;
      }
      const logMessage = `received irrigation system info:
supports master valve: ${systemInfo.supportsMasterValve}
no. of valves:         ${systemInfo.numValves}
no. of valve tables:   ${systemInfo.numValveTables}
max. valve table size: ${systemInfo.maxValveTableSize}`;
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: logMessage,
        direction: "inbound"
      });
      for (let i = 1; i <= systemInfo.numValves; i++) {
        this.ensureMetadata(ctx, import_CCValues_generated.IrrigationCCValues.valveRunDuration(i));
        this.ensureMetadata(ctx, import_CCValues_generated.IrrigationCCValues.valveRunStartStop(i));
      }
      this.ensureMetadata(ctx, import_CCValues_generated.IrrigationCCValues.shutoffSystem);
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Irrigation, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "Querying irrigation system configuration...",
        direction: "outbound"
      });
      const systemConfig = await api.getSystemConfig();
      if (systemConfig) {
        let logMessage = `received irrigation system configuration:
master valve delay:       ${systemConfig.masterValveDelay} seconds
high pressure threshold:  ${systemConfig.highPressureThreshold} kPa
low pressure threshold:   ${systemConfig.lowPressureThreshold} kPa`;
        if (systemConfig.rainSensorPolarity != void 0) {
          logMessage += `
rain sensor polarity:     ${(0, import_shared.getEnumMemberName)(import_Types.IrrigationSensorPolarity, systemConfig.rainSensorPolarity)}`;
        }
        if (systemConfig.moistureSensorPolarity != void 0) {
          logMessage += `
moisture sensor polarity: ${(0, import_shared.getEnumMemberName)(import_Types.IrrigationSensorPolarity, systemConfig.moistureSensorPolarity)}`;
        }
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      }
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "Querying irrigation system status...",
        direction: "outbound"
      });
      await api.getSystemStatus();
      if (IrrigationCC2.supportsMasterValveCached(ctx, endpoint)) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Querying master valve configuration...",
          direction: "outbound"
        });
        await api.getValveConfig("master");
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Querying master valve status...",
          direction: "outbound"
        });
        await api.getValveInfo("master");
      }
      for (let i = 1; i <= (IrrigationCC2.getNumValvesCached(ctx, endpoint) ?? 0); i++) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `Querying configuration for valve ${i.toString().padStart(3, "0")}...`,
          direction: "outbound"
        });
        await api.getValveConfig(i);
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `Querying status for valve ${i.toString().padStart(3, "0")}...`,
          direction: "outbound"
        });
        await api.getValveInfo(i);
      }
    }
    translateProperty(ctx, property, propertyKey) {
      if (property === "master") {
        return "Master valve";
      } else if (typeof property === "number") {
        return `Valve ${property.toString().padStart(3, "0")}`;
      }
      return super.translateProperty(ctx, property, propertyKey);
    }
  };
  return IrrigationCC2 = _classThis;
})();
let IrrigationCCSystemInfoReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.SystemInfoReport), (0, import_CommandClassDecorators.ccValueProperty)("numValves", import_CCValues_generated.IrrigationCCValues.numValves), (0, import_CommandClassDecorators.ccValueProperty)("numValveTables", import_CCValues_generated.IrrigationCCValues.numValveTables), (0, import_CommandClassDecorators.ccValueProperty)("supportsMasterValve", import_CCValues_generated.IrrigationCCValues.supportsMasterValve), (0, import_CommandClassDecorators.ccValueProperty)("maxValveTableSize", import_CCValues_generated.IrrigationCCValues.maxValveTableSize)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCSystemInfoReport2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCSystemInfoReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCSystemInfoReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportsMasterValve = options.supportsMasterValve;
      this.numValves = options.numValves;
      this.numValveTables = options.numValveTables;
      this.maxValveTableSize = options.maxValveTableSize;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 4);
      const supportsMasterValve = !!(raw.payload[0] & 1);
      const numValves = raw.payload[1];
      const numValveTables = raw.payload[2];
      const maxValveTableSize = raw.payload[3] & 15;
      return new this({
        nodeId: ctx.sourceNodeId,
        supportsMasterValve,
        numValves,
        numValveTables,
        maxValveTableSize
      });
    }
    numValves;
    numValveTables;
    supportsMasterValve;
    maxValveTableSize;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supports master valve": this.supportsMasterValve,
          "no. of valves": this.numValves,
          "no. of valve tables": this.numValveTables,
          "max. valve table size": this.maxValveTableSize
        }
      };
    }
  };
  return IrrigationCCSystemInfoReport2 = _classThis;
})();
let IrrigationCCSystemInfoGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.SystemInfoGet), (0, import_CommandClassDecorators.expectedCCResponse)(IrrigationCCSystemInfoReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCSystemInfoGet2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCSystemInfoGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCSystemInfoGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return IrrigationCCSystemInfoGet2 = _classThis;
})();
let IrrigationCCSystemStatusReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.SystemStatusReport), (0, import_CommandClassDecorators.ccValueProperty)("systemVoltage", import_CCValues_generated.IrrigationCCValues.systemVoltage), (0, import_CommandClassDecorators.ccValueProperty)("flowSensorActive", import_CCValues_generated.IrrigationCCValues.flowSensorActive), (0, import_CommandClassDecorators.ccValueProperty)("pressureSensorActive", import_CCValues_generated.IrrigationCCValues.pressureSensorActive), (0, import_CommandClassDecorators.ccValueProperty)("rainSensorActive", import_CCValues_generated.IrrigationCCValues.rainSensorActive), (0, import_CommandClassDecorators.ccValueProperty)("moistureSensorActive", import_CCValues_generated.IrrigationCCValues.moistureSensorActive), (0, import_CommandClassDecorators.ccValueProperty)("flow", import_CCValues_generated.IrrigationCCValues.flow), (0, import_CommandClassDecorators.ccValueProperty)("pressure", import_CCValues_generated.IrrigationCCValues.pressure), (0, import_CommandClassDecorators.ccValueProperty)("shutoffDuration", import_CCValues_generated.IrrigationCCValues.shutoffDuration), (0, import_CommandClassDecorators.ccValueProperty)("errorNotProgrammed", import_CCValues_generated.IrrigationCCValues.errorNotProgrammed), (0, import_CommandClassDecorators.ccValueProperty)("errorEmergencyShutdown", import_CCValues_generated.IrrigationCCValues.errorEmergencyShutdown), (0, import_CommandClassDecorators.ccValueProperty)("errorHighPressure", import_CCValues_generated.IrrigationCCValues.errorHighPressure), (0, import_CommandClassDecorators.ccValueProperty)("errorLowPressure", import_CCValues_generated.IrrigationCCValues.errorLowPressure), (0, import_CommandClassDecorators.ccValueProperty)("errorValve", import_CCValues_generated.IrrigationCCValues.errorValve), (0, import_CommandClassDecorators.ccValueProperty)("masterValveOpen", import_CCValues_generated.IrrigationCCValues.masterValveOpen), (0, import_CommandClassDecorators.ccValueProperty)("firstOpenZoneId", import_CCValues_generated.IrrigationCCValues.firstOpenZoneId)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCSystemStatusReport2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCSystemStatusReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCSystemStatusReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.systemVoltage = options.systemVoltage;
      this.flowSensorActive = options.flowSensorActive;
      this.pressureSensorActive = options.pressureSensorActive;
      this.rainSensorActive = options.rainSensorActive;
      this.moistureSensorActive = options.moistureSensorActive;
      this.flow = options.flow;
      this.pressure = options.pressure;
      this.shutoffDuration = options.shutoffDuration;
      this.errorNotProgrammed = options.errorNotProgrammed;
      this.errorEmergencyShutdown = options.errorEmergencyShutdown;
      this.errorHighPressure = options.errorHighPressure;
      this.errorLowPressure = options.errorLowPressure;
      this.errorValve = options.errorValve;
      this.masterValveOpen = options.masterValveOpen;
      this.firstOpenZoneId = options.firstOpenZoneId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const systemVoltage = raw.payload[0];
      const flowSensorActive = !!(raw.payload[1] & 1);
      const pressureSensorActive = !!(raw.payload[1] & 2);
      const rainSensorActive = !!(raw.payload[1] & 4);
      const moistureSensorActive = !!(raw.payload[1] & 8);
      let offset = 2;
      let flow;
      {
        const { value, scale, bytesRead } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(offset));
        (0, import_core.validatePayload)(scale === 0);
        if (flowSensorActive)
          flow = value;
        offset += bytesRead;
      }
      let pressure;
      {
        const { value, scale, bytesRead } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(offset));
        (0, import_core.validatePayload)(scale === 0);
        if (pressureSensorActive)
          pressure = value;
        offset += bytesRead;
      }
      (0, import_core.validatePayload)(raw.payload.length >= offset + 4);
      const shutoffDuration = raw.payload[offset];
      const errorNotProgrammed = !!(raw.payload[offset + 1] & 1);
      const errorEmergencyShutdown = !!(raw.payload[offset + 1] & 2);
      const errorHighPressure = !!(raw.payload[offset + 1] & 4);
      const errorLowPressure = !!(raw.payload[offset + 1] & 8);
      const errorValve = !!(raw.payload[offset + 1] & 16);
      const masterValveOpen = !!(raw.payload[offset + 2] & 1);
      let firstOpenZoneId;
      if (raw.payload[offset + 3]) {
        firstOpenZoneId = raw.payload[offset + 3];
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        systemVoltage,
        flowSensorActive,
        pressureSensorActive,
        rainSensorActive,
        moistureSensorActive,
        flow,
        pressure,
        shutoffDuration,
        errorNotProgrammed,
        errorEmergencyShutdown,
        errorHighPressure,
        errorLowPressure,
        errorValve,
        masterValveOpen,
        firstOpenZoneId
      });
    }
    systemVoltage;
    flowSensorActive;
    pressureSensorActive;
    rainSensorActive;
    moistureSensorActive;
    flow;
    pressure;
    shutoffDuration;
    errorNotProgrammed;
    errorEmergencyShutdown;
    errorHighPressure;
    errorLowPressure;
    errorValve;
    masterValveOpen;
    firstOpenZoneId;
    toLogEntry(ctx) {
      const message = {
        "system voltage": `${this.systemVoltage} V`,
        "active sensors": [
          this.flowSensorActive ? "flow" : void 0,
          this.pressureSensorActive ? "pressure" : void 0,
          this.rainSensorActive ? "rain" : void 0,
          this.moistureSensorActive ? "moisture" : void 0
        ].filter(Boolean).join(", ")
      };
      if (this.flow != void 0) {
        message.flow = `${this.flow} l/h`;
      }
      if (this.pressure != void 0) {
        message.pressure = `${this.pressure} kPa`;
      }
      message["remaining shutoff duration"] = `${this.shutoffDuration} hours`;
      message["master valve status"] = this.masterValveOpen ? "open" : "closed";
      message["first open zone valve"] = this.firstOpenZoneId || "none";
      const errors = [
        this.errorNotProgrammed ? "device not programmed" : void 0,
        this.errorEmergencyShutdown ? "emergency shutdown" : void 0,
        this.errorHighPressure ? "high pressure threshold triggered" : void 0,
        this.errorLowPressure ? "low pressure threshold triggered" : void 0,
        this.errorValve ? "a valve or the master valve has an error" : void 0
      ].filter(Boolean);
      if (errors.length > 0) {
        message.errors = errors.map((e) => `
\xB7 ${e}`).join("");
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return IrrigationCCSystemStatusReport2 = _classThis;
})();
let IrrigationCCSystemStatusGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.SystemStatusGet), (0, import_CommandClassDecorators.expectedCCResponse)(IrrigationCCSystemStatusReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCSystemStatusGet2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCSystemStatusGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCSystemStatusGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return IrrigationCCSystemStatusGet2 = _classThis;
})();
let IrrigationCCSystemConfigSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.SystemConfigSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCSystemConfigSet2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCSystemConfigSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCSystemConfigSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.masterValveDelay = options.masterValveDelay;
      this.highPressureThreshold = options.highPressureThreshold;
      this.lowPressureThreshold = options.lowPressureThreshold;
      this.rainSensorPolarity = options.rainSensorPolarity;
      this.moistureSensorPolarity = options.moistureSensorPolarity;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    masterValveDelay;
    highPressureThreshold;
    lowPressureThreshold;
    rainSensorPolarity;
    moistureSensorPolarity;
    serialize(ctx) {
      let polarity = 0;
      if (this.rainSensorPolarity != void 0)
        polarity |= 1;
      if (this.moistureSensorPolarity != void 0)
        polarity |= 2;
      if (this.rainSensorPolarity == void 0 && this.moistureSensorPolarity == void 0) {
        polarity |= 128;
      }
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.masterValveDelay]),
        (0, import_core.encodeFloatWithScale)(
          this.highPressureThreshold,
          0
          /* kPa */
        ),
        (0, import_core.encodeFloatWithScale)(
          this.lowPressureThreshold,
          0
          /* kPa */
        ),
        import_shared.Bytes.from([polarity])
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "master valve delay": `${this.masterValveDelay} s`,
        "high pressure threshold": `${this.highPressureThreshold} kPa`,
        "low pressure threshold": `${this.lowPressureThreshold} kPa`
      };
      if (this.rainSensorPolarity != void 0) {
        message["rain sensor polarity"] = (0, import_shared.getEnumMemberName)(import_Types.IrrigationSensorPolarity, this.rainSensorPolarity);
      }
      if (this.moistureSensorPolarity != void 0) {
        message["moisture sensor polarity"] = (0, import_shared.getEnumMemberName)(import_Types.IrrigationSensorPolarity, this.moistureSensorPolarity);
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return IrrigationCCSystemConfigSet2 = _classThis;
})();
let IrrigationCCSystemConfigReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.SystemConfigReport), (0, import_CommandClassDecorators.ccValueProperty)("masterValveDelay", import_CCValues_generated.IrrigationCCValues.masterValveDelay), (0, import_CommandClassDecorators.ccValueProperty)("highPressureThreshold", import_CCValues_generated.IrrigationCCValues.highPressureThreshold), (0, import_CommandClassDecorators.ccValueProperty)("lowPressureThreshold", import_CCValues_generated.IrrigationCCValues.lowPressureThreshold), (0, import_CommandClassDecorators.ccValueProperty)("rainSensorPolarity", import_CCValues_generated.IrrigationCCValues.rainSensorPolarity), (0, import_CommandClassDecorators.ccValueProperty)("moistureSensorPolarity", import_CCValues_generated.IrrigationCCValues.moistureSensorPolarity)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCSystemConfigReport2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCSystemConfigReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCSystemConfigReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.masterValveDelay = options.masterValveDelay;
      this.highPressureThreshold = options.highPressureThreshold;
      this.lowPressureThreshold = options.lowPressureThreshold;
      this.rainSensorPolarity = options.rainSensorPolarity;
      this.moistureSensorPolarity = options.moistureSensorPolarity;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const masterValveDelay = raw.payload[0];
      let offset = 1;
      let highPressureThreshold;
      {
        const { value, scale, bytesRead } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(offset));
        (0, import_core.validatePayload)(
          scale === 0
          /* kPa */
        );
        highPressureThreshold = value;
        offset += bytesRead;
      }
      let lowPressureThreshold;
      {
        const { value, scale, bytesRead } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(offset));
        (0, import_core.validatePayload)(
          scale === 0
          /* kPa */
        );
        lowPressureThreshold = value;
        offset += bytesRead;
      }
      (0, import_core.validatePayload)(raw.payload.length >= offset + 1);
      const polarity = raw.payload[offset];
      let rainSensorPolarity;
      let moistureSensorPolarity;
      if (!!(polarity & 128)) {
        rainSensorPolarity = polarity & 1;
        moistureSensorPolarity = (polarity & 2) >>> 1;
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        masterValveDelay,
        highPressureThreshold,
        lowPressureThreshold,
        rainSensorPolarity,
        moistureSensorPolarity
      });
    }
    masterValveDelay;
    highPressureThreshold;
    lowPressureThreshold;
    rainSensorPolarity;
    moistureSensorPolarity;
    toLogEntry(ctx) {
      const message = {
        "master valve delay": `${this.masterValveDelay} s`,
        "high pressure threshold": `${this.highPressureThreshold} kPa`,
        "low pressure threshold": `${this.lowPressureThreshold} kPa`
      };
      if (this.rainSensorPolarity != void 0) {
        message["rain sensor polarity"] = (0, import_shared.getEnumMemberName)(import_Types.IrrigationSensorPolarity, this.rainSensorPolarity);
      }
      if (this.moistureSensorPolarity != void 0) {
        message["moisture sensor polarity"] = (0, import_shared.getEnumMemberName)(import_Types.IrrigationSensorPolarity, this.moistureSensorPolarity);
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return IrrigationCCSystemConfigReport2 = _classThis;
})();
let IrrigationCCSystemConfigGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.SystemConfigGet), (0, import_CommandClassDecorators.expectedCCResponse)(IrrigationCCSystemConfigReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCSystemConfigGet2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCSystemConfigGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCSystemConfigGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return IrrigationCCSystemConfigGet2 = _classThis;
})();
let IrrigationCCValveInfoReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.ValveInfoReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCValveInfoReport2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCValveInfoReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCValveInfoReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.valveId = options.valveId;
      this.connected = options.connected;
      this.nominalCurrent = options.nominalCurrent;
      this.errorShortCircuit = options.errorShortCircuit;
      this.errorHighCurrent = options.errorHighCurrent;
      this.errorLowCurrent = options.errorLowCurrent;
      this.errorMaximumFlow = options.errorMaximumFlow;
      this.errorHighFlow = options.errorHighFlow;
      this.errorLowFlow = options.errorLowFlow;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 4);
      let valveId;
      if ((raw.payload[0] & 1) === import_Types.ValveType.MasterValve) {
        valveId = "master";
      } else {
        valveId = raw.payload[1];
      }
      const connected = !!(raw.payload[0] & 2);
      const nominalCurrent = 10 * raw.payload[2];
      const errorShortCircuit = !!(raw.payload[3] & 1);
      const errorHighCurrent = !!(raw.payload[3] & 2);
      const errorLowCurrent = !!(raw.payload[3] & 4);
      let errorMaximumFlow;
      let errorHighFlow;
      let errorLowFlow;
      if (valveId === "master") {
        errorMaximumFlow = !!(raw.payload[3] & 8);
        errorHighFlow = !!(raw.payload[3] & 16);
        errorLowFlow = !!(raw.payload[3] & 32);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        valveId,
        connected,
        nominalCurrent,
        errorShortCircuit,
        errorHighCurrent,
        errorLowCurrent,
        errorMaximumFlow,
        errorHighFlow,
        errorLowFlow
      });
    }
    valveId;
    connected;
    nominalCurrent;
    errorShortCircuit;
    errorHighCurrent;
    errorLowCurrent;
    errorMaximumFlow;
    errorHighFlow;
    errorLowFlow;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const valveConnectedValue = import_CCValues_generated.IrrigationCCValues.valveConnected(this.valveId);
      this.ensureMetadata(ctx, valveConnectedValue);
      this.setValue(ctx, valveConnectedValue, this.connected);
      const nominalCurrentValue = import_CCValues_generated.IrrigationCCValues.nominalCurrent(this.valveId);
      this.ensureMetadata(ctx, nominalCurrentValue);
      this.setValue(ctx, nominalCurrentValue, this.nominalCurrent);
      const errorShortCircuitValue = import_CCValues_generated.IrrigationCCValues.errorShortCircuit(this.valveId);
      this.ensureMetadata(ctx, errorShortCircuitValue);
      this.setValue(ctx, errorShortCircuitValue, this.errorShortCircuit);
      const errorHighCurrentValue = import_CCValues_generated.IrrigationCCValues.errorHighCurrent(this.valveId);
      this.ensureMetadata(ctx, errorHighCurrentValue);
      this.setValue(ctx, errorHighCurrentValue, this.errorHighCurrent);
      const errorLowCurrentValue = import_CCValues_generated.IrrigationCCValues.errorLowCurrent(this.valveId);
      this.ensureMetadata(ctx, errorLowCurrentValue);
      this.setValue(ctx, errorLowCurrentValue, this.errorLowCurrent);
      if (this.errorMaximumFlow != void 0) {
        const errorMaximumFlowValue = import_CCValues_generated.IrrigationCCValues.errorMaximumFlow(this.valveId);
        this.ensureMetadata(ctx, errorMaximumFlowValue);
        this.setValue(ctx, errorMaximumFlowValue, this.errorMaximumFlow);
      }
      if (this.errorHighFlow != void 0) {
        const errorHighFlowValue = import_CCValues_generated.IrrigationCCValues.errorHighFlow(this.valveId);
        this.ensureMetadata(ctx, errorHighFlowValue);
        this.setValue(ctx, errorHighFlowValue, this.errorHighFlow);
      }
      if (this.errorLowFlow != void 0) {
        const errorLowFlowValue = import_CCValues_generated.IrrigationCCValues.errorLowFlow(this.valveId);
        this.ensureMetadata(ctx, errorLowFlowValue);
        this.setValue(ctx, errorLowFlowValue, this.errorLowFlow);
      }
      return true;
    }
    toLogEntry(ctx) {
      const message = {
        "valve ID": this.valveId,
        connected: this.connected,
        "nominal current": `${this.nominalCurrent} mA`
      };
      const errors = [
        this.errorShortCircuit ? "short circuit" : void 0,
        this.errorHighCurrent ? "current above high threshold" : void 0,
        this.errorLowCurrent ? "current below low threshold" : void 0,
        this.errorMaximumFlow ? "maximum flow" : void 0,
        this.errorHighFlow ? "flow above high threshold" : void 0,
        this.errorLowFlow ? "flow below low threshold" : void 0
      ].filter(Boolean);
      if (errors.length > 0) {
        message.errors = errors.map((e) => `
\xB7 ${e}`).join("");
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return IrrigationCCValveInfoReport2 = _classThis;
})();
function testResponseForIrrigationCommandWithValveId(sent, received) {
  return received.valveId === sent.valveId;
}
__name(testResponseForIrrigationCommandWithValveId, "testResponseForIrrigationCommandWithValveId");
let IrrigationCCValveInfoGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.ValveInfoGet), (0, import_CommandClassDecorators.expectedCCResponse)(IrrigationCCValveInfoReport, testResponseForIrrigationCommandWithValveId)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCValveInfoGet2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCValveInfoGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCValveInfoGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.valveId = options.valveId;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    valveId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.valveId === "master" ? 1 : 0,
        this.valveId === "master" ? 1 : this.valveId || 1
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "valve ID": this.valveId
        }
      };
    }
  };
  return IrrigationCCValveInfoGet2 = _classThis;
})();
let IrrigationCCValveConfigSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.ValveConfigSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCValveConfigSet2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCValveConfigSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCValveConfigSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.valveId = options.valveId;
      this.nominalCurrentHighThreshold = options.nominalCurrentHighThreshold;
      this.nominalCurrentLowThreshold = options.nominalCurrentLowThreshold;
      this.maximumFlow = options.maximumFlow;
      this.highFlowThreshold = options.highFlowThreshold;
      this.lowFlowThreshold = options.lowFlowThreshold;
      this.useRainSensor = options.useRainSensor;
      this.useMoistureSensor = options.useMoistureSensor;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    valveId;
    nominalCurrentHighThreshold;
    nominalCurrentLowThreshold;
    maximumFlow;
    highFlowThreshold;
    lowFlowThreshold;
    useRainSensor;
    useMoistureSensor;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([
          this.valveId === "master" ? 1 : 0,
          this.valveId === "master" ? 1 : this.valveId || 1,
          Math.floor(this.nominalCurrentHighThreshold / 10),
          Math.floor(this.nominalCurrentLowThreshold / 10)
        ]),
        (0, import_core.encodeFloatWithScale)(
          this.maximumFlow,
          0
          /* l/h */
        ),
        (0, import_core.encodeFloatWithScale)(
          this.highFlowThreshold,
          0
          /* l/h */
        ),
        (0, import_core.encodeFloatWithScale)(
          this.lowFlowThreshold,
          0
          /* l/h */
        ),
        import_shared.Bytes.from([
          (this.useRainSensor ? 1 : 0) | (this.useMoistureSensor ? 2 : 0)
        ])
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "valve ID": this.valveId,
          "nominal current high threshold": `${this.nominalCurrentHighThreshold} mA`,
          "nominal current low threshold": `${this.nominalCurrentLowThreshold} mA`,
          "maximum flow": `${this.maximumFlow} l/h`,
          "high flow threshold": `${this.highFlowThreshold} l/h`,
          "low flow threshold": `${this.lowFlowThreshold} l/h`,
          "use rain sensor": this.useRainSensor,
          "use moisture sensor": this.useMoistureSensor
        }
      };
    }
  };
  return IrrigationCCValveConfigSet2 = _classThis;
})();
let IrrigationCCValveConfigReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.ValveConfigReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCValveConfigReport2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCValveConfigReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCValveConfigReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.valveId = options.valveId;
      this.nominalCurrentHighThreshold = options.nominalCurrentHighThreshold;
      this.nominalCurrentLowThreshold = options.nominalCurrentLowThreshold;
      this.maximumFlow = options.maximumFlow;
      this.highFlowThreshold = options.highFlowThreshold;
      this.lowFlowThreshold = options.lowFlowThreshold;
      this.useRainSensor = options.useRainSensor;
      this.useMoistureSensor = options.useMoistureSensor;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 4);
      let valveId;
      if ((raw.payload[0] & 1) === import_Types.ValveType.MasterValve) {
        valveId = "master";
      } else {
        valveId = raw.payload[1];
      }
      const nominalCurrentHighThreshold = 10 * raw.payload[2];
      const nominalCurrentLowThreshold = 10 * raw.payload[3];
      let offset = 4;
      let maximumFlow;
      {
        const { value, scale, bytesRead } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(offset));
        (0, import_core.validatePayload)(
          scale === 0
          /* l/h */
        );
        maximumFlow = value;
        offset += bytesRead;
      }
      let highFlowThreshold;
      {
        const { value, scale, bytesRead } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(offset));
        (0, import_core.validatePayload)(
          scale === 0
          /* l/h */
        );
        highFlowThreshold = value;
        offset += bytesRead;
      }
      let lowFlowThreshold;
      {
        const { value, scale, bytesRead } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(offset));
        (0, import_core.validatePayload)(
          scale === 0
          /* l/h */
        );
        lowFlowThreshold = value;
        offset += bytesRead;
      }
      (0, import_core.validatePayload)(raw.payload.length >= offset + 1);
      const useRainSensor = !!(raw.payload[offset] & 1);
      const useMoistureSensor = !!(raw.payload[offset] & 2);
      return new this({
        nodeId: ctx.sourceNodeId,
        valveId,
        nominalCurrentHighThreshold,
        nominalCurrentLowThreshold,
        maximumFlow,
        highFlowThreshold,
        lowFlowThreshold,
        useRainSensor,
        useMoistureSensor
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const nominalCurrentHighThresholdValue = import_CCValues_generated.IrrigationCCValues.nominalCurrentHighThreshold(this.valveId);
      this.ensureMetadata(ctx, nominalCurrentHighThresholdValue);
      this.setValue(ctx, nominalCurrentHighThresholdValue, this.nominalCurrentHighThreshold);
      const nominalCurrentLowThresholdValue = import_CCValues_generated.IrrigationCCValues.nominalCurrentLowThreshold(this.valveId);
      this.ensureMetadata(ctx, nominalCurrentLowThresholdValue);
      this.setValue(ctx, nominalCurrentLowThresholdValue, this.nominalCurrentLowThreshold);
      const maximumFlowValue = import_CCValues_generated.IrrigationCCValues.maximumFlow(this.valveId);
      this.ensureMetadata(ctx, maximumFlowValue);
      this.setValue(ctx, maximumFlowValue, this.maximumFlow);
      const highFlowThresholdValue = import_CCValues_generated.IrrigationCCValues.highFlowThreshold(this.valveId);
      this.ensureMetadata(ctx, highFlowThresholdValue);
      this.setValue(ctx, highFlowThresholdValue, this.highFlowThreshold);
      const lowFlowThresholdValue = import_CCValues_generated.IrrigationCCValues.lowFlowThreshold(this.valveId);
      this.ensureMetadata(ctx, lowFlowThresholdValue);
      this.setValue(ctx, lowFlowThresholdValue, this.lowFlowThreshold);
      const useRainSensorValue = import_CCValues_generated.IrrigationCCValues.useRainSensor(this.valveId);
      this.ensureMetadata(ctx, useRainSensorValue);
      this.setValue(ctx, useRainSensorValue, this.useRainSensor);
      const useMoistureSensorValue = import_CCValues_generated.IrrigationCCValues.useMoistureSensor(this.valveId);
      this.ensureMetadata(ctx, useMoistureSensorValue);
      this.setValue(ctx, useMoistureSensorValue, this.useMoistureSensor);
      return true;
    }
    valveId;
    nominalCurrentHighThreshold;
    nominalCurrentLowThreshold;
    maximumFlow;
    highFlowThreshold;
    lowFlowThreshold;
    useRainSensor;
    useMoistureSensor;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "valve ID": this.valveId,
          "nominal current high threshold": `${this.nominalCurrentHighThreshold} mA`,
          "nominal current low threshold": `${this.nominalCurrentLowThreshold} mA`,
          "maximum flow": `${this.maximumFlow} l/h`,
          "high flow threshold": `${this.highFlowThreshold} l/h`,
          "low flow threshold": `${this.lowFlowThreshold} l/h`,
          "use rain sensor": this.useRainSensor,
          "use moisture sensor": this.useMoistureSensor
        }
      };
    }
  };
  return IrrigationCCValveConfigReport2 = _classThis;
})();
let IrrigationCCValveConfigGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.ValveConfigGet), (0, import_CommandClassDecorators.expectedCCResponse)(IrrigationCCValveConfigReport, testResponseForIrrigationCommandWithValveId)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCValveConfigGet2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCValveConfigGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCValveConfigGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.valveId = options.valveId;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    valveId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.valveId === "master" ? 1 : 0,
        this.valveId === "master" ? 1 : this.valveId || 1
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "valve ID": this.valveId
        }
      };
    }
  };
  return IrrigationCCValveConfigGet2 = _classThis;
})();
let IrrigationCCValveRun = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.ValveRun), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCValveRun2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCValveRun");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCValveRun2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.valveId = options.valveId;
      this.duration = options.duration;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    valveId;
    duration;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.valveId === "master" ? 1 : 0,
        this.valveId === "master" ? 1 : this.valveId || 1,
        0,
        0
      ]);
      this.payload.writeUInt16BE(this.duration, 2);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "valve ID": this.valveId
      };
      if (this.duration) {
        message.duration = `${this.duration} s`;
      } else {
        message.action = "turn off";
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return IrrigationCCValveRun2 = _classThis;
})();
let IrrigationCCValveTableSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.ValveTableSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCValveTableSet2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCValveTableSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCValveTableSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.tableId = options.tableId;
      this.entries = options.entries;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    tableId;
    entries;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(1 + this.entries.length * 3);
      this.payload[0] = this.tableId;
      for (let i = 0; i < this.entries.length; i++) {
        const entry = this.entries[i];
        const offset = 1 + i * 3;
        this.payload[offset] = entry.valveId;
        this.payload.writeUInt16BE(entry.duration, offset + 1);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "table ID": this.tableId
      };
      for (let i = 0; i < this.entries.length; i++) {
        const entry = this.entries[i];
        const valveLabel = entry.valveId.toString().padStart(3, "0");
        if (entry.duration) {
          message[`valve ${valveLabel} duration`] = `${entry.duration} s`;
        } else {
          message[`valve ${valveLabel} action`] = `turn off`;
        }
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return IrrigationCCValveTableSet2 = _classThis;
})();
let IrrigationCCValveTableReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.ValveTableReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCValveTableReport2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCValveTableReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCValveTableReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.tableId = options.tableId;
      this.entries = options.entries;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)((raw.payload.length - 1) % 3 === 0);
      const tableId = raw.payload[0];
      const entries = [];
      for (let offset = 1; offset < raw.payload.length; offset += 3) {
        entries.push({
          valveId: raw.payload[offset],
          duration: raw.payload.readUInt16BE(offset + 1)
        });
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        tableId,
        entries
      });
    }
    tableId;
    entries;
    toLogEntry(ctx) {
      const message = {
        "table ID": this.tableId
      };
      for (let i = 0; i < this.entries.length; i++) {
        const entry = this.entries[i];
        const valveLabel = entry.valveId.toString().padStart(3, "0");
        if (entry.duration) {
          message[`valve ${valveLabel} duration`] = `${entry.duration} s`;
        } else {
          message[`valve ${valveLabel} action`] = `turn off`;
        }
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return IrrigationCCValveTableReport2 = _classThis;
})();
function testResponseForIrrigationValveTableGet(sent, received) {
  return received.tableId === sent.tableId;
}
__name(testResponseForIrrigationValveTableGet, "testResponseForIrrigationValveTableGet");
let IrrigationCCValveTableGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.ValveTableGet), (0, import_CommandClassDecorators.expectedCCResponse)(IrrigationCCValveTableReport, testResponseForIrrigationValveTableGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCValveTableGet2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCValveTableGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCValveTableGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.tableId = options.tableId;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    tableId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.tableId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "table ID": this.tableId
        }
      };
    }
  };
  return IrrigationCCValveTableGet2 = _classThis;
})();
let IrrigationCCValveTableRun = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.ValveTableRun), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCValveTableRun2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCValveTableRun");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCValveTableRun2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.tableIDs = options.tableIDs;
      if (this.tableIDs.length < 1) {
        throw new import_core.ZWaveError(`${this.constructor.name}: At least one table ID must be specified.`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    tableIDs;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from(this.tableIDs);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "table IDs": this.tableIDs.map((id) => id.toString().padStart(3, "0")).join(", ")
        }
      };
    }
  };
  return IrrigationCCValveTableRun2 = _classThis;
})();
let IrrigationCCSystemShutoff = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.IrrigationCommand.SystemShutoff), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = IrrigationCC;
  var IrrigationCCSystemShutoff2 = class extends _classSuper {
    static {
      __name(this, "IrrigationCCSystemShutoff");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      IrrigationCCSystemShutoff2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.duration = options.duration;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    duration;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.duration ?? 255]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          duration: this.duration === 0 ? "temporarily" : this.duration === 255 || this.duration === void 0 ? "permanently" : `${this.duration} hours`
        }
      };
    }
  };
  return IrrigationCCSystemShutoff2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  IrrigationCC,
  IrrigationCCAPI,
  IrrigationCCSystemConfigGet,
  IrrigationCCSystemConfigReport,
  IrrigationCCSystemConfigSet,
  IrrigationCCSystemInfoGet,
  IrrigationCCSystemInfoReport,
  IrrigationCCSystemShutoff,
  IrrigationCCSystemStatusGet,
  IrrigationCCSystemStatusReport,
  IrrigationCCValues,
  IrrigationCCValveConfigGet,
  IrrigationCCValveConfigReport,
  IrrigationCCValveConfigSet,
  IrrigationCCValveInfoGet,
  IrrigationCCValveInfoReport,
  IrrigationCCValveRun,
  IrrigationCCValveTableGet,
  IrrigationCCValveTableReport,
  IrrigationCCValveTableRun,
  IrrigationCCValveTableSet
});
//# sourceMappingURL=IrrigationCC.js.map
