"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var LanguageCC_exports = {};
__export(LanguageCC_exports, {
  LanguageCC: () => LanguageCC,
  LanguageCCAPI: () => LanguageCCAPI,
  LanguageCCGet: () => LanguageCCGet,
  LanguageCCReport: () => LanguageCCReport,
  LanguageCCSet: () => LanguageCCSet,
  LanguageCCValues: () => import_CCValues_generated.LanguageCCValues
});
module.exports = __toCommonJS(LanguageCC_exports);
var __validateArgs = __toESM(require("./LanguageCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_LanguageCCAPI_set } = __validateArgs;
let LanguageCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses.Language)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _set_decorators;
  var LanguageCCAPI2 = class extends _classSuper {
    static {
      __name(this, "LanguageCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _set_decorators = [validateArgs_LanguageCCAPI_set()];
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      LanguageCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.LanguageCommand.Get:
          return this.isSinglecast();
        case import_Types.LanguageCommand.Set:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async get() {
      this.assertSupportsCommand(import_Types.LanguageCommand, import_Types.LanguageCommand.Get);
      const cc = new LanguageCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["language", "country"]);
      }
    }
    async set(language, country) {
      this.assertSupportsCommand(import_Types.LanguageCommand, import_Types.LanguageCommand.Set);
      const cc = new LanguageCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        language,
        country
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return LanguageCCAPI2 = _classThis;
})();
let LanguageCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses.Language), (0, import_CommandClassDecorators.implementedVersion)(1), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.LanguageCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var LanguageCC2 = class extends _classSuper {
    static {
      __name(this, "LanguageCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      LanguageCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Language, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        message: "requesting language setting...",
        direction: "outbound"
      });
      const resp = await api.get();
      if (resp) {
        const { language, country } = resp;
        const logMessage = `received current language setting: ${language}${country != void 0 ? `-${country}` : ""}`;
        ctx.logNode(node.id, {
          message: logMessage,
          direction: "inbound"
        });
      }
    }
  };
  return LanguageCC2 = _classThis;
})();
let LanguageCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.LanguageCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = LanguageCC;
  var LanguageCCSet2 = class extends _classSuper {
    static {
      __name(this, "LanguageCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      LanguageCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this._language = options.language;
      this._country = options.country;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    _language;
    get language() {
      return this._language;
    }
    set language(value) {
      if (value.length !== 3 || value.toLowerCase() !== value) {
        throw new import_core.ZWaveError("language must be a 3 digit (lowercase) code according to ISO 639-2", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this._language = value;
    }
    _country;
    get country() {
      return this._country;
    }
    set country(value) {
      if (typeof value === "string" && (value.length !== 2 || value.toUpperCase() !== value)) {
        throw new import_core.ZWaveError("country must be a 2 digit (uppercase) code according to ISO 3166-1", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this._country = value;
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.from(this._language, "ascii");
      if (this._country) {
        this.payload = import_shared.Bytes.concat([
          this.payload,
          import_shared.Bytes.from(this._country, "ascii")
        ]);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = { language: this.language };
      if (this._country != void 0) {
        message.country = this._country;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return LanguageCCSet2 = _classThis;
})();
let LanguageCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.LanguageCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("language", import_CCValues_generated.LanguageCCValues.language), (0, import_CommandClassDecorators.ccValueProperty)("country", import_CCValues_generated.LanguageCCValues.country)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = LanguageCC;
  var LanguageCCReport2 = class extends _classSuper {
    static {
      __name(this, "LanguageCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      LanguageCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.language = options.language;
      this.country = options.country;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const language = raw.payload.subarray(0, 3).toString("ascii");
      let country;
      if (raw.payload.length >= 5) {
        country = raw.payload.subarray(3, 5).toString("ascii");
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        language,
        country
      });
    }
    language;
    country;
    toLogEntry(ctx) {
      const message = { language: this.language };
      if (this.country != void 0) {
        message.country = this.country;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return LanguageCCReport2 = _classThis;
})();
let LanguageCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.LanguageCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(LanguageCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = LanguageCC;
  var LanguageCCGet2 = class extends _classSuper {
    static {
      __name(this, "LanguageCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      LanguageCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return LanguageCCGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  LanguageCC,
  LanguageCCAPI,
  LanguageCCGet,
  LanguageCCReport,
  LanguageCCSet,
  LanguageCCValues
});
//# sourceMappingURL=LanguageCC.js.map
