"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ManufacturerProprietaryCC_exports = {};
__export(ManufacturerProprietaryCC_exports, {
  ManufacturerProprietaryCC: () => ManufacturerProprietaryCC,
  ManufacturerProprietaryCCAPI: () => ManufacturerProprietaryCCAPI
});
module.exports = __toCommonJS(ManufacturerProprietaryCC_exports);
var __validateArgs = __toESM(require("./ManufacturerProprietaryCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_ManufacturerSpecificCC = require("./ManufacturerSpecificCC.js");
var import_Decorators = require("./manufacturerProprietary/Decorators.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_ManufacturerProprietaryCCAPI_sendData, validateArgs_ManufacturerProprietaryCCAPI_sendAndReceiveData } = __validateArgs;
let ManufacturerProprietaryCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Manufacturer Proprietary"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _sendData_decorators;
  let _sendAndReceiveData_decorators;
  var ManufacturerProprietaryCCAPI2 = class extends _classSuper {
    static {
      __name(this, "ManufacturerProprietaryCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _sendData_decorators = [validateArgs_ManufacturerProprietaryCCAPI_sendData()];
      _sendAndReceiveData_decorators = [validateArgs_ManufacturerProprietaryCCAPI_sendAndReceiveData()];
      __esDecorate(this, null, _sendData_decorators, { kind: "method", name: "sendData", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "sendData" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.sendData, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _sendAndReceiveData_decorators, { kind: "method", name: "sendAndReceiveData", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "sendAndReceiveData" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.sendAndReceiveData, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ManufacturerProprietaryCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(host, endpoint) {
      super(host, endpoint);
      __runInitializers(this, _instanceExtraInitializers);
      const manufacturerId = this.getValueDB().getValue(import_ManufacturerSpecificCC.ManufacturerSpecificCCValues.manufacturerId.id);
      if (manufacturerId != void 0) {
        const SpecificAPIConstructor = (0, import_Decorators.getManufacturerProprietaryAPI)(manufacturerId);
        if (SpecificAPIConstructor != void 0 && new.target !== SpecificAPIConstructor) {
          return new SpecificAPIConstructor(host, endpoint);
        }
      }
    }
    async sendData(manufacturerId, data) {
      const cc = new ManufacturerProprietaryCC({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        manufacturerId
      });
      cc.payload = data ? import_shared.Bytes.view(data) : new import_shared.Bytes();
      await this.host.sendCommand(cc, this.commandOptions);
    }
    async sendAndReceiveData(manufacturerId, data) {
      const cc = new ManufacturerProprietaryCC({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        manufacturerId,
        unspecifiedExpectsResponse: true
      });
      cc.payload = data ? import_shared.Bytes.view(data) : new import_shared.Bytes();
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return {
          manufacturerId: response.manufacturerId,
          data: response.payload
        };
      }
    }
  };
  return ManufacturerProprietaryCCAPI2 = _classThis;
})();
function getReponseForManufacturerProprietary(ctx, cc) {
  return cc.unspecifiedExpectsResponse ? ManufacturerProprietaryCC : void 0;
}
__name(getReponseForManufacturerProprietary, "getReponseForManufacturerProprietary");
function testResponseForManufacturerProprietaryRequest(sent, received) {
  return sent.manufacturerId === received.manufacturerId;
}
__name(testResponseForManufacturerProprietaryRequest, "testResponseForManufacturerProprietaryRequest");
let ManufacturerProprietaryCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Manufacturer Proprietary"]), (0, import_CommandClassDecorators.implementedVersion)(1), (0, import_CommandClassDecorators.expectedCCResponse)(getReponseForManufacturerProprietary, testResponseForManufacturerProprietaryRequest)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ManufacturerProprietaryCC2 = class extends _classSuper {
    static {
      __name(this, "ManufacturerProprietaryCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ManufacturerProprietaryCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.manufacturerId = options.manufacturerId ?? (0, import_Decorators.getManufacturerId)(this);
      this.unspecifiedExpectsResponse = options.unspecifiedExpectsResponse;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const manufacturerId = raw.payload.readUInt16BE(0);
      const PCConstructor = (0, import_Decorators.getManufacturerProprietaryCCConstructor)(manufacturerId);
      const payload = raw.payload.subarray(2);
      if (PCConstructor) {
        return PCConstructor.from(raw.withPayload(payload), ctx);
      }
      return new ManufacturerProprietaryCC2({
        nodeId: ctx.sourceNodeId,
        manufacturerId,
        payload
      });
    }
    manufacturerId;
    /**
     * @internal
     * This is used to indicate that an unspecified Manufacturer Proprietary CC instance expects a response.
     * Subclasses should roll their own `@expectedCCResponse` instead.
     */
    unspecifiedExpectsResponse;
    getManufacturerIdOrThrow() {
      if (this.manufacturerId == void 0) {
        throw new import_core.ZWaveError(`To use an instance of ManufacturerProprietaryCC, the manufacturer ID must be stored in the value DB`, import_core.ZWaveErrorCodes.ManufacturerProprietaryCC_NoManufacturerId);
      }
      return this.manufacturerId;
    }
    serialize(ctx) {
      const manufacturerId = this.getManufacturerIdOrThrow();
      this.ccCommand = manufacturerId >>> 8 & 255;
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([
          // 2nd byte of manufacturerId
          manufacturerId & 255
        ]),
        this.payload
      ]);
      return super.serialize(ctx);
    }
    createSpecificInstance() {
      if (this.manufacturerId != void 0) {
        const PCConstructor = (0, import_Decorators.getManufacturerProprietaryCCConstructor)(this.manufacturerId);
        if (PCConstructor) {
          return new PCConstructor({
            nodeId: this.nodeId,
            endpoint: this.endpointIndex
          });
        }
      }
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      this.manufacturerId = this.getValue(ctx, import_ManufacturerSpecificCC.ManufacturerSpecificCCValues.manufacturerId);
      const pcInstance = this.createSpecificInstance();
      if (pcInstance) {
        await pcInstance.interview(ctx);
      } else {
        ctx.logNode(node.id, {
          message: `${this.constructor.name}: skipping interview refresh because the matching proprietary CC is not implemented...`,
          direction: "none"
        });
      }
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      if (this.manufacturerId == void 0) {
        this.manufacturerId = this.getValue(ctx, import_ManufacturerSpecificCC.ManufacturerSpecificCCValues.manufacturerId);
      }
      const pcInstance = this.createSpecificInstance();
      if (pcInstance) {
        await pcInstance.refreshValues(ctx);
      } else {
        ctx.logNode(node.id, {
          message: `${this.constructor.name}: skipping value refresh because the matching proprietary CC is not implemented...`,
          direction: "none"
        });
      }
    }
  };
  return ManufacturerProprietaryCC2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ManufacturerProprietaryCC,
  ManufacturerProprietaryCCAPI
});
//# sourceMappingURL=ManufacturerProprietaryCC.js.map
