"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ManufacturerSpecificCC_exports = {};
__export(ManufacturerSpecificCC_exports, {
  ManufacturerSpecificCC: () => ManufacturerSpecificCC,
  ManufacturerSpecificCCAPI: () => ManufacturerSpecificCCAPI,
  ManufacturerSpecificCCDeviceSpecificGet: () => ManufacturerSpecificCCDeviceSpecificGet,
  ManufacturerSpecificCCDeviceSpecificReport: () => ManufacturerSpecificCCDeviceSpecificReport,
  ManufacturerSpecificCCGet: () => ManufacturerSpecificCCGet,
  ManufacturerSpecificCCReport: () => ManufacturerSpecificCCReport,
  ManufacturerSpecificCCValues: () => import_CCValues_generated.ManufacturerSpecificCCValues
});
module.exports = __toCommonJS(ManufacturerSpecificCC_exports);
var __validateArgs = __toESM(require("./ManufacturerSpecificCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_ManufacturerSpecificCCAPI_deviceSpecificGet, validateArgs_ManufacturerSpecificCCAPI_sendReport } = __validateArgs;
let ManufacturerSpecificCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Manufacturer Specific"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  let _instanceExtraInitializers = [];
  let _deviceSpecificGet_decorators;
  let _sendReport_decorators;
  var ManufacturerSpecificCCAPI2 = class extends _classSuper {
    static {
      __name(this, "ManufacturerSpecificCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _deviceSpecificGet_decorators = [validateArgs_ManufacturerSpecificCCAPI_deviceSpecificGet()];
      _sendReport_decorators = [validateArgs_ManufacturerSpecificCCAPI_sendReport()];
      __esDecorate(this, null, _deviceSpecificGet_decorators, { kind: "method", name: "deviceSpecificGet", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "deviceSpecificGet" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.deviceSpecificGet, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _sendReport_decorators, { kind: "method", name: "sendReport", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "sendReport" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.sendReport, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ManufacturerSpecificCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.ManufacturerSpecificCommand.Get:
        case import_Types.ManufacturerSpecificCommand.Report:
          return true;
        // This is mandatory
        case import_Types.ManufacturerSpecificCommand.DeviceSpecificGet:
        case import_Types.ManufacturerSpecificCommand.DeviceSpecificReport:
          return this.version >= 2;
      }
      return super.supportsCommand(cmd);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async get() {
      this.assertSupportsCommand(import_Types.ManufacturerSpecificCommand, import_Types.ManufacturerSpecificCommand.Get);
      const cc = new ManufacturerSpecificCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "manufacturerId",
          "productType",
          "productId"
        ]);
      }
    }
    async deviceSpecificGet(deviceIdType) {
      this.assertSupportsCommand(import_Types.ManufacturerSpecificCommand, import_Types.ManufacturerSpecificCommand.DeviceSpecificGet);
      const cc = new ManufacturerSpecificCCDeviceSpecificGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        deviceIdType
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.deviceId;
    }
    async sendReport(options) {
      this.assertSupportsCommand(import_Types.ManufacturerSpecificCommand, import_Types.ManufacturerSpecificCommand.Report);
      const cc = new ManufacturerSpecificCCReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return ManufacturerSpecificCCAPI2 = _classThis;
})();
let ManufacturerSpecificCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Manufacturer Specific"]), (0, import_CommandClassDecorators.implementedVersion)(2), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.ManufacturerSpecificCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ManufacturerSpecificCC2 = class extends _classSuper {
    static {
      __name(this, "ManufacturerSpecificCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ManufacturerSpecificCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    determineRequiredCCInterviews() {
      return [];
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Manufacturer Specific"], ctx, endpoint).withOptions({ priority: import_core.MessagePriority.NodeQuery });
      if (node.id !== ctx.ownNodeId) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `Interviewing ${this.ccName}...`,
          direction: "none"
        });
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "querying manufacturer information...",
          direction: "outbound"
        });
        const mfResp = await api.get();
        if (mfResp) {
          const logMessage = `received response for manufacturer information:
  manufacturer: ${ctx.lookupManufacturer(mfResp.manufacturerId) || "unknown"} (${(0, import_shared.num2hex)(mfResp.manufacturerId)})
  product type: ${(0, import_shared.num2hex)(mfResp.productType)}
  product id:   ${(0, import_shared.num2hex)(mfResp.productId)}`;
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        }
      }
      this.setInterviewComplete(ctx, true);
    }
  };
  return ManufacturerSpecificCC2 = _classThis;
})();
let ManufacturerSpecificCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ManufacturerSpecificCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("manufacturerId", import_CCValues_generated.ManufacturerSpecificCCValues.manufacturerId), (0, import_CommandClassDecorators.ccValueProperty)("productType", import_CCValues_generated.ManufacturerSpecificCCValues.productType), (0, import_CommandClassDecorators.ccValueProperty)("productId", import_CCValues_generated.ManufacturerSpecificCCValues.productId)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ManufacturerSpecificCC;
  var ManufacturerSpecificCCReport2 = class extends _classSuper {
    static {
      __name(this, "ManufacturerSpecificCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ManufacturerSpecificCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.manufacturerId = options.manufacturerId;
      this.productType = options.productType;
      this.productId = options.productId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 6);
      const manufacturerId = raw.payload.readUInt16BE(0);
      const productType = raw.payload.readUInt16BE(2);
      const productId = raw.payload.readUInt16BE(4);
      return new this({
        nodeId: ctx.sourceNodeId,
        manufacturerId,
        productType,
        productId
      });
    }
    manufacturerId;
    productType;
    productId;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(6);
      this.payload.writeUInt16BE(this.manufacturerId, 0);
      this.payload.writeUInt16BE(this.productType, 2);
      this.payload.writeUInt16BE(this.productId, 4);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "manufacturer id": (0, import_shared.num2hex)(this.manufacturerId),
          "product type": (0, import_shared.num2hex)(this.productType),
          "product id": (0, import_shared.num2hex)(this.productId)
        }
      };
    }
  };
  return ManufacturerSpecificCCReport2 = _classThis;
})();
let ManufacturerSpecificCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ManufacturerSpecificCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(ManufacturerSpecificCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ManufacturerSpecificCC;
  var ManufacturerSpecificCCGet2 = class extends _classSuper {
    static {
      __name(this, "ManufacturerSpecificCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ManufacturerSpecificCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ManufacturerSpecificCCGet2 = _classThis;
})();
let ManufacturerSpecificCCDeviceSpecificReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ManufacturerSpecificCommand.DeviceSpecificReport), (0, import_CommandClassDecorators.ccValueProperty)("deviceId", import_CCValues_generated.ManufacturerSpecificCCValues.deviceId, (self) => [self.type])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ManufacturerSpecificCC;
  var ManufacturerSpecificCCDeviceSpecificReport2 = class extends _classSuper {
    static {
      __name(this, "ManufacturerSpecificCCDeviceSpecificReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ManufacturerSpecificCCDeviceSpecificReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.type = options.type;
      this.deviceId = options.deviceId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const type = raw.payload[0] & 7;
      const dataFormat = raw.payload[1] >>> 5;
      const dataLength = raw.payload[1] & 31;
      (0, import_core.validatePayload)(dataLength > 0, raw.payload.length >= 2 + dataLength);
      const deviceIdData = raw.payload.subarray(2, 2 + dataLength);
      const deviceId = dataFormat === 0 ? deviceIdData.toString("utf8") : "0x" + deviceIdData.toString("hex");
      return new this({
        nodeId: ctx.sourceNodeId,
        type,
        deviceId
      });
    }
    type;
    deviceId;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "device id type": (0, import_shared.getEnumMemberName)(import_Types.DeviceIdType, this.type),
          "device id": this.deviceId
        }
      };
    }
  };
  return ManufacturerSpecificCCDeviceSpecificReport2 = _classThis;
})();
let ManufacturerSpecificCCDeviceSpecificGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ManufacturerSpecificCommand.DeviceSpecificGet), (0, import_CommandClassDecorators.expectedCCResponse)(ManufacturerSpecificCCDeviceSpecificReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ManufacturerSpecificCC;
  var ManufacturerSpecificCCDeviceSpecificGet2 = class extends _classSuper {
    static {
      __name(this, "ManufacturerSpecificCCDeviceSpecificGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ManufacturerSpecificCCDeviceSpecificGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.deviceIdType = options.deviceIdType;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    deviceIdType;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([(this.deviceIdType || 0) & 7]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "device id type": (0, import_shared.getEnumMemberName)(import_Types.DeviceIdType, this.deviceIdType)
        }
      };
    }
  };
  return ManufacturerSpecificCCDeviceSpecificGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ManufacturerSpecificCC,
  ManufacturerSpecificCCAPI,
  ManufacturerSpecificCCDeviceSpecificGet,
  ManufacturerSpecificCCDeviceSpecificReport,
  ManufacturerSpecificCCGet,
  ManufacturerSpecificCCReport,
  ManufacturerSpecificCCValues
});
//# sourceMappingURL=ManufacturerSpecificCC.js.map
