"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MultiChannelCC_exports = {};
__export(MultiChannelCC_exports, {
  MultiChannelCC: () => MultiChannelCC,
  MultiChannelCCAPI: () => MultiChannelCCAPI,
  MultiChannelCCAggregatedMembersGet: () => MultiChannelCCAggregatedMembersGet,
  MultiChannelCCAggregatedMembersReport: () => MultiChannelCCAggregatedMembersReport,
  MultiChannelCCCapabilityGet: () => MultiChannelCCCapabilityGet,
  MultiChannelCCCapabilityReport: () => MultiChannelCCCapabilityReport,
  MultiChannelCCCommandEncapsulation: () => MultiChannelCCCommandEncapsulation,
  MultiChannelCCEndPointFind: () => MultiChannelCCEndPointFind,
  MultiChannelCCEndPointFindReport: () => MultiChannelCCEndPointFindReport,
  MultiChannelCCEndPointGet: () => MultiChannelCCEndPointGet,
  MultiChannelCCEndPointReport: () => MultiChannelCCEndPointReport,
  MultiChannelCCV1CommandEncapsulation: () => MultiChannelCCV1CommandEncapsulation,
  MultiChannelCCV1Get: () => MultiChannelCCV1Get,
  MultiChannelCCV1Report: () => MultiChannelCCV1Report,
  MultiChannelCCValues: () => import_CCValues_generated.MultiChannelCCValues
});
module.exports = __toCommonJS(MultiChannelCC_exports);
var __validateArgs = __toESM(require("./MultiChannelCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_arrays = require("alcalzone-shared/arrays");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_EncapsulatingCommandClass = require("../lib/EncapsulatingCommandClass.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_MultiChannelCCAPI_getEndpointCapabilities, validateArgs_MultiChannelCCAPI_findEndpoints, validateArgs_MultiChannelCCAPI_getAggregatedMembers, validateArgs_MultiChannelCCAPI_getEndpointCountV1 } = __validateArgs;
function areEndpointsUnnecessary(ctx, nodeId, endpointIndizes) {
  const deviceClasses = /* @__PURE__ */ new Map();
  for (const endpoint of endpointIndizes) {
    const devClassValueId = import_CCValues_generated.MultiChannelCCValues.endpointDeviceClass.endpoint(endpoint);
    const deviceClass = ctx.getValueDB(nodeId).getValue(devClassValueId);
    if (deviceClass) {
      deviceClasses.set(endpoint, {
        generic: deviceClass.generic,
        specific: deviceClass.specific
      });
    }
  }
  const distinctDeviceClasses = (0, import_arrays.distinct)([...deviceClasses.values()].map(({ generic, specific }) => generic * 256 + specific));
  if (distinctDeviceClasses.length !== endpointIndizes.length) {
    return false;
  }
  const switchTypeDeviceClasses = /* @__PURE__ */ new Set([
    16,
    // Binary Switch
    17,
    // Multilevel Switch
    18,
    // Remote Switch
    19
    // Toggle Switch
  ]);
  const numSwitchEndpoints = [...deviceClasses.values()].filter(({ generic }) => switchTypeDeviceClasses.has(generic)).length;
  if (numSwitchEndpoints > 1)
    return false;
  return true;
}
__name(areEndpointsUnnecessary, "areEndpointsUnnecessary");
let MultiChannelCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Multi Channel"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _getEndpointCapabilities_decorators;
  let _findEndpoints_decorators;
  let _getAggregatedMembers_decorators;
  let _getEndpointCountV1_decorators;
  var MultiChannelCCAPI2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _getEndpointCapabilities_decorators = [validateArgs_MultiChannelCCAPI_getEndpointCapabilities()];
      _findEndpoints_decorators = [validateArgs_MultiChannelCCAPI_findEndpoints()];
      _getAggregatedMembers_decorators = [validateArgs_MultiChannelCCAPI_getAggregatedMembers()];
      _getEndpointCountV1_decorators = [validateArgs_MultiChannelCCAPI_getEndpointCountV1()];
      __esDecorate(this, null, _getEndpointCapabilities_decorators, { kind: "method", name: "getEndpointCapabilities", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getEndpointCapabilities" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getEndpointCapabilities, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _findEndpoints_decorators, { kind: "method", name: "findEndpoints", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "findEndpoints" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.findEndpoints, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getAggregatedMembers_decorators, { kind: "method", name: "getAggregatedMembers", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getAggregatedMembers" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getAggregatedMembers, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getEndpointCountV1_decorators, { kind: "method", name: "getEndpointCountV1", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getEndpointCountV1" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getEndpointCountV1, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        // Legacy commands:
        case import_Types.MultiChannelCommand.GetV1:
          return this.isSinglecast() && this.version === 1;
        case import_Types.MultiChannelCommand.CommandEncapsulationV1:
          return this.version === 1;
        // The specs start at version 3 but according to OZW,
        // these do seem to be supported in version 2
        case import_Types.MultiChannelCommand.EndPointGet:
        case import_Types.MultiChannelCommand.CapabilityGet:
          return this.version >= 2 && this.isSinglecast();
        case import_Types.MultiChannelCommand.CommandEncapsulation:
          return this.version >= 2;
        case import_Types.MultiChannelCommand.EndPointFind:
          return this.version >= 3 && this.isSinglecast();
        case import_Types.MultiChannelCommand.AggregatedMembersGet:
          return this.version >= 4 && this.isSinglecast();
      }
      return super.supportsCommand(cmd);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getEndpoints() {
      this.assertSupportsCommand(import_Types.MultiChannelCommand, import_Types.MultiChannelCommand.EndPointGet);
      const cc = new MultiChannelCCEndPointGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return {
          isDynamicEndpointCount: response.countIsDynamic,
          identicalCapabilities: response.identicalCapabilities,
          individualEndpointCount: response.individualCount,
          aggregatedEndpointCount: response.aggregatedCount
        };
      }
    }
    async getEndpointCapabilities(endpoint) {
      this.assertSupportsCommand(import_Types.MultiChannelCommand, import_Types.MultiChannelCommand.CapabilityGet);
      const cc = new MultiChannelCCCapabilityGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        requestedEndpoint: endpoint
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        const generic = (0, import_core.getGenericDeviceClass)(response.genericDeviceClass);
        const specific = (0, import_core.getSpecificDeviceClass)(response.genericDeviceClass, response.specificDeviceClass);
        return {
          isDynamic: response.isDynamic,
          wasRemoved: response.wasRemoved,
          supportedCCs: response.supportedCCs,
          generic,
          specific
        };
      }
    }
    async findEndpoints(genericClass, specificClass) {
      this.assertSupportsCommand(import_Types.MultiChannelCommand, import_Types.MultiChannelCommand.EndPointFind);
      const cc = new MultiChannelCCEndPointFind({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        genericClass,
        specificClass
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.foundEndpoints;
    }
    async getAggregatedMembers(endpoint) {
      this.assertSupportsCommand(import_Types.MultiChannelCommand, import_Types.MultiChannelCommand.AggregatedMembersGet);
      const cc = new MultiChannelCCAggregatedMembersGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        requestedEndpoint: endpoint
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.members;
    }
    // Encapsulation is used internally and too frequently that we
    // want to pay the cost of validating each call
    // eslint-disable-next-line @zwave-js/ccapi-validate-args
    async sendEncapsulated(options) {
      this.assertSupportsCommand(import_Types.MultiChannelCommand, import_Types.MultiChannelCommand.CommandEncapsulation);
      const cc = new MultiChannelCCCommandEncapsulation({
        nodeId: this.endpoint.nodeId,
        ...options
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    async getEndpointCountV1(ccId) {
      this.assertSupportsCommand(import_Types.MultiChannelCommand, import_Types.MultiChannelCommand.GetV1);
      const cc = new MultiChannelCCV1Get({
        nodeId: this.endpoint.nodeId,
        requestedCC: ccId
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.endpointCount;
    }
    // Encapsulation is used internally and too frequently that we
    // want to pay the cost of validating each call
    // eslint-disable-next-line @zwave-js/ccapi-validate-args
    async sendEncapsulatedV1(encapsulated) {
      this.assertSupportsCommand(import_Types.MultiChannelCommand, import_Types.MultiChannelCommand.CommandEncapsulationV1);
      const cc = new MultiChannelCCV1CommandEncapsulation({
        nodeId: this.endpoint.nodeId,
        encapsulated
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return MultiChannelCCAPI2 = _classThis;
})();
let MultiChannelCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Multi Channel"]), (0, import_CommandClassDecorators.implementedVersion)(4), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.MultiChannelCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var MultiChannelCC2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    /** Tests if a command targets a specific endpoint and thus requires encapsulation */
    static requiresEncapsulation(cc) {
      return cc.endpointIndex !== 0 && !(cc instanceof MultiChannelCCCommandEncapsulation) && !(cc instanceof MultiChannelCCV1CommandEncapsulation);
    }
    /** Encapsulates a command that targets a specific endpoint, with version 2+ of the Multi Channel CC */
    static encapsulate(cc) {
      const ret = new MultiChannelCCCommandEncapsulation({
        nodeId: cc.nodeId,
        encapsulated: cc,
        destination: cc.endpointIndex
      });
      ret.encapsulationFlags = cc.encapsulationFlags;
      return ret;
    }
    /** Encapsulates a command that targets a specific endpoint, with version 1 of the Multi Channel CC */
    static encapsulateV1(cc) {
      const ret = new MultiChannelCCV1CommandEncapsulation({
        nodeId: cc.nodeId,
        endpointIndex: cc.endpointIndex,
        encapsulated: cc
      });
      ret.encapsulationFlags = cc.encapsulationFlags;
      return ret;
    }
    skipEndpointInterview() {
      return true;
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const removeEndpoints = ctx.getDeviceConfig?.(node.id)?.compat?.removeEndpoints;
      if (removeEndpoints === "*") {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `Skipping ${this.ccName} interview b/c all endpoints are ignored by the device config file...`,
          direction: "none"
        });
        return;
      }
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      const ccVersion = (0, import_CommandClass.getEffectiveCCVersion)(ctx, this);
      if (ccVersion === 1)
        return this.interviewV1(ctx);
      const endpoint = node.getEndpoint(this.endpointIndex);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Multi Channel"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      const valueDB = this.getValueDB(ctx);
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying device endpoint information...",
        direction: "outbound"
      });
      const multiResponse = await api.getEndpoints();
      if (!multiResponse) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Querying device endpoint information timed out, aborting interview...",
          level: "warn"
        });
        return this.throwMissingCriticalInterviewResponse();
      }
      let logMessage = `received response for device endpoints:
endpoint count (individual): ${multiResponse.individualEndpointCount}
count is dynamic:            ${multiResponse.isDynamicEndpointCount}
identical capabilities:      ${multiResponse.identicalCapabilities}`;
      if (multiResponse.aggregatedEndpointCount != void 0) {
        logMessage += `
endpoint count (aggregated): ${multiResponse.aggregatedEndpointCount}`;
      }
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: logMessage,
        direction: "inbound"
      });
      let allEndpoints = [];
      const addSequentialEndpoints = /* @__PURE__ */ __name(() => {
        for (let i = 1; i <= multiResponse.individualEndpointCount + (multiResponse.aggregatedEndpointCount ?? 0); i++) {
          allEndpoints.push(i);
        }
      }, "addSequentialEndpoints");
      if (api.supportsCommand(import_Types.MultiChannelCommand.EndPointFind)) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "querying all endpoints...",
          direction: "outbound"
        });
        const foundEndpoints = await api.findEndpoints(255, 255);
        if (foundEndpoints)
          allEndpoints.push(...foundEndpoints);
        if (!allEndpoints.length) {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `Endpoint query returned no results, assuming that endpoints are sequential`,
            direction: "inbound"
          });
          addSequentialEndpoints();
        } else {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `received endpoints: ${allEndpoints.map(String).join(", ")}`,
            direction: "inbound"
          });
        }
      } else {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `does not support EndPointFind, assuming that endpoints are sequential`,
          direction: "none"
        });
        addSequentialEndpoints();
      }
      if (removeEndpoints?.length) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `The following endpoints are ignored through the config file: ${removeEndpoints.join(", ")}`,
          direction: "none"
        });
        allEndpoints = allEndpoints.filter((e) => !removeEndpoints.includes(e));
      }
      let hasQueriedCapabilities = false;
      for (const endpoint2 of allEndpoints) {
        if (endpoint2 > multiResponse.individualEndpointCount && ccVersion >= 4) {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `querying members of aggregated endpoint #${endpoint2}...`,
            direction: "outbound"
          });
          const members = await api.getAggregatedMembers(endpoint2);
          if (members) {
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: `aggregated endpoint #${endpoint2} has members ${members.map(String).join(", ")}`,
              direction: "inbound"
            });
          }
        }
        if (multiResponse.identicalCapabilities && hasQueriedCapabilities) {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `all endpoints identical, skipping capability query for endpoint #${endpoint2}...`,
            direction: "none"
          });
          const devClass = valueDB.getValue(import_CCValues_generated.MultiChannelCCValues.endpointDeviceClass.endpoint(allEndpoints[0]));
          valueDB.setValue(import_CCValues_generated.MultiChannelCCValues.endpointDeviceClass.endpoint(endpoint2), devClass);
          const ep1Caps = valueDB.getValue(import_CCValues_generated.MultiChannelCCValues.endpointCCs.endpoint(allEndpoints[0]));
          valueDB.setValue(import_CCValues_generated.MultiChannelCCValues.endpointCCs.endpoint(endpoint2), [...ep1Caps]);
          continue;
        }
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `querying capabilities for endpoint #${endpoint2}...`,
          direction: "outbound"
        });
        const caps = await api.getEndpointCapabilities(endpoint2);
        if (caps) {
          hasQueriedCapabilities = true;
          logMessage = `received response for endpoint capabilities (#${endpoint2}):
generic device class:  ${caps.generic.label}
specific device class: ${caps.specific.label}
is dynamic end point:  ${caps.isDynamic}
supported CCs:`;
          for (const cc of caps.supportedCCs) {
            logMessage += `
  \xB7 ${(0, import_core.getCCName)(cc)}`;
          }
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        } else {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `Querying endpoint #${endpoint2} capabilities timed out, aborting interview...`,
            level: "warn"
          });
          return this.throwMissingCriticalInterviewResponse();
        }
      }
      if (!multiResponse.identicalCapabilities && areEndpointsUnnecessary(ctx, node.id, allEndpoints)) {
        const preserve = ctx.getDeviceConfig?.(node.id)?.compat?.preserveEndpoints;
        if (!preserve) {
          allEndpoints = [];
          ctx.logNode(node.id, {
            message: `Endpoints seem unnecessary b/c they have different device classes, ignoring all...`
          });
        } else if (preserve === "*") {
          ctx.logNode(node.id, {
            message: `Endpoints seem unnecessary, but are configured to be preserved.`
          });
        } else {
          allEndpoints = allEndpoints.filter((ep) => preserve.includes(ep));
          ctx.logNode(node.id, {
            message: `Endpoints seem unnecessary, but endpoints ${allEndpoints.join(", ")} are configured to be preserved.`
          });
        }
      }
      this.setValue(ctx, import_CCValues_generated.MultiChannelCCValues.endpointIndizes, allEndpoints);
      this.setInterviewComplete(ctx, true);
    }
    async interviewV1(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const removeEndpoints = ctx.getDeviceConfig?.(node.id)?.compat?.removeEndpoints;
      if (removeEndpoints === "*") {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `Skipping ${this.ccName} interview b/c all endpoints are ignored by the device config file...`,
          direction: "none"
        });
        return;
      }
      const api = import_API.CCAPI.create(import_core.CommandClasses["Multi Channel"], ctx, endpoint);
      const valueDB = this.getValueDB(ctx);
      const supportedCCs = [...node.getCCs()].filter(([, info]) => info.isSupported).map(([cc]) => cc).filter((cc) => !import_CommandClass.CommandClass.createInstanceUnchecked(node, cc)?.skipEndpointInterview());
      const endpointCounts = /* @__PURE__ */ new Map();
      for (const ccId of supportedCCs) {
        ctx.logNode(node.id, {
          message: `Querying endpoint count for CommandClass ${(0, import_core.getCCName)(ccId)}...`,
          direction: "outbound"
        });
        const endpointCount = await api.getEndpointCountV1(ccId);
        if (endpointCount != void 0) {
          endpointCounts.set(ccId, endpointCount);
          ctx.logNode(node.id, {
            message: `CommandClass ${(0, import_core.getCCName)(ccId)} has ${endpointCount} endpoints`,
            direction: "inbound"
          });
        }
      }
      const numEndpoints = Math.max(...endpointCounts.values());
      this.setValue(ctx, import_CCValues_generated.MultiChannelCCValues.endpointCountIsDynamic, false);
      this.setValue(ctx, import_CCValues_generated.MultiChannelCCValues.aggregatedEndpointCount, 0);
      this.setValue(ctx, import_CCValues_generated.MultiChannelCCValues.individualEndpointCount, numEndpoints);
      this.setValue(ctx, import_CCValues_generated.MultiChannelCCValues.endpointsHaveIdenticalCapabilities, false);
      if (removeEndpoints?.length) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `The following endpoints are ignored through the config file: ${removeEndpoints.join(", ")}`,
          direction: "none"
        });
      }
      const allEndpoints = [];
      for (let endpoint2 = 1; endpoint2 <= numEndpoints; endpoint2++) {
        if (!removeEndpoints?.includes(endpoint2)) {
          const endpointCCs = [...endpointCounts.entries()].filter(([, ccEndpoints]) => ccEndpoints >= endpoint2).map(([ccId]) => ccId);
          valueDB.setValue(import_CCValues_generated.MultiChannelCCValues.endpointCCs.endpoint(endpoint2), endpointCCs);
          allEndpoints.push(endpoint2);
        }
      }
      this.setValue(ctx, import_CCValues_generated.MultiChannelCCValues.endpointIndizes, allEndpoints);
      this.setInterviewComplete(ctx, true);
    }
  };
  return MultiChannelCC2 = _classThis;
})();
let MultiChannelCCEndPointReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelCommand.EndPointReport), (0, import_CommandClassDecorators.ccValueProperty)("countIsDynamic", import_CCValues_generated.MultiChannelCCValues.endpointCountIsDynamic), (0, import_CommandClassDecorators.ccValueProperty)("identicalCapabilities", import_CCValues_generated.MultiChannelCCValues.endpointsHaveIdenticalCapabilities), (0, import_CommandClassDecorators.ccValueProperty)("individualCount", import_CCValues_generated.MultiChannelCCValues.individualEndpointCount), (0, import_CommandClassDecorators.ccValueProperty)("aggregatedCount", import_CCValues_generated.MultiChannelCCValues.aggregatedEndpointCount)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelCC;
  var MultiChannelCCEndPointReport2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelCCEndPointReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelCCEndPointReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.countIsDynamic = options.countIsDynamic;
      this.identicalCapabilities = options.identicalCapabilities;
      this.individualCount = options.individualCount;
      this.aggregatedCount = options.aggregatedCount;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const countIsDynamic = !!(raw.payload[0] & 128);
      const identicalCapabilities = !!(raw.payload[0] & 64);
      const individualCount = raw.payload[1] & 127;
      let aggregatedCount;
      if (raw.payload.length >= 3) {
        aggregatedCount = raw.payload[2] & 127;
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        countIsDynamic,
        identicalCapabilities,
        individualCount,
        aggregatedCount
      });
    }
    countIsDynamic;
    identicalCapabilities;
    individualCount;
    aggregatedCount;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        (this.countIsDynamic ? 128 : 0) | (this.identicalCapabilities ? 64 : 0),
        this.individualCount & 127,
        this.aggregatedCount ?? 0
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "endpoint count (individual)": this.individualCount,
        "count is dynamic": this.countIsDynamic,
        "identical capabilities": this.identicalCapabilities
      };
      if (this.aggregatedCount != void 0) {
        message["endpoint count (aggregated)"] = this.aggregatedCount;
      }
      const ret = {
        ...super.toLogEntry(ctx),
        message
      };
      return ret;
    }
  };
  return MultiChannelCCEndPointReport2 = _classThis;
})();
let MultiChannelCCEndPointGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelCommand.EndPointGet), (0, import_CommandClassDecorators.expectedCCResponse)(MultiChannelCCEndPointReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelCC;
  var MultiChannelCCEndPointGet2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelCCEndPointGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelCCEndPointGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return MultiChannelCCEndPointGet2 = _classThis;
})();
let MultiChannelCCCapabilityReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelCommand.CapabilityReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelCC;
  var MultiChannelCCCapabilityReport2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelCCCapabilityReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelCCCapabilityReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.endpointIndex = options.endpointIndex;
      this.genericDeviceClass = options.genericDeviceClass;
      this.specificDeviceClass = options.specificDeviceClass;
      this.supportedCCs = options.supportedCCs;
      this.isDynamic = options.isDynamic;
      this.wasRemoved = options.wasRemoved;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const endpointIndex = raw.payload[0] & 127;
      const isDynamic = !!(raw.payload[0] & 128);
      const NIF = (0, import_core.parseApplicationNodeInformation)(raw.payload.subarray(1));
      const genericDeviceClass = NIF.genericDeviceClass;
      const specificDeviceClass = NIF.specificDeviceClass;
      const supportedCCs = NIF.supportedCCs;
      const wasRemoved = isDynamic && genericDeviceClass === 255 && specificDeviceClass === 0;
      return new this({
        nodeId: ctx.sourceNodeId,
        endpointIndex,
        isDynamic,
        genericDeviceClass,
        specificDeviceClass,
        supportedCCs,
        wasRemoved
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const deviceClassValue = import_CCValues_generated.MultiChannelCCValues.endpointDeviceClass;
      const ccsValue = import_CCValues_generated.MultiChannelCCValues.endpointCCs;
      if (this.wasRemoved) {
        this.removeValue(ctx, deviceClassValue);
        this.removeValue(ctx, ccsValue);
      } else {
        this.setValue(ctx, deviceClassValue, {
          generic: this.genericDeviceClass,
          specific: this.specificDeviceClass
        });
        this.setValue(ctx, ccsValue, this.supportedCCs);
      }
      return true;
    }
    // The endpoint index must be overridden to be able to attribute the information to the correct endpoint
    genericDeviceClass;
    specificDeviceClass;
    supportedCCs;
    isDynamic;
    wasRemoved;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([
          this.endpointIndex & 127 | (this.isDynamic ? 128 : 0)
        ]),
        (0, import_core.encodeApplicationNodeInformation)(this)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "endpoint index": this.endpointIndex,
          "generic device class": (0, import_core.getGenericDeviceClass)(this.genericDeviceClass).label,
          "specific device class": (0, import_core.getSpecificDeviceClass)(this.genericDeviceClass, this.specificDeviceClass).label,
          "is dynamic end point": this.isDynamic,
          "supported CCs": this.supportedCCs.map((cc) => `
\xB7 ${(0, import_core.getCCName)(cc)}`).join("")
        }
      };
    }
  };
  return MultiChannelCCCapabilityReport2 = _classThis;
})();
function testResponseForMultiChannelCapabilityGet(sent, received) {
  return received.endpointIndex === sent.requestedEndpoint;
}
__name(testResponseForMultiChannelCapabilityGet, "testResponseForMultiChannelCapabilityGet");
let MultiChannelCCCapabilityGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelCommand.CapabilityGet), (0, import_CommandClassDecorators.expectedCCResponse)(MultiChannelCCCapabilityReport, testResponseForMultiChannelCapabilityGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelCC;
  var MultiChannelCCCapabilityGet2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelCCCapabilityGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelCCCapabilityGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.requestedEndpoint = options.requestedEndpoint;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const requestedEndpoint = raw.payload[0] & 127;
      return new this({
        nodeId: ctx.sourceNodeId,
        requestedEndpoint
      });
    }
    requestedEndpoint;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.requestedEndpoint & 127]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { endpoint: this.requestedEndpoint }
      };
    }
  };
  return MultiChannelCCCapabilityGet2 = _classThis;
})();
let MultiChannelCCEndPointFindReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelCommand.EndPointFindReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelCC;
  var MultiChannelCCEndPointFindReport2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelCCEndPointFindReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelCCEndPointFindReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.genericClass = options.genericClass;
      this.specificClass = options.specificClass;
      this.foundEndpoints = options.foundEndpoints;
      this.reportsToFollow = options.reportsToFollow;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const reportsToFollow = raw.payload[0];
      const genericClass = raw.payload[1];
      const specificClass = raw.payload[2];
      const foundEndpoints = [...raw.payload.subarray(3)].map((e) => e & 127).filter((e) => e !== 0);
      return new this({
        nodeId: ctx.sourceNodeId,
        reportsToFollow,
        genericClass,
        specificClass,
        foundEndpoints
      });
    }
    genericClass;
    specificClass;
    foundEndpoints;
    reportsToFollow;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([
          this.reportsToFollow,
          this.genericClass,
          this.specificClass
        ]),
        import_shared.Bytes.from(this.foundEndpoints.map((e) => e & 127))
      ]);
      return super.serialize(ctx);
    }
    getPartialCCSessionId() {
      return {
        genericClass: this.genericClass,
        specificClass: this.specificClass
      };
    }
    expectMoreMessages() {
      return this.reportsToFollow > 0;
    }
    mergePartialCCs(partials, _ctx) {
      this.foundEndpoints = [...partials, this].map((report) => report.foundEndpoints).reduce((prev, cur) => prev.concat(...cur), []);
      return Promise.resolve();
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "generic device class": (0, import_core.getGenericDeviceClass)(this.genericClass).label,
          "specific device class": (0, import_core.getSpecificDeviceClass)(this.genericClass, this.specificClass).label,
          "found endpoints": this.foundEndpoints.join(", "),
          "# of reports to follow": this.reportsToFollow
        }
      };
    }
  };
  return MultiChannelCCEndPointFindReport2 = _classThis;
})();
let MultiChannelCCEndPointFind = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelCommand.EndPointFind), (0, import_CommandClassDecorators.expectedCCResponse)(MultiChannelCCEndPointFindReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelCC;
  var MultiChannelCCEndPointFind2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelCCEndPointFind");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelCCEndPointFind2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.genericClass = options.genericClass;
      this.specificClass = options.specificClass;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const genericClass = raw.payload[0];
      const specificClass = raw.payload[1];
      return new this({
        nodeId: ctx.sourceNodeId,
        genericClass,
        specificClass
      });
    }
    genericClass;
    specificClass;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.genericClass, this.specificClass]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "generic device class": (0, import_core.getGenericDeviceClass)(this.genericClass).label,
          "specific device class": (0, import_core.getSpecificDeviceClass)(this.genericClass, this.specificClass).label
        }
      };
    }
  };
  return MultiChannelCCEndPointFind2 = _classThis;
})();
let MultiChannelCCAggregatedMembersReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelCommand.AggregatedMembersReport), (0, import_CommandClassDecorators.ccValueProperty)("members", import_CCValues_generated.MultiChannelCCValues.aggregatedEndpointMembers, (self) => [self.aggregatedEndpointIndex])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelCC;
  var MultiChannelCCAggregatedMembersReport2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelCCAggregatedMembersReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelCCAggregatedMembersReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.aggregatedEndpointIndex = options.aggregatedEndpointIndex;
      this.members = options.members;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const aggregatedEndpointIndex = raw.payload[0] & 127;
      const bitMaskLength = raw.payload[1];
      (0, import_core.validatePayload)(raw.payload.length >= 2 + bitMaskLength);
      const bitMask = raw.payload.subarray(2, 2 + bitMaskLength);
      const members = (0, import_core.parseBitMask)(bitMask);
      return new this({
        nodeId: ctx.sourceNodeId,
        aggregatedEndpointIndex,
        members
      });
    }
    aggregatedEndpointIndex;
    members;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "aggregated endpoint": this.aggregatedEndpointIndex,
          members: this.members.join(", ")
        }
      };
    }
  };
  return MultiChannelCCAggregatedMembersReport2 = _classThis;
})();
let MultiChannelCCAggregatedMembersGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelCommand.AggregatedMembersGet), (0, import_CommandClassDecorators.expectedCCResponse)(MultiChannelCCAggregatedMembersReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelCC;
  var MultiChannelCCAggregatedMembersGet2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelCCAggregatedMembersGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelCCAggregatedMembersGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.requestedEndpoint = options.requestedEndpoint;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    requestedEndpoint;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.requestedEndpoint & 127]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { endpoint: this.requestedEndpoint }
      };
    }
  };
  return MultiChannelCCAggregatedMembersGet2 = _classThis;
})();
function getCCResponseForCommandEncapsulation(ctx, sent) {
  if (typeof sent.destination === "number" && sent.encapsulated.expectsCCResponse(ctx)) {
    return [
      MultiChannelCCCommandEncapsulation,
      MultiChannelCCV1CommandEncapsulation
    ];
  }
}
__name(getCCResponseForCommandEncapsulation, "getCCResponseForCommandEncapsulation");
function testResponseForCommandEncapsulation(sent, received) {
  if (typeof sent.destination === "number" && sent.destination === received.endpointIndex) {
    return "checkEncapsulated";
  }
  return false;
}
__name(testResponseForCommandEncapsulation, "testResponseForCommandEncapsulation");
let MultiChannelCCCommandEncapsulation = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelCommand.CommandEncapsulation), (0, import_CommandClassDecorators.expectedCCResponse)(getCCResponseForCommandEncapsulation, testResponseForCommandEncapsulation)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelCC;
  var MultiChannelCCCommandEncapsulation2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelCCCommandEncapsulation");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelCCCommandEncapsulation2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.encapsulated = options.encapsulated;
      this.encapsulated.encapsulatingCC = this;
      let cur = this;
      while (cur) {
        if ((0, import_EncapsulatingCommandClass.isMultiEncapsulatingCommandClass)(cur)) {
          for (const cc of cur.encapsulated) {
            cc.endpointIndex = this.endpointIndex;
          }
          break;
        } else if ((0, import_EncapsulatingCommandClass.isEncapsulatingCommandClass)(cur)) {
          cur.encapsulated.endpointIndex = this.endpointIndex;
          cur = cur.encapsulated;
        } else {
          break;
        }
      }
      this.destination = options.destination;
    }
    static async from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      let endpointIndex;
      let destination;
      if (ctx.getDeviceConfig?.(ctx.sourceNodeId)?.compat?.treatDestinationEndpointAsSource) {
        endpointIndex = raw.payload[1] & 127;
        destination = 0;
      } else {
        endpointIndex = raw.payload[0] & 127;
        const isBitMask = !!(raw.payload[1] & 128);
        destination = raw.payload[1] & 127;
        if (isBitMask) {
          destination = (0, import_core.parseBitMask)(import_shared.Bytes.from([destination]));
        }
      }
      const encapsulated = await import_CommandClass.CommandClass.parse(raw.payload.subarray(2), ctx);
      return new this({
        nodeId: ctx.sourceNodeId,
        endpointIndex,
        destination,
        encapsulated
      });
    }
    encapsulated;
    /** The destination end point (0-127) or an array of destination end points (1-7) */
    destination;
    async serialize(ctx) {
      if (ctx.getDeviceConfig?.(this.nodeId)?.compat?.treatDestinationEndpointAsSource) {
        if (typeof this.destination === "number") {
          this.endpointIndex = this.destination;
        }
      }
      const destination = typeof this.destination === "number" ? this.destination & 127 : (0, import_core.encodeBitMask)(this.destination, 7)[0] | 128;
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.endpointIndex & 127, destination]),
        await this.encapsulated.serialize(ctx)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          source: this.endpointIndex,
          destination: typeof this.destination === "number" ? this.destination : this.destination.join(", ")
        }
      };
    }
    computeEncapsulationOverhead() {
      return super.computeEncapsulationOverhead() + 2;
    }
  };
  return MultiChannelCCCommandEncapsulation2 = _classThis;
})();
let MultiChannelCCV1Report = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelCommand.ReportV1)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelCC;
  var MultiChannelCCV1Report2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelCCV1Report");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelCCV1Report2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.requestedCC = options.requestedCC;
      this.endpointCount = options.endpointCount;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length === 2);
      const requestedCC = raw.payload[0];
      const endpointCount = raw.payload[1];
      return new this({
        nodeId: ctx.sourceNodeId,
        requestedCC,
        endpointCount
      });
    }
    requestedCC;
    endpointCount;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.requestedCC,
        this.endpointCount
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          CC: (0, import_core.getCCName)(this.requestedCC),
          "# of endpoints": this.endpointCount
        }
      };
    }
  };
  return MultiChannelCCV1Report2 = _classThis;
})();
function testResponseForMultiChannelV1Get(sent, received) {
  return sent.requestedCC === received.requestedCC;
}
__name(testResponseForMultiChannelV1Get, "testResponseForMultiChannelV1Get");
let MultiChannelCCV1Get = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelCommand.GetV1), (0, import_CommandClassDecorators.expectedCCResponse)(MultiChannelCCV1Report, testResponseForMultiChannelV1Get)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelCC;
  var MultiChannelCCV1Get2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelCCV1Get");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelCCV1Get2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.requestedCC = options.requestedCC;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length === 1);
      const requestedCC = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        requestedCC
      });
    }
    requestedCC;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.requestedCC]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { CC: (0, import_core.getCCName)(this.requestedCC) }
      };
    }
  };
  return MultiChannelCCV1Get2 = _classThis;
})();
function getResponseForV1CommandEncapsulation(ctx, sent) {
  if (sent.encapsulated.expectsCCResponse(ctx)) {
    return MultiChannelCCV1CommandEncapsulation;
  }
}
__name(getResponseForV1CommandEncapsulation, "getResponseForV1CommandEncapsulation");
function testResponseForV1CommandEncapsulation(sent, received) {
  if (sent.endpointIndex === received.endpointIndex) {
    return "checkEncapsulated";
  }
  return false;
}
__name(testResponseForV1CommandEncapsulation, "testResponseForV1CommandEncapsulation");
let MultiChannelCCV1CommandEncapsulation = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultiChannelCommand.CommandEncapsulationV1), (0, import_CommandClassDecorators.expectedCCResponse)(getResponseForV1CommandEncapsulation, testResponseForV1CommandEncapsulation)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultiChannelCC;
  var MultiChannelCCV1CommandEncapsulation2 = class extends _classSuper {
    static {
      __name(this, "MultiChannelCCV1CommandEncapsulation");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultiChannelCCV1CommandEncapsulation2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.encapsulated = options.encapsulated;
      this.encapsulated.encapsulatingCC = this;
      let cur = this;
      while (cur) {
        if ((0, import_EncapsulatingCommandClass.isMultiEncapsulatingCommandClass)(cur)) {
          for (const cc of cur.encapsulated) {
            cc.endpointIndex = this.endpointIndex;
          }
          break;
        } else if ((0, import_EncapsulatingCommandClass.isEncapsulatingCommandClass)(cur)) {
          cur.encapsulated.endpointIndex = this.endpointIndex;
          cur = cur.encapsulated;
        } else {
          break;
        }
      }
    }
    static async from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const endpointIndex = raw.payload[0];
      const isV2withV1Header = raw.payload.length >= 2 && raw.payload[1] === 0;
      const encapsulated = await import_CommandClass.CommandClass.parse(raw.payload.subarray(isV2withV1Header ? 2 : 1), ctx);
      return new this({
        nodeId: ctx.sourceNodeId,
        endpointIndex,
        encapsulated
      });
    }
    encapsulated;
    async serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.endpointIndex]),
        await this.encapsulated.serialize(ctx)
      ]);
      return super.serialize(ctx);
    }
    computeEncapsulationOverhead() {
      return super.computeEncapsulationOverhead() + 1;
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { source: this.endpointIndex }
      };
    }
  };
  return MultiChannelCCV1CommandEncapsulation2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MultiChannelCC,
  MultiChannelCCAPI,
  MultiChannelCCAggregatedMembersGet,
  MultiChannelCCAggregatedMembersReport,
  MultiChannelCCCapabilityGet,
  MultiChannelCCCapabilityReport,
  MultiChannelCCCommandEncapsulation,
  MultiChannelCCEndPointFind,
  MultiChannelCCEndPointFindReport,
  MultiChannelCCEndPointGet,
  MultiChannelCCEndPointReport,
  MultiChannelCCV1CommandEncapsulation,
  MultiChannelCCV1Get,
  MultiChannelCCV1Report,
  MultiChannelCCValues
});
//# sourceMappingURL=MultiChannelCC.js.map
