"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ScheduleEntryLockCC_exports = {};
__export(ScheduleEntryLockCC_exports, {
  ScheduleEntryLockCC: () => ScheduleEntryLockCC,
  ScheduleEntryLockCCAPI: () => ScheduleEntryLockCCAPI,
  ScheduleEntryLockCCDailyRepeatingScheduleGet: () => ScheduleEntryLockCCDailyRepeatingScheduleGet,
  ScheduleEntryLockCCDailyRepeatingScheduleReport: () => ScheduleEntryLockCCDailyRepeatingScheduleReport,
  ScheduleEntryLockCCDailyRepeatingScheduleSet: () => ScheduleEntryLockCCDailyRepeatingScheduleSet,
  ScheduleEntryLockCCEnableAllSet: () => ScheduleEntryLockCCEnableAllSet,
  ScheduleEntryLockCCEnableSet: () => ScheduleEntryLockCCEnableSet,
  ScheduleEntryLockCCSupportedGet: () => ScheduleEntryLockCCSupportedGet,
  ScheduleEntryLockCCSupportedReport: () => ScheduleEntryLockCCSupportedReport,
  ScheduleEntryLockCCTimeOffsetGet: () => ScheduleEntryLockCCTimeOffsetGet,
  ScheduleEntryLockCCTimeOffsetReport: () => ScheduleEntryLockCCTimeOffsetReport,
  ScheduleEntryLockCCTimeOffsetSet: () => ScheduleEntryLockCCTimeOffsetSet,
  ScheduleEntryLockCCValues: () => import_CCValues_generated.ScheduleEntryLockCCValues,
  ScheduleEntryLockCCWeekDayScheduleGet: () => ScheduleEntryLockCCWeekDayScheduleGet,
  ScheduleEntryLockCCWeekDayScheduleReport: () => ScheduleEntryLockCCWeekDayScheduleReport,
  ScheduleEntryLockCCWeekDayScheduleSet: () => ScheduleEntryLockCCWeekDayScheduleSet,
  ScheduleEntryLockCCYearDayScheduleGet: () => ScheduleEntryLockCCYearDayScheduleGet,
  ScheduleEntryLockCCYearDayScheduleReport: () => ScheduleEntryLockCCYearDayScheduleReport,
  ScheduleEntryLockCCYearDayScheduleSet: () => ScheduleEntryLockCCYearDayScheduleSet
});
module.exports = __toCommonJS(ScheduleEntryLockCC_exports);
var __validateArgs = __toESM(require("./ScheduleEntryLockCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_serializers = require("../lib/serializers.js");
var import_UserCodeCC = require("./UserCodeCC.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_ScheduleEntryLockCCAPI_setEnabled, validateArgs_ScheduleEntryLockCCAPI_setWeekDaySchedule, validateArgs_ScheduleEntryLockCCAPI_getWeekDaySchedule, validateArgs_ScheduleEntryLockCCAPI_setYearDaySchedule, validateArgs_ScheduleEntryLockCCAPI_getYearDaySchedule, validateArgs_ScheduleEntryLockCCAPI_setDailyRepeatingSchedule, validateArgs_ScheduleEntryLockCCAPI_getDailyRepeatingSchedule, validateArgs_ScheduleEntryLockCCAPI_setTimezone } = __validateArgs;
function persistSchedule(ctx, scheduleKind, userId, slotId, schedule) {
  const scheduleValue = import_CCValues_generated.ScheduleEntryLockCCValues.schedule(scheduleKind, userId, slotId);
  if (schedule != void 0) {
    this.setValue(ctx, scheduleValue, schedule);
  } else {
    this.removeValue(ctx, scheduleValue);
  }
}
__name(persistSchedule, "persistSchedule");
function setUserCodeScheduleKindCached(ctx, endpoint, userId, scheduleKind) {
  ctx.getValueDB(endpoint.nodeId).setValue(import_CCValues_generated.ScheduleEntryLockCCValues.scheduleKind(userId).endpoint(endpoint.index), scheduleKind);
}
__name(setUserCodeScheduleKindCached, "setUserCodeScheduleKindCached");
function setUserCodeScheduleEnabledCached(ctx, endpoint, userId, enabled) {
  const setEnabled = /* @__PURE__ */ __name((userId2) => {
    ctx.getValueDB(endpoint.nodeId).setValue(import_CCValues_generated.ScheduleEntryLockCCValues.userEnabled(userId2).endpoint(endpoint.index), enabled);
  }, "setEnabled");
  if (userId == void 0) {
    const numUsers = import_UserCodeCC.UserCodeCC.getSupportedUsersCached(ctx, endpoint) ?? 0;
    for (let userId2 = 1; userId2 <= numUsers; userId2++) {
      setEnabled(userId2);
    }
  } else {
    setEnabled(userId);
  }
}
__name(setUserCodeScheduleEnabledCached, "setUserCodeScheduleEnabledCached");
let ScheduleEntryLockCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Schedule Entry Lock"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _setEnabled_decorators;
  let _setWeekDaySchedule_decorators;
  let _getWeekDaySchedule_decorators;
  let _setYearDaySchedule_decorators;
  let _getYearDaySchedule_decorators;
  let _setDailyRepeatingSchedule_decorators;
  let _getDailyRepeatingSchedule_decorators;
  let _setTimezone_decorators;
  var ScheduleEntryLockCCAPI2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _setEnabled_decorators = [validateArgs_ScheduleEntryLockCCAPI_setEnabled()];
      _setWeekDaySchedule_decorators = [validateArgs_ScheduleEntryLockCCAPI_setWeekDaySchedule()];
      _getWeekDaySchedule_decorators = [validateArgs_ScheduleEntryLockCCAPI_getWeekDaySchedule()];
      _setYearDaySchedule_decorators = [validateArgs_ScheduleEntryLockCCAPI_setYearDaySchedule()];
      _getYearDaySchedule_decorators = [validateArgs_ScheduleEntryLockCCAPI_getYearDaySchedule()];
      _setDailyRepeatingSchedule_decorators = [validateArgs_ScheduleEntryLockCCAPI_setDailyRepeatingSchedule()];
      _getDailyRepeatingSchedule_decorators = [validateArgs_ScheduleEntryLockCCAPI_getDailyRepeatingSchedule()];
      _setTimezone_decorators = [validateArgs_ScheduleEntryLockCCAPI_setTimezone()];
      __esDecorate(this, null, _setEnabled_decorators, { kind: "method", name: "setEnabled", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setEnabled" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setEnabled, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setWeekDaySchedule_decorators, { kind: "method", name: "setWeekDaySchedule", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setWeekDaySchedule" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setWeekDaySchedule, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getWeekDaySchedule_decorators, { kind: "method", name: "getWeekDaySchedule", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getWeekDaySchedule" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getWeekDaySchedule, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setYearDaySchedule_decorators, { kind: "method", name: "setYearDaySchedule", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setYearDaySchedule" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setYearDaySchedule, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getYearDaySchedule_decorators, { kind: "method", name: "getYearDaySchedule", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getYearDaySchedule" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getYearDaySchedule, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setDailyRepeatingSchedule_decorators, { kind: "method", name: "setDailyRepeatingSchedule", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setDailyRepeatingSchedule" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setDailyRepeatingSchedule, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getDailyRepeatingSchedule_decorators, { kind: "method", name: "getDailyRepeatingSchedule", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getDailyRepeatingSchedule" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getDailyRepeatingSchedule, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setTimezone_decorators, { kind: "method", name: "setTimezone", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setTimezone" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setTimezone, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.ScheduleEntryLockCommand.EnableSet:
        case import_Types.ScheduleEntryLockCommand.EnableAllSet:
        case import_Types.ScheduleEntryLockCommand.WeekDayScheduleSet:
        case import_Types.ScheduleEntryLockCommand.WeekDayScheduleGet:
        case import_Types.ScheduleEntryLockCommand.YearDayScheduleSet:
        case import_Types.ScheduleEntryLockCommand.YearDayScheduleGet:
        case import_Types.ScheduleEntryLockCommand.SupportedGet:
          return true;
        // V1
        case import_Types.ScheduleEntryLockCommand.TimeOffsetSet:
        case import_Types.ScheduleEntryLockCommand.TimeOffsetGet:
          return this.version >= 2;
        case import_Types.ScheduleEntryLockCommand.DailyRepeatingScheduleSet:
        case import_Types.ScheduleEntryLockCommand.DailyRepeatingScheduleGet:
          return this.version >= 3;
      }
      return super.supportsCommand(cmd);
    }
    /**
     * Enables or disables schedules. If a user ID is given, that user's
     * schedules will be enabled or disabled. If no user ID is given, all schedules
     * will be affected.
     */
    async setEnabled(enabled, userId) {
      let result;
      if (userId != void 0) {
        this.assertSupportsCommand(import_Types.ScheduleEntryLockCommand, import_Types.ScheduleEntryLockCommand.EnableSet);
        const cc = new ScheduleEntryLockCCEnableSet({
          nodeId: this.endpoint.nodeId,
          endpointIndex: this.endpoint.index,
          userId,
          enabled
        });
        result = await this.host.sendCommand(cc, this.commandOptions);
      } else {
        this.assertSupportsCommand(import_Types.ScheduleEntryLockCommand, import_Types.ScheduleEntryLockCommand.EnableAllSet);
        const cc = new ScheduleEntryLockCCEnableAllSet({
          nodeId: this.endpoint.nodeId,
          endpointIndex: this.endpoint.index,
          enabled
        });
        result = await this.host.sendCommand(cc, this.commandOptions);
      }
      if (this.isSinglecast() && (0, import_core.isUnsupervisedOrSucceeded)(result)) {
        setUserCodeScheduleEnabledCached(this.host, this.endpoint, userId, enabled);
      }
      return result;
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getNumSlots() {
      this.assertSupportsCommand(import_Types.ScheduleEntryLockCommand, import_Types.ScheduleEntryLockCommand.SupportedGet);
      const cc = new ScheduleEntryLockCCSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const result = await this.host.sendCommand(cc, this.commandOptions);
      if (result) {
        return (0, import_shared.pick)(result, [
          "numWeekDaySlots",
          "numYearDaySlots",
          "numDailyRepeatingSlots"
        ]);
      }
    }
    async setWeekDaySchedule(slot, schedule) {
      this.assertSupportsCommand(import_Types.ScheduleEntryLockCommand, import_Types.ScheduleEntryLockCommand.WeekDayScheduleSet);
      if (this.isSinglecast()) {
        const numSlots = ScheduleEntryLockCC.getNumWeekDaySlotsCached(this.host, this.endpoint);
        if (slot.slotId < 1 || slot.slotId > numSlots) {
          throw new import_core.ZWaveError(`The schedule slot # must be between 1 and the number of supported day-of-week slots ${numSlots}.`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
      }
      if (schedule) {
        if (schedule.stopHour < schedule.startHour || schedule.stopHour === schedule.startHour && schedule.stopMinute <= schedule.startMinute) {
          throw new import_core.ZWaveError(`The stop time must be after the start time.`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
      }
      const cc = new ScheduleEntryLockCCWeekDayScheduleSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...slot,
        ...schedule ? {
          action: import_Types.ScheduleEntryLockSetAction.Set,
          ...schedule
        } : {
          action: import_Types.ScheduleEntryLockSetAction.Erase
        }
      });
      const result = await this.host.sendCommand(cc, this.commandOptions);
      if (this.isSinglecast() && (0, import_core.isUnsupervisedOrSucceeded)(result)) {
        if (!!schedule) {
          setUserCodeScheduleEnabledCached(this.host, this.endpoint, slot.userId, true);
          setUserCodeScheduleKindCached(this.host, this.endpoint, slot.userId, import_Types.ScheduleEntryLockScheduleKind.WeekDay);
        }
        persistSchedule.call(cc, this.host, import_Types.ScheduleEntryLockScheduleKind.WeekDay, slot.userId, slot.slotId, schedule ?? false);
      }
      return result;
    }
    async getWeekDaySchedule(slot) {
      this.assertSupportsCommand(import_Types.ScheduleEntryLockCommand, import_Types.ScheduleEntryLockCommand.WeekDayScheduleSet);
      const cc = new ScheduleEntryLockCCWeekDayScheduleGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...slot
      });
      const result = await this.host.sendCommand(cc, this.commandOptions);
      if (result?.weekday != void 0) {
        return {
          weekday: result.weekday,
          startHour: result.startHour,
          startMinute: result.startMinute,
          stopHour: result.stopHour,
          stopMinute: result.stopMinute
        };
      }
    }
    async setYearDaySchedule(slot, schedule) {
      this.assertSupportsCommand(import_Types.ScheduleEntryLockCommand, import_Types.ScheduleEntryLockCommand.YearDayScheduleSet);
      if (this.isSinglecast()) {
        const numSlots = ScheduleEntryLockCC.getNumYearDaySlotsCached(this.host, this.endpoint);
        if (slot.slotId < 1 || slot.slotId > numSlots) {
          throw new import_core.ZWaveError(`The schedule slot # must be between 1 and the number of supported day-of-year slots ${numSlots}.`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
      }
      if (schedule) {
        const startDate = new Date(schedule.startYear, schedule.startMonth - 1, schedule.startDay, schedule.startHour, schedule.startMinute);
        const stopDate = new Date(schedule.stopYear, schedule.stopMonth - 1, schedule.stopDay, schedule.stopHour, schedule.stopMinute);
        if (stopDate <= startDate) {
          throw new import_core.ZWaveError(`The stop date must be after the start date.`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
      }
      const cc = new ScheduleEntryLockCCYearDayScheduleSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...slot,
        ...schedule ? {
          action: import_Types.ScheduleEntryLockSetAction.Set,
          ...schedule
        } : {
          action: import_Types.ScheduleEntryLockSetAction.Erase
        }
      });
      const result = await this.host.sendCommand(cc, this.commandOptions);
      if (this.isSinglecast() && (0, import_core.isUnsupervisedOrSucceeded)(result)) {
        if (!!schedule) {
          setUserCodeScheduleEnabledCached(this.host, this.endpoint, slot.userId, true);
          setUserCodeScheduleKindCached(this.host, this.endpoint, slot.userId, import_Types.ScheduleEntryLockScheduleKind.YearDay);
        }
        persistSchedule.call(cc, this.host, import_Types.ScheduleEntryLockScheduleKind.YearDay, slot.userId, slot.slotId, schedule ?? false);
      }
      return result;
    }
    async getYearDaySchedule(slot) {
      this.assertSupportsCommand(import_Types.ScheduleEntryLockCommand, import_Types.ScheduleEntryLockCommand.YearDayScheduleSet);
      const cc = new ScheduleEntryLockCCYearDayScheduleGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...slot
      });
      const result = await this.host.sendCommand(cc, this.commandOptions);
      if (result?.startYear != void 0) {
        return {
          startYear: result.startYear,
          startMonth: result.startMonth,
          startDay: result.startDay,
          startHour: result.startHour,
          startMinute: result.startMinute,
          stopYear: result.stopYear,
          stopMonth: result.stopMonth,
          stopDay: result.stopDay,
          stopHour: result.stopHour,
          stopMinute: result.stopMinute
        };
      }
    }
    async setDailyRepeatingSchedule(slot, schedule) {
      this.assertSupportsCommand(import_Types.ScheduleEntryLockCommand, import_Types.ScheduleEntryLockCommand.DailyRepeatingScheduleSet);
      if (this.isSinglecast()) {
        const numSlots = ScheduleEntryLockCC.getNumDailyRepeatingSlotsCached(this.host, this.endpoint);
        if (slot.slotId < 1 || slot.slotId > numSlots) {
          throw new import_core.ZWaveError(`The schedule slot # must be between 1 and the number of supported daily repeating slots ${numSlots}.`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
      }
      const cc = new ScheduleEntryLockCCDailyRepeatingScheduleSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...slot,
        ...schedule ? {
          action: import_Types.ScheduleEntryLockSetAction.Set,
          ...schedule
        } : {
          action: import_Types.ScheduleEntryLockSetAction.Erase
        }
      });
      const result = await this.host.sendCommand(cc, this.commandOptions);
      if (this.isSinglecast() && (0, import_core.isUnsupervisedOrSucceeded)(result)) {
        if (!!schedule) {
          setUserCodeScheduleEnabledCached(this.host, this.endpoint, slot.userId, true);
          setUserCodeScheduleKindCached(this.host, this.endpoint, slot.userId, import_Types.ScheduleEntryLockScheduleKind.DailyRepeating);
        }
        persistSchedule.call(cc, this.host, import_Types.ScheduleEntryLockScheduleKind.DailyRepeating, slot.userId, slot.slotId, schedule ?? false);
      }
      return result;
    }
    async getDailyRepeatingSchedule(slot) {
      this.assertSupportsCommand(import_Types.ScheduleEntryLockCommand, import_Types.ScheduleEntryLockCommand.DailyRepeatingScheduleSet);
      const cc = new ScheduleEntryLockCCDailyRepeatingScheduleGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...slot
      });
      const result = await this.host.sendCommand(cc, this.commandOptions);
      if (result?.weekdays != void 0) {
        return {
          weekdays: result.weekdays,
          startHour: result.startHour,
          startMinute: result.startMinute,
          durationHour: result.durationHour,
          durationMinute: result.durationMinute
        };
      }
    }
    async getTimezone() {
      this.assertSupportsCommand(import_Types.ScheduleEntryLockCommand, import_Types.ScheduleEntryLockCommand.TimeOffsetGet);
      const cc = new ScheduleEntryLockCCTimeOffsetGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const result = await this.host.sendCommand(cc, this.commandOptions);
      if (result) {
        return (0, import_shared.pick)(result, ["standardOffset", "dstOffset"]);
      }
    }
    async setTimezone(timezone) {
      this.assertSupportsCommand(import_Types.ScheduleEntryLockCommand, import_Types.ScheduleEntryLockCommand.TimeOffsetSet);
      const cc = new ScheduleEntryLockCCTimeOffsetSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...timezone
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return ScheduleEntryLockCCAPI2 = _classThis;
})();
let ScheduleEntryLockCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Schedule Entry Lock"]), (0, import_CommandClassDecorators.implementedVersion)(3), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.ScheduleEntryLockCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ScheduleEntryLockCC2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Schedule Entry Lock"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "Querying supported number of schedule slots...",
        direction: "outbound"
      });
      const slotsResp = await api.getNumSlots();
      if (slotsResp) {
        let logMessage = `received supported number of schedule slots:
day of week:     ${slotsResp.numWeekDaySlots}
day of year:     ${slotsResp.numYearDaySlots}`;
        if (slotsResp.numDailyRepeatingSlots != void 0) {
          logMessage += `
daily repeating: ${slotsResp.numDailyRepeatingSlots}`;
        }
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      }
      if (api.supportsCommand(import_Types.ScheduleEntryLockCommand.TimeOffsetSet) && (!endpoint.supportsCC(import_core.CommandClasses.Time) || endpoint.getCCVersion(import_core.CommandClasses.Time) < 2)) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "setting timezone information...",
          direction: "outbound"
        });
        const timezone = (0, import_core.getDSTInfo)();
        await api.setTimezone(timezone);
      }
      this.setInterviewComplete(ctx, true);
    }
    /**
     * Returns the number of supported day-of-week slots.
     * This only works AFTER the interview process
     */
    static getNumWeekDaySlotsCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.ScheduleEntryLockCCValues.numWeekDaySlots.endpoint(endpoint.index)) || 0;
    }
    /**
     * Returns the number of supported day-of-year slots.
     * This only works AFTER the interview process
     */
    static getNumYearDaySlotsCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.ScheduleEntryLockCCValues.numYearDaySlots.endpoint(endpoint.index)) || 0;
    }
    /**
     * Returns the number of supported daily-repeating slots.
     * This only works AFTER the interview process
     */
    static getNumDailyRepeatingSlotsCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.ScheduleEntryLockCCValues.numDailyRepeatingSlots.endpoint(endpoint.index)) || 0;
    }
    /**
     * Returns whether scheduling for a given user ID (most likely) enabled. Since the Schedule Entry Lock CC
     * provides no way to query the enabled state, Z-Wave JS tracks this in its own cache.
     *
     * This only works AFTER the interview process and is likely to be wrong if a device
     * with existing schedules is queried. To be sure, disable scheduling for all users and enable
     * only the desired ones.
     */
    static getUserCodeScheduleEnabledCached(ctx, endpoint, userId) {
      return !!ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.ScheduleEntryLockCCValues.userEnabled(userId).endpoint(endpoint.index));
    }
    /**
     * Returns which scheduling kind is (most likely) enabled for a given user ID . Since the Schedule Entry Lock CC
     * provides no way to query the current state, Z-Wave JS tracks this in its own cache.
     *
     * This only works AFTER the interview process and is likely to be wrong if a device
     * with existing schedules is queried. To be sure, edit a schedule of the desired kind
     * which will automatically switch the user to that scheduling kind.
     */
    static getUserCodeScheduleKindCached(ctx, endpoint, userId) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.ScheduleEntryLockCCValues.scheduleKind(userId).endpoint(endpoint.index));
    }
    /**
     * Returns the assumed state of a schedule. Since the Schedule Entry Lock CC
     * provides no way to query the current state, Z-Wave JS tracks this in its own cache.
     *
     * A return value of `false` means the slot is empty, a return value of `undefined` means the information is not cached yet.
     *
     * This only works AFTER the interview process.
     */
    static getScheduleCached(ctx, endpoint, scheduleKind, userId, slotId) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.ScheduleEntryLockCCValues.schedule(scheduleKind, userId, slotId).endpoint(endpoint.index));
    }
  };
  return ScheduleEntryLockCC2 = _classThis;
})();
let ScheduleEntryLockCCEnableSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.EnableSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCEnableSet2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCEnableSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCEnableSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userId = options.userId;
      this.enabled = options.enabled;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const userId = raw.payload[0];
      const enabled = raw.payload[1] === 1;
      return new this({
        nodeId: ctx.sourceNodeId,
        userId,
        enabled
      });
    }
    userId;
    enabled;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.userId, this.enabled ? 1 : 0]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "user ID": this.userId,
          action: this.enabled ? "enable" : "disable"
        }
      };
    }
  };
  return ScheduleEntryLockCCEnableSet2 = _classThis;
})();
let ScheduleEntryLockCCEnableAllSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.EnableAllSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCEnableAllSet2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCEnableAllSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCEnableAllSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.enabled = options.enabled;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const enabled = raw.payload[0] === 1;
      return new this({
        nodeId: ctx.sourceNodeId,
        enabled
      });
    }
    enabled;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.enabled ? 1 : 0]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          action: this.enabled ? "enable all" : "disable all"
        }
      };
    }
  };
  return ScheduleEntryLockCCEnableAllSet2 = _classThis;
})();
let ScheduleEntryLockCCSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.SupportedReport), (0, import_CommandClassDecorators.ccValueProperty)("numWeekDaySlots", import_CCValues_generated.ScheduleEntryLockCCValues.numWeekDaySlots), (0, import_CommandClassDecorators.ccValueProperty)("numYearDaySlots", import_CCValues_generated.ScheduleEntryLockCCValues.numYearDaySlots), (0, import_CommandClassDecorators.ccValueProperty)("numDailyRepeatingSlots", import_CCValues_generated.ScheduleEntryLockCCValues.numDailyRepeatingSlots)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.numWeekDaySlots = options.numWeekDaySlots;
      this.numYearDaySlots = options.numYearDaySlots;
      this.numDailyRepeatingSlots = options.numDailyRepeatingSlots;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const numWeekDaySlots = raw.payload[0];
      const numYearDaySlots = raw.payload[1];
      let numDailyRepeatingSlots;
      if (raw.payload.length >= 3) {
        numDailyRepeatingSlots = raw.payload[2];
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        numWeekDaySlots,
        numYearDaySlots,
        numDailyRepeatingSlots
      });
    }
    numWeekDaySlots;
    numYearDaySlots;
    numDailyRepeatingSlots;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.numWeekDaySlots,
        this.numYearDaySlots,
        this.numDailyRepeatingSlots ?? 0
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "no. of weekday schedule slots": this.numWeekDaySlots,
        "no. of day-of-year schedule slots": this.numYearDaySlots
      };
      if (this.numDailyRepeatingSlots != void 0) {
        message["no. of daily repeating schedule slots"] = this.numDailyRepeatingSlots;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ScheduleEntryLockCCSupportedReport2 = _classThis;
})();
let ScheduleEntryLockCCSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.SupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(ScheduleEntryLockCCSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ScheduleEntryLockCCSupportedGet2 = _classThis;
})();
let ScheduleEntryLockCCWeekDayScheduleSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.WeekDayScheduleSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCWeekDayScheduleSet2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCWeekDayScheduleSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCWeekDayScheduleSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userId = options.userId;
      this.slotId = options.slotId;
      this.action = options.action;
      if (options.action === import_Types.ScheduleEntryLockSetAction.Set) {
        this.weekday = options.weekday;
        this.startHour = options.startHour;
        this.startMinute = options.startMinute;
        this.stopHour = options.stopHour;
        this.stopMinute = options.stopMinute;
      }
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const action = raw.payload[0];
      (0, import_core.validatePayload)(action === import_Types.ScheduleEntryLockSetAction.Set || action === import_Types.ScheduleEntryLockSetAction.Erase);
      const userId = raw.payload[1];
      const slotId = raw.payload[2];
      if (action !== import_Types.ScheduleEntryLockSetAction.Set) {
        return new this({
          nodeId: ctx.sourceNodeId,
          action,
          userId,
          slotId
        });
      }
      (0, import_core.validatePayload)(raw.payload.length >= 8);
      const weekday = raw.payload[3];
      const startHour = raw.payload[4];
      const startMinute = raw.payload[5];
      const stopHour = raw.payload[6];
      const stopMinute = raw.payload[7];
      return new this({
        nodeId: ctx.sourceNodeId,
        action,
        userId,
        slotId,
        weekday,
        startHour,
        startMinute,
        stopHour,
        stopMinute
      });
    }
    userId;
    slotId;
    action;
    weekday;
    startHour;
    startMinute;
    stopHour;
    stopMinute;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.action,
        this.userId,
        this.slotId,
        // The report should have these fields set to 0xff
        // if the slot is erased. The specs don't mention anything
        // for the Set command, so we just assume the same is okay
        this.weekday ?? 255,
        this.startHour ?? 255,
        this.startMinute ?? 255,
        this.stopHour ?? 255,
        this.stopMinute ?? 255
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      let message;
      if (this.action === import_Types.ScheduleEntryLockSetAction.Erase) {
        message = {
          "user ID": this.userId,
          "slot #": this.slotId,
          action: "erase"
        };
      } else {
        message = {
          "user ID": this.userId,
          "slot #": this.slotId,
          action: "set",
          weekday: (0, import_shared.getEnumMemberName)(import_Types.ScheduleEntryLockWeekday, this.weekday),
          "start time": (0, import_shared.formatTime)(this.startHour ?? 0, this.startMinute ?? 0),
          "end time": (0, import_shared.formatTime)(this.stopHour ?? 0, this.stopMinute ?? 0)
        };
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ScheduleEntryLockCCWeekDayScheduleSet2 = _classThis;
})();
let ScheduleEntryLockCCWeekDayScheduleReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.WeekDayScheduleReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCWeekDayScheduleReport2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCWeekDayScheduleReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCWeekDayScheduleReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userId = options.userId;
      this.slotId = options.slotId;
      this.weekday = options.weekday;
      this.startHour = options.startHour;
      this.startMinute = options.startMinute;
      this.stopHour = options.stopHour;
      this.stopMinute = options.stopMinute;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const userId = raw.payload[0];
      const slotId = raw.payload[1];
      let ccOptions = {
        userId,
        slotId
      };
      let weekday;
      let startHour;
      let startMinute;
      let stopHour;
      let stopMinute;
      if (raw.payload.length >= 7) {
        if (raw.payload[2] !== 255) {
          weekday = raw.payload[2];
        }
        if (raw.payload[3] !== 255) {
          startHour = raw.payload[3];
        }
        if (raw.payload[4] !== 255) {
          startMinute = raw.payload[4];
        }
        if (raw.payload[5] !== 255) {
          stopHour = raw.payload[5];
        }
        if (raw.payload[6] !== 255) {
          stopMinute = raw.payload[6];
        }
      }
      if (weekday != void 0 && startHour != void 0 && startMinute != void 0 && stopHour != void 0 && stopMinute != void 0) {
        ccOptions = {
          ...ccOptions,
          weekday,
          startHour,
          startMinute,
          stopHour,
          stopMinute
        };
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        ...ccOptions
      });
    }
    userId;
    slotId;
    weekday;
    startHour;
    startMinute;
    stopHour;
    stopMinute;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      persistSchedule.call(this, ctx, import_Types.ScheduleEntryLockScheduleKind.WeekDay, this.userId, this.slotId, this.weekday != void 0 ? {
        weekday: this.weekday,
        startHour: this.startHour,
        startMinute: this.startMinute,
        stopHour: this.stopHour,
        stopMinute: this.stopMinute
      } : false);
      return true;
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.userId,
        this.slotId,
        this.weekday ?? 255,
        this.startHour ?? 255,
        this.startMinute ?? 255,
        this.stopHour ?? 255,
        this.stopMinute ?? 255
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      let message;
      if (this.weekday == void 0) {
        message = {
          "user ID": this.userId,
          "slot #": this.slotId,
          schedule: "(empty)"
        };
      } else {
        message = {
          "user ID": this.userId,
          "slot #": this.slotId,
          weekday: (0, import_shared.getEnumMemberName)(import_Types.ScheduleEntryLockWeekday, this.weekday),
          "start time": (0, import_shared.formatTime)(this.startHour ?? 0, this.startMinute ?? 0),
          "end time": (0, import_shared.formatTime)(this.stopHour ?? 0, this.stopMinute ?? 0)
        };
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ScheduleEntryLockCCWeekDayScheduleReport2 = _classThis;
})();
let ScheduleEntryLockCCWeekDayScheduleGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.WeekDayScheduleGet), (0, import_CommandClassDecorators.expectedCCResponse)(ScheduleEntryLockCCWeekDayScheduleReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCWeekDayScheduleGet2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCWeekDayScheduleGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCWeekDayScheduleGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userId = options.userId;
      this.slotId = options.slotId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const userId = raw.payload[0];
      const slotId = raw.payload[1];
      return new this({
        nodeId: ctx.sourceNodeId,
        userId,
        slotId
      });
    }
    userId;
    slotId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.userId, this.slotId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "user ID": this.userId,
          "slot #": this.slotId
        }
      };
    }
  };
  return ScheduleEntryLockCCWeekDayScheduleGet2 = _classThis;
})();
let ScheduleEntryLockCCYearDayScheduleSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.YearDayScheduleSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCYearDayScheduleSet2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCYearDayScheduleSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCYearDayScheduleSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userId = options.userId;
      this.slotId = options.slotId;
      this.action = options.action;
      if (options.action === import_Types.ScheduleEntryLockSetAction.Set) {
        this.startYear = options.startYear;
        this.startMonth = options.startMonth;
        this.startDay = options.startDay;
        this.startHour = options.startHour;
        this.startMinute = options.startMinute;
        this.stopYear = options.stopYear;
        this.stopMonth = options.stopMonth;
        this.stopDay = options.stopDay;
        this.stopHour = options.stopHour;
        this.stopMinute = options.stopMinute;
      }
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const action = raw.payload[0];
      (0, import_core.validatePayload)(action === import_Types.ScheduleEntryLockSetAction.Set || action === import_Types.ScheduleEntryLockSetAction.Erase);
      const userId = raw.payload[1];
      const slotId = raw.payload[2];
      if (action !== import_Types.ScheduleEntryLockSetAction.Set) {
        return new this({
          nodeId: ctx.sourceNodeId,
          action,
          userId,
          slotId
        });
      }
      (0, import_core.validatePayload)(raw.payload.length >= 13);
      const startYear = raw.payload[3];
      const startMonth = raw.payload[4];
      const startDay = raw.payload[5];
      const startHour = raw.payload[6];
      const startMinute = raw.payload[7];
      const stopYear = raw.payload[8];
      const stopMonth = raw.payload[9];
      const stopDay = raw.payload[10];
      const stopHour = raw.payload[11];
      const stopMinute = raw.payload[12];
      return new this({
        nodeId: ctx.sourceNodeId,
        action,
        userId,
        slotId,
        startYear,
        startMonth,
        startDay,
        startHour,
        startMinute,
        stopYear,
        stopMonth,
        stopDay,
        stopHour,
        stopMinute
      });
    }
    userId;
    slotId;
    action;
    startYear;
    startMonth;
    startDay;
    startHour;
    startMinute;
    stopYear;
    stopMonth;
    stopDay;
    stopHour;
    stopMinute;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.action,
        this.userId,
        this.slotId,
        // The report should have these fields set to 0xff
        // if the slot is erased. The specs don't mention anything
        // for the Set command, so we just assume the same is okay
        this.startYear ?? 255,
        this.startMonth ?? 255,
        this.startDay ?? 255,
        this.startHour ?? 255,
        this.startMinute ?? 255,
        this.stopYear ?? 255,
        this.stopMonth ?? 255,
        this.stopDay ?? 255,
        this.stopHour ?? 255,
        this.stopMinute ?? 255
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      let message;
      if (this.action === import_Types.ScheduleEntryLockSetAction.Erase) {
        message = {
          "user ID": this.userId,
          "slot #": this.slotId,
          action: "erase"
        };
      } else {
        message = {
          "user ID": this.userId,
          "slot #": this.slotId,
          action: "set",
          "start date": `${(0, import_shared.formatDate)(this.startYear ?? 0, this.startMonth ?? 0, this.startDay ?? 0)} ${(0, import_shared.formatTime)(this.startHour ?? 0, this.startMinute ?? 0)}`,
          "end date": `${(0, import_shared.formatDate)(this.stopYear ?? 0, this.stopMonth ?? 0, this.stopDay ?? 0)} ${(0, import_shared.formatTime)(this.stopHour ?? 0, this.stopMinute ?? 0)}`
        };
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ScheduleEntryLockCCYearDayScheduleSet2 = _classThis;
})();
let ScheduleEntryLockCCYearDayScheduleReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.YearDayScheduleReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCYearDayScheduleReport2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCYearDayScheduleReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCYearDayScheduleReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userId = options.userId;
      this.slotId = options.slotId;
      this.startYear = options.startYear;
      this.startMonth = options.startMonth;
      this.startDay = options.startDay;
      this.startHour = options.startHour;
      this.startMinute = options.startMinute;
      this.stopYear = options.stopYear;
      this.stopMonth = options.stopMonth;
      this.stopDay = options.stopDay;
      this.stopHour = options.stopHour;
      this.stopMinute = options.stopMinute;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const userId = raw.payload[0];
      const slotId = raw.payload[1];
      let ccOptions = {
        userId,
        slotId
      };
      let startYear;
      let startMonth;
      let startDay;
      let startHour;
      let startMinute;
      let stopYear;
      let stopMonth;
      let stopDay;
      let stopHour;
      let stopMinute;
      if (raw.payload.length >= 12) {
        if (raw.payload[2] !== 255) {
          startYear = raw.payload[2];
        }
        if (raw.payload[3] !== 255) {
          startMonth = raw.payload[3];
        }
        if (raw.payload[4] !== 255) {
          startDay = raw.payload[4];
        }
        if (raw.payload[5] !== 255) {
          startHour = raw.payload[5];
        }
        if (raw.payload[6] !== 255) {
          startMinute = raw.payload[6];
        }
        if (raw.payload[7] !== 255) {
          stopYear = raw.payload[7];
        }
        if (raw.payload[8] !== 255) {
          stopMonth = raw.payload[8];
        }
        if (raw.payload[9] !== 255) {
          stopDay = raw.payload[9];
        }
        if (raw.payload[10] !== 255) {
          stopHour = raw.payload[10];
        }
        if (raw.payload[11] !== 255) {
          stopMinute = raw.payload[11];
        }
      }
      if (startYear != void 0 && startMonth != void 0 && startDay != void 0 && startHour != void 0 && startMinute != void 0 && stopYear != void 0 && stopMonth != void 0 && stopDay != void 0 && stopHour != void 0 && stopMinute != void 0) {
        ccOptions = {
          ...ccOptions,
          startYear,
          startMonth,
          startDay,
          startHour,
          startMinute,
          stopYear,
          stopMonth,
          stopDay,
          stopHour,
          stopMinute
        };
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        ...ccOptions
      });
    }
    userId;
    slotId;
    startYear;
    startMonth;
    startDay;
    startHour;
    startMinute;
    stopYear;
    stopMonth;
    stopDay;
    stopHour;
    stopMinute;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      persistSchedule.call(this, ctx, import_Types.ScheduleEntryLockScheduleKind.YearDay, this.userId, this.slotId, this.startYear != void 0 ? {
        startYear: this.startYear,
        startMonth: this.startMonth,
        startDay: this.startDay,
        startHour: this.startHour,
        startMinute: this.startMinute,
        stopYear: this.stopYear,
        stopMonth: this.stopMonth,
        stopDay: this.stopDay,
        stopHour: this.stopHour,
        stopMinute: this.stopMinute
      } : false);
      return true;
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.userId,
        this.slotId,
        this.startYear ?? 255,
        this.startMonth ?? 255,
        this.startDay ?? 255,
        this.startHour ?? 255,
        this.startMinute ?? 255,
        this.stopYear ?? 255,
        this.stopMonth ?? 255,
        this.stopDay ?? 255,
        this.stopHour ?? 255,
        this.stopMinute ?? 255
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      let message;
      if (this.startYear !== void 0) {
        message = {
          "user ID": this.userId,
          "slot #": this.slotId,
          schedule: "(empty)"
        };
      } else {
        message = {
          "user ID": this.userId,
          "slot #": this.slotId,
          action: "set",
          "start date": `${(0, import_shared.formatDate)(this.startYear ?? 0, this.startMonth ?? 0, this.startDay ?? 0)} ${(0, import_shared.formatTime)(this.startHour ?? 0, this.startMinute ?? 0)}`,
          "end date": `${(0, import_shared.formatDate)(this.stopYear ?? 0, this.stopMonth ?? 0, this.stopDay ?? 0)} ${(0, import_shared.formatTime)(this.stopHour ?? 0, this.stopMinute ?? 0)}`
        };
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ScheduleEntryLockCCYearDayScheduleReport2 = _classThis;
})();
let ScheduleEntryLockCCYearDayScheduleGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.YearDayScheduleGet), (0, import_CommandClassDecorators.expectedCCResponse)(ScheduleEntryLockCCYearDayScheduleReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCYearDayScheduleGet2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCYearDayScheduleGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCYearDayScheduleGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userId = options.userId;
      this.slotId = options.slotId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const userId = raw.payload[0];
      const slotId = raw.payload[1];
      return new this({
        nodeId: ctx.sourceNodeId,
        userId,
        slotId
      });
    }
    userId;
    slotId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.userId, this.slotId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "user ID": this.userId,
          "slot #": this.slotId
        }
      };
    }
  };
  return ScheduleEntryLockCCYearDayScheduleGet2 = _classThis;
})();
let ScheduleEntryLockCCTimeOffsetSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.TimeOffsetSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCTimeOffsetSet2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCTimeOffsetSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCTimeOffsetSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.standardOffset = options.standardOffset;
      this.dstOffset = options.dstOffset;
    }
    static from(raw, ctx) {
      const { standardOffset, dstOffset } = (0, import_serializers.parseTimezone)(raw.payload);
      return new this({
        nodeId: ctx.sourceNodeId,
        standardOffset,
        dstOffset
      });
    }
    standardOffset;
    dstOffset;
    serialize(ctx) {
      this.payload = (0, import_serializers.encodeTimezone)({
        standardOffset: this.standardOffset,
        dstOffset: this.dstOffset
      });
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "standard time offset": `${this.standardOffset} minutes`,
          "DST offset": `${this.dstOffset} minutes`
        }
      };
    }
  };
  return ScheduleEntryLockCCTimeOffsetSet2 = _classThis;
})();
let ScheduleEntryLockCCTimeOffsetReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.TimeOffsetReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCTimeOffsetReport2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCTimeOffsetReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCTimeOffsetReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.standardOffset = options.standardOffset;
      this.dstOffset = options.dstOffset;
    }
    static from(raw, ctx) {
      const { standardOffset, dstOffset } = (0, import_serializers.parseTimezone)(raw.payload);
      return new this({
        nodeId: ctx.sourceNodeId,
        standardOffset,
        dstOffset
      });
    }
    standardOffset;
    dstOffset;
    serialize(ctx) {
      this.payload = (0, import_serializers.encodeTimezone)({
        standardOffset: this.standardOffset,
        dstOffset: this.dstOffset
      });
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "standard time offset": `${this.standardOffset} minutes`,
          "DST offset": `${this.dstOffset} minutes`
        }
      };
    }
  };
  return ScheduleEntryLockCCTimeOffsetReport2 = _classThis;
})();
let ScheduleEntryLockCCTimeOffsetGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.TimeOffsetGet), (0, import_CommandClassDecorators.expectedCCResponse)(ScheduleEntryLockCCTimeOffsetReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCTimeOffsetGet2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCTimeOffsetGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCTimeOffsetGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ScheduleEntryLockCCTimeOffsetGet2 = _classThis;
})();
let ScheduleEntryLockCCDailyRepeatingScheduleSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.DailyRepeatingScheduleSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCDailyRepeatingScheduleSet2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCDailyRepeatingScheduleSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCDailyRepeatingScheduleSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userId = options.userId;
      this.slotId = options.slotId;
      this.action = options.action;
      if (options.action === import_Types.ScheduleEntryLockSetAction.Set) {
        this.weekdays = options.weekdays;
        this.startHour = options.startHour;
        this.startMinute = options.startMinute;
        this.durationHour = options.durationHour;
        this.durationMinute = options.durationMinute;
      }
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const action = raw.payload[0];
      (0, import_core.validatePayload)(action === import_Types.ScheduleEntryLockSetAction.Set || action === import_Types.ScheduleEntryLockSetAction.Erase);
      const userId = raw.payload[1];
      const slotId = raw.payload[2];
      if (action !== import_Types.ScheduleEntryLockSetAction.Set) {
        return new this({
          nodeId: ctx.sourceNodeId,
          action,
          userId,
          slotId
        });
      }
      (0, import_core.validatePayload)(raw.payload.length >= 8);
      const weekdays = (0, import_core.parseBitMask)(raw.payload.subarray(3, 4), import_Types.ScheduleEntryLockWeekday.Sunday);
      const startHour = raw.payload[4];
      const startMinute = raw.payload[5];
      const durationHour = raw.payload[6];
      const durationMinute = raw.payload[7];
      return new this({
        nodeId: ctx.sourceNodeId,
        action,
        userId,
        slotId,
        weekdays,
        startHour,
        startMinute,
        durationHour,
        durationMinute
      });
    }
    userId;
    slotId;
    action;
    weekdays;
    startHour;
    startMinute;
    durationHour;
    durationMinute;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.action, this.userId, this.slotId]);
      if (this.action === import_Types.ScheduleEntryLockSetAction.Set) {
        this.payload = import_shared.Bytes.concat([
          this.payload,
          (0, import_core.encodeBitMask)(this.weekdays, import_Types.ScheduleEntryLockWeekday.Saturday, import_Types.ScheduleEntryLockWeekday.Sunday),
          import_shared.Bytes.from([
            this.startHour,
            this.startMinute,
            this.durationHour,
            this.durationMinute
          ])
        ]);
      } else {
        this.payload = import_shared.Bytes.concat([this.payload, import_shared.Bytes.alloc(5, 255)]);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      let message;
      if (this.action === import_Types.ScheduleEntryLockSetAction.Erase) {
        message = {
          "user ID": this.userId,
          "slot #": this.slotId,
          action: "erase"
        };
      } else {
        message = {
          "user ID": this.userId,
          "slot #": this.slotId,
          action: "set",
          weekdays: this.weekdays.map((w) => (0, import_shared.getEnumMemberName)(import_Types.ScheduleEntryLockWeekday, w)).join(", "),
          "start time": (0, import_shared.formatTime)(this.startHour ?? 0, this.startMinute ?? 0),
          duration: (0, import_shared.formatTime)(this.durationHour ?? 0, this.durationMinute ?? 0)
        };
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ScheduleEntryLockCCDailyRepeatingScheduleSet2 = _classThis;
})();
let ScheduleEntryLockCCDailyRepeatingScheduleReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.DailyRepeatingScheduleReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCDailyRepeatingScheduleReport2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCDailyRepeatingScheduleReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCDailyRepeatingScheduleReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userId = options.userId;
      this.slotId = options.slotId;
      this.weekdays = options.weekdays;
      this.startHour = options.startHour;
      this.startMinute = options.startMinute;
      this.durationHour = options.durationHour;
      this.durationMinute = options.durationMinute;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const userId = raw.payload[0];
      const slotId = raw.payload[1];
      if (raw.payload.length >= 7 && raw.payload[2] !== 0) {
        const weekdays = (0, import_core.parseBitMask)(raw.payload.subarray(2, 3), import_Types.ScheduleEntryLockWeekday.Sunday);
        const startHour = raw.payload[3];
        const startMinute = raw.payload[4];
        const durationHour = raw.payload[5];
        const durationMinute = raw.payload[6];
        return new this({
          nodeId: ctx.sourceNodeId,
          userId,
          slotId,
          weekdays,
          startHour,
          startMinute,
          durationHour,
          durationMinute
        });
      } else {
        return new this({
          nodeId: ctx.sourceNodeId,
          userId,
          slotId
        });
      }
    }
    userId;
    slotId;
    weekdays;
    startHour;
    startMinute;
    durationHour;
    durationMinute;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      persistSchedule.call(this, ctx, import_Types.ScheduleEntryLockScheduleKind.DailyRepeating, this.userId, this.slotId, this.weekdays?.length ? {
        weekdays: this.weekdays,
        startHour: this.startHour,
        startMinute: this.startMinute,
        durationHour: this.durationHour,
        durationMinute: this.durationMinute
      } : false);
      return true;
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.userId, this.slotId]);
      if (this.weekdays) {
        this.payload = import_shared.Bytes.concat([
          this.payload,
          (0, import_core.encodeBitMask)(this.weekdays, import_Types.ScheduleEntryLockWeekday.Saturday, import_Types.ScheduleEntryLockWeekday.Sunday),
          import_shared.Bytes.from([
            this.startHour,
            this.startMinute,
            this.durationHour,
            this.durationMinute
          ])
        ]);
      } else {
        this.payload = import_shared.Bytes.concat([this.payload, import_shared.Bytes.alloc(5, 0)]);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      let message;
      if (!this.weekdays) {
        message = {
          "user ID": this.userId,
          "slot #": this.slotId,
          schedule: "(empty)"
        };
      } else {
        message = {
          "user ID": this.userId,
          "slot #": this.slotId,
          action: "set",
          weekdays: this.weekdays.map((w) => (0, import_shared.getEnumMemberName)(import_Types.ScheduleEntryLockWeekday, w)).join(", "),
          "start time": (0, import_shared.formatTime)(this.startHour ?? 0, this.startMinute ?? 0),
          duration: (0, import_shared.formatTime)(this.durationHour ?? 0, this.durationMinute ?? 0)
        };
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ScheduleEntryLockCCDailyRepeatingScheduleReport2 = _classThis;
})();
let ScheduleEntryLockCCDailyRepeatingScheduleGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ScheduleEntryLockCommand.DailyRepeatingScheduleGet), (0, import_CommandClassDecorators.expectedCCResponse)(ScheduleEntryLockCCDailyRepeatingScheduleReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ScheduleEntryLockCC;
  var ScheduleEntryLockCCDailyRepeatingScheduleGet2 = class extends _classSuper {
    static {
      __name(this, "ScheduleEntryLockCCDailyRepeatingScheduleGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ScheduleEntryLockCCDailyRepeatingScheduleGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.userId = options.userId;
      this.slotId = options.slotId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const userId = raw.payload[0];
      const slotId = raw.payload[1];
      return new this({
        nodeId: ctx.sourceNodeId,
        userId,
        slotId
      });
    }
    userId;
    slotId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.userId, this.slotId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "user ID": this.userId,
          "slot #": this.slotId
        }
      };
    }
  };
  return ScheduleEntryLockCCDailyRepeatingScheduleGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ScheduleEntryLockCC,
  ScheduleEntryLockCCAPI,
  ScheduleEntryLockCCDailyRepeatingScheduleGet,
  ScheduleEntryLockCCDailyRepeatingScheduleReport,
  ScheduleEntryLockCCDailyRepeatingScheduleSet,
  ScheduleEntryLockCCEnableAllSet,
  ScheduleEntryLockCCEnableSet,
  ScheduleEntryLockCCSupportedGet,
  ScheduleEntryLockCCSupportedReport,
  ScheduleEntryLockCCTimeOffsetGet,
  ScheduleEntryLockCCTimeOffsetReport,
  ScheduleEntryLockCCTimeOffsetSet,
  ScheduleEntryLockCCValues,
  ScheduleEntryLockCCWeekDayScheduleGet,
  ScheduleEntryLockCCWeekDayScheduleReport,
  ScheduleEntryLockCCWeekDayScheduleSet,
  ScheduleEntryLockCCYearDayScheduleGet,
  ScheduleEntryLockCCYearDayScheduleReport,
  ScheduleEntryLockCCYearDayScheduleSet
});
//# sourceMappingURL=ScheduleEntryLockCC.js.map
