"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SecurityCC_exports = {};
__export(SecurityCC_exports, {
  SecurityCC: () => SecurityCC,
  SecurityCCAPI: () => SecurityCCAPI,
  SecurityCCCommandEncapsulation: () => SecurityCCCommandEncapsulation,
  SecurityCCCommandEncapsulationNonceGet: () => SecurityCCCommandEncapsulationNonceGet,
  SecurityCCCommandsSupportedGet: () => SecurityCCCommandsSupportedGet,
  SecurityCCCommandsSupportedReport: () => SecurityCCCommandsSupportedReport,
  SecurityCCNetworkKeySet: () => SecurityCCNetworkKeySet,
  SecurityCCNetworkKeyVerify: () => SecurityCCNetworkKeyVerify,
  SecurityCCNonceGet: () => SecurityCCNonceGet,
  SecurityCCNonceReport: () => SecurityCCNonceReport,
  SecurityCCSchemeGet: () => SecurityCCSchemeGet,
  SecurityCCSchemeInherit: () => SecurityCCSchemeInherit,
  SecurityCCSchemeReport: () => SecurityCCSchemeReport
});
module.exports = __toCommonJS(SecurityCC_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_async = require("alcalzone-shared/async");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Types = require("../lib/_Types.js");
var import_CRC16CC = require("./CRC16CC.js");
var import_Security2CC = require("./Security2CC.js");
var import_TransportServiceCC = require("./TransportServiceCC.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
function getAuthenticationData(senderNonce, receiverNonce, ccCommand, sendingNodeId, receivingNodeId, encryptedPayload) {
  return import_shared.Bytes.concat([
    senderNonce,
    receiverNonce,
    import_shared.Bytes.from([
      ccCommand,
      sendingNodeId,
      receivingNodeId,
      encryptedPayload.length
    ]),
    encryptedPayload
  ]);
}
__name(getAuthenticationData, "getAuthenticationData");
function throwNoNonce(reason) {
  let message = `Security CC requires a nonce to be sent!`;
  if (reason)
    message += ` Reason: ${reason}`;
  throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.SecurityCC_NoNonce);
}
__name(throwNoNonce, "throwNoNonce");
const HALF_NONCE_SIZE = 8;
function assertSecurityRX(ctx) {
  if (!ctx.ownNodeId) {
    throw new import_core.ZWaveError(`Secure commands (S0) can only be decoded when the controller's node id is known!`, import_core.ZWaveErrorCodes.Driver_NotReady);
  }
  if (!ctx.securityManager) {
    throw new import_core.ZWaveError(`Secure commands (S0) can only be decoded when the security manager is set up!`, import_core.ZWaveErrorCodes.Driver_NoSecurity);
  }
}
__name(assertSecurityRX, "assertSecurityRX");
function assertSecurityTX(ctx) {
  if (!ctx.ownNodeId) {
    throw new import_core.ZWaveError(`Secure commands (S0) can only be sent when the controller's node id is known!`, import_core.ZWaveErrorCodes.Driver_NotReady);
  }
  if (!ctx.securityManager) {
    throw new import_core.ZWaveError(`Secure commands (S0) can only be sent when the security manager is set up!`, import_core.ZWaveErrorCodes.Driver_NoSecurity);
  }
}
__name(assertSecurityTX, "assertSecurityTX");
let SecurityCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses.Security)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  var SecurityCCAPI2 = class extends _classSuper {
    static {
      __name(this, "SecurityCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SecurityCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(_cmd) {
      return true;
    }
    async sendEncapsulated(encapsulated, requestNextNonce = false) {
      if (requestNextNonce) {
        this.assertSupportsCommand(import_Types.SecurityCommand, import_Types.SecurityCommand.CommandEncapsulation);
      } else {
        this.assertSupportsCommand(import_Types.SecurityCommand, import_Types.SecurityCommand.CommandEncapsulationNonceGet);
      }
      const cc = new (requestNextNonce ? SecurityCCCommandEncapsulationNonceGet : SecurityCCCommandEncapsulation)({
        nodeId: this.endpoint.nodeId,
        encapsulated
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Requests a new nonce for Security CC encapsulation which is not directly linked to a specific command.
     */
    async getNonce() {
      this.assertSupportsCommand(import_Types.SecurityCommand, import_Types.SecurityCommand.NonceGet);
      const cc = new SecurityCCNonceGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, {
        ...this.commandOptions,
        // Only try getting a nonce once
        maxSendAttempts: 1
      });
      if (!response)
        return;
      const nonce = response.nonce;
      const secMan = this.host.securityManager;
      secMan.setNonce({
        issuer: this.endpoint.nodeId,
        nonceId: secMan.getNonceId(nonce)
      }, { nonce, receiver: this.host.ownNodeId }, { free: true });
      return nonce;
    }
    /**
     * Responds to a NonceGet request. The message is sent without any retransmission etc.
     * The return value indicates whether a nonce was successfully sent
     */
    async sendNonce() {
      this.assertSupportsCommand(import_Types.SecurityCommand, import_Types.SecurityCommand.NonceReport);
      if (!this.host.securityManager) {
        throw new import_core.ZWaveError(`Nonces can only be sent if secure communication is set up!`, import_core.ZWaveErrorCodes.Driver_NoSecurity);
      }
      const nonce = this.host.securityManager.generateNonce(this.endpoint.nodeId, HALF_NONCE_SIZE);
      const nonceId = this.host.securityManager.getNonceId(nonce);
      const cc = new SecurityCCNonceReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        nonce
      });
      try {
        await this.host.sendCommand(cc, {
          ...this.commandOptions,
          // Seems we need these options or some nodes won't accept the nonce
          transmitOptions: import_core.TransmitOptions.ACK | import_core.TransmitOptions.AutoRoute,
          // Only try sending a nonce once
          maxSendAttempts: 1,
          // Nonce requests must be handled immediately
          priority: import_core.MessagePriority.Immediate,
          // We don't want failures causing us to treat the node as asleep or dead
          changeNodeStatusOnMissingACK: false
        });
      } catch (e) {
        if ((0, import_core.isTransmissionError)(e)) {
          this.host.securityManager.deleteNonce(nonceId);
          return false;
        } else {
          throw e;
        }
      }
      return true;
    }
    async getSecurityScheme() {
      this.assertSupportsCommand(import_Types.SecurityCommand, import_Types.SecurityCommand.SchemeGet);
      const cc = new SecurityCCSchemeGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      await this.host.sendCommand(cc, this.commandOptions);
      return [0];
    }
    async reportSecurityScheme(encapsulated) {
      this.assertSupportsCommand(import_Types.SecurityCommand, import_Types.SecurityCommand.SchemeReport);
      let cc = new SecurityCCSchemeReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      if (encapsulated) {
        cc = new SecurityCCCommandEncapsulation({
          nodeId: this.endpoint.nodeId,
          endpointIndex: this.endpoint.index,
          encapsulated: cc
        });
      }
      await this.host.sendCommand(cc, this.commandOptions);
    }
    async inheritSecurityScheme() {
      this.assertSupportsCommand(import_Types.SecurityCommand, import_Types.SecurityCommand.SchemeInherit);
      const cc = new SecurityCCSchemeInherit({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    async setNetworkKey(networkKey) {
      this.assertSupportsCommand(import_Types.SecurityCommand, import_Types.SecurityCommand.NetworkKeySet);
      const keySet = new SecurityCCNetworkKeySet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        networkKey
      });
      const cc = new SecurityCCCommandEncapsulation({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        encapsulated: keySet,
        alternativeNetworkKey: new Uint8Array(16).fill(0)
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    async verifyNetworkKey() {
      this.assertSupportsCommand(import_Types.SecurityCommand, import_Types.SecurityCommand.NetworkKeyVerify);
      const cc = new SecurityCCNetworkKeyVerify({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getSupportedCommands() {
      this.assertSupportsCommand(import_Types.SecurityCommand, import_Types.SecurityCommand.CommandsSupportedGet);
      const cc = new SecurityCCCommandsSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["supportedCCs", "controlledCCs"]);
      }
    }
    async reportSupportedCommands(supportedCCs, controlledCCs) {
      this.assertSupportsCommand(import_Types.SecurityCommand, import_Types.SecurityCommand.CommandsSupportedReport);
      const cc = new SecurityCCCommandsSupportedReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        supportedCCs,
        controlledCCs,
        reportsToFollow: 0
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
  };
  return SecurityCCAPI2 = _classThis;
})();
let SecurityCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses.Security), (0, import_CommandClassDecorators.implementedVersion)(1)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var SecurityCC2 = class extends _classSuper {
    static {
      __name(this, "SecurityCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SecurityCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Security, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        message: "Querying securely supported commands (S0)...",
        direction: "outbound"
      });
      let supportedCCs;
      let controlledCCs;
      const MAX_ATTEMPTS = this.endpointIndex === 0 ? 3 : 1;
      for (let attempts = 1; attempts <= MAX_ATTEMPTS; attempts++) {
        const resp = await api.getSupportedCommands();
        if (resp) {
          supportedCCs = resp.supportedCCs;
          controlledCCs = resp.controlledCCs;
          break;
        } else if (attempts < MAX_ATTEMPTS) {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `Querying securely supported commands (S0), attempt ${attempts}/${MAX_ATTEMPTS} failed. Retrying in 500ms...`,
            level: "warn"
          });
          await (0, import_async.wait)(500);
        }
      }
      if (!supportedCCs || !controlledCCs) {
        if (node.hasSecurityClass(import_core.SecurityClass.S0_Legacy) === true) {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "Querying securely supported commands (S0) failed",
            level: "warn"
          });
        } else {
          ctx.logNode(node.id, `The node was not granted the S0 security class. Continuing interview non-securely.`);
          node.setSecurityClass(import_core.SecurityClass.S0_Legacy, false);
        }
        return;
      }
      const logLines = [
        "received secure commands (S0)",
        "supported CCs:"
      ];
      for (const cc of supportedCCs) {
        logLines.push(`\xB7 ${(0, import_core.getCCName)(cc)}`);
      }
      logLines.push("controlled CCs:");
      for (const cc of controlledCCs) {
        logLines.push(`\xB7 ${(0, import_core.getCCName)(cc)}`);
      }
      ctx.logNode(node.id, {
        message: logLines.join("\n"),
        direction: "inbound"
      });
      for (const cc of supportedCCs) {
        if (cc === import_core.CommandClasses.Basic) {
          endpoint.addCC(cc, { secure: true });
        } else {
          endpoint.addCC(cc, {
            isSupported: true,
            secure: true
          });
        }
      }
      for (const cc of controlledCCs) {
        if (cc === import_core.CommandClasses.Basic) {
          endpoint.addCC(cc, { secure: true });
        } else {
          endpoint.addCC(cc, {
            isControlled: true,
            secure: true
          });
        }
      }
      if (node.hasSecurityClass(import_core.SecurityClass.S0_Legacy) !== true) {
        node.setSecurityClass(import_core.SecurityClass.S0_Legacy, true);
        ctx.logNode(node.id, `The node was granted the S0 security class`);
      }
      this.setInterviewComplete(ctx, true);
    }
    /** Tests if a command should be sent secure and thus requires encapsulation */
    static requiresEncapsulation(cc) {
      if (!(cc.encapsulationFlags & import_core.EncapsulationFlags.Security)) {
        return false;
      }
      if (cc instanceof import_Security2CC.Security2CC || cc instanceof import_CRC16CC.CRC16CC || cc instanceof import_TransportServiceCC.TransportServiceCC) {
        return false;
      }
      if (cc instanceof SecurityCC2) {
        switch (cc.ccCommand) {
          // Already encapsulated
          case import_Types.SecurityCommand.CommandEncapsulation:
          case import_Types.SecurityCommand.CommandEncapsulationNonceGet:
          // Cannot be sent encapsulated:
          case import_Types.SecurityCommand.NonceGet:
          case import_Types.SecurityCommand.NonceReport:
          case import_Types.SecurityCommand.SchemeGet:
          case import_Types.SecurityCommand.SchemeReport:
            return false;
          default:
            return true;
        }
      }
      return true;
    }
    /** Encapsulates a command that should be sent encrypted */
    static encapsulate(ownNodeId, securityManager, cc) {
      const ret = new SecurityCCCommandEncapsulation({
        nodeId: cc.nodeId,
        encapsulated: cc
      });
      ret.encapsulationFlags = cc.encapsulationFlags & ~import_core.EncapsulationFlags.Security;
      return ret;
    }
  };
  return SecurityCC2 = _classThis;
})();
let SecurityCCNonceReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SecurityCommand.NonceReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SecurityCC;
  var SecurityCCNonceReport2 = class extends _classSuper {
    static {
      __name(this, "SecurityCCNonceReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SecurityCCNonceReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.nonce.length !== HALF_NONCE_SIZE) {
        throw new import_core.ZWaveError(`Nonce must have length ${HALF_NONCE_SIZE}!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.nonce = options.nonce;
    }
    static from(raw, ctx) {
      import_core.validatePayload.withReason("Invalid nonce length")(raw.payload.length === HALF_NONCE_SIZE);
      return new this({
        nodeId: ctx.sourceNodeId,
        nonce: raw.payload
      });
    }
    nonce;
    serialize(ctx) {
      this.payload = import_shared.Bytes.view(this.nonce);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { nonce: (0, import_shared.buffer2hex)(this.nonce) }
      };
    }
  };
  return SecurityCCNonceReport2 = _classThis;
})();
let SecurityCCNonceGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SecurityCommand.NonceGet), (0, import_CommandClassDecorators.expectedCCResponse)(SecurityCCNonceReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SecurityCC;
  var SecurityCCNonceGet2 = class extends _classSuper {
    static {
      __name(this, "SecurityCCNonceGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SecurityCCNonceGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SecurityCCNonceGet2 = _classThis;
})();
function getCCResponseForCommandEncapsulation(ctx, sent) {
  if (sent.encapsulated.expectsCCResponse(ctx)) {
    return SecurityCCCommandEncapsulation;
  }
}
__name(getCCResponseForCommandEncapsulation, "getCCResponseForCommandEncapsulation");
let SecurityCCCommandEncapsulation = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SecurityCommand.CommandEncapsulation), (0, import_CommandClassDecorators.expectedCCResponse)(getCCResponseForCommandEncapsulation, () => "checkEncapsulated")];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SecurityCC;
  var SecurityCCCommandEncapsulation2 = class extends _classSuper {
    static {
      __name(this, "SecurityCCCommandEncapsulation");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SecurityCCCommandEncapsulation2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ("encapsulated" in options) {
        this.encapsulated = options.encapsulated;
        this.encapsulated.encapsulatingCC = this;
      } else {
        this.decryptedCCBytes = options.decryptedCCBytes;
        this.sequenced = options.sequenced;
        this.secondFrame = options.secondFrame;
        this.sequenceCounter = options.sequenceCounter;
      }
      this.alternativeNetworkKey = options.alternativeNetworkKey;
    }
    static async from(raw, ctx) {
      assertSecurityRX(ctx);
      (0, import_core.validatePayload)(raw.payload.length >= HALF_NONCE_SIZE + 1 + 1 + 1 + 8);
      const iv = raw.payload.subarray(0, HALF_NONCE_SIZE);
      const encryptedPayload = raw.payload.subarray(HALF_NONCE_SIZE, -9);
      const nonceId = raw.payload.at(-9);
      const authCode = raw.payload.subarray(-8);
      const nonce = ctx.securityManager.getNonce(nonceId);
      if (!nonce) {
        import_core.validatePayload.fail(`Nonce ${(0, import_shared.num2hex)(nonceId)} expired, cannot decode security encapsulated command.`);
      }
      ctx.securityManager.deleteNonce(nonceId);
      const authData = getAuthenticationData(iv, nonce, import_Types.SecurityCommand.CommandEncapsulation, ctx.sourceNodeId, ctx.ownNodeId, encryptedPayload);
      const expectedAuthCode = await (0, import_core.computeMAC)(authData, await ctx.securityManager.getAuthKey());
      import_core.validatePayload.withReason("Invalid auth code, won't accept security encapsulated command.")(authCode.equals(expectedAuthCode));
      const frameControlAndDecryptedCC = await (0, import_core.decryptAES128OFB)(encryptedPayload, await ctx.securityManager.getEncryptionKey(), import_shared.Bytes.concat([iv, nonce]));
      const frameControl = frameControlAndDecryptedCC[0];
      const sequenceCounter = frameControl & 15;
      const sequenced = !!(frameControl & 16);
      const secondFrame = !!(frameControl & 32);
      const decryptedCCBytes = frameControlAndDecryptedCC.subarray(1);
      const ret = new SecurityCCCommandEncapsulation2({
        nodeId: ctx.sourceNodeId,
        sequenceCounter,
        sequenced,
        secondFrame,
        decryptedCCBytes
      });
      ret.authData = authData;
      ret.authCode = authCode;
      ret.iv = iv;
      return ret;
    }
    sequenced;
    secondFrame;
    sequenceCounter;
    decryptedCCBytes;
    encapsulated;
    alternativeNetworkKey;
    get nonceId() {
      return this.nonce?.[0];
    }
    nonce;
    // Only used testing/for debugging purposes
    iv;
    authData;
    authCode;
    ciphertext;
    getPartialCCSessionId() {
      if (this.sequenced) {
        return {
          // Treat Encapsulation and EncapsulationNonceGet as one
          ccCommand: void 0,
          sequence: this.sequenceCounter
        };
      } else {
        return {
          // Treat Encapsulation and EncapsulationNonceGet as one
          ccCommand: void 0
        };
      }
    }
    expectMoreMessages() {
      return !!this.sequenced && !this.secondFrame;
    }
    async mergePartialCCs(partials, ctx) {
      this.decryptedCCBytes = import_shared.Bytes.concat([...partials, this].map((cc) => cc.decryptedCCBytes));
      (0, import_core.validatePayload)(this.decryptedCCBytes.length >= 2);
      this.encapsulated = await import_CommandClass.CommandClass.parse(this.decryptedCCBytes, ctx);
      this.encapsulated.encapsulatingCC = this;
    }
    async serialize(ctx) {
      if (!this.nonce)
        throwNoNonce();
      if (this.nonce.length !== HALF_NONCE_SIZE) {
        throwNoNonce("Invalid nonce size");
      }
      assertSecurityTX(ctx);
      let authKey;
      let encryptionKey;
      if (this.alternativeNetworkKey) {
        authKey = await (0, import_core.generateAuthKey)(this.alternativeNetworkKey);
        encryptionKey = await (0, import_core.generateEncryptionKey)(this.alternativeNetworkKey);
      } else {
        authKey = await ctx.securityManager.getAuthKey();
        encryptionKey = await ctx.securityManager.getEncryptionKey();
      }
      const serializedCC = await this.encapsulated.serialize(ctx);
      const plaintext = import_shared.Bytes.concat([
        import_shared.Bytes.from([0]),
        // TODO: frame control
        serializedCC
      ]);
      const senderNonce = (0, import_core.randomBytes)(HALF_NONCE_SIZE);
      const iv = import_shared.Bytes.concat([senderNonce, this.nonce]);
      const ciphertext = await (0, import_core.encryptAES128OFB)(plaintext, encryptionKey, iv);
      const authData = getAuthenticationData(senderNonce, this.nonce, this.ccCommand, ctx.ownNodeId, this.nodeId, ciphertext);
      const authCode = await (0, import_core.computeMAC)(authData, authKey);
      this.iv = iv;
      this.authData = authData;
      this.authCode = authCode;
      this.ciphertext = ciphertext;
      this.payload = import_shared.Bytes.concat([
        senderNonce,
        ciphertext,
        import_shared.Bytes.from([this.nonceId]),
        authCode
      ]);
      return super.serialize(ctx);
    }
    computeEncapsulationOverhead() {
      return super.computeEncapsulationOverhead() + 18;
    }
    toLogEntry(ctx) {
      const message = {};
      if (this.nonceId != void 0) {
        message["nonce id"] = this.nonceId;
      }
      if (this.sequenced != void 0) {
        message.sequenced = this.sequenced;
        if (this.sequenced) {
          if (this.secondFrame != void 0) {
            message["second frame"] = this.secondFrame;
          }
          if (this.sequenceCounter != void 0) {
            message["sequence counter"] = this.sequenceCounter;
          }
        }
      }
      if (process.env.NODE_ENV === "test" || process.env.NODE_ENV === "development") {
        if (this.iv) {
          message.IV = (0, import_shared.buffer2hex)(this.iv);
        }
        if (this.ciphertext) {
          message.ciphertext = (0, import_shared.buffer2hex)(this.ciphertext);
        } else if (this.decryptedCCBytes) {
          message.plaintext = (0, import_shared.buffer2hex)(this.decryptedCCBytes);
        }
        if (this.authData) {
          message["auth data"] = (0, import_shared.buffer2hex)(this.authData);
        }
        if (this.authCode) {
          message["auth code"] = (0, import_shared.buffer2hex)(this.authCode);
        }
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return SecurityCCCommandEncapsulation2 = _classThis;
})();
let SecurityCCCommandEncapsulationNonceGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SecurityCommand.CommandEncapsulationNonceGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SecurityCCCommandEncapsulation;
  var SecurityCCCommandEncapsulationNonceGet2 = class extends _classSuper {
    static {
      __name(this, "SecurityCCCommandEncapsulationNonceGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SecurityCCCommandEncapsulationNonceGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SecurityCCCommandEncapsulationNonceGet2 = _classThis;
})();
let SecurityCCSchemeReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SecurityCommand.SchemeReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SecurityCC;
  var SecurityCCSchemeReport2 = class extends _classSuper {
    static {
      __name(this, "SecurityCCSchemeReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SecurityCCSchemeReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      return new this({
        nodeId: ctx.sourceNodeId
      });
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([0]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        // Hide the default payload line
        message: void 0
      };
    }
  };
  return SecurityCCSchemeReport2 = _classThis;
})();
let SecurityCCSchemeGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SecurityCommand.SchemeGet), (0, import_CommandClassDecorators.expectedCCResponse)(SecurityCCSchemeReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SecurityCC;
  var SecurityCCSchemeGet2 = class extends _classSuper {
    static {
      __name(this, "SecurityCCSchemeGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SecurityCCSchemeGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      return new this({
        nodeId: ctx.sourceNodeId
      });
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([0]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        // Hide the default payload line
        message: void 0
      };
    }
  };
  return SecurityCCSchemeGet2 = _classThis;
})();
let SecurityCCSchemeInherit = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SecurityCommand.SchemeInherit), (0, import_CommandClassDecorators.expectedCCResponse)(SecurityCCSchemeReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SecurityCC;
  var SecurityCCSchemeInherit2 = class extends _classSuper {
    static {
      __name(this, "SecurityCCSchemeInherit");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SecurityCCSchemeInherit2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      return new this({
        nodeId: ctx.sourceNodeId
      });
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([0]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        // Hide the default payload line
        message: void 0
      };
    }
  };
  return SecurityCCSchemeInherit2 = _classThis;
})();
let SecurityCCNetworkKeyVerify = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SecurityCommand.NetworkKeyVerify)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SecurityCC;
  var SecurityCCNetworkKeyVerify2 = class extends _classSuper {
    static {
      __name(this, "SecurityCCNetworkKeyVerify");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SecurityCCNetworkKeyVerify2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SecurityCCNetworkKeyVerify2 = _classThis;
})();
let SecurityCCNetworkKeySet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SecurityCommand.NetworkKeySet), (0, import_CommandClassDecorators.expectedCCResponse)(SecurityCCNetworkKeyVerify)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SecurityCC;
  var SecurityCCNetworkKeySet2 = class extends _classSuper {
    static {
      __name(this, "SecurityCCNetworkKeySet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SecurityCCNetworkKeySet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.networkKey.length !== 16) {
        throw new import_core.ZWaveError(`The network key must have length 16!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.networkKey = options.networkKey;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 16);
      const networkKey = raw.payload.subarray(0, 16);
      return new this({
        nodeId: ctx.sourceNodeId,
        networkKey
      });
    }
    networkKey;
    serialize(ctx) {
      this.payload = import_shared.Bytes.view(this.networkKey);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const { message, ...log } = super.toLogEntry(ctx);
      return log;
    }
  };
  return SecurityCCNetworkKeySet2 = _classThis;
})();
let SecurityCCCommandsSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SecurityCommand.CommandsSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SecurityCC;
  var SecurityCCCommandsSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "SecurityCCCommandsSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SecurityCCCommandsSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedCCs = options.supportedCCs;
      this.controlledCCs = options.controlledCCs;
      this.reportsToFollow = options.reportsToFollow ?? 0;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const reportsToFollow = raw.payload[0];
      const list = (0, import_core.parseCCList)(raw.payload.subarray(1));
      const supportedCCs = list.supportedCCs;
      const controlledCCs = list.controlledCCs;
      return new this({
        nodeId: ctx.sourceNodeId,
        reportsToFollow,
        supportedCCs,
        controlledCCs
      });
    }
    reportsToFollow;
    supportedCCs;
    controlledCCs;
    getPartialCCSessionId() {
      return {};
    }
    expectMoreMessages() {
      return this.reportsToFollow > 0;
    }
    mergePartialCCs(partials) {
      this.supportedCCs = [...partials, this].map((report) => report.supportedCCs).reduce((prev, cur) => prev.concat(...cur), []);
      this.controlledCCs = [...partials, this].map((report) => report.controlledCCs).reduce((prev, cur) => prev.concat(...cur), []);
      return Promise.resolve();
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.reportsToFollow]),
        (0, import_core.encodeCCList)(this.supportedCCs, this.controlledCCs)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          reportsToFollow: this.reportsToFollow,
          supportedCCs: this.supportedCCs.map((cc) => (0, import_core.getCCName)(cc)).map((cc) => `
\xB7 ${cc}`).join(""),
          controlledCCs: this.controlledCCs.map((cc) => (0, import_core.getCCName)(cc)).map((cc) => `
\xB7 ${cc}`).join("")
        }
      };
    }
  };
  return SecurityCCCommandsSupportedReport2 = _classThis;
})();
let SecurityCCCommandsSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SecurityCommand.CommandsSupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(SecurityCCCommandsSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SecurityCC;
  var SecurityCCCommandsSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "SecurityCCCommandsSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SecurityCCCommandsSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SecurityCCCommandsSupportedGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SecurityCC,
  SecurityCCAPI,
  SecurityCCCommandEncapsulation,
  SecurityCCCommandEncapsulationNonceGet,
  SecurityCCCommandsSupportedGet,
  SecurityCCCommandsSupportedReport,
  SecurityCCNetworkKeySet,
  SecurityCCNetworkKeyVerify,
  SecurityCCNonceGet,
  SecurityCCNonceReport,
  SecurityCCSchemeGet,
  SecurityCCSchemeInherit,
  SecurityCCSchemeReport
});
//# sourceMappingURL=SecurityCC.js.map
